// third_party/blink/public/mojom/file_system_access/native_file_system_transfer_token.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/native_file_system_transfer_token.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/file_system_access/native_file_system_transfer_token.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_transfer_token.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/native_file_system_transfer_token.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_TRANSFER_TOKEN_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_TRANSFER_TOKEN_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char NativeFileSystemTransferToken::Name_[] = "blink.mojom.NativeFileSystemTransferToken";

class NativeFileSystemTransferToken_GetInternalID_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemTransferToken_GetInternalID_ForwardToCallback(
      NativeFileSystemTransferToken::GetInternalIDCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemTransferToken::GetInternalIDCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemTransferToken_GetInternalID_ForwardToCallback);
};

NativeFileSystemTransferTokenProxy::NativeFileSystemTransferTokenProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NativeFileSystemTransferTokenProxy::GetInternalID(
    GetInternalIDCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::NativeFileSystemTransferToken::GetInternalID");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemTransferToken_GetInternalID_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemTransferToken_GetInternalID_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemTransferToken::Name_);
  message.set_method_name("GetInternalID");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemTransferToken_GetInternalID_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemTransferTokenProxy::Clone(
    ::mojo::PendingReceiver<NativeFileSystemTransferToken> in_token_clone) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemTransferToken::Clone", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("token_clone", in_token_clone.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemTransferToken_Clone_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemTransferToken_Clone_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::NativeFileSystemTransferTokenInterfaceBase>>(
      in_token_clone, &params->token_clone, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token_clone),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token_clone in NativeFileSystemTransferToken.Clone request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemTransferToken::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class NativeFileSystemTransferToken_GetInternalID_ProxyToResponder {
 public:
  static NativeFileSystemTransferToken::GetInternalIDCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemTransferToken_GetInternalID_ProxyToResponder> proxy(
        new NativeFileSystemTransferToken_GetInternalID_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemTransferToken_GetInternalID_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemTransferToken_GetInternalID_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemTransferToken_GetInternalID_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemTransferToken::GetInternalIDCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::UnguessableToken& in_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemTransferToken_GetInternalID_ProxyToResponder);
};

bool NativeFileSystemTransferToken_GetInternalID_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemTransferToken::GetInternalIDCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemTransferToken_GetInternalID_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemTransferToken_GetInternalID_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::base::UnguessableToken p_id{};
  NativeFileSystemTransferToken_GetInternalID_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadId(&p_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemTransferToken::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_id));
  return true;
}

void NativeFileSystemTransferToken_GetInternalID_ProxyToResponder::Run(
    const ::base::UnguessableToken& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemTransferToken::GetInternalIDCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("id", base::trace_event::ValueToString(in_id, "<value of type const ::base::UnguessableToken&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemTransferToken_GetInternalID_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemTransferToken_GetInternalID_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->id)::BaseType::BufferWriter
      id_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_id, buffer, &id_writer, &serialization_context);
  params->id.Set(
      id_writer.is_null() ? nullptr : id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemTransferToken::GetInternalIDCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemTransferToken::Name_);
  message.set_method_name("GetInternalID");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NativeFileSystemTransferTokenStubDispatch::Accept(
    NativeFileSystemTransferToken* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNativeFileSystemTransferToken_GetInternalID_Name: {
      break;
    }
    case internal::kNativeFileSystemTransferToken_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemTransferToken::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemTransferToken::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NativeFileSystemTransferToken_Clone_Params_Data* params =
          reinterpret_cast<internal::NativeFileSystemTransferToken_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<NativeFileSystemTransferToken> p_token_clone{};
      NativeFileSystemTransferToken_Clone_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_token_clone =
            input_data_view.TakeTokenClone<decltype(p_token_clone)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemTransferToken::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_token_clone));
      return true;
    }
  }
  return false;
}

// static
bool NativeFileSystemTransferTokenStubDispatch::AcceptWithResponder(
    NativeFileSystemTransferToken* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNativeFileSystemTransferToken_GetInternalID_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemTransferToken::GetInternalID",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemTransferToken::GetInternalID");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemTransferToken_GetInternalID_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemTransferToken_GetInternalID_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NativeFileSystemTransferToken_GetInternalID_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemTransferToken::Name_, 0, false);
        return false;
      }
      NativeFileSystemTransferToken::GetInternalIDCallback callback =
          NativeFileSystemTransferToken_GetInternalID_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInternalID(std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemTransferToken_Clone_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kNativeFileSystemTransferTokenValidationInfo[] = {
    {&internal::NativeFileSystemTransferToken_GetInternalID_Params_Data::Validate,
     &internal::NativeFileSystemTransferToken_GetInternalID_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemTransferToken_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool NativeFileSystemTransferTokenRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::NativeFileSystemTransferToken::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kNativeFileSystemTransferTokenValidationInfo);
}

bool NativeFileSystemTransferTokenResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::NativeFileSystemTransferToken::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kNativeFileSystemTransferTokenValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif