/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.tomcat.util.descriptor.tld.TaglibXml;
import org.apache.tomcat.util.descriptor.tld.TldParser;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.xml.sax.SAXException;

public class TldCache {
    public static final String SERVLET_CONTEXT_ATTRIBUTE_NAME = TldCache.class.getName();
    private final ServletContext servletContext;
    private final Map<String, TldResourcePath> uriTldResourcePathMap = new HashMap<String, TldResourcePath>();
    private final Map<TldResourcePath, TaglibXmlCacheEntry> tldResourcePathTaglibXmlMap = new HashMap<TldResourcePath, TaglibXmlCacheEntry>();
    private final TldParser tldParser;

    public static TldCache getInstance(ServletContext servletContext) {
        if (servletContext == null) {
            throw new IllegalArgumentException(Localizer.getMessage("org.apache.jasper.compiler.TldCache.servletContextNull"));
        }
        return (TldCache)servletContext.getAttribute(SERVLET_CONTEXT_ATTRIBUTE_NAME);
    }

    public TldCache(ServletContext servletContext, Map<String, TldResourcePath> map, Map<TldResourcePath, TaglibXml> map2) {
        this.servletContext = servletContext;
        this.uriTldResourcePathMap.putAll(map);
        for (Map.Entry<TldResourcePath, TaglibXml> object2 : map2.entrySet()) {
            TldResourcePath bl2 = object2.getKey();
            long[] lArray = this.getLastModified(bl2);
            TaglibXmlCacheEntry taglibXmlCacheEntry = new TaglibXmlCacheEntry(object2.getValue(), lArray[0], lArray[1]);
            this.tldResourcePathTaglibXmlMap.put(bl2, taglibXmlCacheEntry);
        }
        boolean bl = Boolean.parseBoolean(servletContext.getInitParameter("org.apache.jasper.XML_VALIDATE_TLD"));
        String string = servletContext.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
        boolean bl2 = string == null ? true : Boolean.parseBoolean(string);
        this.tldParser = new TldParser(true, bl, bl2);
    }

    public TldResourcePath getTldResourcePath(String string) {
        return this.uriTldResourcePathMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaglibXml getTaglibXml(TldResourcePath tldResourcePath) throws JasperException {
        TaglibXmlCacheEntry taglibXmlCacheEntry = this.tldResourcePathTaglibXmlMap.get(tldResourcePath);
        if (taglibXmlCacheEntry == null) {
            return null;
        }
        long[] lArray = this.getLastModified(tldResourcePath);
        if (lArray[0] != taglibXmlCacheEntry.getWebAppPathLastModified() || lArray[1] != taglibXmlCacheEntry.getEntryLastModified()) {
            TaglibXmlCacheEntry taglibXmlCacheEntry2 = taglibXmlCacheEntry;
            synchronized (taglibXmlCacheEntry2) {
                if (lArray[0] != taglibXmlCacheEntry.getWebAppPathLastModified() || lArray[1] != taglibXmlCacheEntry.getEntryLastModified()) {
                    TaglibXml taglibXml;
                    try {
                        taglibXml = this.tldParser.parse(tldResourcePath);
                    }
                    catch (IOException | SAXException exception) {
                        throw new JasperException(exception);
                    }
                    taglibXmlCacheEntry.setTaglibXml(taglibXml);
                    taglibXmlCacheEntry.setWebAppPathLastModified(lArray[0]);
                    taglibXmlCacheEntry.setEntryLastModified(lArray[1]);
                }
            }
        }
        return taglibXmlCacheEntry.getTaglibXml();
    }

    private long[] getLastModified(TldResourcePath tldResourcePath) {
        long[] lArray = new long[]{-1L, -1L};
        try {
            Object object;
            Object object2;
            String string = tldResourcePath.getWebappPath();
            if (string != null) {
                object2 = this.servletContext.getResource(tldResourcePath.getWebappPath());
                object = ((URL)object2).openConnection();
                lArray[0] = ((URLConnection)object).getLastModified();
                if ("file".equals(((URL)object2).getProtocol())) {
                    ((URLConnection)object).getInputStream().close();
                }
            }
            object2 = tldResourcePath.openJar();
            object = null;
            try {
                if (object2 != null) {
                    lArray[1] = object2.getLastModified(tldResourcePath.getEntryName());
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            object2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        object2.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lArray;
    }

    private static class TaglibXmlCacheEntry {
        private volatile TaglibXml taglibXml;
        private volatile long webAppPathLastModified;
        private volatile long entryLastModified;

        public TaglibXmlCacheEntry(TaglibXml taglibXml, long l, long l2) {
            this.taglibXml = taglibXml;
            this.webAppPathLastModified = l;
            this.entryLastModified = l2;
        }

        public TaglibXml getTaglibXml() {
            return this.taglibXml;
        }

        public void setTaglibXml(TaglibXml taglibXml) {
            this.taglibXml = taglibXml;
        }

        public long getWebAppPathLastModified() {
            return this.webAppPathLastModified;
        }

        public void setWebAppPathLastModified(long l) {
            this.webAppPathLastModified = l;
        }

        public long getEntryLastModified() {
            return this.entryLastModified;
        }

        public void setEntryLastModified(long l) {
            this.entryLastModified = l;
        }
    }
}

