/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.WebResource;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.util.DOMWriter;
import org.apache.catalina.util.URLEncoder;
import org.apache.catalina.util.XMLWriter;
import org.apache.tomcat.util.http.ConcurrentDateFormat;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.RequestUtil;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;
import org.apache.tomcat.util.security.MD5Encoder;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebdavServlet
extends DefaultServlet {
    private static final long serialVersionUID = 1L;
    private static final URLEncoder URL_ENCODER_XML = (URLEncoder)URLEncoder.DEFAULT.clone();
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_LOCK = "LOCK";
    private static final String METHOD_UNLOCK = "UNLOCK";
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static final int LOCK_CREATION = 0;
    private static final int LOCK_REFRESH = 1;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int MAX_TIMEOUT = 604800;
    protected static final String DEFAULT_NAMESPACE = "DAV:";
    protected static final ConcurrentDateFormat creationDateFormat;
    private final Hashtable<String, LockInfo> resourceLocks = new Hashtable();
    private final Hashtable<String, Vector<String>> lockNullResources = new Hashtable();
    private final Vector<LockInfo> collectionLocks = new Vector();
    private String secret = "catalina";
    private int maxDepth = 3;
    private boolean allowSpecialPaths = false;

    @Override
    public void init() throws ServletException {
        super.init();
        if (this.getServletConfig().getInitParameter("secret") != null) {
            this.secret = this.getServletConfig().getInitParameter("secret");
        }
        if (this.getServletConfig().getInitParameter("maxDepth") != null) {
            this.maxDepth = Integer.parseInt(this.getServletConfig().getInitParameter("maxDepth"));
        }
        if (this.getServletConfig().getInitParameter("allowSpecialPaths") != null) {
            this.allowSpecialPaths = Boolean.parseBoolean(this.getServletConfig().getInitParameter("allowSpecialPaths"));
        }
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new WebdavResolver(this.getServletContext()));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ServletException(sm.getString("webdavservlet.jaxpfailed"));
        }
        return documentBuilder;
    }

    @Override
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.getRelativePath(httpServletRequest);
        if (httpServletRequest.getDispatcherType() == DispatcherType.ERROR) {
            this.doGet(httpServletRequest, httpServletResponse);
            return;
        }
        if (this.isSpecialPath(string)) {
            httpServletResponse.sendError(404);
            return;
        }
        String string2 = httpServletRequest.getMethod();
        if (this.debug > 0) {
            this.log("[" + string2 + "] " + string);
        }
        if (string2.equals(METHOD_PROPFIND)) {
            this.doPropfind(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_PROPPATCH)) {
            this.doProppatch(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_MKCOL)) {
            this.doMkcol(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_COPY)) {
            this.doCopy(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_MOVE)) {
            this.doMove(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_LOCK)) {
            this.doLock(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_UNLOCK)) {
            this.doUnlock(httpServletRequest, httpServletResponse);
        } else {
            super.service(httpServletRequest, httpServletResponse);
        }
    }

    private final boolean isSpecialPath(String string) {
        return !this.allowSpecialPaths && (string.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF") || string.toUpperCase(Locale.ENGLISH).startsWith("/META-INF"));
    }

    @Override
    protected boolean checkIfHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WebResource webResource) throws IOException {
        return super.checkIfHeaders(httpServletRequest, httpServletResponse, webResource);
    }

    @Override
    protected String rewriteUrl(String string) {
        return URL_ENCODER_XML.encode(string, StandardCharsets.UTF_8);
    }

    @Override
    protected String getRelativePath(HttpServletRequest httpServletRequest) {
        return this.getRelativePath(httpServletRequest, false);
    }

    @Override
    protected String getRelativePath(HttpServletRequest httpServletRequest, boolean bl) {
        String string = httpServletRequest.getAttribute("jakarta.servlet.include.request_uri") != null ? (String)httpServletRequest.getAttribute("jakarta.servlet.include.path_info") : httpServletRequest.getPathInfo();
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getPathPrefix(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getContextPath();
        if (httpServletRequest.getServletPath() != null) {
            string = string + httpServletRequest.getServletPath();
        }
        return string;
    }

    @Override
    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.addHeader("DAV", "1,2");
        httpServletResponse.addHeader("Allow", this.determineMethodsAllowed(httpServletRequest));
        httpServletResponse.addHeader("MS-Author-Via", "DAV");
    }

    protected void doPropfind(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        int n;
        Object object;
        Vector<String> vector;
        Vector vector2;
        Object object2;
        Object object3;
        if (!this.listings) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        if (string.length() > 1 && string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        Vector<String> vector3 = null;
        int n2 = this.maxDepth;
        int n3 = 1;
        String string2 = httpServletRequest.getHeader("Depth");
        if (string2 == null) {
            n2 = this.maxDepth;
        } else if (string2.equals("0")) {
            n2 = 0;
        } else if (string2.equals("1")) {
            n2 = 1;
        } else if (string2.equals("infinity")) {
            n2 = this.maxDepth;
        }
        Node node = null;
        if (httpServletRequest.getContentLengthLong() > 0L) {
            object3 = this.getDocumentBuilder();
            try {
                object2 = ((DocumentBuilder)object3).parse(new InputSource((InputStream)httpServletRequest.getInputStream()));
                vector2 = object2.getDocumentElement();
                vector = vector2.getChildNodes();
                block10: for (int i = 0; i < vector.getLength(); ++i) {
                    object = vector.item(i);
                    switch (object.getNodeType()) {
                        case 3: {
                            continue block10;
                        }
                        case 1: {
                            if (object.getNodeName().endsWith("prop")) {
                                n3 = 0;
                                node = object;
                            }
                            if (object.getNodeName().endsWith("propname")) {
                                n3 = 2;
                            }
                            if (!object.getNodeName().endsWith("allprop")) continue block10;
                            n3 = 1;
                        }
                    }
                }
            }
            catch (IOException | SAXException exception) {
                httpServletResponse.sendError(400);
                return;
            }
        }
        if (n3 == 0) {
            vector3 = new Vector<String>();
            object3 = node.getChildNodes();
            block11: for (int i = 0; i < object3.getLength(); ++i) {
                vector2 = object3.item(i);
                switch (vector2.getNodeType()) {
                    case 3: {
                        continue block11;
                    }
                    case 1: {
                        vector = vector2.getNodeName();
                        Object object4 = null;
                        object4 = ((String)((Object)vector)).indexOf(58) != -1 ? ((String)((Object)vector)).substring(((String)((Object)vector)).indexOf(58) + 1) : vector;
                        vector3.addElement((String)object4);
                    }
                }
            }
        }
        if (!(object3 = this.resources.getResource(string)).exists() && (n = string.lastIndexOf(47)) != -1 && (vector = this.lockNullResources.get(vector2 = string.substring(0, n))) != null) {
            Enumeration<String> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!object.equals(string)) continue;
                httpServletResponse.setStatus(207);
                httpServletResponse.setContentType("text/xml; charset=UTF-8");
                XMLWriter xMLWriter = new XMLWriter(httpServletResponse.getWriter());
                xMLWriter.writeXMLHeader();
                xMLWriter.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                this.parseLockNullProperties(httpServletRequest, xMLWriter, (String)object, n3, vector3);
                xMLWriter.writeElement("D", "multistatus", 1);
                xMLWriter.sendData();
                return;
            }
        }
        if (!object3.exists()) {
            httpServletResponse.sendError(404);
            return;
        }
        httpServletResponse.setStatus(207);
        httpServletResponse.setContentType("text/xml; charset=UTF-8");
        object2 = new XMLWriter(httpServletResponse.getWriter());
        ((XMLWriter)object2).writeXMLHeader();
        ((XMLWriter)object2).writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        if (n2 == 0) {
            this.parseProperties(httpServletRequest, (XMLWriter)object2, string, n3, vector3);
        } else {
            vector2 = new Stack<String>();
            vector2.push(string);
            vector = new Stack<String>();
            while (!vector2.isEmpty() && n2 >= 0) {
                String string3 = (String)vector2.pop();
                this.parseProperties(httpServletRequest, (XMLWriter)object2, string3, n3, vector3);
                object3 = this.resources.getResource(string3);
                if (object3.isDirectory() && n2 > 0) {
                    Vector<String> vector4;
                    object = this.resources.list(string3);
                    for (String string4 : object) {
                        String string5 = string3;
                        if (!string5.endsWith("/")) {
                            string5 = string5 + "/";
                        }
                        string5 = string5 + string4;
                        ((Stack)vector).push(string5);
                    }
                    Object object5 = string3;
                    if (((String)object5).endsWith("/")) {
                        object5 = ((String)object5).substring(0, ((String)object5).length() - 1);
                    }
                    if ((vector4 = this.lockNullResources.get(object5)) != null) {
                        Enumeration<String> enumeration = vector4.elements();
                        while (enumeration.hasMoreElements()) {
                            String string4;
                            string4 = enumeration.nextElement();
                            this.parseLockNullProperties(httpServletRequest, (XMLWriter)object2, string4, n3, vector3);
                        }
                    }
                }
                if (vector2.isEmpty()) {
                    --n2;
                    vector2 = vector;
                    vector = new Stack<String>();
                }
                ((XMLWriter)object2).sendData();
            }
        }
        ((XMLWriter)object2).writeElement("D", "multistatus", 1);
        ((XMLWriter)object2).sendData();
    }

    protected void doProppatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        httpServletResponse.sendError(501);
    }

    protected void doMkcol(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.getRelativePath(httpServletRequest);
        WebResource webResource = this.resources.getResource(string);
        if (webResource.exists()) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        if (httpServletRequest.getContentLengthLong() > 0L) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                documentBuilder.parse(new InputSource((InputStream)httpServletRequest.getInputStream()));
                httpServletResponse.sendError(501);
                return;
            }
            catch (SAXException sAXException) {
                httpServletResponse.sendError(415);
                return;
            }
        }
        if (this.resources.mkdir(string)) {
            httpServletResponse.setStatus(201);
            this.lockNullResources.remove(string);
        } else {
            httpServletResponse.sendError(409);
        }
    }

    @Override
    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        this.deleteResource(httpServletRequest, httpServletResponse);
    }

    @Override
    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        WebResource webResource = this.resources.getResource(string);
        if (webResource.isDirectory()) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        super.doPut(httpServletRequest, httpServletResponse);
        this.lockNullResources.remove(string);
    }

    protected void doCopy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        this.copyResource(httpServletRequest, httpServletResponse);
    }

    protected void doMove(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        if (this.copyResource(httpServletRequest, httpServletResponse)) {
            this.deleteResource(string, httpServletRequest, httpServletResponse, false);
        }
    }

    protected void doLock(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Vector<String> vector;
        Object object;
        int n;
        Serializable serializable;
        Object object2;
        Object object3;
        Enumeration<LockInfo> enumeration;
        Object object4;
        Object object5;
        int n2;
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        Object object6 = new LockInfo(this.maxDepth);
        String string = httpServletRequest.getHeader("Depth");
        ((LockInfo)object6).depth = string == null ? this.maxDepth : (string.equals("0") ? 0 : this.maxDepth);
        int n3 = 3600;
        String string2 = httpServletRequest.getHeader("Timeout");
        if (string2 == null) {
            n3 = 3600;
        } else {
            n2 = string2.indexOf(44);
            if (n2 != -1) {
                string2 = string2.substring(0, n2);
            }
            if (string2.startsWith("Second-")) {
                n3 = Integer.parseInt(string2.substring(7));
            } else if (string2.equalsIgnoreCase("infinity")) {
                n3 = 604800;
            } else {
                try {
                    n3 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 604800;
                }
            }
            if (n3 == 0) {
                n3 = 3600;
            }
            if (n3 > 604800) {
                n3 = 604800;
            }
        }
        ((LockInfo)object6).expiresAt = System.currentTimeMillis() + (long)(n3 * 1000);
        n2 = 0;
        Node node = null;
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        try {
            object5 = documentBuilder.parse(new InputSource((InputStream)httpServletRequest.getInputStream()));
            object4 = object5.getDocumentElement();
            node = object4;
        }
        catch (IOException | SAXException exception) {
            n2 = 1;
        }
        if (node != null) {
            object5 = node.getChildNodes();
            object4 = null;
            enumeration = null;
            object3 = null;
            object2 = null;
            serializable = null;
            block20: for (n = 0; n < object5.getLength(); ++n) {
                object = object5.item(n);
                switch (object.getNodeType()) {
                    case 3: {
                        continue block20;
                    }
                    case 1: {
                        vector = object.getNodeName();
                        if (((String)((Object)vector)).endsWith("lockscope")) {
                            object3 = object;
                        }
                        if (((String)((Object)vector)).endsWith("locktype")) {
                            object2 = object;
                        }
                        if (!((String)((Object)vector)).endsWith("owner")) continue block20;
                        serializable = object;
                    }
                }
            }
            if (object3 != null) {
                object5 = object3.getChildNodes();
                block21: for (n = 0; n < object5.getLength(); ++n) {
                    object = object5.item(n);
                    switch (object.getNodeType()) {
                        case 3: {
                            continue block21;
                        }
                        case 1: {
                            vector = object.getNodeName();
                            ((LockInfo)object6).scope = ((String)((Object)vector)).indexOf(58) != -1 ? ((String)((Object)vector)).substring(((String)((Object)vector)).indexOf(58) + 1) : vector;
                        }
                    }
                }
                if (((LockInfo)object6).scope == null) {
                    httpServletResponse.setStatus(400);
                }
            } else {
                httpServletResponse.setStatus(400);
            }
            if (object2 != null) {
                object5 = object2.getChildNodes();
                block22: for (n = 0; n < object5.getLength(); ++n) {
                    object = object5.item(n);
                    switch (object.getNodeType()) {
                        case 3: {
                            continue block22;
                        }
                        case 1: {
                            vector = object.getNodeName();
                            ((LockInfo)object6).type = ((String)((Object)vector)).indexOf(58) != -1 ? ((String)((Object)vector)).substring(((String)((Object)vector)).indexOf(58) + 1) : vector;
                        }
                    }
                }
                if (((LockInfo)object6).type == null) {
                    httpServletResponse.setStatus(400);
                }
            } else {
                httpServletResponse.setStatus(400);
            }
            if (serializable != null) {
                object5 = serializable.getChildNodes();
                block23: for (n = 0; n < object5.getLength(); ++n) {
                    object = object5.item(n);
                    switch (object.getNodeType()) {
                        case 3: {
                            ((LockInfo)object6).owner = ((LockInfo)object6).owner + object.getNodeValue();
                            continue block23;
                        }
                        case 1: {
                            object4 = new StringWriter();
                            enumeration = new DOMWriter((Writer)object4);
                            ((DOMWriter)((Object)enumeration)).print((Node)object);
                            ((LockInfo)object6).owner = ((LockInfo)object6).owner + ((StringWriter)object4).toString();
                        }
                    }
                }
                if (((LockInfo)object6).owner == null) {
                    httpServletResponse.setStatus(400);
                }
            } else {
                ((LockInfo)object6).owner = "";
            }
        }
        ((LockInfo)object6).path = object5 = this.getRelativePath(httpServletRequest);
        object4 = this.resources.getResource((String)object5);
        enumeration = null;
        if (n2 == 0) {
            object3 = httpServletRequest.getServletPath() + "-" + ((LockInfo)object6).type + "-" + ((LockInfo)object6).scope + "-" + httpServletRequest.getUserPrincipal() + "-" + ((LockInfo)object6).depth + "-" + ((LockInfo)object6).owner + "-" + ((LockInfo)object6).tokens + "-" + ((LockInfo)object6).expiresAt + "-" + System.currentTimeMillis() + "-" + this.secret;
            object2 = MD5Encoder.encode((byte[])ConcurrentMessageDigest.digestMD5((byte[][])new byte[][]{((String)object3).getBytes(StandardCharsets.ISO_8859_1)}));
            if (object4.isDirectory() && ((LockInfo)object6).depth == this.maxDepth) {
                serializable = new Vector<String>();
                enumeration = this.collectionLocks.elements();
                while (enumeration.hasMoreElements()) {
                    LockInfo lockInfo = (LockInfo)enumeration.nextElement();
                    if (lockInfo.hasExpired()) {
                        this.resourceLocks.remove(lockInfo.path);
                        continue;
                    }
                    if (!lockInfo.path.startsWith(((LockInfo)object6).path) || !lockInfo.isExclusive() && !((LockInfo)object6).isExclusive()) continue;
                    serializable.addElement(lockInfo.path);
                }
                enumeration = this.resourceLocks.elements();
                while (enumeration.hasMoreElements()) {
                    LockInfo lockInfo = enumeration.nextElement();
                    if (lockInfo.hasExpired()) {
                        this.resourceLocks.remove(lockInfo.path);
                        continue;
                    }
                    if (!lockInfo.path.startsWith(((LockInfo)object6).path) || !lockInfo.isExclusive() && !((LockInfo)object6).isExclusive()) continue;
                    serializable.addElement(lockInfo.path);
                }
                if (!serializable.isEmpty()) {
                    Enumeration enumeration2 = serializable.elements();
                    httpServletResponse.setStatus(409);
                    object = new XMLWriter();
                    ((XMLWriter)object).writeXMLHeader();
                    ((XMLWriter)object).writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                    while (enumeration2.hasMoreElements()) {
                        ((XMLWriter)object).writeElement("D", "response", 0);
                        ((XMLWriter)object).writeElement("D", "href", 0);
                        ((XMLWriter)object).writeText((String)enumeration2.nextElement());
                        ((XMLWriter)object).writeElement("D", "href", 1);
                        ((XMLWriter)object).writeElement("D", "status", 0);
                        ((XMLWriter)object).writeText("HTTP/1.1 423 ");
                        ((XMLWriter)object).writeElement("D", "status", 1);
                        ((XMLWriter)object).writeElement("D", "response", 1);
                    }
                    ((XMLWriter)object).writeElement("D", "multistatus", 1);
                    vector = httpServletResponse.getWriter();
                    ((Writer)((Object)vector)).write(((XMLWriter)object).toString());
                    ((Writer)((Object)vector)).close();
                    return;
                }
                n = 1;
                enumeration = this.collectionLocks.elements();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (!((LockInfo)object).path.equals(((LockInfo)object6).path)) continue;
                    if (((LockInfo)object).isExclusive()) {
                        httpServletResponse.sendError(423);
                        return;
                    }
                    if (((LockInfo)object6).isExclusive()) {
                        httpServletResponse.sendError(423);
                        return;
                    }
                    ((LockInfo)object).tokens.addElement((String)object2);
                    object6 = object;
                    n = 0;
                }
                if (n != 0) {
                    ((LockInfo)object6).tokens.addElement((String)object2);
                    this.collectionLocks.addElement((LockInfo)object6);
                }
            } else {
                serializable = this.resourceLocks.get(((LockInfo)object6).path);
                if (serializable != null) {
                    if (((LockInfo)serializable).isExclusive() || ((LockInfo)object6).isExclusive()) {
                        httpServletResponse.sendError(412);
                        return;
                    }
                    ((LockInfo)serializable).tokens.addElement((String)object2);
                    object6 = serializable;
                } else {
                    ((LockInfo)object6).tokens.addElement((String)object2);
                    this.resourceLocks.put(((LockInfo)object6).path, (LockInfo)object6);
                    if (!object4.exists()) {
                        n = ((LockInfo)object6).path.lastIndexOf(47);
                        object = ((LockInfo)object6).path.substring(0, n);
                        vector = this.lockNullResources.get(object);
                        if (vector == null) {
                            vector = new Vector<String>();
                            this.lockNullResources.put((String)object, vector);
                        }
                        vector.addElement(((LockInfo)object6).path);
                    }
                    httpServletResponse.addHeader("Lock-Token", "<opaquelocktoken:" + (String)object2 + ">");
                }
            }
        }
        if (n2 == 1) {
            object3 = httpServletRequest.getHeader("If");
            if (object3 == null) {
                object3 = "";
            }
            object2 = this.resourceLocks.get(object5);
            serializable = null;
            if (object2 != null) {
                serializable = ((LockInfo)object2).tokens.elements();
                while (serializable.hasMoreElements()) {
                    String string3 = (String)serializable.nextElement();
                    if (!((String)object3).contains(string3)) continue;
                    ((LockInfo)object2).expiresAt = ((LockInfo)object6).expiresAt;
                    object6 = object2;
                }
            }
            Enumeration<LockInfo> enumeration3 = this.collectionLocks.elements();
            while (enumeration3.hasMoreElements()) {
                object2 = enumeration3.nextElement();
                if (!((String)object5).equals(((LockInfo)object2).path)) continue;
                serializable = ((LockInfo)object2).tokens.elements();
                while (serializable.hasMoreElements()) {
                    object = serializable.nextElement();
                    if (!((String)object3).contains((CharSequence)object)) continue;
                    ((LockInfo)object2).expiresAt = ((LockInfo)object6).expiresAt;
                    object6 = object2;
                }
            }
        }
        object3 = new XMLWriter();
        ((XMLWriter)object3).writeXMLHeader();
        ((XMLWriter)object3).writeElement("D", DEFAULT_NAMESPACE, "prop", 0);
        ((XMLWriter)object3).writeElement("D", "lockdiscovery", 0);
        ((LockInfo)object6).toXML((XMLWriter)object3);
        ((XMLWriter)object3).writeElement("D", "lockdiscovery", 1);
        ((XMLWriter)object3).writeElement("D", "prop", 1);
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/xml; charset=UTF-8");
        object2 = httpServletResponse.getWriter();
        ((Writer)object2).write(((XMLWriter)object3).toString());
        ((Writer)object2).close();
    }

    protected void doUnlock(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        String string2 = httpServletRequest.getHeader("Lock-Token");
        if (string2 == null) {
            string2 = "";
        }
        LockInfo lockInfo = this.resourceLocks.get(string);
        Enumeration<String> enumeration = null;
        if (lockInfo != null) {
            enumeration = lockInfo.tokens.elements();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!string2.contains((CharSequence)object)) continue;
                lockInfo.tokens.removeElement(object);
            }
            if (lockInfo.tokens.isEmpty()) {
                this.resourceLocks.remove(string);
                this.lockNullResources.remove(string);
            }
        }
        object = this.collectionLocks.elements();
        while (object.hasMoreElements()) {
            lockInfo = object.nextElement();
            if (!string.equals(lockInfo.path)) continue;
            enumeration = lockInfo.tokens.elements();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                if (!string2.contains(string3)) continue;
                lockInfo.tokens.removeElement(string3);
                break;
            }
            if (!lockInfo.tokens.isEmpty()) continue;
            this.collectionLocks.removeElement(lockInfo);
            this.lockNullResources.remove(string);
        }
        httpServletResponse.setStatus(204);
    }

    private boolean isLocked(HttpServletRequest httpServletRequest) {
        String string;
        String string2 = this.getRelativePath(httpServletRequest);
        String string3 = httpServletRequest.getHeader("If");
        if (string3 == null) {
            string3 = "";
        }
        if ((string = httpServletRequest.getHeader("Lock-Token")) == null) {
            string = "";
        }
        return this.isLocked(string2, string3 + string);
    }

    private boolean isLocked(String string, String string2) {
        LockInfo lockInfo = this.resourceLocks.get(string);
        Enumeration<String> enumeration = null;
        if (lockInfo != null && lockInfo.hasExpired()) {
            this.resourceLocks.remove(string);
        } else if (lockInfo != null) {
            enumeration = lockInfo.tokens.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                if (!string2.contains(string3)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return true;
            }
        }
        Enumeration<LockInfo> enumeration2 = this.collectionLocks.elements();
        while (enumeration2.hasMoreElements()) {
            lockInfo = enumeration2.nextElement();
            if (lockInfo.hasExpired()) {
                this.collectionLocks.removeElement(lockInfo);
                continue;
            }
            if (!string.startsWith(lockInfo.path)) continue;
            enumeration = lockInfo.tokens.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string4 = enumeration.nextElement();
                if (!string2.contains(string4)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return true;
        }
        return false;
    }

    private boolean copyResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Hashtable<String, Integer> hashtable;
        boolean bl;
        String string;
        URI uRI;
        String string2 = this.getRelativePath(httpServletRequest);
        WebResource webResource = this.resources.getResource(string2);
        if (!webResource.exists()) {
            httpServletResponse.sendError(404);
            return false;
        }
        String string3 = httpServletRequest.getHeader("Destination");
        if (string3 == null || string3.isEmpty()) {
            httpServletResponse.sendError(400);
            return false;
        }
        try {
            uRI = new URI(string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            httpServletResponse.sendError(400);
            return false;
        }
        String string4 = uRI.getPath();
        if (!string4.equals(RequestUtil.normalize((String)string4))) {
            httpServletResponse.sendError(400);
            return false;
        }
        if (uRI.isAbsolute()) {
            if (!httpServletRequest.getScheme().equals(uRI.getScheme()) || !httpServletRequest.getServerName().equals(uRI.getHost())) {
                httpServletResponse.sendError(403);
                return false;
            }
            if (!(httpServletRequest.getServerPort() == uRI.getPort() || uRI.getPort() == -1 && ("http".equals(httpServletRequest.getScheme()) && httpServletRequest.getServerPort() == 80 || "https".equals(httpServletRequest.getScheme()) && httpServletRequest.getServerPort() == 443))) {
                httpServletResponse.sendError(403);
                return false;
            }
        }
        if (!string4.startsWith((string = httpServletRequest.getContextPath()) + "/")) {
            httpServletResponse.sendError(403);
            return false;
        }
        string4 = string4.substring(string.length() + httpServletRequest.getServletPath().length());
        if (this.debug > 0) {
            this.log("Dest path :" + string4);
        }
        if (this.isSpecialPath(string4)) {
            httpServletResponse.sendError(403);
            return false;
        }
        if (string4.equals(string2)) {
            httpServletResponse.sendError(403);
            return false;
        }
        if (string4.startsWith(string2) && string4.charAt(string2.length()) == '/' || string2.startsWith(string4) && string2.charAt(string4.length()) == '/') {
            httpServletResponse.sendError(403);
            return false;
        }
        boolean bl2 = true;
        String string5 = httpServletRequest.getHeader("Overwrite");
        if (string5 != null) {
            bl2 = string5.equalsIgnoreCase("T");
        }
        WebResource webResource2 = this.resources.getResource(string4);
        if (bl2) {
            if (webResource2.exists()) {
                if (!this.deleteResource(string4, httpServletRequest, httpServletResponse, true)) {
                    return false;
                }
            } else {
                httpServletResponse.setStatus(201);
            }
        } else if (webResource2.exists()) {
            httpServletResponse.sendError(412);
            return false;
        }
        if (!(bl = this.copyResource(hashtable = new Hashtable<String, Integer>(), string2, string4)) || !hashtable.isEmpty()) {
            if (hashtable.size() == 1) {
                httpServletResponse.sendError(hashtable.elements().nextElement().intValue());
            } else {
                this.sendReport(httpServletRequest, httpServletResponse, hashtable);
            }
            return false;
        }
        if (webResource2.exists()) {
            httpServletResponse.setStatus(204);
        } else {
            httpServletResponse.setStatus(201);
        }
        this.lockNullResources.remove(string4);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyResource(Hashtable<String, Integer> hashtable, String string, String string2) {
        Object object;
        WebResource webResource;
        int n;
        WebResource webResource2;
        if (this.debug > 1) {
            this.log("Copy: " + string + " To: " + string2);
        }
        if ((webResource2 = this.resources.getResource(string)).isDirectory()) {
            String[] stringArray;
            if (!this.resources.mkdir(string2) && !(stringArray = this.resources.getResource(string2)).isDirectory()) {
                hashtable.put(string2, 409);
                return false;
            }
            String[] stringArray2 = stringArray = this.resources.list(string);
            int n2 = stringArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray2[n3];
                String string4 = string2;
                if (!string4.equals("/")) {
                    string4 = string4 + "/";
                }
                string4 = string4 + string3;
                String string5 = string;
                if (!string5.equals("/")) {
                    string5 = string5 + "/";
                }
                string5 = string5 + string3;
                this.copyResource(hashtable, string5, string4);
                ++n3;
            }
            return true;
        }
        if (!webResource2.isFile()) {
            hashtable.put(string, 500);
            return false;
        }
        WebResource webResource3 = this.resources.getResource(string2);
        if (!(webResource3.exists() || webResource3.getWebappPath().endsWith("/") || (n = webResource3.getWebappPath().lastIndexOf(47)) <= 0 || (webResource = this.resources.getResource((String)(object = webResource3.getWebappPath().substring(0, n)))).isDirectory())) {
            hashtable.put(string, 409);
            return false;
        }
        if (!webResource3.exists() && string2.endsWith("/") && string2.length() > 1) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        try {
            InputStream inputStream = webResource2.getInputStream();
            object = null;
            try {
                if (this.resources.write(string2, inputStream, false)) return true;
                hashtable.put(string, 500);
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.log(sm.getString("webdavservlet.inputstreamclosefail", new Object[]{string}), iOException);
            return true;
        }
    }

    private boolean deleteResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = this.getRelativePath(httpServletRequest);
        return this.deleteResource(string, httpServletRequest, httpServletResponse, true);
    }

    private boolean deleteResource(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws IOException {
        String string2;
        String string3 = httpServletRequest.getHeader("If");
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = httpServletRequest.getHeader("Lock-Token")) == null) {
            string2 = "";
        }
        if (this.isLocked(string, string3 + string2)) {
            httpServletResponse.sendError(423);
            return false;
        }
        WebResource webResource = this.resources.getResource(string);
        if (!webResource.exists()) {
            httpServletResponse.sendError(404);
            return false;
        }
        if (!webResource.isDirectory()) {
            if (!webResource.delete()) {
                httpServletResponse.sendError(500);
                return false;
            }
        } else {
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            this.deleteCollection(httpServletRequest, string, hashtable);
            if (!webResource.delete()) {
                hashtable.put(string, 500);
            }
            if (!hashtable.isEmpty()) {
                this.sendReport(httpServletRequest, httpServletResponse, hashtable);
                return false;
            }
        }
        if (bl) {
            httpServletResponse.setStatus(204);
        }
        return true;
    }

    private void deleteCollection(HttpServletRequest httpServletRequest, String string, Hashtable<String, Integer> hashtable) {
        String[] stringArray;
        String string2;
        if (this.debug > 1) {
            this.log("Delete:" + string);
        }
        if (this.isSpecialPath(string)) {
            hashtable.put(string, 403);
            return;
        }
        String string3 = httpServletRequest.getHeader("If");
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = httpServletRequest.getHeader("Lock-Token")) == null) {
            string2 = "";
        }
        for (String string4 : stringArray = this.resources.list(string)) {
            String string5 = string;
            if (!string5.equals("/")) {
                string5 = string5 + "/";
            }
            if (this.isLocked(string5 = string5 + string4, string3 + string2)) {
                hashtable.put(string5, 423);
                continue;
            }
            WebResource webResource = this.resources.getResource(string5);
            if (webResource.isDirectory()) {
                this.deleteCollection(httpServletRequest, string5, hashtable);
            }
            if (webResource.delete() || webResource.isDirectory()) continue;
            hashtable.put(string5, 500);
        }
    }

    private void sendReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable<String, Integer> hashtable) throws IOException {
        Object object;
        httpServletResponse.setStatus(207);
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.writeXMLHeader();
        xMLWriter.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            int n = hashtable.get(object);
            xMLWriter.writeElement("D", "response", 0);
            xMLWriter.writeElement("D", "href", 0);
            xMLWriter.writeText(this.getServletContext().getContextPath() + (String)object);
            xMLWriter.writeElement("D", "href", 1);
            xMLWriter.writeElement("D", "status", 0);
            xMLWriter.writeText("HTTP/1.1 " + n + " ");
            xMLWriter.writeElement("D", "status", 1);
            xMLWriter.writeElement("D", "response", 1);
        }
        xMLWriter.writeElement("D", "multistatus", 1);
        object = httpServletResponse.getWriter();
        ((Writer)object).write(xMLWriter.toString());
        ((Writer)object).close();
    }

    private void parseProperties(HttpServletRequest httpServletRequest, XMLWriter xMLWriter, String string, int n, Vector<String> vector) {
        if (this.isSpecialPath(string)) {
            return;
        }
        WebResource webResource = this.resources.getResource(string);
        if (!webResource.exists()) {
            return;
        }
        String string2 = httpServletRequest.getContextPath() + httpServletRequest.getServletPath();
        string2 = string2.endsWith("/") && string.startsWith("/") ? string2 + string.substring(1) : string2 + string;
        if (webResource.isDirectory() && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        String string3 = this.rewriteUrl(string2);
        this.generatePropFindResponse(xMLWriter, string3, string, n, vector, webResource.isFile(), false, webResource.getCreation(), webResource.getLastModified(), webResource.getContentLength(), this.getServletContext().getMimeType(webResource.getName()), this.generateETag(webResource));
    }

    private void parseLockNullProperties(HttpServletRequest httpServletRequest, XMLWriter xMLWriter, String string, int n, Vector<String> vector) {
        if (this.isSpecialPath(string)) {
            return;
        }
        LockInfo lockInfo = this.resourceLocks.get(string);
        if (lockInfo == null) {
            return;
        }
        String string2 = httpServletRequest.getRequestURI();
        String string3 = this.getRelativePath(httpServletRequest);
        String string4 = string.substring(string3.length());
        if (!string4.startsWith("/")) {
            string4 = "/" + string4;
        }
        String string5 = this.rewriteUrl(RequestUtil.normalize((String)(string2 + string4)));
        this.generatePropFindResponse(xMLWriter, string5, string, n, vector, true, true, lockInfo.creationDate.getTime(), lockInfo.creationDate.getTime(), 0L, "", "");
    }

    private void generatePropFindResponse(XMLWriter xMLWriter, String string, String string2, int n, Vector<String> vector, boolean bl, boolean bl2, long l, long l2, long l3, String string3, String string4) {
        xMLWriter.writeElement("D", "response", 0);
        String string5 = "HTTP/1.1 200 ";
        xMLWriter.writeElement("D", "href", 0);
        xMLWriter.writeText(string);
        xMLWriter.writeElement("D", "href", 1);
        String string6 = string2;
        int n2 = string2.lastIndexOf(47);
        if (n2 != -1) {
            string6 = string6.substring(n2 + 1);
        }
        switch (n) {
            case 1: {
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                xMLWriter.writeProperty("D", "creationdate", this.getISOCreationDate(l));
                xMLWriter.writeElement("D", "displayname", 0);
                xMLWriter.writeData(string6);
                xMLWriter.writeElement("D", "displayname", 1);
                if (bl) {
                    xMLWriter.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)l2));
                    xMLWriter.writeProperty("D", "getcontentlength", Long.toString(l3));
                    if (string3 != null) {
                        xMLWriter.writeProperty("D", "getcontenttype", string3);
                    }
                    xMLWriter.writeProperty("D", "getetag", string4);
                    if (bl2) {
                        xMLWriter.writeElement("D", "resourcetype", 0);
                        xMLWriter.writeElement("D", "lock-null", 2);
                        xMLWriter.writeElement("D", "resourcetype", 1);
                    } else {
                        xMLWriter.writeElement("D", "resourcetype", 2);
                    }
                } else {
                    xMLWriter.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)l2));
                    xMLWriter.writeElement("D", "resourcetype", 0);
                    xMLWriter.writeElement("D", "collection", 2);
                    xMLWriter.writeElement("D", "resourcetype", 1);
                }
                xMLWriter.writeProperty("D", "source", "");
                String string7 = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                xMLWriter.writeElement("D", "supportedlock", 0);
                xMLWriter.writeText(string7);
                xMLWriter.writeElement("D", "supportedlock", 1);
                this.generateLockDiscovery(string2, xMLWriter);
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
                break;
            }
            case 2: {
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                xMLWriter.writeElement("D", "creationdate", 2);
                xMLWriter.writeElement("D", "displayname", 2);
                if (bl) {
                    xMLWriter.writeElement("D", "getcontentlanguage", 2);
                    xMLWriter.writeElement("D", "getcontentlength", 2);
                    xMLWriter.writeElement("D", "getcontenttype", 2);
                    xMLWriter.writeElement("D", "getetag", 2);
                    xMLWriter.writeElement("D", "getlastmodified", 2);
                }
                xMLWriter.writeElement("D", "resourcetype", 2);
                xMLWriter.writeElement("D", "source", 2);
                xMLWriter.writeElement("D", "lockdiscovery", 2);
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
                break;
            }
            case 0: {
                Object object;
                Vector<Object> vector2 = new Vector<Object>();
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                Enumeration<String> enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (((String)object).equals("creationdate")) {
                        xMLWriter.writeProperty("D", "creationdate", this.getISOCreationDate(l));
                        continue;
                    }
                    if (((String)object).equals("displayname")) {
                        xMLWriter.writeElement("D", "displayname", 0);
                        xMLWriter.writeData(string6);
                        xMLWriter.writeElement("D", "displayname", 1);
                        continue;
                    }
                    if (((String)object).equals("getcontentlanguage")) {
                        if (bl) {
                            xMLWriter.writeElement("D", "getcontentlanguage", 2);
                            continue;
                        }
                        vector2.addElement(object);
                        continue;
                    }
                    if (((String)object).equals("getcontentlength")) {
                        if (bl) {
                            xMLWriter.writeProperty("D", "getcontentlength", Long.toString(l3));
                            continue;
                        }
                        vector2.addElement(object);
                        continue;
                    }
                    if (((String)object).equals("getcontenttype")) {
                        if (bl) {
                            xMLWriter.writeProperty("D", "getcontenttype", string3);
                            continue;
                        }
                        vector2.addElement(object);
                        continue;
                    }
                    if (((String)object).equals("getetag")) {
                        if (bl) {
                            xMLWriter.writeProperty("D", "getetag", string4);
                            continue;
                        }
                        vector2.addElement(object);
                        continue;
                    }
                    if (((String)object).equals("getlastmodified")) {
                        if (bl) {
                            xMLWriter.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)l2));
                            continue;
                        }
                        vector2.addElement(object);
                        continue;
                    }
                    if (((String)object).equals("resourcetype")) {
                        if (bl) {
                            if (bl2) {
                                xMLWriter.writeElement("D", "resourcetype", 0);
                                xMLWriter.writeElement("D", "lock-null", 2);
                                xMLWriter.writeElement("D", "resourcetype", 1);
                                continue;
                            }
                            xMLWriter.writeElement("D", "resourcetype", 2);
                            continue;
                        }
                        xMLWriter.writeElement("D", "resourcetype", 0);
                        xMLWriter.writeElement("D", "collection", 2);
                        xMLWriter.writeElement("D", "resourcetype", 1);
                        continue;
                    }
                    if (((String)object).equals("source")) {
                        xMLWriter.writeProperty("D", "source", "");
                        continue;
                    }
                    if (((String)object).equals("supportedlock")) {
                        String string8 = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                        xMLWriter.writeElement("D", "supportedlock", 0);
                        xMLWriter.writeText(string8);
                        xMLWriter.writeElement("D", "supportedlock", 1);
                        continue;
                    }
                    if (((String)object).equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(string2, xMLWriter)) continue;
                        vector2.addElement(object);
                        continue;
                    }
                    vector2.addElement(object);
                }
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
                object = vector2.elements();
                if (!object.hasMoreElements()) break;
                string5 = "HTTP/1.1 404 ";
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                while (object.hasMoreElements()) {
                    xMLWriter.writeElement("D", (String)object.nextElement(), 2);
                }
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
            }
        }
        xMLWriter.writeElement("D", "response", 1);
    }

    private boolean generateLockDiscovery(String string, XMLWriter xMLWriter) {
        LockInfo lockInfo = this.resourceLocks.get(string);
        Enumeration<LockInfo> enumeration = this.collectionLocks.elements();
        boolean bl = false;
        if (lockInfo != null) {
            bl = true;
            xMLWriter.writeElement("D", "lockdiscovery", 0);
            lockInfo.toXML(xMLWriter);
        }
        while (enumeration.hasMoreElements()) {
            LockInfo lockInfo2 = enumeration.nextElement();
            if (!string.startsWith(lockInfo2.path)) continue;
            if (!bl) {
                bl = true;
                xMLWriter.writeElement("D", "lockdiscovery", 0);
            }
            lockInfo2.toXML(xMLWriter);
        }
        if (!bl) {
            return false;
        }
        xMLWriter.writeElement("D", "lockdiscovery", 1);
        return true;
    }

    private String getISOCreationDate(long l) {
        return creationDateFormat.format(new Date(l));
    }

    @Override
    protected String determineMethodsAllowed(HttpServletRequest httpServletRequest) {
        WebResource webResource = this.resources.getResource(this.getRelativePath(httpServletRequest));
        StringBuilder stringBuilder = new StringBuilder("OPTIONS, GET, POST, HEAD");
        if (!this.readOnly) {
            stringBuilder.append(", DELETE");
            if (!webResource.isDirectory()) {
                stringBuilder.append(", PUT");
            }
        }
        if (httpServletRequest instanceof RequestFacade && ((RequestFacade)httpServletRequest).getAllowTrace()) {
            stringBuilder.append(", TRACE");
        }
        stringBuilder.append(", LOCK, UNLOCK, PROPPATCH, COPY, MOVE");
        if (this.listings) {
            stringBuilder.append(", PROPFIND");
        }
        if (!webResource.exists()) {
            stringBuilder.append(", MKCOL");
        }
        return stringBuilder.toString();
    }

    static {
        URL_ENCODER_XML.removeSafeCharacter('&');
        creationDateFormat = new ConcurrentDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US, TimeZone.getTimeZone("GMT"));
    }

    private static class WebdavResolver
    implements EntityResolver {
        private ServletContext context;

        public WebdavResolver(ServletContext servletContext) {
            this.context = servletContext;
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            this.context.log(DefaultServlet.sm.getString("webdavservlet.externalEntityIgnored", new Object[]{string, string2}));
            return new InputSource(new StringReader("Ignored external entity"));
        }
    }

    private static class LockInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int maxDepth;
        String path = "/";
        String type = "write";
        String scope = "exclusive";
        int depth = 0;
        String owner = "";
        Vector<String> tokens = new Vector();
        long expiresAt = 0L;
        Date creationDate = new Date();

        public LockInfo(int n) {
            this.maxDepth = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Type:");
            stringBuilder.append(this.type);
            stringBuilder.append("\nScope:");
            stringBuilder.append(this.scope);
            stringBuilder.append("\nDepth:");
            stringBuilder.append(this.depth);
            stringBuilder.append("\nOwner:");
            stringBuilder.append(this.owner);
            stringBuilder.append("\nExpiration:");
            stringBuilder.append(FastHttpDateFormat.formatDate((long)this.expiresAt));
            Enumeration<String> enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                stringBuilder.append("\nToken:");
                stringBuilder.append(enumeration.nextElement());
            }
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() > this.expiresAt;
        }

        public boolean isExclusive() {
            return this.scope.equals("exclusive");
        }

        public void toXML(XMLWriter xMLWriter) {
            xMLWriter.writeElement("D", "activelock", 0);
            xMLWriter.writeElement("D", "locktype", 0);
            xMLWriter.writeElement("D", this.type, 2);
            xMLWriter.writeElement("D", "locktype", 1);
            xMLWriter.writeElement("D", "lockscope", 0);
            xMLWriter.writeElement("D", this.scope, 2);
            xMLWriter.writeElement("D", "lockscope", 1);
            xMLWriter.writeElement("D", "depth", 0);
            if (this.depth == this.maxDepth) {
                xMLWriter.writeText("Infinity");
            } else {
                xMLWriter.writeText("0");
            }
            xMLWriter.writeElement("D", "depth", 1);
            xMLWriter.writeElement("D", "owner", 0);
            xMLWriter.writeText(this.owner);
            xMLWriter.writeElement("D", "owner", 1);
            xMLWriter.writeElement("D", "timeout", 0);
            long l = (this.expiresAt - System.currentTimeMillis()) / 1000L;
            xMLWriter.writeText("Second-" + l);
            xMLWriter.writeElement("D", "timeout", 1);
            xMLWriter.writeElement("D", "locktoken", 0);
            Enumeration<String> enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                xMLWriter.writeElement("D", "href", 0);
                xMLWriter.writeText("opaquelocktoken:" + enumeration.nextElement());
                xMLWriter.writeElement("D", "href", 1);
            }
            xMLWriter.writeElement("D", "locktoken", 1);
            xMLWriter.writeElement("D", "activelock", 1);
        }
    }
}

