/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awtjs2d;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import org.jmol.api.SC;
import org.jmol.awtjs.swing.ButtonGroup;
import org.jmol.awtjs.swing.Component;
import org.jmol.awtjs.swing.JCheckBoxMenuItem;
import org.jmol.awtjs.swing.JMenu;
import org.jmol.awtjs.swing.JMenuItem;
import org.jmol.awtjs.swing.JPopupMenu;
import org.jmol.awtjs.swing.JRadioButtonMenuItem;
import org.jmol.popup.GenericPopup;
import org.jmol.popup.PopupHelper;

public class JSPopupHelper
implements PopupHelper {
    GenericPopup popup;
    private ButtonGroup buttonGroup;

    public JSPopupHelper(GenericPopup popup) {
        this.popup = popup;
    }

    public SC menuCreatePopup(String name, Object applet) {
        JPopupMenu j = new JPopupMenu(name);
        j.setInvoker(applet);
        return j;
    }

    public SC getMenu(String name) {
        JMenu jm = new JMenu();
        jm.setName(name);
        return jm;
    }

    public SC getMenuItem(String text) {
        return new JMenuItem(text);
    }

    public SC getRadio(String name) {
        return new JRadioButtonMenuItem();
    }

    public SC getCheckBox(String name) {
        return new JCheckBoxMenuItem();
    }

    public void menuAddButtonGroup(SC item) {
        if (item == null) {
            this.buttonGroup = null;
            return;
        }
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        this.buttonGroup.add(item);
    }

    public int getItemType(SC m) {
        return ((JMenuItem)m).btnType;
    }

    public void menuInsertSubMenu(SC menu, SC subMenu, int index) {
        ((Component)subMenu).setParent((Object)menu);
    }

    public SC getSwingComponent(Object component) {
        return (SC)component;
    }

    public void menuClearListeners(SC menu) {
        if (menu != null) {
            ((JPopupMenu)menu).disposeMenu();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.popup.menuCheckBoxCallback((SC)e.getSource());
    }

    public void actionPerformed(ActionEvent e) {
        this.popup.menuClickCallback((SC)e.getSource(), e.getActionCommand());
    }

    public Object getButtonGroup() {
        return this.buttonGroup;
    }

    public void handleEvent(MouseEvent e) {
        String type = "" + e.getID();
        if (type == "mouseenter") {
            this.mouseEntered(e);
        } else if (type == "mouseleave") {
            this.mouseExited(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
        SC jmi = (SC)e.getSource();
        this.popup.menuFocusCallback(jmi.getName(), jmi.getActionCommand(), true);
    }

    public void mouseExited(MouseEvent e) {
        SC jmi = (SC)e.getSource();
        this.popup.menuFocusCallback(jmi.getName(), jmi.getActionCommand(), false);
    }

    public void dispose(SC popupMenu) {
        this.menuClearListeners(popupMenu);
        this.popup = null;
    }
}

