/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.vp;

import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedFrames;

public abstract class ViewPlatformAWTBehavior
extends ViewPlatformBehavior
implements MouseListener,
MouseMotionListener,
KeyListener,
MouseWheelListener {
    private static final boolean DEBUG = false;
    protected static final int POST_ID = 9998;
    protected WakeupOnElapsedFrames frameWakeup;
    protected WakeupOnBehaviorPost postWakeup;
    protected Transform3D targetTransform = new Transform3D();
    protected boolean motion = false;
    public static final int MOUSE_LISTENER = 1;
    public static final int MOUSE_MOTION_LISTENER = 2;
    public static final int KEY_LISTENER = 4;
    public static final int MOUSE_WHEEL_LISTENER = 8;
    protected Canvas3D[] canvases;
    private ArrayList eventQueue = new ArrayList();
    private int listenerFlags = 0;
    private boolean firstEvent = false;

    protected ViewPlatformAWTBehavior() {
    }

    protected ViewPlatformAWTBehavior(int n) {
        this.setListenerFlags(n);
    }

    public ViewPlatformAWTBehavior(Canvas3D canvas3D, int n) {
        if (canvas3D == null) {
            throw new NullPointerException();
        }
        this.canvases = new Canvas3D[]{canvas3D};
        this.setListenerFlags(n);
    }

    protected void setListenerFlags(int n) {
        this.listenerFlags = n;
    }

    public void initialize() {
        this.frameWakeup = new WakeupOnElapsedFrames(0);
        this.postWakeup = new WakeupOnBehaviorPost((Behavior)this, 9998);
        this.wakeupOn((WakeupCondition)this.postWakeup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration enumeration) {
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            WakeupCondition wakeupCondition = (WakeupCondition)enumeration.nextElement();
            if (wakeupCondition instanceof WakeupOnBehaviorPost) {
                bl = true;
                continue;
            }
            if (!(wakeupCondition instanceof WakeupOnElapsedFrames)) continue;
            AWTEvent[] aWTEventArray = null;
            ArrayList arrayList = this.eventQueue;
            synchronized (arrayList) {
                aWTEventArray = this.eventQueue.toArray(new AWTEvent[this.eventQueue.size()]);
                this.eventQueue.clear();
            }
            this.processAWTEvents(aWTEventArray);
            if (!this.motion) continue;
            this.integrateTransforms();
        }
        if (this.motion || bl) {
            this.wakeupOn((WakeupCondition)this.frameWakeup);
        } else {
            this.wakeupOn((WakeupCondition)this.postWakeup);
        }
    }

    public void setEnable(boolean bl) {
        if (bl == this.getEnable()) {
            return;
        }
        super.setEnable(bl);
        if (this.canvases != null) {
            this.enableListeners(bl);
        }
    }

    private void enableListeners(boolean bl) {
        block16: {
            int n;
            block15: {
                int n2;
                if (!bl) break block15;
                this.firstEvent = true;
                if ((this.listenerFlags & 1) != 0) {
                    for (n2 = 0; n2 < this.canvases.length; ++n2) {
                        this.canvases[n2].addMouseListener((MouseListener)this);
                    }
                }
                if ((this.listenerFlags & 2) != 0) {
                    for (n2 = 0; n2 < this.canvases.length; ++n2) {
                        this.canvases[n2].addMouseMotionListener((MouseMotionListener)this);
                    }
                }
                if ((this.listenerFlags & 8) != 0) {
                    for (n2 = 0; n2 < this.canvases.length; ++n2) {
                        this.canvases[n2].addMouseWheelListener((MouseWheelListener)this);
                    }
                }
                if ((this.listenerFlags & 4) == 0) break block16;
                for (n2 = 0; n2 < this.canvases.length; ++n2) {
                    this.canvases[n2].addKeyListener((KeyListener)this);
                }
                break block16;
            }
            if ((this.listenerFlags & 1) != 0) {
                for (n = 0; n < this.canvases.length; ++n) {
                    this.canvases[n].removeMouseListener((MouseListener)this);
                }
            }
            if ((this.listenerFlags & 2) != 0) {
                for (n = 0; n < this.canvases.length; ++n) {
                    this.canvases[n].removeMouseMotionListener((MouseMotionListener)this);
                }
            }
            if ((this.listenerFlags & 8) != 0) {
                for (n = 0; n < this.canvases.length; ++n) {
                    this.canvases[n].removeMouseWheelListener((MouseWheelListener)this);
                }
            }
            if ((this.listenerFlags & 4) != 0) {
                for (n = 0; n < this.canvases.length; ++n) {
                    this.canvases[n].removeKeyListener((KeyListener)this);
                }
            }
        }
    }

    @Override
    public void setViewingPlatform(ViewingPlatform viewingPlatform) {
        super.setViewingPlatform(viewingPlatform);
        if (viewingPlatform == null) {
            this.enableListeners(false);
        } else {
            Viewer[] viewerArray;
            if (this.canvases != null) {
                this.enableListeners(false);
            }
            if ((viewerArray = viewingPlatform.getViewers()) != null && viewerArray[0] != null) {
                this.canvases = viewerArray[0].getCanvas3Ds();
            }
            if (this.canvases == null || this.canvases[0] == null) {
                throw new IllegalStateException("No canvases available");
            }
            if (this.getEnable()) {
                this.enableListeners(true);
            }
        }
    }

    protected abstract void processAWTEvents(AWTEvent[] var1);

    protected abstract void integrateTransforms();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueAWTEvent(AWTEvent aWTEvent) {
        ArrayList arrayList = this.eventQueue;
        synchronized (arrayList) {
            this.eventQueue.add(aWTEvent);
            if (this.firstEvent || this.eventQueue.size() == 1) {
                this.firstEvent = false;
                this.postId(9998);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.queueAWTEvent(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.queueAWTEvent(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.queueAWTEvent(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.queueAWTEvent(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.queueAWTEvent(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.queueAWTEvent(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.queueAWTEvent(mouseEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.queueAWTEvent(keyEvent);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.queueAWTEvent(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.queueAWTEvent(keyEvent);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.queueAWTEvent(mouseWheelEvent);
    }
}

