
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "downloadmanager_downloadinfo_wrapper.h"

// inner classes

// Extra includes
#include <webpage.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_DownloadManager_DownloadInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::DownloadManager::DownloadInfo >()))
        return -1;

    ::DownloadManager::DownloadInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DownloadManager.DownloadInfo.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_DownloadManager_DownloadInfo_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:DownloadInfo", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: DownloadInfo::DownloadInfo(WebPage*)
    // 1: DownloadInfo::DownloadInfo(DownloadManager::DownloadInfo)
    if (numArgs == 0) {
        overloadId = 0; // DownloadInfo(WebPage*)
    } else if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBPAGE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // DownloadInfo(WebPage*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_DOWNLOADINFO_IDX]), (pyArgs[0])))) {
        overloadId = 1; // DownloadInfo(DownloadManager::DownloadInfo)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_DownloadManager_DownloadInfo_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // DownloadInfo(WebPage * p)
        {
            if (kwds) {
                PyObject *value{};
                PyObject *kwds_dup = PyDict_Copy(kwds);
                static PyObject *const key_p = Shiboken::String::createStaticString("p");
                if (PyDict_Contains(kwds, key_p)) {
                    value = PyDict_GetItem(kwds, key_p);
                    if (value && pyArgs[0]) {
                        errInfo = key_p;
                        Py_INCREF(errInfo);
                        goto Sbk_DownloadManager_DownloadInfo_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBPAGE_IDX]), (pyArgs[0]))))
                            goto Sbk_DownloadManager_DownloadInfo_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_p);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup;
                    goto Sbk_DownloadManager_DownloadInfo_Init_TypeError;
                } else {
                    Py_DECREF(kwds_dup);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::WebPage *cppArg0 = 0;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // DownloadInfo(WebPage*)
                cptr = new ::DownloadManager::DownloadInfo(cppArg0);
            }
            break;
        }
        case 1: // DownloadInfo(const DownloadManager::DownloadInfo & DownloadInfo)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_DownloadManager_DownloadInfo_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::DownloadManager::DownloadInfo cppArg0_local;
            ::DownloadManager::DownloadInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_DOWNLOADINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // DownloadInfo(DownloadManager::DownloadInfo)
                cptr = new ::DownloadManager::DownloadInfo(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::DownloadManager::DownloadInfo >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_DownloadManager_DownloadInfo_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_DownloadManager_DownloadInfo_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_DownloadManager_DownloadInfo___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_DOWNLOADINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_DOWNLOADINFO_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_DownloadManager_DownloadInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_DownloadManager_DownloadInfo_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_DownloadManager_DownloadInfo___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_DownloadManager_DownloadInfo_get_page(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_DOWNLOADINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBPAGE_IDX]), cppSelf->page);
    return pyOut;
}
static int Sbk_DownloadManager_DownloadInfo_set_page(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_DOWNLOADINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'page' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBPAGE_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'page', 'WebPage' or convertible type expected");
        return -1;
    }

    ::WebPage *& cppOut_ptr = cppSelf->page;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "page", pyIn);
    return 0;
}

static PyObject *Sbk_DownloadManager_DownloadInfo_get_suggestedFileName(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_DOWNLOADINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->suggestedFileName);
    return pyOut;
}
static int Sbk_DownloadManager_DownloadInfo_set_suggestedFileName(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_DOWNLOADINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'suggestedFileName' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'suggestedFileName', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->suggestedFileName;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_DownloadManager_DownloadInfo_get_askWhatToDo(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_DOWNLOADINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->askWhatToDo;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_DownloadManager_DownloadInfo_set_askWhatToDo(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_DOWNLOADINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'askWhatToDo' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'askWhatToDo', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->askWhatToDo;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->askWhatToDo = cppOut_local;

    return 0;
}

static PyObject *Sbk_DownloadManager_DownloadInfo_get_forceChoosingPath(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_DOWNLOADINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->forceChoosingPath;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_DownloadManager_DownloadInfo_set_forceChoosingPath(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_DOWNLOADINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'forceChoosingPath' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'forceChoosingPath', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->forceChoosingPath;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->forceChoosingPath = cppOut_local;

    return 0;
}

// Getters and Setters for DownloadInfo
static PyGetSetDef Sbk_DownloadManager_DownloadInfo_getsetlist[] = {
    {const_cast<char *>("page"), Sbk_DownloadManager_DownloadInfo_get_page, Sbk_DownloadManager_DownloadInfo_set_page},
    {const_cast<char *>("suggestedFileName"), Sbk_DownloadManager_DownloadInfo_get_suggestedFileName, Sbk_DownloadManager_DownloadInfo_set_suggestedFileName},
    {const_cast<char *>("askWhatToDo"), Sbk_DownloadManager_DownloadInfo_get_askWhatToDo, Sbk_DownloadManager_DownloadInfo_set_askWhatToDo},
    {const_cast<char *>("forceChoosingPath"), Sbk_DownloadManager_DownloadInfo_get_forceChoosingPath, Sbk_DownloadManager_DownloadInfo_set_forceChoosingPath},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_DownloadManager_DownloadInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_DownloadManager_DownloadInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_DownloadManager_DownloadInfo_Type = nullptr;
static SbkObjectType *Sbk_DownloadManager_DownloadInfo_TypeF(void)
{
    return _Sbk_DownloadManager_DownloadInfo_Type;
}

static PyType_Slot Sbk_DownloadManager_DownloadInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_DownloadManager_DownloadInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_DownloadManager_DownloadInfo_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_DownloadManager_DownloadInfo_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_DownloadManager_DownloadInfo_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_DownloadManager_DownloadInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_DownloadManager_DownloadInfo_spec = {
    "1:PyFalkon.DownloadManager.DownloadInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_DownloadManager_DownloadInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void DownloadInfo_PythonToCpp_DownloadInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_DownloadManager_DownloadInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_DownloadInfo_PythonToCpp_DownloadInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_DownloadManager_DownloadInfo_TypeF())))
        return DownloadInfo_PythonToCpp_DownloadInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *DownloadInfo_PTR_CppToPython_DownloadInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::DownloadManager::DownloadInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_DownloadManager_DownloadInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *DownloadInfo_COPY_CppToPython_DownloadInfo(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_DownloadManager_DownloadInfo_TypeF(), new ::DownloadManager::DownloadInfo(*reinterpret_cast<const ::DownloadManager::DownloadInfo *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void DownloadInfo_PythonToCpp_DownloadInfo_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::DownloadManager::DownloadInfo *>(cppOut) = *reinterpret_cast< ::DownloadManager::DownloadInfo *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_DOWNLOADINFO_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_DownloadInfo_PythonToCpp_DownloadInfo_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_DownloadManager_DownloadInfo_TypeF())))
        return DownloadInfo_PythonToCpp_DownloadInfo_COPY;
    return {};
}

// Implicit conversions.
static void WebPagePTR_PythonToCpp_DownloadManager_DownloadInfo(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::DownloadManager::DownloadInfo *>(cppOut) = ::DownloadManager::DownloadInfo(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_WebPagePTR_PythonToCpp_DownloadManager_DownloadInfo_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], pyIn))
        return WebPagePTR_PythonToCpp_DownloadManager_DownloadInfo;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *DownloadManager_DownloadInfo_SignatureStrings[] = {
    "1:PyFalkon.DownloadManager.DownloadInfo(self,p:PyFalkon.WebPage=0)",
    "0:PyFalkon.DownloadManager.DownloadInfo(self,DownloadInfo:PyFalkon.DownloadManager.DownloadInfo)",
    "PyFalkon.DownloadManager.DownloadInfo.__copy__()",
    nullptr}; // Sentinel

void init_DownloadManager_DownloadInfo(PyObject *enclosingClass)
{
    _Sbk_DownloadManager_DownloadInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "DownloadInfo",
        "DownloadManager::DownloadInfo",
        &Sbk_DownloadManager_DownloadInfo_spec,
        &Shiboken::callCppDestructor< ::DownloadManager::DownloadInfo >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_DownloadManager_DownloadInfo_Type);
    InitSignatureStrings(pyType, DownloadManager_DownloadInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_DownloadManager_DownloadInfo_Type), Sbk_DownloadManager_DownloadInfo_PropertyStrings);
    SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_DOWNLOADINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_DownloadManager_DownloadInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_DownloadManager_DownloadInfo_TypeF(),
        DownloadInfo_PythonToCpp_DownloadInfo_PTR,
        is_DownloadInfo_PythonToCpp_DownloadInfo_PTR_Convertible,
        DownloadInfo_PTR_CppToPython_DownloadInfo,
        DownloadInfo_COPY_CppToPython_DownloadInfo);

    Shiboken::Conversions::registerConverterName(converter, "DownloadManager::DownloadInfo");
    Shiboken::Conversions::registerConverterName(converter, "DownloadManager::DownloadInfo*");
    Shiboken::Conversions::registerConverterName(converter, "DownloadManager::DownloadInfo&");
    Shiboken::Conversions::registerConverterName(converter, "DownloadInfo");
    Shiboken::Conversions::registerConverterName(converter, "DownloadInfo*");
    Shiboken::Conversions::registerConverterName(converter, "DownloadInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::DownloadManager::DownloadInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        DownloadInfo_PythonToCpp_DownloadInfo_COPY,
        is_DownloadInfo_PythonToCpp_DownloadInfo_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        WebPagePTR_PythonToCpp_DownloadManager_DownloadInfo,
        is_WebPagePTR_PythonToCpp_DownloadManager_DownloadInfo_Convertible);


}
