/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyRep;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;

final class PBKDF2KeyImpl
implements PBEKey {
    static final long serialVersionUID = -2234868909660948157L;
    private char[] passwd;
    private byte[] salt;
    private int iterCount;
    private byte[] key;
    private Mac prf;

    private static byte[] getPasswordBytes(char[] passwd) {
        Charset utf8 = Charset.forName("UTF-8");
        CharBuffer cb = CharBuffer.wrap(passwd);
        ByteBuffer bb = utf8.encode(cb);
        int len = bb.limit();
        byte[] passwdBytes = new byte[len];
        bb.get(passwdBytes, 0, len);
        return passwdBytes;
    }

    PBKDF2KeyImpl(PBEKeySpec keySpec, String prfAlgo) throws InvalidKeySpecException {
        char[] passwd = keySpec.getPassword();
        this.passwd = passwd == null ? new char[0] : (char[])passwd.clone();
        byte[] passwdBytes = PBKDF2KeyImpl.getPasswordBytes(this.passwd);
        if (passwd != null) {
            Arrays.fill(passwd, '\u0000');
        }
        this.salt = keySpec.getSalt();
        if (this.salt == null) {
            throw new InvalidKeySpecException("Salt not found");
        }
        this.iterCount = keySpec.getIterationCount();
        if (this.iterCount == 0) {
            throw new InvalidKeySpecException("Iteration count not found");
        }
        if (this.iterCount < 0) {
            throw new InvalidKeySpecException("Iteration count is negative");
        }
        int keyLength = keySpec.getKeyLength();
        if (keyLength == 0) {
            throw new InvalidKeySpecException("Key length not found");
        }
        if (keyLength == 0) {
            throw new InvalidKeySpecException("Key length is negative");
        }
        try {
            this.prf = Mac.getInstance(prfAlgo, SunJCE.getInstance());
            this.key = PBKDF2KeyImpl.deriveKey(this.prf, passwdBytes, this.salt, this.iterCount, keyLength);
        }
        catch (NoSuchAlgorithmException nsae) {
            InvalidKeySpecException ike = new InvalidKeySpecException();
            ike.initCause(nsae);
            throw ike;
        }
        finally {
            Arrays.fill(passwdBytes, (byte)0);
        }
    }

    private static byte[] deriveKey(final Mac prf, final byte[] password, byte[] salt, int iterCount, int keyLengthInBit) {
        int keyLength = keyLengthInBit / 8;
        byte[] key = new byte[keyLength];
        try {
            int hlen = prf.getMacLength();
            int intL = (keyLength + hlen - 1) / hlen;
            int intR = keyLength - (intL - 1) * hlen;
            byte[] ui = new byte[hlen];
            byte[] ti = new byte[hlen];
            SecretKey macKey = new SecretKey(){
                private static final long serialVersionUID = 7874493593505141603L;

                @Override
                public String getAlgorithm() {
                    return prf.getAlgorithm();
                }

                @Override
                public String getFormat() {
                    return "RAW";
                }

                @Override
                public byte[] getEncoded() {
                    return password;
                }

                public int hashCode() {
                    return Arrays.hashCode(password) * 41 + prf.getAlgorithm().toLowerCase(Locale.ENGLISH).hashCode();
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    SecretKey sk = (SecretKey)obj;
                    return prf.getAlgorithm().equalsIgnoreCase(sk.getAlgorithm()) && MessageDigest.isEqual(password, sk.getEncoded());
                }
            };
            prf.init(macKey);
            byte[] ibytes = new byte[4];
            for (int i = 1; i <= intL; ++i) {
                prf.update(salt);
                ibytes[3] = (byte)i;
                ibytes[2] = (byte)(i >> 8 & 0xFF);
                ibytes[1] = (byte)(i >> 16 & 0xFF);
                ibytes[0] = (byte)(i >> 24 & 0xFF);
                prf.update(ibytes);
                prf.doFinal(ui, 0);
                System.arraycopy(ui, 0, ti, 0, ui.length);
                for (int j = 2; j <= iterCount; ++j) {
                    prf.update(ui);
                    prf.doFinal(ui, 0);
                    for (int k = 0; k < ui.length; ++k) {
                        int n = k;
                        ti[n] = (byte)(ti[n] ^ ui[k]);
                    }
                }
                if (i == intL) {
                    System.arraycopy(ti, 0, key, (i - 1) * hlen, intR);
                    continue;
                }
                System.arraycopy(ti, 0, key, (i - 1) * hlen, hlen);
            }
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException("Error deriving PBKDF2 keys");
        }
        return key;
    }

    @Override
    public synchronized byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public String getAlgorithm() {
        return "PBKDF2With" + this.prf.getAlgorithm();
    }

    @Override
    public int getIterationCount() {
        return this.iterCount;
    }

    @Override
    public synchronized char[] getPassword() {
        return (char[])this.passwd.clone();
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        int retval = 0;
        for (int i = 1; i < this.key.length; ++i) {
            retval += this.key[i] * i;
        }
        return retval ^= this.getAlgorithm().toLowerCase(Locale.ENGLISH).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SecretKey)) {
            return false;
        }
        SecretKey that = (SecretKey)obj;
        if (!that.getAlgorithm().equalsIgnoreCase(this.getAlgorithm())) {
            return false;
        }
        if (!that.getFormat().equalsIgnoreCase("RAW")) {
            return false;
        }
        byte[] thatEncoded = that.getEncoded();
        boolean ret = MessageDigest.isEqual(this.key, thatEncoded);
        Arrays.fill(thatEncoded, (byte)0);
        return ret;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            PBKDF2KeyImpl pBKDF2KeyImpl = this;
            synchronized (pBKDF2KeyImpl) {
                if (this.passwd != null) {
                    Arrays.fill(this.passwd, '\u0000');
                    this.passwd = null;
                }
                if (this.key != null) {
                    Arrays.fill(this.key, (byte)0);
                    this.key = null;
                }
            }
        }
        finally {
            super.finalize();
        }
    }
}

