/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.catalina.tribes.Member;

public class AbsoluteOrder {
    public static final AbsoluteComparator comp = new AbsoluteComparator();

    protected AbsoluteOrder() {
    }

    public static void absoluteOrder(Member[] memberArray) {
        if (memberArray == null || memberArray.length <= 1) {
            return;
        }
        Arrays.sort(memberArray, comp);
    }

    public static void absoluteOrder(List<Member> list) {
        if (list == null || list.size() <= 1) {
            return;
        }
        list.sort(comp);
    }

    public static class AbsoluteComparator
    implements Comparator<Member>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Member member, Member member2) {
            int n = this.compareIps(member, member2);
            if (n == 0) {
                n = this.comparePorts(member, member2);
            }
            if (n == 0) {
                n = this.compareIds(member, member2);
            }
            return n;
        }

        public int compareIps(Member member, Member member2) {
            return this.compareBytes(member.getHost(), member2.getHost());
        }

        public int comparePorts(Member member, Member member2) {
            return this.compareInts(member.getPort(), member2.getPort());
        }

        public int compareIds(Member member, Member member2) {
            return this.compareBytes(member.getUniqueId(), member2.getUniqueId());
        }

        protected int compareBytes(byte[] byArray, byte[] byArray2) {
            int n = 0;
            if (byArray.length == byArray2.length) {
                for (int i = 0; n == 0 && i < byArray.length; ++i) {
                    n = this.compareBytes(byArray[i], byArray2[i]);
                }
            } else {
                n = byArray.length < byArray2.length ? -1 : 1;
            }
            return n;
        }

        protected int compareBytes(byte by, byte by2) {
            return this.compareInts(by, by2);
        }

        protected int compareInts(int n, int n2) {
            int n3 = 0;
            if (n != n2) {
                n3 = n < n2 ? -1 : 1;
            }
            return n3;
        }
    }
}

