/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk;

import java.time.Instant;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public final class TimeDetailsProvider
extends DetailsProvider.Basic {
    private static final String INSTANT_MASK = "java.time.Instant";

    public TimeDetailsProvider() {
        super(INSTANT_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance) {
        if (INSTANT_MASK.equals(className)) {
            long seconds = DetailsUtils.getLongFieldValue(instance, "seconds", -1L);
            int nanos = DetailsUtils.getIntFieldValue(instance, "nanos", -1);
            if (seconds != -1L && nanos != -1) {
                return Instant.ofEpochSecond(seconds, nanos).toString();
            }
        }
        return null;
    }
}

