/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.IOException;
import java.io.Serializable;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;

public final class PositionBounds
implements Serializable {
    static final long serialVersionUID = 3338509625548836633L;
    private PositionRef begin;
    private PositionRef end;

    public PositionBounds(PositionRef positionRef, PositionRef positionRef2) {
        this.begin = positionRef;
        this.end = positionRef2;
    }

    public PositionRef getBegin() {
        return this.begin;
    }

    public PositionRef getEnd() {
        return this.end;
    }

    public void setText(final String string) throws IOException, BadLocationException {
        final CloneableEditorSupport cloneableEditorSupport = this.begin.getCloneableEditorSupport();
        final StyledDocument styledDocument = cloneableEditorSupport.openDocument();
        final BadLocationException[] badLocationExceptionArray = new BadLocationException[]{null};
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    int n = PositionBounds.this.begin.getOffset();
                    int n2 = PositionBounds.this.end.getOffset();
                    int n3 = string.length();
                    if (n3 == 0) {
                        if (n2 > n) {
                            styledDocument.remove(n, n2 - n);
                        }
                    } else {
                        int n4 = styledDocument.getLength();
                        if (n2 - n >= 2) {
                            styledDocument.insertString(n + 1, string, null);
                            n3 = styledDocument.getLength() - n4;
                            styledDocument.remove(n + 1 + n3, n2 - n - 1);
                            styledDocument.remove(n, 1);
                        } else {
                            styledDocument.insertString(n, string, null);
                            n3 = styledDocument.getLength() - n4;
                            if (n2 > n) {
                                styledDocument.remove(n + n3, n2 - n);
                            }
                            if (PositionBounds.this.begin.getOffset() != n) {
                                PositionBounds.this.begin = cloneableEditorSupport.createPositionRef(n, PositionBounds.this.begin.getPositionBias());
                            }
                            if (PositionBounds.this.end.getOffset() - n != n3) {
                                PositionBounds.this.end = cloneableEditorSupport.createPositionRef(n + n3, PositionBounds.this.end.getPositionBias());
                            }
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationExceptionArray[0] = badLocationException;
                }
            }
        };
        NbDocument.runAtomic(styledDocument, runnable);
        if (badLocationExceptionArray[0] != null) {
            throw badLocationExceptionArray[0];
        }
    }

    public PositionBounds insertAfter(final String string) throws IOException, BadLocationException {
        if (string.length() == 0) {
            throw new BadLocationException(NbBundle.getBundle(PositionBounds.class).getString("MSG_Empty_string"), this.begin.getOffset());
        }
        final CloneableEditorSupport cloneableEditorSupport = this.begin.getCloneableEditorSupport();
        final StyledDocument styledDocument = cloneableEditorSupport.openDocument();
        final Object[] objectArray = new Object[]{null, null};
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = cloneableEditorSupport.getLock();
                synchronized (object) {
                    try {
                        int n = styledDocument.getLength();
                        int n2 = PositionBounds.this.end.getOffset();
                        styledDocument.insertString(n2, string, null);
                        int n3 = n2 + styledDocument.getLength() - n;
                        PositionBounds.this.end = cloneableEditorSupport.createPositionRef(n2, PositionBounds.this.end.getPositionBias());
                        PositionRef positionRef = cloneableEditorSupport.createPositionRef(n2, Position.Bias.Forward);
                        PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(n3, Position.Bias.Backward);
                        objectArray[1] = new PositionBounds(positionRef, positionRef2);
                    }
                    catch (BadLocationException badLocationException) {
                        objectArray[0] = badLocationException;
                    }
                }
            }
        };
        NbDocument.runAtomic(styledDocument, runnable);
        if (objectArray[0] != null) {
            throw (BadLocationException)objectArray[0];
        }
        return (PositionBounds)objectArray[1];
    }

    public String getText() throws BadLocationException, IOException {
        StyledDocument styledDocument = this.begin.getCloneableEditorSupport().openDocument();
        int n = this.begin.getOffset();
        int n2 = this.end.getOffset();
        return styledDocument.getText(n, n2 - n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Position bounds[");
        try {
            String string = this.getText();
            stringBuffer.append(this.begin);
            stringBuffer.append(",");
            stringBuffer.append(this.end);
            stringBuffer.append(",\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        catch (IOException iOException) {
            stringBuffer.append("Invalid: ");
            stringBuffer.append(iOException.getMessage());
        }
        catch (BadLocationException badLocationException) {
            stringBuffer.append("Invalid: ");
            stringBuffer.append(badLocationException.getMessage());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

