/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.1
 *
 * Copyright (c) 2022 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 613 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qpycore_qlist.sip"
#include <utility>
#include <qlist.h>
#line 30 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQList0600stdpair18001800.cpp"



extern "C" {static void assign_QList_0600std_pair_1800_1800(void *, Py_ssize_t, void *);}
static void assign_QList_0600std_pair_1800_1800(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QList<std::pair<int,int> > *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QList<std::pair<int,int> > *>(sipSrc);
}


extern "C" {static void *array_QList_0600std_pair_1800_1800(Py_ssize_t);}
static void *array_QList_0600std_pair_1800_1800(Py_ssize_t sipNrElem)
{
    return new  ::QList<std::pair<int,int> >[sipNrElem];
}


extern "C" {static void *copy_QList_0600std_pair_1800_1800(const void *, Py_ssize_t);}
static void *copy_QList_0600std_pair_1800_1800(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::QList<std::pair<int,int> >(reinterpret_cast<const  ::QList<std::pair<int,int> > *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QList_0600std_pair_1800_1800(void *, int, void *);}
static void release_QList_0600std_pair_1800_1800(void *sipCppV, int, void *)
{
     ::QList<std::pair<int,int> > *sipCpp = reinterpret_cast< ::QList<std::pair<int,int> > *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QList_0600std_pair_1800_1800(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_QList_0600std_pair_1800_1800(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
     ::QList<std::pair<int,int> > **sipCppPtr = reinterpret_cast< ::QList<std::pair<int,int> > **>(sipCppPtrV);

#line 642 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qpycore_qlist.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter && !PyBytes_Check(sipPy) && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QList<std::pair<int, int> > *ql = new QList<std::pair<int, int> >;
 
    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *seq = PyIter_Next(iter);

        if (!seq)
        {
            if (PyErr_Occurred())
            {
                delete ql;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        Py_ssize_t sub_len;

        if (PySequence_Check(seq) && !PyBytes_Check(sipPy) && !PyUnicode_Check(seq))
            sub_len = PySequence_Size(seq);
        else
            sub_len = -1;

        if (sub_len != 2)
        {
            if (sub_len < 0)
                PyErr_Format(PyExc_TypeError,
                        "index %zd has type '%s' but a 2 element non-string sequence is expected",
                        i, sipPyTypeName(Py_TYPE(seq)));
            else
                PyErr_Format(PyExc_TypeError,
                        "index %zd is a sequence of %zd sub-elements but 2 sub-elements are expected",
                        i, sub_len);

            Py_DECREF(seq);
            delete ql;
            Py_DECREF(iter);
            *sipIsErr = 1;

            return 0;
        }

        PyObject *itm1 = PySequence_GetItem(seq, 0);

        if (!itm1)
        {
            Py_DECREF(seq);
            delete ql;
            Py_DECREF(iter);
            *sipIsErr = 1;

            return 0;
        }

        int first = sipLong_AsInt(itm1);

        if (PyErr_Occurred())
        {
            if (PyErr_ExceptionMatches(PyExc_TypeError))
                PyErr_Format(PyExc_TypeError,
                        "the first sub-element of index %zd has type '%s' but 'int' is expected",
                        i, sipPyTypeName(Py_TYPE(itm1)));

            Py_DECREF(itm1);
            Py_DECREF(seq);
            delete ql;
            Py_DECREF(iter);
            *sipIsErr = 1;

            return 0;
        }

        PyObject *itm2 = PySequence_GetItem(seq, 1);

        if (!itm2)
        {
            Py_DECREF(itm1);
            Py_DECREF(seq);
            delete ql;
            Py_DECREF(iter);
            *sipIsErr = 1;

            return 0;
        }

        int second = sipLong_AsInt(itm2);

        if (PyErr_Occurred())
        {
            if (PyErr_ExceptionMatches(PyExc_TypeError))
                PyErr_Format(PyExc_TypeError,
                        "the second sub-element of index %zd has type '%s' but 'int' is expected",
                        i, sipPyTypeName(Py_TYPE(itm2)));

            Py_DECREF(itm2);
            Py_DECREF(itm1);
            Py_DECREF(seq);
            delete ql;
            Py_DECREF(iter);
            *sipIsErr = 1;

            return 0;
        }

        ql->append(std::pair<int, int>(first, second));

        Py_DECREF(itm2);
        Py_DECREF(itm1);
        Py_DECREF(seq);
    }

    Py_DECREF(iter);
 
    *sipCppPtr = ql;
 
    return sipGetState(sipTransferObj);
#line 209 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQList0600stdpair18001800.cpp"
}


extern "C" {static PyObject *convertFrom_QList_0600std_pair_1800_1800(void *, PyObject *);}
static PyObject *convertFrom_QList_0600std_pair_1800_1800(void *sipCppV, PyObject *)
{
    ::QList<std::pair<int,int> > *sipCpp = reinterpret_cast< ::QList<std::pair<int,int> > *>(sipCppV);

#line 618 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qpycore_qlist.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        const std::pair<int, int> &p = sipCpp->at(i);
        PyObject *pobj = Py_BuildValue((char *)"ii", p.first, p.second);

        if (!pobj)
        {
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, pobj);
    }

    return l;
#line 240 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQList0600stdpair18001800.cpp"
}


sipMappedTypeDef sipTypeDef_QtCore_QList_0600std_pair_1800_1800 = {
    {
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_6011,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        -1,
        {0, 0, 1},
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    assign_QList_0600std_pair_1800_1800,
    array_QList_0600std_pair_1800_1800,
    copy_QList_0600std_pair_1800_1800,
    release_QList_0600std_pair_1800_1800,
    convertTo_QList_0600std_pair_1800_1800,
    convertFrom_QList_0600std_pair_1800_1800
};
