/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.progress;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.modules.progress.spi.RunOffEDTProvider;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

public final class BaseProgressUtils {
    private static final RunOffEDTProvider PROVIDER = BaseProgressUtils.getProvider();
    private static final int DISPLAY_DIALOG_MS = 9450;
    private static final int DISPLAY_WAIT_CURSOR_MS = 50;
    private static final RequestProcessor TRIVIAL = new RequestProcessor(Trivial.class);

    private BaseProgressUtils() {
    }

    private static RunOffEDTProvider getProvider() {
        RunOffEDTProvider runOffEDTProvider = (RunOffEDTProvider)Lookup.getDefault().lookup(RunOffEDTProvider.class);
        return runOffEDTProvider != null ? runOffEDTProvider : new Trivial();
    }

    public static void runOffEventDispatchThread(Runnable runnable, String string, AtomicBoolean atomicBoolean, boolean bl) {
        PROVIDER.runOffEventDispatchThread(runnable, string, atomicBoolean, bl, 50, 9450);
    }

    public static void runOffEventDispatchThread(Runnable runnable, String string, AtomicBoolean atomicBoolean, boolean bl, int n, int n2) {
        PROVIDER.runOffEventDispatchThread(runnable, string, atomicBoolean, bl, n, n2);
    }

    public static void showProgressDialogAndRun(Runnable runnable, ProgressHandle progressHandle, boolean bl) {
        if (PROVIDER instanceof RunOffEDTProvider.Progress) {
            RunOffEDTProvider.Progress progress = (RunOffEDTProvider.Progress)PROVIDER;
            progress.showProgressDialogAndRun(runnable, progressHandle, bl);
        } else {
            PROVIDER.runOffEventDispatchThread(runnable, progressHandle.getDisplayName(), new AtomicBoolean(false), false, 0, 0);
        }
    }

    public static void runOffEventThreadWithProgressDialog(Runnable runnable, String string, ProgressHandle progressHandle, boolean bl, int n, int n2) {
        if (PROVIDER instanceof RunOffEDTProvider.Progress2) {
            RunOffEDTProvider.Progress2 progress2 = (RunOffEDTProvider.Progress2)PROVIDER;
            progress2.runOffEventThreadWithProgressDialog(runnable, string, progressHandle, bl, n, n2);
        } else {
            PROVIDER.runOffEventDispatchThread(runnable, progressHandle.getDisplayName(), new AtomicBoolean(false), true, 50, 9450);
        }
    }

    public static <T> T showProgressDialogAndRun(final ProgressRunnable<T> progressRunnable, final String string, boolean bl) {
        if (PROVIDER instanceof RunOffEDTProvider.Progress) {
            RunOffEDTProvider.Progress progress = (RunOffEDTProvider.Progress)PROVIDER;
            return progress.showProgressDialogAndRun(progressRunnable, string, bl);
        }
        final AtomicReference atomicReference = new AtomicReference();
        PROVIDER.runOffEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                try (ProgressHandle progressHandle = ProgressHandle.createHandle(string);){
                    progressHandle.start();
                    progressHandle.switchToIndeterminate();
                    atomicReference.set(progressRunnable.run(progressHandle));
                }
            }
        }, string, new AtomicBoolean(false), true, 0, 0);
        return (T)atomicReference.get();
    }

    public static void showProgressDialogAndRun(Runnable runnable, String string) {
        RunnableWrapper runnableWrapper = runnable instanceof Cancellable ? new CancellableRunnableWrapper(runnable) : new RunnableWrapper(runnable);
        BaseProgressUtils.showProgressDialogAndRun(runnableWrapper, string, false);
    }

    public static <T> Future<T> showProgressDialogAndRunLater(final ProgressRunnable<T> progressRunnable, final ProgressHandle progressHandle, boolean bl) {
        if (PROVIDER instanceof RunOffEDTProvider.Progress) {
            RunOffEDTProvider.Progress progress = (RunOffEDTProvider.Progress)PROVIDER;
            return progress.showProgressDialogAndRunLater(progressRunnable, progressHandle, bl);
        }
        FutureTask futureTask = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return progressRunnable.run(progressHandle);
            }
        });
        PROVIDER.runOffEventDispatchThread(futureTask, progressHandle.getDisplayName(), new AtomicBoolean(false), true, 0, 0);
        return futureTask;
    }

    private static class Trivial
    implements RunOffEDTProvider {
        private Trivial() {
        }

        @Override
        public void runOffEventDispatchThread(Runnable runnable, String string, AtomicBoolean atomicBoolean, boolean bl, int n, int n2) {
            if (Mutex.EVENT.isReadAccess()) {
                TRIVIAL.post(runnable).waitFinished();
            } else {
                runnable.run();
            }
        }
    }

    private static final class CancellableRunnableWrapper
    extends RunnableWrapper
    implements Cancellable {
        private final Cancellable cancelable;

        CancellableRunnableWrapper(Runnable runnable) {
            super(runnable);
            this.cancelable = (Cancellable)runnable;
        }

        public boolean cancel() {
            return this.cancelable.cancel();
        }
    }

    private static class RunnableWrapper
    implements ProgressRunnable<Void> {
        private final Runnable toRun;

        RunnableWrapper(Runnable runnable) {
            this.toRun = runnable;
        }

        @Override
        public Void run(ProgressHandle progressHandle) {
            this.toRun.run();
            return null;
        }
    }
}

