/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.charts.axis;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.visualvm.lib.charts.ChartContext;
import org.graalvm.visualvm.lib.charts.axis.AxisMark;

public interface AxisMarksComputer {
    public static final Iterator<AxisMark> EMPTY_ITERATOR = new Iterator<AxisMark>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public AxisMark next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    };

    public Iterator<AxisMark> marksIterator(int var1, int var2);

    public static abstract class AbstractIterator
    implements Iterator<AxisMark> {
        @Override
        public void remove() {
            throw new UnsupportedOperationException("AxisMarksComputer does not support remove()");
        }
    }

    public static abstract class Abstract
    implements AxisMarksComputer {
        protected final ChartContext context;
        protected final int orientation;
        protected final boolean horizontal;
        protected final boolean reverse;

        public Abstract(ChartContext context, int orientation) {
            this.context = context;
            this.orientation = orientation;
            this.horizontal = orientation == 0;
            this.reverse = this.horizontal ? context.isRightBased() : context.isBottomBased();
        }

        protected int getMinMarksDistance() {
            return 50;
        }

        protected boolean refreshConfiguration() {
            return true;
        }
    }
}

