// third_party/blink/public/mojom/fetch/fetch_api_request.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-params-data.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
FetchAPIRequestHeaders::FetchAPIRequestHeaders()
    : headers() {}

FetchAPIRequestHeaders::FetchAPIRequestHeaders(
    const base::flat_map<std::string, std::string>& headers_in)
    : headers(std::move(headers_in)) {}

FetchAPIRequestHeaders::~FetchAPIRequestHeaders() = default;

void FetchAPIRequestHeaders::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginDictionary("headers");
  for (const auto& item0 : this->headers) {
    value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.first, "<value of type const std::string&>"), item0.second);
  }
  value->EndDictionary();
}

bool FetchAPIRequestHeaders::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FetchAPIDataElement::FetchAPIDataElement()
    : type(),
      buf(),
      path(),
      blob_uuid(),
      data_pipe_getter(),
      chunked_data_pipe_getter(),
      offset(),
      length(),
      expected_modification_time() {}

FetchAPIDataElement::FetchAPIDataElement(
    ::network::mojom::DataElementType type_in,
    std::vector<uint8_t> buf_in,
    const ::base::FilePath& path_in,
    const base::Optional<std::string>& blob_uuid_in,
    ::mojo::PendingRemote<::network::mojom::DataPipeGetter> data_pipe_getter_in,
    ::mojo::PendingRemote<::network::mojom::ChunkedDataPipeGetter> chunked_data_pipe_getter_in,
    uint64_t offset_in,
    uint64_t length_in,
    ::base::Time expected_modification_time_in)
    : type(std::move(type_in)),
      buf(std::move(buf_in)),
      path(std::move(path_in)),
      blob_uuid(std::move(blob_uuid_in)),
      data_pipe_getter(std::move(data_pipe_getter_in)),
      chunked_data_pipe_getter(std::move(chunked_data_pipe_getter_in)),
      offset(std::move(offset_in)),
      length(std::move(length_in)),
      expected_modification_time(std::move(expected_modification_time_in)) {}

FetchAPIDataElement::~FetchAPIDataElement() = default;

void FetchAPIDataElement::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("type", base::trace_event::ValueToString(this->type));
  value->BeginArray("buf");
  for (const auto& item0 : this->buf) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->SetString("path", base::trace_event::ValueToString(this->path, "<value of type const ::base::FilePath&>"));
  if (this->blob_uuid.has_value()) {
    value->SetString("blob_uuid", this->blob_uuid.value());
  } else {
    value->SetString("blob_uuid", "base::nullopt");
  }
  value->SetBoolean("data_pipe_getter", this->data_pipe_getter.is_valid());
  value->SetBoolean("chunked_data_pipe_getter", this->chunked_data_pipe_getter.is_valid());
  value->SetString("offset", base::NumberToString(this->offset));
  value->SetString("length", base::NumberToString(this->length));
  value->SetString("expected_modification_time", base::trace_event::ValueToString(this->expected_modification_time, "<value of type ::base::Time>"));
}

bool FetchAPIDataElement::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FetchAPIRequestBody::FetchAPIRequestBody()
    : elements(),
      identifier(),
      contains_sensitive_info() {}

FetchAPIRequestBody::FetchAPIRequestBody(
    std::vector<::network::DataElement> elements_in,
    uint64_t identifier_in,
    bool contains_sensitive_info_in)
    : elements(std::move(elements_in)),
      identifier(std::move(identifier_in)),
      contains_sensitive_info(std::move(contains_sensitive_info_in)) {}

FetchAPIRequestBody::~FetchAPIRequestBody() = default;

void FetchAPIRequestBody::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("elements");
  for (const auto& item0 : this->elements) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::network::DataElement>"));
  }
  value->EndArray();
  value->SetString("identifier", base::NumberToString(this->identifier));
  value->SetBoolean("contains_sensitive_info", this->contains_sensitive_info);
}

bool FetchAPIRequestBody::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FetchAPIRequest::FetchAPIRequest()
    : mode(::network::mojom::RequestMode::kNoCors),
      is_main_resource_load(false),
      destination(::network::mojom::RequestDestination::kEmpty),
      frame_type(::blink::mojom::RequestContextFrameType::kNone),
      url(),
      method(),
      headers(),
      blob(),
      body(),
      request_initiator(),
      navigation_redirect_chain(),
      referrer(),
      credentials_mode(::network::mojom::CredentialsMode::kOmit),
      cache_mode(FetchCacheMode::kDefault),
      redirect_mode(::network::mojom::RedirectMode::kFollow),
      integrity(),
      priority(mojo::internal::ConvertEnumValue<::network::mojom::RequestPriority, ::net::RequestPriority>(::network::mojom::RequestPriority::kIdle)),
      fetch_window_id(),
      keepalive(false),
      is_reload(false),
      is_history_navigation(false) {}

FetchAPIRequest::FetchAPIRequest(
    ::network::mojom::RequestMode mode_in,
    bool is_main_resource_load_in,
    ::network::mojom::RequestDestination destination_in,
    ::blink::mojom::RequestContextFrameType frame_type_in,
    const ::GURL& url_in,
    const std::string& method_in,
    ::blink::FetchAPIRequestHeadersMap headers_in,
    ::blink::mojom::SerializedBlobPtr blob_in,
    ::scoped_refptr<::network::ResourceRequestBody> body_in,
    const base::Optional<::url::Origin>& request_initiator_in,
    std::vector<::GURL> navigation_redirect_chain_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    ::network::mojom::CredentialsMode credentials_mode_in,
    FetchCacheMode cache_mode_in,
    ::network::mojom::RedirectMode redirect_mode_in,
    const base::Optional<std::string>& integrity_in,
    ::net::RequestPriority priority_in,
    const base::Optional<::base::UnguessableToken>& fetch_window_id_in,
    bool keepalive_in,
    bool is_reload_in,
    bool is_history_navigation_in)
    : mode(std::move(mode_in)),
      is_main_resource_load(std::move(is_main_resource_load_in)),
      destination(std::move(destination_in)),
      frame_type(std::move(frame_type_in)),
      url(std::move(url_in)),
      method(std::move(method_in)),
      headers(std::move(headers_in)),
      blob(std::move(blob_in)),
      body(std::move(body_in)),
      request_initiator(std::move(request_initiator_in)),
      navigation_redirect_chain(std::move(navigation_redirect_chain_in)),
      referrer(std::move(referrer_in)),
      credentials_mode(std::move(credentials_mode_in)),
      cache_mode(std::move(cache_mode_in)),
      redirect_mode(std::move(redirect_mode_in)),
      integrity(std::move(integrity_in)),
      priority(std::move(priority_in)),
      fetch_window_id(std::move(fetch_window_id_in)),
      keepalive(std::move(keepalive_in)),
      is_reload(std::move(is_reload_in)),
      is_history_navigation(std::move(is_history_navigation_in)) {}

FetchAPIRequest::~FetchAPIRequest() = default;

void FetchAPIRequest::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("mode", base::trace_event::ValueToString(this->mode));
  value->SetBoolean("is_main_resource_load", this->is_main_resource_load);
  value->SetString("destination", base::trace_event::ValueToString(this->destination));
  value->SetString("frame_type", base::trace_event::ValueToString(this->frame_type));
  value->SetString("url", base::trace_event::ValueToString(this->url, "<value of type const ::GURL&>"));
  value->SetString("method", this->method);
  value->SetString("headers", base::trace_event::ValueToString(this->headers, "<value of type ::blink::FetchAPIRequestHeadersMap>"));
  if (this->blob.is_null()) {
    value->SetString("blob", "nullptr");
  } else {
    value->BeginDictionary("blob");
    this->blob->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("body", base::trace_event::ValueToString(this->body, "<value of type ::scoped_refptr<::network::ResourceRequestBody>>"));
  value->SetString("request_initiator", base::trace_event::ValueToString(this->request_initiator, "<value of type const base::Optional<::url::Origin>&>"));
  value->BeginArray("navigation_redirect_chain");
  for (const auto& item0 : this->navigation_redirect_chain) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::GURL&>"));
  }
  value->EndArray();
  if (this->referrer.is_null()) {
    value->SetString("referrer", "nullptr");
  } else {
    value->BeginDictionary("referrer");
    this->referrer->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("credentials_mode", base::trace_event::ValueToString(this->credentials_mode));
  value->SetString("cache_mode", base::trace_event::ValueToString(this->cache_mode));
  value->SetString("redirect_mode", base::trace_event::ValueToString(this->redirect_mode));
  if (this->integrity.has_value()) {
    value->SetString("integrity", this->integrity.value());
  } else {
    value->SetString("integrity", "base::nullopt");
  }
  value->SetInteger("priority", static_cast<int>(this->priority));
  value->SetString("fetch_window_id", base::trace_event::ValueToString(this->fetch_window_id, "<value of type const base::Optional<::base::UnguessableToken>&>"));
  value->SetBoolean("keepalive", this->keepalive);
  value->SetBoolean("is_reload", this->is_reload);
  value->SetBoolean("is_history_navigation", this->is_history_navigation);
}

bool FetchAPIRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::FetchAPIRequestHeaders::DataView, ::blink::mojom::FetchAPIRequestHeadersPtr>::Read(
    ::blink::mojom::FetchAPIRequestHeaders::DataView input,
    ::blink::mojom::FetchAPIRequestHeadersPtr* output) {
  bool success = true;
  ::blink::mojom::FetchAPIRequestHeadersPtr result(::blink::mojom::FetchAPIRequestHeaders::New());
  
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FetchAPIDataElement::DataView, ::blink::mojom::FetchAPIDataElementPtr>::Read(
    ::blink::mojom::FetchAPIDataElement::DataView input,
    ::blink::mojom::FetchAPIDataElementPtr* output) {
  bool success = true;
  ::blink::mojom::FetchAPIDataElementPtr result(::blink::mojom::FetchAPIDataElement::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadBuf(&result->buf))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadBlobUuid(&result->blob_uuid))
        success = false;
      if (success) {
        result->data_pipe_getter =
            input.TakeDataPipeGetter<decltype(result->data_pipe_getter)>();
      }
      if (success) {
        result->chunked_data_pipe_getter =
            input.TakeChunkedDataPipeGetter<decltype(result->chunked_data_pipe_getter)>();
      }
      if (success)
        result->offset = input.offset();
      if (success)
        result->length = input.length();
      if (success && !input.ReadExpectedModificationTime(&result->expected_modification_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FetchAPIRequestBody::DataView, ::blink::mojom::FetchAPIRequestBodyPtr>::Read(
    ::blink::mojom::FetchAPIRequestBody::DataView input,
    ::blink::mojom::FetchAPIRequestBodyPtr* output) {
  bool success = true;
  ::blink::mojom::FetchAPIRequestBodyPtr result(::blink::mojom::FetchAPIRequestBody::New());
  
      if (success && !input.ReadElements(&result->elements))
        success = false;
      if (success)
        result->identifier = input.identifier();
      if (success)
        result->contains_sensitive_info = input.contains_sensitive_info();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FetchAPIRequest::DataView, ::blink::mojom::FetchAPIRequestPtr>::Read(
    ::blink::mojom::FetchAPIRequest::DataView input,
    ::blink::mojom::FetchAPIRequestPtr* output) {
  bool success = true;
  ::blink::mojom::FetchAPIRequestPtr result(::blink::mojom::FetchAPIRequest::New());
  
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success)
        result->is_main_resource_load = input.is_main_resource_load();
      if (success && !input.ReadDestination(&result->destination))
        success = false;
      if (success && !input.ReadFrameType(&result->frame_type))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadBlob(&result->blob))
        success = false;
      if (success && !input.ReadBody(&result->body))
        success = false;
      if (success && !input.ReadRequestInitiator(&result->request_initiator))
        success = false;
      if (success && !input.ReadNavigationRedirectChain(&result->navigation_redirect_chain))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadCredentialsMode(&result->credentials_mode))
        success = false;
      if (success && !input.ReadCacheMode(&result->cache_mode))
        success = false;
      if (success && !input.ReadRedirectMode(&result->redirect_mode))
        success = false;
      if (success && !input.ReadIntegrity(&result->integrity))
        success = false;
      if (success && !input.ReadPriority(&result->priority))
        success = false;
      if (success && !input.ReadFetchWindowId(&result->fetch_window_id))
        success = false;
      if (success)
        result->keepalive = input.keepalive();
      if (success)
        result->is_reload = input.is_reload();
      if (success)
        result->is_history_navigation = input.is_history_navigation();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif