/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.HashSet;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.DefaultWaypointRenderer;
import org.jdesktop.swingx.mapviewer.Waypoint;
import org.jdesktop.swingx.mapviewer.WaypointRenderer;
import org.jdesktop.swingx.painter.AbstractPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaypointPainter<T extends JXMapViewer>
extends AbstractPainter<T> {
    private WaypointRenderer renderer = new DefaultWaypointRenderer();
    private Iterable<Waypoint> waypoints;

    public WaypointPainter() {
        this.setAntialiasing(true);
        this.setCacheable(false);
        this.waypoints = new HashSet<Waypoint>();
    }

    public void setRenderer(WaypointRenderer r) {
        this.renderer = r;
    }

    public Iterable<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public void setWaypoints(Iterable<Waypoint> waypoints) {
        this.waypoints = waypoints;
    }

    protected void doPaint(Graphics2D g, T map, int width, int height) {
        double vpx;
        if (this.renderer == null) {
            return;
        }
        Rectangle viewportBounds = ((JXMapViewer)map).getViewportBounds();
        int zoom = ((JXMapViewer)map).getZoom();
        Dimension sizeInTiles = ((JXMapViewer)map).getTileFactory().getMapSize(zoom);
        int tileSize = ((JXMapViewer)map).getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        for (vpx = viewportBounds.getX(); vpx < 0.0; vpx += sizeInPixels.getWidth()) {
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        for (Waypoint w : this.getWaypoints()) {
            int y;
            int x;
            Point2D point = ((JXMapViewer)map).getTileFactory().geoToPixel(w.getPosition(), ((JXMapViewer)map).getZoom());
            if (vp2.contains(point)) {
                x = (int)(point.getX() - ((RectangularShape)vp2).getX());
                y = (int)(point.getY() - ((RectangularShape)vp2).getY());
                g.translate(x, y);
                this.paintWaypoint(w, map, g);
                g.translate(-x, -y);
            }
            if (!vp3.contains(point)) continue;
            x = (int)(point.getX() - ((RectangularShape)vp3).getX());
            y = (int)(point.getY() - ((RectangularShape)vp3).getY());
            g.translate(x, y);
            this.paintWaypoint(w, map, g);
            g.translate(-x, -y);
        }
    }

    protected void paintWaypoint(Waypoint w, T map, Graphics2D g) {
        this.renderer.paintWaypoint(g, (JXMapViewer)map, w);
    }

    private static void p(String str) {
        System.out.println(str);
    }
}

