/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class FallbackProperty<T>
extends AbstractProperty<T> {
    private final AbstractProperty<T> property;
    private final AbstractProperty<T> fallback;

    public FallbackProperty(AbstractProperty<T> property, AbstractProperty<T> fallback) {
        super(property.getKey(), null);
        CheckParameterUtil.ensureParameterNotNull(property, "property");
        CheckParameterUtil.ensureParameterNotNull(fallback, "fallback");
        this.property = property;
        this.fallback = fallback;
    }

    public AbstractProperty<T> getDelegateProperty() {
        return this.property;
    }

    public AbstractProperty<T> getFallbackProperty() {
        return this.fallback;
    }

    @Override
    protected void storeDefaultValue() {
    }

    @Override
    public boolean isSet() {
        return this.property.isSet();
    }

    @Override
    public T getDefaultValue() {
        return this.fallback.getDefaultValue();
    }

    @Override
    public void remove() {
        this.property.remove();
    }

    @Override
    public T get() {
        if (this.property.isSet()) {
            return this.property.get();
        }
        return this.fallback.get();
    }

    @Override
    public boolean put(T value) {
        return this.property.put(value);
    }

    @Override
    protected void addListenerImpl(PreferenceChangedListener adapter) {
        this.property.addListenerImpl(adapter);
        this.fallback.addListenerImpl(adapter);
    }

    @Override
    public void addWeakListener(AbstractProperty.ValueChangeListener<? super T> listener) {
        this.property.addWeakListener(listener);
        this.fallback.addWeakListener(listener);
    }

    @Override
    protected void removeListenerImpl(PreferenceChangedListener adapter) {
        this.property.removeListenerImpl(adapter);
        this.fallback.removeListenerImpl(adapter);
    }
}

