/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.transport.wagon;

import javax.inject.Named;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.Transporter;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;
import org.jetbrains.kotlin.org.eclipse.aether.spi.log.Logger;
import org.jetbrains.kotlin.org.eclipse.aether.spi.log.LoggerFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.log.NullLoggerFactory;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.NoTransporterException;
import org.jetbrains.kotlin.org.eclipse.aether.transport.wagon.WagonConfigurator;
import org.jetbrains.kotlin.org.eclipse.aether.transport.wagon.WagonProvider;
import org.jetbrains.kotlin.org.eclipse.aether.transport.wagon.WagonTransporter;

@Named(value="wagon")
public final class WagonTransporterFactory
implements TransporterFactory,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private WagonProvider wagonProvider;
    private WagonConfigurator wagonConfigurator;
    private float priority = -1.0f;

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setWagonProvider(locator.getService(WagonProvider.class));
        this.setWagonConfigurator(locator.getService(WagonConfigurator.class));
    }

    public WagonTransporterFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, WagonTransporter.class);
        return this;
    }

    public WagonTransporterFactory setWagonProvider(WagonProvider wagonProvider) {
        this.wagonProvider = wagonProvider;
        return this;
    }

    public WagonTransporterFactory setWagonConfigurator(WagonConfigurator wagonConfigurator) {
        this.wagonConfigurator = wagonConfigurator;
        return this;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    @Override
    public Transporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        return new WagonTransporter(this.wagonProvider, this.wagonConfigurator, repository, session, this.logger);
    }
}

