/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.lower.InventNamesForLocalClasses;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.FileClassLoweringKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0014J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmInventNamesForLocalClasses;", "Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "computeTopLevelClassName", "", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "putLocalClassName", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;", "localClassName", "sanitizeNameIfNeeded", "name", "backend.jvm.lower"})
public final class JvmInventNamesForLocalClasses
extends InventNamesForLocalClasses {
    @NotNull
    private final JvmBackendContext context;

    public JvmInventNamesForLocalClasses(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        super(false);
        this.context = context2;
    }

    @Override
    @NotNull
    protected String computeTopLevelClassName(@NotNull IrClass clazz) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        IrDeclarationParent irDeclarationParent = clazz.getParent();
        IrFile irFile = irDeclarationParent instanceof IrFile ? (IrFile)irDeclarationParent : null;
        if (irFile == null) {
            throw new AssertionError((Object)("Top-level class expected: " + RenderIrElementKt.render(clazz)));
        }
        IrFile file2 = irFile;
        if (Intrinsics.areEqual(clazz.getOrigin(), IrDeclarationOrigin.FILE_CLASS.INSTANCE) || Intrinsics.areEqual(clazz.getOrigin(), IrDeclarationOrigin.SYNTHETIC_FILE_CLASS.INSTANCE)) {
            fqName2 = FileClassLoweringKt.getFileClassInfo(file2).getFileClassFqName();
        } else {
            FqName fqName3 = file2.getFqName().child(clazz.getName());
            fqName2 = fqName3;
            Intrinsics.checkNotNullExpressionValue(fqName3, "{\n                file.f\u2026clazz.name)\n            }");
        }
        FqName classFqn = fqName2;
        String string2 = JvmClassName.byFqNameWithoutInnerClasses(classFqn).getInternalName();
        Intrinsics.checkNotNullExpressionValue(string2, "byFqNameWithoutInnerClasses(classFqn).internalName");
        return string2;
    }

    @Override
    @NotNull
    protected String sanitizeNameIfNeeded(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string2 = JvmCodegenUtil.sanitizeNameIfNeeded(name, this.context.getState().getLanguageVersionSettings());
        Intrinsics.checkNotNullExpressionValue(string2, "sanitizeNameIfNeeded(nam\u2026.languageVersionSettings)");
        return string2;
    }

    @Override
    protected void putLocalClassName(@NotNull IrAttributeContainer declaration2, @NotNull String localClassName) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(localClassName, "localClassName");
        Type type2 = Type.getObjectType(localClassName);
        Intrinsics.checkNotNullExpressionValue(type2, "getObjectType(localClassName)");
        this.context.putLocalClassType(declaration2, type2);
    }
}

