/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.AbstractValueUsageTransformer;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001aH\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/UnitToVoidLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractValueUsageTransformer;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "getSymbols", "()Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "shouldVoidify", "", "expr", "Lorg/jetbrains/kotlin/ir/IrStatement;", "voidify", "useAsStatement", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.wasm"})
public final class UnitToVoidLowering
extends AbstractValueUsageTransformer
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final WasmSymbols symbols;

    public UnitToVoidLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        super(context2.getIrBuiltIns());
        this.context = context2;
        this.builtIns = this.context.getIrBuiltIns();
        this.symbols = this.context.getWasmSymbols();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public final WasmSymbols getSymbols() {
        return this.symbols;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    protected IrExpression useAsStatement(@NotNull IrExpression $this$useAsStatement) {
        Intrinsics.checkNotNullParameter($this$useAsStatement, "<this>");
        if (!Intrinsics.areEqual($this$useAsStatement.getType(), this.builtIns.getUnitType())) {
            return $this$useAsStatement;
        }
        if (this.shouldVoidify($this$useAsStatement)) {
            return (IrExpression)this.voidify($this$useAsStatement);
        }
        return $this$useAsStatement;
    }

    private final boolean shouldVoidify(IrStatement expr) {
        if (!(expr instanceof IrExpression)) {
            return true;
        }
        if (Intrinsics.areEqual(((IrExpression)expr).getType(), this.symbols.getVoidType()) || Intrinsics.areEqual(((IrExpression)expr).getType(), this.builtIns.getNothingType())) {
            return false;
        }
        IrStatement irStatement = expr;
        if (irStatement instanceof IrContainerExpression) {
            if (((IrContainerExpression)expr).getStatements().isEmpty()) {
                return false;
            }
            return this.shouldVoidify(CollectionsKt.last(((IrContainerExpression)expr).getStatements()));
        }
        if (irStatement instanceof IrWhen) {
            return true;
        }
        if (irStatement instanceof IrTry) {
            return true;
        }
        if (irStatement instanceof IrTypeOperatorCall) {
            return ((IrTypeOperatorCall)expr).getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final IrStatement voidify(IrStatement expr) {
        if (!(expr instanceof IrExpression)) {
            return expr;
        }
        if (Intrinsics.areEqual(((IrExpression)expr).getType(), this.symbols.getVoidType()) || Intrinsics.areEqual(((IrExpression)expr).getType(), this.builtIns.getNothingType())) {
            return expr;
        }
        IrStatement irStatement = expr;
        if (irStatement instanceof IrContainerExpression) {
            ((IrExpression)expr).setType(this.symbols.getVoidType());
            IrStatement irStatement2 = CollectionsKt.lastOrNull(((IrContainerExpression)expr).getStatements());
            if (irStatement2 != null) {
                IrStatement last = irStatement2;
                boolean bl = false;
                ((IrContainerExpression)expr).getStatements().set(CollectionsKt.getLastIndex(((IrContainerExpression)expr).getStatements()), this.voidify(last));
            }
            return expr;
        }
        if (irStatement instanceof IrWhen) {
            ((IrExpression)expr).setType(this.symbols.getVoidType());
            Iterable $this$forEachIndexed$iv = ((IrWhen)expr).getBranches();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void branch;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrBranch irBranch = (IrBranch)item$iv;
                int i = n;
                boolean bl = false;
                ((IrWhen)expr).getBranches().get(i).setResult((IrExpression)this.voidify(branch.getResult()));
            }
            return expr;
        }
        if (irStatement instanceof IrTry) {
            ((IrExpression)expr).setType(this.symbols.getVoidType());
            ((IrTry)expr).setTryResult((IrExpression)this.voidify(((IrTry)expr).getTryResult()));
            Iterable $this$forEachIndexed$iv = ((IrTry)expr).getCatches();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void catch_;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrCatch branch = (IrCatch)item$iv;
                int i = n;
                boolean bl = false;
                ((IrTry)expr).getCatches().get(i).setResult((IrExpression)this.voidify(catch_.getResult()));
            }
            return expr;
        }
        if (irStatement instanceof IrTypeOperatorCall && ((IrTypeOperatorCall)expr).getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT) {
            return this.voidify(((IrTypeOperatorCall)expr).getArgument());
        }
        IrStatement $this$voidify_u24lambda_u2d3 = irStatement = new IrCallImpl(expr.getStartOffset(), expr.getEndOffset(), this.symbols.getVoidType(), this.symbols.getConsumeAnyIntoVoid(), 0, 1, null, null, 192, null);
        boolean bl = false;
        ((IrFunctionAccessExpression)$this$voidify_u24lambda_u2d3).putValueArgument(0, (IrExpression)expr);
        return irStatement;
    }
}

