/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\t\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\n\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\u000b\u001a\u00020\u0006*\u00020\u0007\u00a8\u0006\f"}, d2={"fqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isInvoke", "", "Lorg/jetbrains/kotlin/name/CallableId;", "isIterator", "isIteratorHasNext", "isIteratorNext", "isKFunctionInvoke", "semantics"})
public final class CallableIdUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInvoke(@NotNull CallableId $this$isInvoke) {
        Intrinsics.checkNotNullParameter($this$isInvoke, "<this>");
        if (CallableIdUtilsKt.isKFunctionInvoke($this$isInvoke)) return true;
        if (!Intrinsics.areEqual($this$isInvoke.getCallableName().asString(), "invoke")) return false;
        FqName fqName2 = $this$isInvoke.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.startsWith$default((String)object, "Function", false, 2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual($this$isInvoke.getPackageName(), StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKFunctionInvoke(@NotNull CallableId $this$isKFunctionInvoke) {
        Intrinsics.checkNotNullParameter($this$isKFunctionInvoke, "<this>");
        if (!Intrinsics.areEqual($this$isKFunctionInvoke.getCallableName().asString(), "invoke")) return false;
        FqName fqName2 = $this$isKFunctionInvoke.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.startsWith$default((String)object, "KFunction", false, 2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual($this$isKFunctionInvoke.getPackageName().asString(), "kotlin.reflect")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIteratorNext(@NotNull CallableId $this$isIteratorNext) {
        Intrinsics.checkNotNullParameter($this$isIteratorNext, "<this>");
        if (!Intrinsics.areEqual($this$isIteratorNext.getCallableName().asString(), "next")) return false;
        FqName fqName2 = $this$isIteratorNext.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.endsWith$default((String)object, "Iterator", false, 2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual($this$isIteratorNext.getPackageName().asString(), "kotlin.collections")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIteratorHasNext(@NotNull CallableId $this$isIteratorHasNext) {
        Intrinsics.checkNotNullParameter($this$isIteratorHasNext, "<this>");
        if (!Intrinsics.areEqual($this$isIteratorHasNext.getCallableName().asString(), "hasNext")) return false;
        FqName fqName2 = $this$isIteratorHasNext.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.endsWith$default((String)object, "Iterator", false, 2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual($this$isIteratorHasNext.getPackageName().asString(), "kotlin.collections")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIterator(@NotNull CallableId $this$isIterator) {
        Intrinsics.checkNotNullParameter($this$isIterator, "<this>");
        if (!Intrinsics.areEqual($this$isIterator.getCallableName().asString(), "iterator")) return false;
        String[] stringArray = new String[]{"kotlin.collections", "kotlin.ranges"};
        String string2 = $this$isIterator.getPackageName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "packageName.asString()");
        if (!ArraysKt.contains(stringArray, string2)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FqName fqName(@NotNull FirAnnotation $this$fqName, @NotNull FirSession session2) {
        FirBasedSymbol firBasedSymbol;
        Object object;
        Intrinsics.checkNotNullParameter($this$fqName, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirSymbolProvider firSymbolProvider = FirSymbolProviderKt.getSymbolProvider(session2);
        FirTypeRef typeRef$iv = $this$fqName.getAnnotationTypeRef();
        boolean $i$f$getSymbolByTypeRef = false;
        FirTypeRef $this$coneTypeSafe$iv$iv = typeRef$iv;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
            coneKotlinType = null;
        }
        if ((object = (ConeLookupTagBasedType)((ConeKotlinType)((ConeLookupTagBasedType)coneKotlinType))) == null || (object = ((ConeLookupTagBasedType)object).getLookupTag()) == null) {
            firBasedSymbol = null;
        } else {
            void $this$getSymbolByTypeRef$iv;
            Object lookupTag$iv = object;
            FirClassifierSymbol<?> firClassifierSymbol = LookupTagUtilsKt.getSymbolByLookupTag((FirSymbolProvider)$this$getSymbolByTypeRef$iv, (ConeClassifierLookupTag)lookupTag$iv);
            if (!(firClassifierSymbol instanceof FirRegularClassSymbol)) {
                firClassifierSymbol = null;
            }
            firBasedSymbol = (FirRegularClassSymbol)firClassifierSymbol;
        }
        FirRegularClassSymbol firRegularClassSymbol = (FirRegularClassSymbol)firBasedSymbol;
        if (firRegularClassSymbol == null) {
            return null;
        }
        FirRegularClassSymbol symbol2 = firRegularClassSymbol;
        return symbol2.getClassId().asSingleFqName();
    }
}

