/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.AbstractIterator;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.utils.ArrayMap;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001e*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002\u001e\u001fB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0002\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00150\u0014J\u0018\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0012\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u0010\u0017J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0096\u0002J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bJ\u001e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001dR\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/utils/ArrayMapImpl;", "T", "", "Lorg/jetbrains/kotlin/fir/utils/ArrayMap;", "()V", "data", "", "initialSize", "", "([Ljava/lang/Object;I)V", "[Ljava/lang/Object;", "<set-?>", "size", "getSize", "()I", "copy", "ensureCapacity", "", "index", "entries", "", "Lorg/jetbrains/kotlin/fir/utils/ArrayMapImpl$Entry;", "get", "(I)Ljava/lang/Object;", "iterator", "", "remove", "set", "value", "(ILjava/lang/Object;)V", "Companion", "Entry", "cones"})
public final class ArrayMapImpl<T>
extends ArrayMap<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Object[] data;
    private int size;

    private ArrayMapImpl(Object[] data, int initialSize) {
        super(null);
        this.data = data;
        this.size = initialSize;
    }

    public ArrayMapImpl() {
        this(new Object[20], 0);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private final void ensureCapacity(int index2) {
        if (this.data.length <= index2) {
            Object[] objectArray = Arrays.copyOf(this.data, this.data.length * 2);
            Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(this, newSize)");
            this.data = objectArray;
        }
    }

    @Override
    public void set(int index2, @NotNull T value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.ensureCapacity(index2);
        if (this.data[index2] == null) {
            int n = this.getSize();
            this.size = n + 1;
        }
        this.data[index2] = value2;
    }

    @Override
    @Nullable
    public T get(int index2) {
        return (T)ArraysKt.getOrNull(this.data, index2);
    }

    @Override
    @NotNull
    public ArrayMap<T> copy() {
        Object[] objectArray = Arrays.copyOf(this.data, this.data.length);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(this, size)");
        return new ArrayMapImpl<T>(objectArray, this.getSize());
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new AbstractIterator<T>(this){
            private int index;
            final /* synthetic */ ArrayMapImpl<T> this$0;
            {
                this.this$0 = $receiver;
                this.index = -1;
            }

            protected void computeNext() {
                do {
                    int n = this.index;
                    this.index = n + 1;
                } while (this.index < ArrayMapImpl.access$getData$p(this.this$0).length && ArrayMapImpl.access$getData$p(this.this$0)[this.index] == null);
                if (this.index >= ArrayMapImpl.access$getData$p(this.this$0).length) {
                    this.done();
                } else {
                    Object object = ArrayMapImpl.access$getData$p(this.this$0)[this.index];
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type T of org.jetbrains.kotlin.fir.utils.ArrayMapImpl");
                    }
                    this.setNext(object);
                }
            }
        };
    }

    public final void remove(int index2) {
        if (this.data[index2] != null) {
            int n = this.getSize();
            this.size = n + -1;
        }
        this.data[index2] = null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entry<T>> entries() {
        void $this$mapIndexedNotNullTo$iv$iv;
        Object[] $this$mapIndexedNotNull$iv = this.data;
        boolean $i$f$mapIndexedNotNull = false;
        Object[] objectArray = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (void item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            Entry<void> it$iv$iv;
            void value2;
            void element$iv$iv;
            int n = index$iv$iv$iv++;
            void var12_12 = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            void var15_15 = element$iv$iv;
            int index2 = index$iv$iv;
            boolean bl2 = false;
            if ((value2 != null ? new Entry<void>(index2, value2) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ Object[] access$getData$p(ArrayMapImpl $this) {
        return $this.data;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/utils/ArrayMapImpl$Companion;", "", "()V", "DEFAULT_SIZE", "", "INCREASE_K", "cones"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\r\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0005\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/utils/ArrayMapImpl$Entry;", "T", "", "", "key", "value", "(ILjava/lang/Object;)V", "getKey", "()Ljava/lang/Integer;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "copy", "(ILjava/lang/Object;)Lorg/jetbrains/kotlin/fir/utils/ArrayMapImpl$Entry;", "equals", "", "other", "", "hashCode", "toString", "", "cones"})
    public static final class Entry<T>
    implements Map.Entry<Integer, T>,
    KMappedMarker {
        private final int key;
        private final T value;

        public Entry(int key, T value2) {
            this.key = key;
            this.value = value2;
        }

        @Override
        @NotNull
        public Integer getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        public final int component1() {
            return this.getKey();
        }

        public final T component2() {
            return this.getValue();
        }

        @NotNull
        public final Entry<T> copy(int key, T value2) {
            return new Entry<T>(key, value2);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, int n, Object object, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                n = entry.getKey();
            }
            if ((n2 & 2) != 0) {
                object = entry.getValue();
            }
            return entry.copy(n, object);
        }

        @NotNull
        public String toString() {
            return "Entry(key=" + this.getKey() + ", value=" + this.getValue() + ')';
        }

        @Override
        public int hashCode() {
            int result2 = ((Object)this.getKey()).hashCode();
            result2 = result2 * 31 + (this.getValue() == null ? 0 : this.getValue().hashCode());
            return result2;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (this.getKey().intValue() != entry.getKey().intValue()) {
                return false;
            }
            return Intrinsics.areEqual(this.getValue(), entry.getValue());
        }

        @Override
        public T setValue(T newValue2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

