/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0004J\u0013\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\bH&J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/types/ClassifierBasedTypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "()V", "hashCode", "", "areFqNamesEqual", "", "first", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "second", "equals", "other", "", "getDeclarationDescriptor", "hasMeaningfulFqName", "descriptor", "isSameClassifier", "classifier", "descriptors"})
public abstract class ClassifierBasedTypeConstructor
implements TypeConstructor {
    private int hashCode;

    @Override
    @NotNull
    public abstract ClassifierDescriptor getDeclarationDescriptor();

    public int hashCode() {
        int computedHashCode;
        int n;
        int cachedHashCode = this.hashCode;
        if (cachedHashCode != 0) {
            return cachedHashCode;
        }
        ClassifierDescriptor descriptor2 = this.getDeclarationDescriptor();
        int it = n = (computedHashCode = this.hasMeaningfulFqName(descriptor2) ? DescriptorUtils.getFqName(descriptor2).hashCode() : System.identityHashCode(this));
        boolean bl = false;
        this.hashCode = it;
        return n;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypeConstructor)) {
            return false;
        }
        if (other.hashCode() != this.hashCode()) {
            return false;
        }
        if (((TypeConstructor)other).getParameters().size() != this.getParameters().size()) {
            return false;
        }
        ClassifierDescriptor myDescriptor = this.getDeclarationDescriptor();
        ClassifierDescriptor classifierDescriptor = ((TypeConstructor)other).getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return false;
        }
        ClassifierDescriptor otherDescriptor = classifierDescriptor;
        if (!this.hasMeaningfulFqName(myDescriptor) || !this.hasMeaningfulFqName(otherDescriptor)) {
            return false;
        }
        return this.isSameClassifier(otherDescriptor);
    }

    protected abstract boolean isSameClassifier(@NotNull ClassifierDescriptor var1);

    protected final boolean areFqNamesEqual(@NotNull ClassifierDescriptor first, @NotNull ClassifierDescriptor second) {
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(second, "second");
        if (!Intrinsics.areEqual(first.getName(), second.getName())) {
            return false;
        }
        DeclarationDescriptor a = first.getContainingDeclaration();
        for (DeclarationDescriptor b = second.getContainingDeclaration(); a != null && b != null; a = a.getContainingDeclaration(), b = b.getContainingDeclaration()) {
            if (a instanceof ModuleDescriptor) {
                return b instanceof ModuleDescriptor;
            }
            if (b instanceof ModuleDescriptor) {
                return false;
            }
            if (a instanceof PackageFragmentDescriptor) {
                return b instanceof PackageFragmentDescriptor && Intrinsics.areEqual(((PackageFragmentDescriptor)a).getFqName(), ((PackageFragmentDescriptor)b).getFqName());
            }
            if (b instanceof PackageFragmentDescriptor) {
                return false;
            }
            if (Intrinsics.areEqual(a.getName(), b.getName())) continue;
            return false;
        }
        return true;
    }

    private final boolean hasMeaningfulFqName(ClassifierDescriptor descriptor2) {
        return !ErrorUtils.isError(descriptor2) && !DescriptorUtils.isLocal(descriptor2);
    }
}

