/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.formatter.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Objects;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.tools.formatter.serialize.CatalogSerializer;

public final class JavaSerializedCatalog
implements CatalogSerializer {
    private final Catalog catalog;

    private static Catalog readCatalog(InputStream in) {
        Catalog catalog;
        Objects.requireNonNull(in, "No input stream provided");
        ObjectInputStream objIn = new ObjectInputStream(in);
        try {
            catalog = (Catalog)objIn.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objIn.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new ExecutionRuntimeException("Cannot deserialize catalog", (Throwable)e);
            }
        }
        objIn.close();
        return catalog;
    }

    public JavaSerializedCatalog(Catalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
    }

    public JavaSerializedCatalog(InputStream in) {
        this(JavaSerializedCatalog.readCatalog(in));
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public void save(OutputStream out) {
        Objects.requireNonNull(out, "No output stream provided");
        try (ObjectOutputStream objOut = new ObjectOutputStream(out);){
            objOut.writeObject(this.catalog);
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not serialize catalog", e);
        }
    }

    @Override
    public void save(Writer out) {
        throw new UnsupportedOperationException("Cannot serialize binary format using character data");
    }
}

