/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.sqlite;

import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.tools.databaseconnector.DatabaseConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnectionSource;
import schemacrawler.tools.databaseconnector.DatabaseUrlConnectionOptions;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import schemacrawler.tools.sqlite.SQLiteDatabaseConnector;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.database.DatabaseUtility;

public class EmbeddedSQLiteWrapper {
    private Path databaseFile;

    public DatabaseConnectionSource createDatabaseConnectionSource() {
        Objects.requireNonNull(this.databaseFile, "Database file not loaded");
        DatabaseUrlConnectionOptions urlConnectionOptions = new DatabaseUrlConnectionOptions(this.getConnectionUrl());
        DatabaseConnectionSource connectionOptions = new SQLiteDatabaseConnector().newDatabaseConnectionSource((DatabaseConnectionOptions)urlConnectionOptions);
        return connectionOptions;
    }

    public Path createDiagram(String title, String extension) {
        Path path;
        block8: {
            Connection connection = this.createDatabaseConnectionSource().get();
            try {
                path = this.createDiagram(connection, title, extension);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseAccessException("Could not create database connection", e);
                }
            }
            connection.close();
        }
        return path;
    }

    public String getConnectionUrl() {
        Objects.requireNonNull(this.databaseFile, "Database file not loaded");
        return "jdbc:sqlite:" + this.databaseFile.toString();
    }

    public String getDatabase() {
        if (this.databaseFile == null) {
            return "";
        }
        return this.databaseFile.toString();
    }

    public void loadDatabaseFile(Path dbFile) {
        this.databaseFile = this.checkDatabaseFile(dbFile);
    }

    protected final Path checkDatabaseFile(Path dbFile) {
        Path databaseFile = Objects.requireNonNull(dbFile, "No database file path provided").normalize().toAbsolutePath();
        if (!IOUtility.isFileReadable((Path)databaseFile)) {
            throw new IORuntimeException(String.format("Could not read database file <%s>", dbFile));
        }
        return databaseFile;
    }

    private Path createDiagram(Connection connection, String title, String extension) {
        try {
            DatabaseUtility.checkConnection((Connection)connection);
            SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
            Path diagramFile = IOUtility.createTempFilePath((String)"schemacrawler", (String)extension);
            OutputOptions outputOptions = OutputOptionsBuilder.builder().title(title).withOutputFormatValue(extension).withOutputFile(diagramFile).toOptions();
            SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable("schema");
            executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
            executable.setOutputOptions(outputOptions);
            executable.setConnection(connection);
            executable.execute();
            return diagramFile;
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException(String.format("Could not create database schema diagram <%s>", title), (Throwable)e);
        }
    }
}

