/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.MutableProcedureParameter;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.ParameterModeType;
import schemacrawler.schema.ProcedureParameter;
import schemacrawler.schema.RoutineType;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.WrappedSQLException;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class ProcedureParameterRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(ProcedureParameterRetriever.class.getName());

    ProcedureParameterRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) {
        super(retrieverConnection, catalog, options);
    }

    void retrieveProcedureParameters(NamedObjectList<MutableRoutine> allRoutines, InclusionRule parameterInclusionRule) throws SQLException {
        Objects.requireNonNull(allRoutines, "No procedures provided");
        InclusionRuleFilter<ProcedureParameter> parameterFilter = new InclusionRuleFilter<ProcedureParameter>(parameterInclusionRule, true);
        if (parameterFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving procedure parameters, since this was not requested");
            return;
        }
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.procedureParametersRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving procedure parameters, using fast data dictionary retrieval");
                this.retrieveProcedureParametersFromDataDictionary(allRoutines, parameterFilter);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving procedure parameters");
                this.retrieveProcedureParametersFromMetadata(allRoutines, parameterFilter);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving procedure parameters");
            }
        }
    }

    private void createProcedureParameter(MetadataResultSet results, NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<ProcedureParameter> parameterFilter) {
        String columnCatalogName = this.normalizeCatalogName(results.getString("PROCEDURE_CAT"));
        String schemaName = this.normalizeSchemaName(results.getString("PROCEDURE_SCHEM"));
        String procedureName = results.getString("PROCEDURE_NAME");
        String columnName = results.getString("COLUMN_NAME");
        String specificName = results.getString("SPECIFIC_NAME");
        ParameterModeType parameterMode = this.getProcedureParameterMode(results.getInt("COLUMN_TYPE", 0));
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Retrieving procedure parameter <%s.%s.%s.%s.%s>", new Object[]{columnCatalogName, schemaName, procedureName, specificName, columnName}));
        if (Utility.isBlank((CharSequence)columnName) && parameterMode == ParameterModeType.result) {
            columnName = "<return value>";
        }
        if (Utility.isBlank((CharSequence)columnName)) {
            return;
        }
        Optional<MutableRoutine> optionalRoutine = allRoutines.lookup(new NamedObjectKey(columnCatalogName, schemaName, procedureName, specificName));
        if (!optionalRoutine.isPresent()) {
            return;
        }
        MutableRoutine routine = optionalRoutine.get();
        if (routine.getRoutineType() != RoutineType.procedure) {
            return;
        }
        MutableProcedure procedure = (MutableProcedure)routine;
        MutableProcedureParameter parameter = this.lookupOrCreateProcedureParameter(procedure, columnName);
        if (parameterFilter.test(parameter) && this.belongsToSchema(procedure, columnCatalogName, schemaName)) {
            int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
            int dataType = results.getInt("DATA_TYPE", 0);
            String typeName = results.getString("TYPE_NAME");
            int length = results.getInt("LENGTH", 0);
            int precision = results.getInt("PRECISION", 0);
            boolean isNullable = results.getShort("NULLABLE", (short)2) == 1;
            String remarks = results.getString("REMARKS");
            parameter.setOrdinalPosition(ordinalPosition);
            parameter.setParameterMode(parameterMode);
            parameter.setColumnDataType(this.lookupOrCreateColumnDataType(DataTypeType.user_defined, procedure.getSchema(), dataType, typeName));
            parameter.setSize(length);
            parameter.setPrecision(precision);
            parameter.setNullable(isNullable);
            parameter.setRemarks(remarks);
            parameter.addAttributes(results.getAttributes());
            LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Adding parameter to procedure <%s>", new Object[]{parameter}));
            procedure.addParameter(parameter);
        }
    }

    private ParameterModeType getProcedureParameterMode(int columnType) {
        switch (columnType) {
            case 1: {
                return ParameterModeType.in;
            }
            case 2: {
                return ParameterModeType.inOut;
            }
            case 4: {
                return ParameterModeType.out;
            }
            case 3: {
                return ParameterModeType.result;
            }
            case 5: {
                return ParameterModeType.returnValue;
            }
        }
        return ParameterModeType.unknown;
    }

    private MutableProcedureParameter lookupOrCreateProcedureParameter(MutableProcedure procedure, String columnName) {
        Optional<MutableProcedureParameter> parameterOptional = procedure.lookupParameter(columnName);
        MutableProcedureParameter parameter = parameterOptional.orElseGet(() -> new MutableProcedureParameter(procedure, columnName));
        return parameter;
    }

    private void retrieveProcedureParametersFromDataDictionary(NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<ProcedureParameter> parameterFilter) throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.PROCEDURE_COLUMNS)) {
            throw new ExecutionRuntimeException("No procedure parameters SQL provided");
        }
        Query procedureColumnsSql = informationSchemaViews.getQuery(InformationSchemaKey.PROCEDURE_COLUMNS);
        try (Statement statement = this.createStatement();
             MetadataResultSet results = new MetadataResultSet(procedureColumnsSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                this.createProcedureParameter(results, allRoutines, parameterFilter);
            }
        }
    }

    private void retrieveProcedureParametersFromMetadata(NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<ProcedureParameter> parameterFilter) throws WrappedSQLException {
        for (MutableRoutine routine : allRoutines) {
            if (routine.getRoutineType() != RoutineType.procedure) continue;
            MutableProcedure procedure = (MutableProcedure)routine;
            LOGGER.log(Level.FINE, "Retrieving procedure parameters for " + procedure);
            try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getProcedureColumns(procedure.getSchema().getCatalogName(), procedure.getSchema().getName(), procedure.getName(), null), "DatabaseMetaData::getProcedureColumns");){
                while (results.next()) {
                    this.createProcedureParameter(results, allRoutines, parameterFilter);
                }
            }
            catch (SQLException e) {
                throw new WrappedSQLException(String.format("Could not retrieve procedure parameters for procedure <%s>", procedure), e);
            }
        }
    }
}

