/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import schemacrawler.schemacrawler.InfoLevel;
import schemacrawler.schemacrawler.LoadOptions;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;

public final class LoadOptionsBuilder
implements OptionsBuilder<LoadOptionsBuilder, LoadOptions> {
    private SchemaInfoLevel schemaInfoLevel = SchemaInfoLevelBuilder.standard();

    public static LoadOptionsBuilder builder() {
        return new LoadOptionsBuilder();
    }

    public static LoadOptions newLoadOptions() {
        return LoadOptionsBuilder.builder().toOptions();
    }

    private LoadOptionsBuilder() {
    }

    public LoadOptionsBuilder fromOptions(LoadOptions options) {
        if (options == null) {
            return this;
        }
        this.schemaInfoLevel = options.getSchemaInfoLevel();
        return this;
    }

    @Override
    public LoadOptions toOptions() {
        return new LoadOptions(this.schemaInfoLevel);
    }

    public LoadOptionsBuilder withInfoLevel(InfoLevel infoLevel) {
        if (infoLevel != null) {
            this.schemaInfoLevel = infoLevel.toSchemaInfoLevel();
        }
        return this;
    }

    public LoadOptionsBuilder withSchemaInfoLevel(SchemaInfoLevel schemaInfoLevel) {
        if (schemaInfoLevel != null) {
            this.schemaInfoLevel = schemaInfoLevel;
        }
        return this;
    }

    public LoadOptionsBuilder withSchemaInfoLevelBuilder(SchemaInfoLevelBuilder schemaInfoLevelBuilder) {
        if (schemaInfoLevelBuilder != null) {
            this.schemaInfoLevel = schemaInfoLevelBuilder.toOptions();
        }
        return this;
    }
}

