/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.AttributedObject;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.Table;
import schemacrawler.tools.command.lint.options.LintOptions;
import schemacrawler.tools.lint.Lint;
import schemacrawler.tools.lint.LintReport;
import schemacrawler.tools.lint.LintSeverity;
import schemacrawler.tools.lint.formatter.LintReportBuilder;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.formatter.base.BaseTabularFormatter;
import schemacrawler.tools.text.formatter.base.helper.TextFormattingHelper;
import schemacrawler.tools.text.options.BaseTextOptions;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.Color;
import us.fatehi.utility.Multimap;

public final class LintReportTextFormatter
extends BaseTabularFormatter<LintOptions>
implements LintReportBuilder {
    private static final String LINT_KEY = "schemacrawler.lint";
    private final Catalog catalog;
    private final LintOptions lintOptions;

    private static Collection<Lint<?>> getLint(AttributedObject namedObject) {
        if (namedObject == null) {
            return null;
        }
        ArrayList lints = new ArrayList((Collection)namedObject.getAttribute(LINT_KEY, new ArrayList()));
        lints.sort(Comparator.naturalOrder());
        return lints;
    }

    public LintReportTextFormatter(Catalog catalog, LintOptions lintOptions, OutputOptions outputOptions, String identifierQuoteString) {
        super((BaseTextOptions)lintOptions, false, outputOptions, identifierQuoteString);
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
        this.lintOptions = Objects.requireNonNull(lintOptions, "No lint options provided");
    }

    @Override
    public void generateLintReport(LintReport report) {
        this.begin();
        this.handleInfoStart();
        this.handle(this.catalog.getDatabaseInfo());
        this.handle(this.catalog.getJdbcDriverInfo());
        this.handleInfoEnd();
        this.handleStart();
        this.handle(this.catalog);
        ArrayList tablesList = new ArrayList(this.catalog.getTables());
        Collections.sort(tablesList, NamedObjectSort.getNamedObjectSort((boolean)this.lintOptions.isAlphabeticalSortForTables()));
        for (Table table : tablesList) {
            this.handle(table);
        }
        this.handleEnd();
        this.end();
    }

    private void handle(Catalog catalog) {
        Collection<Lint<?>> lints = LintReportTextFormatter.getLint((AttributedObject)catalog);
        if (lints != null && !lints.isEmpty()) {
            this.formattingHelper.writeObjectStart();
            this.formattingHelper.writeObjectNameRow("", "Database", "[database]", Color.white);
            this.printLints(lints);
            this.formattingHelper.writeObjectEnd();
        }
    }

    private void handle(Table table) {
        Collection<Lint<?>> lints = LintReportTextFormatter.getLint((AttributedObject)table);
        if (lints != null && !lints.isEmpty()) {
            this.formattingHelper.writeObjectStart();
            this.formattingHelper.println();
            this.formattingHelper.println();
            String tableType = "[" + table.getTableType() + "]";
            this.formattingHelper.writeObjectNameRow(this.nodeId((DatabaseObject)table), this.identifiers.quoteFullName((DatabaseObject)table), tableType, this.colorMap.getColor((DatabaseObject)table));
            this.printLints(lints);
            this.formattingHelper.writeObjectEnd();
        }
    }

    private void handleEnd() {
    }

    private void handleStart() {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Lints");
    }

    private void printLints(Collection<Lint<?>> lints) {
        this.formattingHelper.writeEmptyRow();
        Multimap multiMap = new Multimap();
        for (Lint<?> lint : lints) {
            multiMap.add((Object)lint.getSeverity(), lint);
        }
        List<LintSeverity> severities = Arrays.asList(LintSeverity.values());
        Collections.reverse(severities);
        for (LintSeverity severity : severities) {
            if (!multiMap.containsKey((Object)severity)) continue;
            this.formattingHelper.writeNameRow("", String.format("[lint, %s]", new Object[]{severity}));
            ArrayList lintsById = new ArrayList((Collection)multiMap.get((Object)severity));
            for (Lint lint : lintsById) {
                Object lintValue = lint.getValue();
                if (lintValue instanceof Boolean) {
                    if (!((Boolean)lintValue).booleanValue()) continue;
                    this.formattingHelper.writeRow(new Object[]{"", lint.getMessage(), ""});
                    continue;
                }
                this.formattingHelper.writeRow(new Object[]{"", lint.getMessage(), lint.getValueAsString()});
            }
        }
    }
}

