/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.CSMspwd;
import com.informix.asf.IfxASFException;
import com.informix.asf.IfxDataOutputStream;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.BufferedOutputStream;
import java.io.IOException;

public class CSMBufferedOutputStream
extends BufferedOutputStream {
    static final int STREAM_BUF_SIZE = 4098;
    static final short BLOCK_SIZE = 8;
    static final short SPWD_CSM_MSG_TYPE_DATA = 3;
    private CSMspwd CSMspwd = null;
    private IfxDataOutputStream IfxOs = null;
    private byte[] buffer;
    private int bufferDataLen;
    private String ClientLocale = null;
    private Trace traceObj;

    public CSMBufferedOutputStream(IfxDataOutputStream Os, CSMspwd csm) {
        super(Os);
        this.CSMspwd = csm;
        this.IfxOs = Os;
        this.buffer = new byte[4098];
        this.bufferDataLen = 0;
    }

    public CSMBufferedOutputStream(IfxDataOutputStream Os, int size, CSMspwd csm) {
        super(Os, size);
        this.CSMspwd = csm;
        this.IfxOs = Os;
        this.buffer = new byte[4098];
        this.bufferDataLen = 0;
    }

    @Override
    public final void flush() throws IOException {
        if (this.bufferDataLen > 0) {
            this.encryptWrite(this.buffer, 0, this.bufferDataLen);
            this.bufferDataLen = 0;
        }
        this.IfxOs.flush();
    }

    @Override
    public void write(int i) throws IOException {
        byte[] b = new byte[]{(byte)i};
        this.write(b, 0, 1);
    }

    @Override
    public void write(byte[] data, int off, int len) throws IOException {
        if (len >= 4098) {
            this.encryptWrite(this.buffer, 0, this.bufferDataLen);
            this.bufferDataLen = 0;
            this.encryptWrite(data, off, len);
        } else {
            int newLen = this.bufferDataLen + len;
            if (newLen > 4098) {
                byte[] tmpBuffer = new byte[newLen];
                System.arraycopy(this.buffer, 0, tmpBuffer, 0, this.bufferDataLen);
                System.arraycopy(data, off, tmpBuffer, this.bufferDataLen, len);
                this.encryptWrite(tmpBuffer, 0, newLen);
                this.bufferDataLen = 0;
            } else {
                System.arraycopy(data, off, this.buffer, this.bufferDataLen, len);
                if (newLen == 4098) {
                    this.encryptWrite(this.buffer, 0, newLen);
                    this.bufferDataLen = 0;
                } else {
                    this.bufferDataLen = newLen;
                }
            }
        }
    }

    private void encryptWrite(byte[] data, int off, int len) throws IOException {
        byte[] paddedData;
        int paddedLen;
        this.IfxOs.writeShort((short)3);
        int remainder = len % 8;
        if (remainder > 0) {
            paddedLen = len + (8 - remainder);
            paddedData = new byte[paddedLen];
            System.arraycopy(data, off, paddedData, 0, len);
            for (int i = len; i < paddedLen; ++i) {
                paddedData[i] = 0;
            }
        } else {
            paddedLen = len;
            paddedData = new byte[paddedLen];
            System.arraycopy(data, off, paddedData, 0, len);
        }
        byte[] messageArray = new byte[paddedLen];
        try {
            this.CSMspwd.processOutMessage(paddedData, messageArray);
        }
        catch (IfxASFException e) {
            throw IfxErrMsg.getLocIOException(-5030, this.ClientLocale);
        }
        short messageLength = (short)(paddedLen + 2);
        this.IfxOs.writeShort(messageLength);
        this.IfxOs.writeShort(len);
        this.IfxOs.write(messageArray, 0, paddedLen);
    }

    public void setClientLocale(String loc) {
        this.ClientLocale = loc;
    }

    public String getClientLocale() {
        return this.ClientLocale;
    }
}

