/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.UcanaccessConnection;

public class DFunction {
    private Connection conn;
    private String sql;
    private static final Pattern FROM_PATTERN = Pattern.compile("\\w*(?i)FROM\\w*");
    private static final String SELECT_FROM = "(?i)SELECT(.*\\W)(?i)FROM(.*)";
    private static final String DFUNCTIONS_WHERE = "(?i)_[\\s\n\r]*\\([\\s\n\r]*['\"](.*)['\"]\\,[\\s\n\r]*['\"](.*)['\"]\\,[\\s\n\r]*['\"](.*)['\"][\\s\n\r]*\\)";
    private static final String DFUNCTIONS_WHERE_DYNAMIC = "(?i)_[\\s\n\r]*\\([\\s\n\r]*['\"](.*)['\"]\\,[\\s\n\r]*['\"](.*)['\"]\\,(.*)\\)";
    private static final String DFUNCTIONS_NO_WHERE = "(?i)_[\\s\n\r]*\\([\\s\n\r]*['\"](.*)['\"]\\,[\\s\n\r]*['\"](.*)['\"][\\s\n\r]*\\)";
    private static final String IDENTIFIER = "(\\W)((?i)_)(\\W)";
    private static final List<String> DFUNCTIONLIST = Arrays.asList("COUNT", "MAX", "MIN", "SUM", "AVG", "LAST", "FIRST", "LOOKUP");

    public DFunction(Connection _conn, String _sql) {
        this.conn = _conn;
        this.sql = _sql;
    }

    private String convertDFunctions() {
        String sql0 = this.sql;
        try {
            boolean hasFrom = FROM_PATTERN.matcher(this.sql).find();
            String init = hasFrom ? " (SELECT " : "";
            String end = hasFrom ? " ) " : "";
            for (String s : DFUNCTIONLIST) {
                String fun = "D" + s;
                s = s.equalsIgnoreCase("lookup") ? " " : s;
                sql0 = sql0.replaceAll(DFUNCTIONS_WHERE.replaceFirst("_", fun), init + s + "($1) FROM $2 WHERE $3     " + end);
                sql0 = sql0.replaceAll(DFUNCTIONS_NO_WHERE.replaceFirst("_", fun), init + s + "($1) FROM $2    " + end);
                Pattern dfd = Pattern.compile(DFUNCTIONS_WHERE_DYNAMIC.replaceFirst("_", fun));
                Matcher mtc = dfd.matcher(sql0);
                while (mtc.find()) {
                    boolean sqlConcat;
                    StringBuffer sb = new StringBuffer();
                    String g3 = mtc.group(3);
                    String tableN = mtc.group(2).trim();
                    String alias = tableN.startsWith("[") & tableN.endsWith("]") ? "[" + DFunction.unpad(tableN) + "_DALIAS]" : tableN + "_DALIAS";
                    String tn = tableN.startsWith("[") & tableN.endsWith("]") ? DFunction.unpad(tableN) : tableN;
                    sb.append(init).append(s).append("(").append(mtc.group(1)).append(") FROM ").append(tableN).append(" AS ").append(alias).append(" WHERE ");
                    boolean accessConcat = g3.indexOf("&") > 0;
                    boolean bl = sqlConcat = g3.indexOf("||") > 0;
                    if (accessConcat || sqlConcat) {
                        String[] pts;
                        String concat = accessConcat ? "&" : Pattern.quote("||");
                        for (String tkn : pts = g3.split(concat, -1)) {
                            if (DFunction.isQuoted(tkn)) {
                                tkn = tkn.trim();
                                sb.append(DFunction.unpad(tkn));
                                continue;
                            }
                            tkn = tkn + " ";
                            for (String cln : this.getColumnNames(tn.toUpperCase())) {
                                String pref;
                                String oppn = IDENTIFIER.replaceFirst("_", cln);
                                Pattern op = Pattern.compile(oppn);
                                Matcher mtcop = op.matcher(tkn);
                                if (!mtcop.find() || (pref = mtcop.group(1)).equals(".") || pref.equals("[") && mtcop.start(1) > 0 && tkn.charAt(mtcop.start(1) - 1) == '.') continue;
                                tkn = tkn.replaceAll(oppn, pref.equals("[") ? this.resolveAmbiguosTableName(cln) + ".$1$2$3" : "$1" + this.resolveAmbiguosTableName(cln) + ".$2$3");
                            }
                            sb.append(tkn);
                        }
                    }
                    sb.append(end);
                    sql0 = sql0.replaceFirst(DFUNCTIONS_WHERE_DYNAMIC.replaceFirst("_", fun), sb.toString());
                    mtc = dfd.matcher(sql0);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return sql0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveAmbiguosTableName(String identifier) {
        Statement st = null;
        try {
            String f4t = SQLConverter.convertSQL(this.sql.replaceAll("[\r\n]", " ").replaceFirst(SELECT_FROM, "SELECT " + identifier + " FROM $2 ")).getSql();
            st = this.conn.createStatement();
            ResultSetMetaData rsmd = st.executeQuery(f4t).getMetaData();
            String tableN = rsmd.getTableName(1);
            if (tableN == null || tableN.trim().length() == 0) {
                String string = identifier;
                return string;
            }
            String string = tableN;
            return string;
        }
        catch (SQLException e) {
            String string = identifier;
            return string;
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private List<String> getColumnNames(String tableName) throws SQLException {
        ArrayList<String> ar = new ArrayList<String>();
        if (this.conn == null) {
            UcanaccessConnection conu = UcanaccessConnection.getCtxConnection();
            if (conu == null) {
                return ar;
            }
            this.conn = conu.getHSQLDBConnection();
        }
        DatabaseMetaData dbmd = this.conn.getMetaData();
        ResultSet rs = dbmd.getColumns(null, null, tableName, null);
        while (rs.next()) {
            ar.add(rs.getString("COLUMN_NAME"));
        }
        return ar;
    }

    private static boolean isQuoted(String g3) {
        return (g3 = g3.trim()).startsWith("'") && g3.endsWith("'") && g3.substring(1, g3.length() - 1).indexOf(39) < 0 || g3.startsWith("\"") && g3.endsWith("\"") && g3.substring(1, g3.length() - 1).indexOf(34) < 0;
    }

    private static String unpad(String tkn) {
        return tkn.substring(1, tkn.length() - 1);
    }

    public String toSQL() {
        return this.convertDFunctions();
    }

    public static String convertDFunctions(String sql, Connection conu) {
        return new DFunction(conu, sql).toSQL();
    }
}

