SELECT  
  NULL AS TABLE_CATALOG,
  COLUMNS.OWNER AS TABLE_SCHEMA,
  COLUMNS.TABLE_NAME,
  COLUMNS.COLUMN_NAME
FROM 
  ${catalogscope}_TAB_COLS COLUMNS
WHERE
  COLUMNS.OWNER NOT IN 
    ('ANONYMOUS', 'APEX_PUBLIC_USER', 'APPQOSSYS', 'BI', 'CTXSYS', 'DBSNMP', 'DIP', 
    'EXFSYS', 'FLOWS_30000', 'FLOWS_FILES', 'GSMADMIN_INTERNAL', 'IX', 'LBACSYS', 
    'MDDATA', 'MDSYS', 'MGMT_VIEW', 'OE', 'OLAPSYS', 'ORACLE_OCM', 
    'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'OWBSYS', 'PM', 'SCOTT', 'SH', 
    'SI_INFORMTN_SCHEMA', 'SPATIAL_CSW_ADMIN_USR', 'SPATIAL_WFS_ADMIN_USR', 
    'SYS', 'SYSMAN', 'SYSTEM', 'TSMSYS', 'WKPROXY', 'WKSYS', 'WK_TEST', 
    'WMSYS', 'XDB', 'XS$NULL', 'RDSADMIN')  
  AND NOT REGEXP_LIKE(COLUMNS.OWNER, '^APEX_[0-9]{6}$')
  AND NOT REGEXP_LIKE(COLUMNS.OWNER, '^FLOWS_[0-9]{5,6}$')
  AND REGEXP_LIKE(COLUMNS.OWNER, '${schemas}')
  AND COLUMNS.TABLE_NAME NOT LIKE 'BIN$%'
  AND NOT REGEXP_LIKE(COLUMNS.TABLE_NAME, '^(SYS_IOT|MDOS|MDRS|MDRT|MDOT|MDXT)_.*$')
  AND COLUMNS.HIDDEN_COLUMN = 'YES'
ORDER BY 
  COLUMNS.OWNER, 
  COLUMNS.TABLE_NAME,
  COLUMNS.COLUMN_NAME
