// services/data_decoder/public/mojom/data_decoder_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/data_decoder/public/mojom/data_decoder_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/data_decoder/public/mojom/data_decoder_service.mojom-params-data.h"
#include "services/data_decoder/public/mojom/data_decoder_service.mojom-shared-message-ids.h"

#include "services/data_decoder/public/mojom/data_decoder_service.mojom-import-headers.h"


#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_DATA_DECODER_SERVICE_MOJOM_JUMBO_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_DATA_DECODER_SERVICE_MOJOM_JUMBO_H_
#endif
namespace data_decoder {
namespace mojom {
const char DataDecoderService::Name_[] = "data_decoder.mojom.DataDecoderService";

DataDecoderServiceProxy::DataDecoderServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DataDecoderServiceProxy::BindImageDecoder(
    ::mojo::PendingReceiver<::data_decoder::mojom::ImageDecoder> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "data_decoder::mojom::DataDecoderService::BindImageDecoder", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDataDecoderService_BindImageDecoder_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::data_decoder::mojom::internal::DataDecoderService_BindImageDecoder_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::data_decoder::mojom::ImageDecoderInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DataDecoderService.BindImageDecoder request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataDecoderService::Name_);
  message.set_method_name("BindImageDecoder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DataDecoderServiceProxy::BindJsonParser(
    ::mojo::PendingReceiver<::data_decoder::mojom::JsonParser> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "data_decoder::mojom::DataDecoderService::BindJsonParser", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDataDecoderService_BindJsonParser_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::data_decoder::mojom::internal::DataDecoderService_BindJsonParser_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::data_decoder::mojom::JsonParserInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DataDecoderService.BindJsonParser request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataDecoderService::Name_);
  message.set_method_name("BindJsonParser");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DataDecoderServiceProxy::BindXmlParser(
    ::mojo::PendingReceiver<::data_decoder::mojom::XmlParser> in_reciever) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "data_decoder::mojom::DataDecoderService::BindXmlParser", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("reciever", in_reciever.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDataDecoderService_BindXmlParser_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::data_decoder::mojom::internal::DataDecoderService_BindXmlParser_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::data_decoder::mojom::XmlParserInterfaceBase>>(
      in_reciever, &params->reciever, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->reciever),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid reciever in DataDecoderService.BindXmlParser request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataDecoderService::Name_);
  message.set_method_name("BindXmlParser");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DataDecoderServiceProxy::BindWebBundleParserFactory(
    ::mojo::PendingReceiver<::web_package::mojom::WebBundleParserFactory> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "data_decoder::mojom::DataDecoderService::BindWebBundleParserFactory", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDataDecoderService_BindWebBundleParserFactory_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::data_decoder::mojom::internal::DataDecoderService_BindWebBundleParserFactory_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::web_package::mojom::WebBundleParserFactoryInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DataDecoderService.BindWebBundleParserFactory request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataDecoderService::Name_);
  message.set_method_name("BindWebBundleParserFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DataDecoderServiceProxy::BindWebBundler(
    ::mojo::PendingReceiver<::data_decoder::mojom::WebBundler> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "data_decoder::mojom::DataDecoderService::BindWebBundler", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDataDecoderService_BindWebBundler_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::data_decoder::mojom::internal::DataDecoderService_BindWebBundler_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::data_decoder::mojom::WebBundlerInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DataDecoderService.BindWebBundler request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataDecoderService::Name_);
  message.set_method_name("BindWebBundler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DataDecoderServiceStubDispatch::Accept(
    DataDecoderService* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kDataDecoderService_BindImageDecoder_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)data_decoder::mojom::DataDecoderService::BindImageDecoder",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)data_decoder::mojom::DataDecoderService::BindImageDecoder");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DataDecoderService_BindImageDecoder_Params_Data* params =
          reinterpret_cast<internal::DataDecoderService_BindImageDecoder_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::data_decoder::mojom::ImageDecoder> p_receiver{};
      DataDecoderService_BindImageDecoder_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataDecoderService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindImageDecoder(
std::move(p_receiver));
      return true;
    }
    case internal::kDataDecoderService_BindJsonParser_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)data_decoder::mojom::DataDecoderService::BindJsonParser",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)data_decoder::mojom::DataDecoderService::BindJsonParser");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DataDecoderService_BindJsonParser_Params_Data* params =
          reinterpret_cast<internal::DataDecoderService_BindJsonParser_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::data_decoder::mojom::JsonParser> p_receiver{};
      DataDecoderService_BindJsonParser_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataDecoderService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindJsonParser(
std::move(p_receiver));
      return true;
    }
    case internal::kDataDecoderService_BindXmlParser_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)data_decoder::mojom::DataDecoderService::BindXmlParser",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)data_decoder::mojom::DataDecoderService::BindXmlParser");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DataDecoderService_BindXmlParser_Params_Data* params =
          reinterpret_cast<internal::DataDecoderService_BindXmlParser_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::data_decoder::mojom::XmlParser> p_reciever{};
      DataDecoderService_BindXmlParser_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_reciever =
            input_data_view.TakeReciever<decltype(p_reciever)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataDecoderService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindXmlParser(
std::move(p_reciever));
      return true;
    }
    case internal::kDataDecoderService_BindWebBundleParserFactory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)data_decoder::mojom::DataDecoderService::BindWebBundleParserFactory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)data_decoder::mojom::DataDecoderService::BindWebBundleParserFactory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DataDecoderService_BindWebBundleParserFactory_Params_Data* params =
          reinterpret_cast<internal::DataDecoderService_BindWebBundleParserFactory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::web_package::mojom::WebBundleParserFactory> p_receiver{};
      DataDecoderService_BindWebBundleParserFactory_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataDecoderService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindWebBundleParserFactory(
std::move(p_receiver));
      return true;
    }
    case internal::kDataDecoderService_BindWebBundler_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)data_decoder::mojom::DataDecoderService::BindWebBundler",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)data_decoder::mojom::DataDecoderService::BindWebBundler");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DataDecoderService_BindWebBundler_Params_Data* params =
          reinterpret_cast<internal::DataDecoderService_BindWebBundler_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::data_decoder::mojom::WebBundler> p_receiver{};
      DataDecoderService_BindWebBundler_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataDecoderService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindWebBundler(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool DataDecoderServiceStubDispatch::AcceptWithResponder(
    DataDecoderService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDataDecoderService_BindImageDecoder_Name: {
      break;
    }
    case internal::kDataDecoderService_BindJsonParser_Name: {
      break;
    }
    case internal::kDataDecoderService_BindXmlParser_Name: {
      break;
    }
    case internal::kDataDecoderService_BindWebBundleParserFactory_Name: {
      break;
    }
    case internal::kDataDecoderService_BindWebBundler_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDataDecoderServiceValidationInfo[] = {
    {internal::kDataDecoderService_BindImageDecoder_Name,
     {&internal::DataDecoderService_BindImageDecoder_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDataDecoderService_BindJsonParser_Name,
     {&internal::DataDecoderService_BindJsonParser_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDataDecoderService_BindXmlParser_Name,
     {&internal::DataDecoderService_BindXmlParser_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDataDecoderService_BindWebBundleParserFactory_Name,
     {&internal::DataDecoderService_BindWebBundleParserFactory_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDataDecoderService_BindWebBundler_Name,
     {&internal::DataDecoderService_BindWebBundler_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DataDecoderServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::data_decoder::mojom::DataDecoderService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDataDecoderServiceValidationInfo);
}

}  // namespace mojom
}  // namespace data_decoder

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif