/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "grd-dbus-remote-desktop.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.RemoteDesktop
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GrdDBusRemoteDesktop
 * @title: GrdDBusRemoteDesktop
 * @short_description: Generated C code for the org.gnome.Mutter.RemoteDesktop D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Mutter.RemoteDesktop ---- */

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_method_info_create_session_OUT_ARG_session_path =
{
  {
    -1,
    (gchar *) "session_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_method_info_create_session_OUT_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_method_info_create_session_OUT_ARG_session_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_method_info_create_session =
{
  {
    -1,
    (gchar *) "CreateSession",
    NULL,
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_method_info_create_session_OUT_ARG_pointers,
    NULL
  },
  "handle-create-session",
  FALSE
};

static const GDBusMethodInfo * const _grd_dbus_remote_desktop_method_info_pointers[] =
{
  &_grd_dbus_remote_desktop_method_info_create_session.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _grd_dbus_remote_desktop_property_info_supported_device_types =
{
  {
    -1,
    (gchar *) "SupportedDeviceTypes",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-device-types",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grd_dbus_remote_desktop_property_info_version =
{
  {
    -1,
    (gchar *) "Version",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _grd_dbus_remote_desktop_property_info_pointers[] =
{
  &_grd_dbus_remote_desktop_property_info_supported_device_types.parent_struct,
  &_grd_dbus_remote_desktop_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _grd_dbus_remote_desktop_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.RemoteDesktop",
    (GDBusMethodInfo **) &_grd_dbus_remote_desktop_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_grd_dbus_remote_desktop_property_info_pointers,
    NULL
  },
  "remote-desktop",
};


/**
 * grd_dbus_remote_desktop_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
grd_dbus_remote_desktop_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_grd_dbus_remote_desktop_interface_info.parent_struct;
}

/**
 * grd_dbus_remote_desktop_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GrdDBusRemoteDesktop interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
grd_dbus_remote_desktop_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "supported-device-types");
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * GrdDBusRemoteDesktop:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link>.
 */

/**
 * GrdDBusRemoteDesktopIface:
 * @parent_iface: The parent interface.
 * @handle_create_session: Handler for the #GrdDBusRemoteDesktop::handle-create-session signal.
 * @get_supported_device_types: Getter for the #GrdDBusRemoteDesktop:supported-device-types property.
 * @get_version: Getter for the #GrdDBusRemoteDesktop:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link>.
 */

typedef GrdDBusRemoteDesktopIface GrdDBusRemoteDesktopInterface;
G_DEFINE_INTERFACE (GrdDBusRemoteDesktop, grd_dbus_remote_desktop, G_TYPE_OBJECT)

static void
grd_dbus_remote_desktop_default_init (GrdDBusRemoteDesktopIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GrdDBusRemoteDesktop::handle-create-session:
   * @object: A #GrdDBusRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_complete_create_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopIface, handle_create_session),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * GrdDBusRemoteDesktop:supported-device-types:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.SupportedDeviceTypes">"SupportedDeviceTypes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("supported-device-types", "SupportedDeviceTypes", "SupportedDeviceTypes", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrdDBusRemoteDesktop:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.Version">"Version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("version", "Version", "Version", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * grd_dbus_remote_desktop_get_supported_device_types: (skip)
 * @object: A #GrdDBusRemoteDesktop.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.SupportedDeviceTypes">"SupportedDeviceTypes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
grd_dbus_remote_desktop_get_supported_device_types (GrdDBusRemoteDesktop *object)
{
  return GRD_DBUS_REMOTE_DESKTOP_GET_IFACE (object)->get_supported_device_types (object);
}

/**
 * grd_dbus_remote_desktop_set_supported_device_types: (skip)
 * @object: A #GrdDBusRemoteDesktop.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.SupportedDeviceTypes">"SupportedDeviceTypes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grd_dbus_remote_desktop_set_supported_device_types (GrdDBusRemoteDesktop *object, guint value)
{
  g_object_set (G_OBJECT (object), "supported-device-types", value, NULL);
}

/**
 * grd_dbus_remote_desktop_get_version: (skip)
 * @object: A #GrdDBusRemoteDesktop.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
grd_dbus_remote_desktop_get_version (GrdDBusRemoteDesktop *object)
{
  return GRD_DBUS_REMOTE_DESKTOP_GET_IFACE (object)->get_version (object);
}

/**
 * grd_dbus_remote_desktop_set_version: (skip)
 * @object: A #GrdDBusRemoteDesktop.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.Version">"Version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grd_dbus_remote_desktop_set_version (GrdDBusRemoteDesktop *object, gint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * grd_dbus_remote_desktop_call_create_session:
 * @proxy: A #GrdDBusRemoteDesktopProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_call_create_session_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_call_create_session_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_call_create_session (
    GrdDBusRemoteDesktop *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_call_create_session_finish:
 * @proxy: A #GrdDBusRemoteDesktopProxy.
 * @out_session_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_call_create_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_call_create_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_call_create_session_finish (
    GrdDBusRemoteDesktop *proxy,
    gchar **out_session_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_session_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_call_create_session_sync:
 * @proxy: A #GrdDBusRemoteDesktopProxy.
 * @out_session_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_call_create_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_call_create_session_sync (
    GrdDBusRemoteDesktop *proxy,
    gchar **out_session_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_session_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_complete_create_session:
 * @object: A #GrdDBusRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @session_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_complete_create_session (
    GrdDBusRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *session_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   session_path));
}

/* ------------------------------------------------------------------------ */

/**
 * GrdDBusRemoteDesktopProxy:
 *
 * The #GrdDBusRemoteDesktopProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GrdDBusRemoteDesktopProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GrdDBusRemoteDesktopProxy.
 */

struct _GrdDBusRemoteDesktopProxyPrivate
{
  GData *qdata;
};

static void grd_dbus_remote_desktop_proxy_iface_init (GrdDBusRemoteDesktopIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GrdDBusRemoteDesktopProxy, grd_dbus_remote_desktop_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GrdDBusRemoteDesktopProxy)
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_TYPE_REMOTE_DESKTOP, grd_dbus_remote_desktop_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GrdDBusRemoteDesktopProxy, grd_dbus_remote_desktop_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_TYPE_REMOTE_DESKTOP, grd_dbus_remote_desktop_proxy_iface_init))

#endif
static void
grd_dbus_remote_desktop_proxy_finalize (GObject *object)
{
  GrdDBusRemoteDesktopProxy *proxy = GRD_DBUS_REMOTE_DESKTOP_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (grd_dbus_remote_desktop_proxy_parent_class)->finalize (object);
}

static void
grd_dbus_remote_desktop_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _grd_dbus_remote_desktop_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
grd_dbus_remote_desktop_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Mutter.RemoteDesktop: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
grd_dbus_remote_desktop_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _grd_dbus_remote_desktop_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Mutter.RemoteDesktop", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) grd_dbus_remote_desktop_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
grd_dbus_remote_desktop_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_grd_dbus_remote_desktop_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GRD_DBUS_TYPE_REMOTE_DESKTOP);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GRD_DBUS_TYPE_REMOTE_DESKTOP);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
grd_dbus_remote_desktop_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GrdDBusRemoteDesktopProxy *proxy = GRD_DBUS_REMOTE_DESKTOP_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_remote_desktop_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_remote_desktop_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
grd_dbus_remote_desktop_proxy_get_supported_device_types (GrdDBusRemoteDesktop *object)
{
  GrdDBusRemoteDesktopProxy *proxy = GRD_DBUS_REMOTE_DESKTOP_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedDeviceTypes");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
grd_dbus_remote_desktop_proxy_get_version (GrdDBusRemoteDesktop *object)
{
  GrdDBusRemoteDesktopProxy *proxy = GRD_DBUS_REMOTE_DESKTOP_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Version");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
grd_dbus_remote_desktop_proxy_init (GrdDBusRemoteDesktopProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = grd_dbus_remote_desktop_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GRD_DBUS_TYPE_REMOTE_DESKTOP_PROXY, GrdDBusRemoteDesktopProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), grd_dbus_remote_desktop_interface_info ());
}

static void
grd_dbus_remote_desktop_proxy_class_init (GrdDBusRemoteDesktopProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = grd_dbus_remote_desktop_proxy_finalize;
  gobject_class->get_property = grd_dbus_remote_desktop_proxy_get_property;
  gobject_class->set_property = grd_dbus_remote_desktop_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = grd_dbus_remote_desktop_proxy_g_signal;
  proxy_class->g_properties_changed = grd_dbus_remote_desktop_proxy_g_properties_changed;

  grd_dbus_remote_desktop_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GrdDBusRemoteDesktopProxyPrivate));
#endif
}

static void
grd_dbus_remote_desktop_proxy_iface_init (GrdDBusRemoteDesktopIface *iface)
{
  iface->get_supported_device_types = grd_dbus_remote_desktop_proxy_get_supported_device_types;
  iface->get_version = grd_dbus_remote_desktop_proxy_get_version;
}

/**
 * grd_dbus_remote_desktop_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_proxy_new_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
grd_dbus_remote_desktop_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GRD_DBUS_TYPE_REMOTE_DESKTOP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop", NULL);
}

/**
 * grd_dbus_remote_desktop_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with grd_dbus_remote_desktop_proxy_new().
 *
 * Returns: (transfer full) (type GrdDBusRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusRemoteDesktop *
grd_dbus_remote_desktop_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GRD_DBUS_REMOTE_DESKTOP (ret);
  else
    return NULL;
}

/**
 * grd_dbus_remote_desktop_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GrdDBusRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusRemoteDesktop *
grd_dbus_remote_desktop_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GRD_DBUS_TYPE_REMOTE_DESKTOP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop", NULL);
  if (ret != NULL)
    return GRD_DBUS_REMOTE_DESKTOP (ret);
  else
    return NULL;
}


/**
 * grd_dbus_remote_desktop_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like grd_dbus_remote_desktop_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
grd_dbus_remote_desktop_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GRD_DBUS_TYPE_REMOTE_DESKTOP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop", NULL);
}

/**
 * grd_dbus_remote_desktop_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with grd_dbus_remote_desktop_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GrdDBusRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusRemoteDesktop *
grd_dbus_remote_desktop_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GRD_DBUS_REMOTE_DESKTOP (ret);
  else
    return NULL;
}

/**
 * grd_dbus_remote_desktop_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like grd_dbus_remote_desktop_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GrdDBusRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusRemoteDesktop *
grd_dbus_remote_desktop_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GRD_DBUS_TYPE_REMOTE_DESKTOP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop", NULL);
  if (ret != NULL)
    return GRD_DBUS_REMOTE_DESKTOP (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GrdDBusRemoteDesktopSkeleton:
 *
 * The #GrdDBusRemoteDesktopSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GrdDBusRemoteDesktopSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GrdDBusRemoteDesktopSkeleton.
 */

struct _GrdDBusRemoteDesktopSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_grd_dbus_remote_desktop_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GrdDBusRemoteDesktopSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GRD_DBUS_TYPE_REMOTE_DESKTOP);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GRD_DBUS_TYPE_REMOTE_DESKTOP);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_grd_dbus_remote_desktop_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GrdDBusRemoteDesktopSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_remote_desktop_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_grd_dbus_remote_desktop_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GrdDBusRemoteDesktopSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_remote_desktop_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _grd_dbus_remote_desktop_skeleton_vtable =
{
  _grd_dbus_remote_desktop_skeleton_handle_method_call,
  _grd_dbus_remote_desktop_skeleton_handle_get_property,
  _grd_dbus_remote_desktop_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
grd_dbus_remote_desktop_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return grd_dbus_remote_desktop_interface_info ();
}

static GDBusInterfaceVTable *
grd_dbus_remote_desktop_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_grd_dbus_remote_desktop_skeleton_vtable;
}

static GVariant *
grd_dbus_remote_desktop_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GrdDBusRemoteDesktopSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_grd_dbus_remote_desktop_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _grd_dbus_remote_desktop_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _grd_dbus_remote_desktop_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _grd_dbus_remote_desktop_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.RemoteDesktop", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _grd_dbus_remote_desktop_emit_changed (gpointer user_data);

static void
grd_dbus_remote_desktop_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GrdDBusRemoteDesktopSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _grd_dbus_remote_desktop_emit_changed (skeleton);
}

static void grd_dbus_remote_desktop_skeleton_iface_init (GrdDBusRemoteDesktopIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GrdDBusRemoteDesktopSkeleton, grd_dbus_remote_desktop_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GrdDBusRemoteDesktopSkeleton)
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_TYPE_REMOTE_DESKTOP, grd_dbus_remote_desktop_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GrdDBusRemoteDesktopSkeleton, grd_dbus_remote_desktop_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_TYPE_REMOTE_DESKTOP, grd_dbus_remote_desktop_skeleton_iface_init))

#endif
static void
grd_dbus_remote_desktop_skeleton_finalize (GObject *object)
{
  GrdDBusRemoteDesktopSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (grd_dbus_remote_desktop_skeleton_parent_class)->finalize (object);
}

static void
grd_dbus_remote_desktop_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GrdDBusRemoteDesktopSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_grd_dbus_remote_desktop_emit_changed (gpointer user_data)
{
  GrdDBusRemoteDesktopSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Mutter.RemoteDesktop",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_grd_dbus_remote_desktop_schedule_emit_changed (GrdDBusRemoteDesktopSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
grd_dbus_remote_desktop_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GrdDBusRemoteDesktopSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _grd_dbus_remote_desktop_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _grd_dbus_remote_desktop_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
grd_dbus_remote_desktop_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GrdDBusRemoteDesktopSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _grd_dbus_remote_desktop_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _grd_dbus_remote_desktop_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
grd_dbus_remote_desktop_skeleton_init (GrdDBusRemoteDesktopSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = grd_dbus_remote_desktop_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GRD_DBUS_TYPE_REMOTE_DESKTOP_SKELETON, GrdDBusRemoteDesktopSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_INT);
}

static guint 
grd_dbus_remote_desktop_skeleton_get_supported_device_types (GrdDBusRemoteDesktop *object)
{
  GrdDBusRemoteDesktopSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
grd_dbus_remote_desktop_skeleton_get_version (GrdDBusRemoteDesktop *object)
{
  GrdDBusRemoteDesktopSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
grd_dbus_remote_desktop_skeleton_class_init (GrdDBusRemoteDesktopSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = grd_dbus_remote_desktop_skeleton_finalize;
  gobject_class->get_property = grd_dbus_remote_desktop_skeleton_get_property;
  gobject_class->set_property = grd_dbus_remote_desktop_skeleton_set_property;
  gobject_class->notify       = grd_dbus_remote_desktop_skeleton_notify;


  grd_dbus_remote_desktop_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = grd_dbus_remote_desktop_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = grd_dbus_remote_desktop_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = grd_dbus_remote_desktop_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = grd_dbus_remote_desktop_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GrdDBusRemoteDesktopSkeletonPrivate));
#endif
}

static void
grd_dbus_remote_desktop_skeleton_iface_init (GrdDBusRemoteDesktopIface *iface)
{
  iface->get_supported_device_types = grd_dbus_remote_desktop_skeleton_get_supported_device_types;
  iface->get_version = grd_dbus_remote_desktop_skeleton_get_version;
}

/**
 * grd_dbus_remote_desktop_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link>.
 *
 * Returns: (transfer full) (type GrdDBusRemoteDesktopSkeleton): The skeleton object.
 */
GrdDBusRemoteDesktop *
grd_dbus_remote_desktop_skeleton_new (void)
{
  return GRD_DBUS_REMOTE_DESKTOP (g_object_new (GRD_DBUS_TYPE_REMOTE_DESKTOP_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.RemoteDesktop.Session
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GrdDBusRemoteDesktopSession
 * @title: GrdDBusRemoteDesktopSession
 * @short_description: Generated C code for the org.gnome.Mutter.RemoteDesktop.Session D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Mutter.RemoteDesktop.Session ---- */

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    NULL,
    NULL,
    NULL
  },
  "handle-start",
  FALSE
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_keycode =
{
  {
    -1,
    (gchar *) "keycode",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_keycode.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_notify_keyboard_keycode =
{
  {
    -1,
    (gchar *) "NotifyKeyboardKeycode",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-keyboard-keycode",
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_keysym =
{
  {
    -1,
    (gchar *) "keysym",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_keysym.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_notify_keyboard_keysym =
{
  {
    -1,
    (gchar *) "NotifyKeyboardKeysym",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-keyboard-keysym",
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_button =
{
  {
    -1,
    (gchar *) "button",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_button.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_button =
{
  {
    -1,
    (gchar *) "NotifyPointerButton",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-button",
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_dx =
{
  {
    -1,
    (gchar *) "dx",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_dy =
{
  {
    -1,
    (gchar *) "dy",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_dx.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_dy.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_axis =
{
  {
    -1,
    (gchar *) "NotifyPointerAxis",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-axis",
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_axis =
{
  {
    -1,
    (gchar *) "axis",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_steps =
{
  {
    -1,
    (gchar *) "steps",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_axis.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_steps.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete =
{
  {
    -1,
    (gchar *) "NotifyPointerAxisDiscrete",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-axis-discrete",
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_dx =
{
  {
    -1,
    (gchar *) "dx",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_dy =
{
  {
    -1,
    (gchar *) "dy",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_dx.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_dy.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative =
{
  {
    -1,
    (gchar *) "NotifyPointerMotionRelative",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-motion-relative",
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_stream.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_x.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute =
{
  {
    -1,
    (gchar *) "NotifyPointerMotionAbsolute",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-motion-absolute",
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_slot =
{
  {
    -1,
    (gchar *) "slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_stream.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_slot.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_x.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_notify_touch_down =
{
  {
    -1,
    (gchar *) "NotifyTouchDown",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-touch-down",
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_slot =
{
  {
    -1,
    (gchar *) "slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_stream.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_slot.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_x.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_notify_touch_motion =
{
  {
    -1,
    (gchar *) "NotifyTouchMotion",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-touch-motion",
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_notify_touch_up_IN_ARG_slot =
{
  {
    -1,
    (gchar *) "slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_notify_touch_up_IN_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_notify_touch_up_IN_ARG_slot.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_notify_touch_up =
{
  {
    -1,
    (gchar *) "NotifyTouchUp",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_notify_touch_up_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-touch-up",
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_enable_clipboard_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_enable_clipboard_IN_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_enable_clipboard_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_enable_clipboard =
{
  {
    -1,
    (gchar *) "EnableClipboard",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_enable_clipboard_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-enable-clipboard",
  FALSE
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_disable_clipboard =
{
  {
    -1,
    (gchar *) "DisableClipboard",
    NULL,
    NULL,
    NULL
  },
  "handle-disable-clipboard",
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_set_selection_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_set_selection_IN_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_set_selection_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_set_selection =
{
  {
    -1,
    (gchar *) "SetSelection",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_set_selection_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-selection",
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_selection_write_IN_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_selection_write_IN_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_selection_write_IN_ARG_serial.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_selection_write_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_selection_write_OUT_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_selection_write_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_selection_write =
{
  {
    -1,
    (gchar *) "SelectionWrite",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_selection_write_IN_ARG_pointers,
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_selection_write_OUT_ARG_pointers,
    NULL
  },
  "handle-selection-write",
  TRUE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_selection_write_done_IN_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_selection_write_done_IN_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_selection_write_done_IN_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_selection_write_done_IN_ARG_serial.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_selection_write_done_IN_ARG_success.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_selection_write_done =
{
  {
    -1,
    (gchar *) "SelectionWriteDone",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_selection_write_done_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-selection-write-done",
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_selection_read_IN_ARG_mime_type =
{
  {
    -1,
    (gchar *) "mime_type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_selection_read_IN_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_selection_read_IN_ARG_mime_type.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_method_info_selection_read_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_method_info_selection_read_OUT_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_selection_read_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_remote_desktop_session_method_info_selection_read =
{
  {
    -1,
    (gchar *) "SelectionRead",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_selection_read_IN_ARG_pointers,
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_method_info_selection_read_OUT_ARG_pointers,
    NULL
  },
  "handle-selection-read",
  TRUE
};

static const GDBusMethodInfo * const _grd_dbus_remote_desktop_session_method_info_pointers[] =
{
  &_grd_dbus_remote_desktop_session_method_info_start.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_stop.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_keyboard_keycode.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_keyboard_keysym.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_button.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_axis.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_touch_down.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_touch_motion.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_notify_touch_up.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_enable_clipboard.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_disable_clipboard.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_set_selection.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_selection_write.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_selection_write_done.parent_struct,
  &_grd_dbus_remote_desktop_session_method_info_selection_read.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _grd_dbus_remote_desktop_session_signal_info_closed =
{
  {
    -1,
    (gchar *) "Closed",
    NULL,
    NULL
  },
  "closed"
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_signal_info_selection_owner_changed_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_signal_info_selection_owner_changed_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_signal_info_selection_owner_changed_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _grd_dbus_remote_desktop_session_signal_info_selection_owner_changed =
{
  {
    -1,
    (gchar *) "SelectionOwnerChanged",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_signal_info_selection_owner_changed_ARG_pointers,
    NULL
  },
  "selection-owner-changed"
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_signal_info_selection_transfer_ARG_mime_type =
{
  {
    -1,
    (gchar *) "mime_type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grd_dbus_remote_desktop_session_signal_info_selection_transfer_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_remote_desktop_session_signal_info_selection_transfer_ARG_pointers[] =
{
  &_grd_dbus_remote_desktop_session_signal_info_selection_transfer_ARG_mime_type.parent_struct,
  &_grd_dbus_remote_desktop_session_signal_info_selection_transfer_ARG_serial.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _grd_dbus_remote_desktop_session_signal_info_selection_transfer =
{
  {
    -1,
    (gchar *) "SelectionTransfer",
    (GDBusArgInfo **) &_grd_dbus_remote_desktop_session_signal_info_selection_transfer_ARG_pointers,
    NULL
  },
  "selection-transfer"
};

static const GDBusSignalInfo * const _grd_dbus_remote_desktop_session_signal_info_pointers[] =
{
  &_grd_dbus_remote_desktop_session_signal_info_closed.parent_struct,
  &_grd_dbus_remote_desktop_session_signal_info_selection_owner_changed.parent_struct,
  &_grd_dbus_remote_desktop_session_signal_info_selection_transfer.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _grd_dbus_remote_desktop_session_property_info_session_id =
{
  {
    -1,
    (gchar *) "SessionId",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "session-id",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grd_dbus_remote_desktop_session_property_info_caps_lock_state =
{
  {
    -1,
    (gchar *) "CapsLockState",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "caps-lock-state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grd_dbus_remote_desktop_session_property_info_num_lock_state =
{
  {
    -1,
    (gchar *) "NumLockState",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "num-lock-state",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _grd_dbus_remote_desktop_session_property_info_pointers[] =
{
  &_grd_dbus_remote_desktop_session_property_info_session_id.parent_struct,
  &_grd_dbus_remote_desktop_session_property_info_caps_lock_state.parent_struct,
  &_grd_dbus_remote_desktop_session_property_info_num_lock_state.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _grd_dbus_remote_desktop_session_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.RemoteDesktop.Session",
    (GDBusMethodInfo **) &_grd_dbus_remote_desktop_session_method_info_pointers,
    (GDBusSignalInfo **) &_grd_dbus_remote_desktop_session_signal_info_pointers,
    (GDBusPropertyInfo **) &_grd_dbus_remote_desktop_session_property_info_pointers,
    NULL
  },
  "remote-desktop-session",
};


/**
 * grd_dbus_remote_desktop_session_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
grd_dbus_remote_desktop_session_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_grd_dbus_remote_desktop_session_interface_info.parent_struct;
}

/**
 * grd_dbus_remote_desktop_session_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GrdDBusRemoteDesktopSession interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
grd_dbus_remote_desktop_session_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "session-id");
  g_object_class_override_property (klass, property_id_begin++, "caps-lock-state");
  g_object_class_override_property (klass, property_id_begin++, "num-lock-state");
  return property_id_begin - 1;
}



/**
 * GrdDBusRemoteDesktopSession:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link>.
 */

/**
 * GrdDBusRemoteDesktopSessionIface:
 * @parent_iface: The parent interface.
 * @handle_disable_clipboard: Handler for the #GrdDBusRemoteDesktopSession::handle-disable-clipboard signal.
 * @handle_enable_clipboard: Handler for the #GrdDBusRemoteDesktopSession::handle-enable-clipboard signal.
 * @handle_notify_keyboard_keycode: Handler for the #GrdDBusRemoteDesktopSession::handle-notify-keyboard-keycode signal.
 * @handle_notify_keyboard_keysym: Handler for the #GrdDBusRemoteDesktopSession::handle-notify-keyboard-keysym signal.
 * @handle_notify_pointer_axis: Handler for the #GrdDBusRemoteDesktopSession::handle-notify-pointer-axis signal.
 * @handle_notify_pointer_axis_discrete: Handler for the #GrdDBusRemoteDesktopSession::handle-notify-pointer-axis-discrete signal.
 * @handle_notify_pointer_button: Handler for the #GrdDBusRemoteDesktopSession::handle-notify-pointer-button signal.
 * @handle_notify_pointer_motion_absolute: Handler for the #GrdDBusRemoteDesktopSession::handle-notify-pointer-motion-absolute signal.
 * @handle_notify_pointer_motion_relative: Handler for the #GrdDBusRemoteDesktopSession::handle-notify-pointer-motion-relative signal.
 * @handle_notify_touch_down: Handler for the #GrdDBusRemoteDesktopSession::handle-notify-touch-down signal.
 * @handle_notify_touch_motion: Handler for the #GrdDBusRemoteDesktopSession::handle-notify-touch-motion signal.
 * @handle_notify_touch_up: Handler for the #GrdDBusRemoteDesktopSession::handle-notify-touch-up signal.
 * @handle_selection_read: Handler for the #GrdDBusRemoteDesktopSession::handle-selection-read signal.
 * @handle_selection_write: Handler for the #GrdDBusRemoteDesktopSession::handle-selection-write signal.
 * @handle_selection_write_done: Handler for the #GrdDBusRemoteDesktopSession::handle-selection-write-done signal.
 * @handle_set_selection: Handler for the #GrdDBusRemoteDesktopSession::handle-set-selection signal.
 * @handle_start: Handler for the #GrdDBusRemoteDesktopSession::handle-start signal.
 * @handle_stop: Handler for the #GrdDBusRemoteDesktopSession::handle-stop signal.
 * @get_caps_lock_state: Getter for the #GrdDBusRemoteDesktopSession:caps-lock-state property.
 * @get_num_lock_state: Getter for the #GrdDBusRemoteDesktopSession:num-lock-state property.
 * @get_session_id: Getter for the #GrdDBusRemoteDesktopSession:session-id property.
 * @closed: Handler for the #GrdDBusRemoteDesktopSession::closed signal.
 * @selection_owner_changed: Handler for the #GrdDBusRemoteDesktopSession::selection-owner-changed signal.
 * @selection_transfer: Handler for the #GrdDBusRemoteDesktopSession::selection-transfer signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link>.
 */

typedef GrdDBusRemoteDesktopSessionIface GrdDBusRemoteDesktopSessionInterface;
G_DEFINE_INTERFACE (GrdDBusRemoteDesktopSession, grd_dbus_remote_desktop_session, G_TYPE_OBJECT)

static void
grd_dbus_remote_desktop_session_default_init (GrdDBusRemoteDesktopSessionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GrdDBusRemoteDesktopSession::handle-start:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GrdDBusRemoteDesktopSession::handle-stop:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GrdDBusRemoteDesktopSession::handle-notify-keyboard-keycode:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_keycode: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_notify_keyboard_keycode() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-keyboard-keycode",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_notify_keyboard_keycode),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /**
   * GrdDBusRemoteDesktopSession::handle-notify-keyboard-keysym:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_keysym: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_notify_keyboard_keysym() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-keyboard-keysym",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_notify_keyboard_keysym),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /**
   * GrdDBusRemoteDesktopSession::handle-notify-pointer-button:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_button: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_notify_pointer_button() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-button",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_notify_pointer_button),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_BOOLEAN);

  /**
   * GrdDBusRemoteDesktopSession::handle-notify-pointer-axis:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_dx: Argument passed by remote caller.
   * @arg_dy: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_notify_pointer_axis() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-axis",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_notify_pointer_axis),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_DOUBLE, G_TYPE_DOUBLE, G_TYPE_UINT);

  /**
   * GrdDBusRemoteDesktopSession::handle-notify-pointer-axis-discrete:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_axis: Argument passed by remote caller.
   * @arg_steps: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_notify_pointer_axis_discrete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-axis-discrete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_notify_pointer_axis_discrete),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_INT);

  /**
   * GrdDBusRemoteDesktopSession::handle-notify-pointer-motion-relative:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_dx: Argument passed by remote caller.
   * @arg_dy: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionRelative">NotifyPointerMotionRelative()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_notify_pointer_motion_relative() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-motion-relative",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_notify_pointer_motion_relative),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * GrdDBusRemoteDesktopSession::handle-notify-pointer-motion-absolute:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_stream: Argument passed by remote caller.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_notify_pointer_motion_absolute() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-motion-absolute",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_notify_pointer_motion_absolute),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * GrdDBusRemoteDesktopSession::handle-notify-touch-down:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_stream: Argument passed by remote caller.
   * @arg_slot: Argument passed by remote caller.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_notify_touch_down() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-touch-down",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_notify_touch_down),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * GrdDBusRemoteDesktopSession::handle-notify-touch-motion:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_stream: Argument passed by remote caller.
   * @arg_slot: Argument passed by remote caller.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_notify_touch_motion() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-touch-motion",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_notify_touch_motion),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * GrdDBusRemoteDesktopSession::handle-notify-touch-up:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_slot: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_notify_touch_up() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-touch-up",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_notify_touch_up),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * GrdDBusRemoteDesktopSession::handle-enable-clipboard:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.EnableClipboard">EnableClipboard()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_enable_clipboard() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable-clipboard",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_enable_clipboard),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * GrdDBusRemoteDesktopSession::handle-disable-clipboard:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.DisableClipboard">DisableClipboard()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_disable_clipboard() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disable-clipboard",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_disable_clipboard),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GrdDBusRemoteDesktopSession::handle-set-selection:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SetSelection">SetSelection()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_set_selection() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-selection",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_set_selection),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * GrdDBusRemoteDesktopSession::handle-selection-write:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_serial: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWrite">SelectionWrite()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_selection_write() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-selection-write",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_selection_write),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_UINT);

  /**
   * GrdDBusRemoteDesktopSession::handle-selection-write-done:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_serial: Argument passed by remote caller.
   * @arg_success: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWriteDone">SelectionWriteDone()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_selection_write_done() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-selection-write-done",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_selection_write_done),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /**
   * GrdDBusRemoteDesktopSession::handle-selection-read:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_mime_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionRead">SelectionRead()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_remote_desktop_session_complete_selection_read() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-selection-read",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, handle_selection_read),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * GrdDBusRemoteDesktopSession::closed:
   * @object: A #GrdDBusRemoteDesktopSession.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-RemoteDesktop-Session.Closed">"Closed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("closed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, closed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * GrdDBusRemoteDesktopSession::selection-owner-changed:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @arg_options: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-RemoteDesktop-Session.SelectionOwnerChanged">"SelectionOwnerChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("selection-owner-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, selection_owner_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_VARIANT);

  /**
   * GrdDBusRemoteDesktopSession::selection-transfer:
   * @object: A #GrdDBusRemoteDesktopSession.
   * @arg_mime_type: Argument.
   * @arg_serial: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-RemoteDesktop-Session.SelectionTransfer">"SelectionTransfer"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("selection-transfer",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusRemoteDesktopSessionIface, selection_transfer),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * GrdDBusRemoteDesktopSession:session-id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.SessionId">"SessionId"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("session-id", "SessionId", "SessionId", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrdDBusRemoteDesktopSession:caps-lock-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.CapsLockState">"CapsLockState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("caps-lock-state", "CapsLockState", "CapsLockState", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrdDBusRemoteDesktopSession:num-lock-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.NumLockState">"NumLockState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("num-lock-state", "NumLockState", "NumLockState", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * grd_dbus_remote_desktop_session_get_session_id: (skip)
 * @object: A #GrdDBusRemoteDesktopSession.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.SessionId">"SessionId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grd_dbus_remote_desktop_session_dup_session_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grd_dbus_remote_desktop_session_get_session_id (GrdDBusRemoteDesktopSession *object)
{
  return GRD_DBUS_REMOTE_DESKTOP_SESSION_GET_IFACE (object)->get_session_id (object);
}

/**
 * grd_dbus_remote_desktop_session_dup_session_id: (skip)
 * @object: A #GrdDBusRemoteDesktopSession.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.SessionId">"SessionId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grd_dbus_remote_desktop_session_dup_session_id (GrdDBusRemoteDesktopSession *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "session-id", &value, NULL);
  return value;
}

/**
 * grd_dbus_remote_desktop_session_set_session_id: (skip)
 * @object: A #GrdDBusRemoteDesktopSession.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.SessionId">"SessionId"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grd_dbus_remote_desktop_session_set_session_id (GrdDBusRemoteDesktopSession *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "session-id", value, NULL);
}

/**
 * grd_dbus_remote_desktop_session_get_caps_lock_state: (skip)
 * @object: A #GrdDBusRemoteDesktopSession.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.CapsLockState">"CapsLockState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
grd_dbus_remote_desktop_session_get_caps_lock_state (GrdDBusRemoteDesktopSession *object)
{
  return GRD_DBUS_REMOTE_DESKTOP_SESSION_GET_IFACE (object)->get_caps_lock_state (object);
}

/**
 * grd_dbus_remote_desktop_session_set_caps_lock_state: (skip)
 * @object: A #GrdDBusRemoteDesktopSession.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.CapsLockState">"CapsLockState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grd_dbus_remote_desktop_session_set_caps_lock_state (GrdDBusRemoteDesktopSession *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "caps-lock-state", value, NULL);
}

/**
 * grd_dbus_remote_desktop_session_get_num_lock_state: (skip)
 * @object: A #GrdDBusRemoteDesktopSession.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.NumLockState">"NumLockState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
grd_dbus_remote_desktop_session_get_num_lock_state (GrdDBusRemoteDesktopSession *object)
{
  return GRD_DBUS_REMOTE_DESKTOP_SESSION_GET_IFACE (object)->get_num_lock_state (object);
}

/**
 * grd_dbus_remote_desktop_session_set_num_lock_state: (skip)
 * @object: A #GrdDBusRemoteDesktopSession.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.NumLockState">"NumLockState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grd_dbus_remote_desktop_session_set_num_lock_state (GrdDBusRemoteDesktopSession *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "num-lock-state", value, NULL);
}

/**
 * grd_dbus_remote_desktop_session_emit_closed:
 * @object: A #GrdDBusRemoteDesktopSession.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-RemoteDesktop-Session.Closed">"Closed"</link> D-Bus signal.
 */
void
grd_dbus_remote_desktop_session_emit_closed (
    GrdDBusRemoteDesktopSession *object)
{
  g_signal_emit_by_name (object, "closed");
}

/**
 * grd_dbus_remote_desktop_session_emit_selection_owner_changed:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @arg_options: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-RemoteDesktop-Session.SelectionOwnerChanged">"SelectionOwnerChanged"</link> D-Bus signal.
 */
void
grd_dbus_remote_desktop_session_emit_selection_owner_changed (
    GrdDBusRemoteDesktopSession *object,
    GVariant *arg_options)
{
  g_signal_emit_by_name (object, "selection-owner-changed", arg_options);
}

/**
 * grd_dbus_remote_desktop_session_emit_selection_transfer:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @arg_mime_type: Argument to pass with the signal.
 * @arg_serial: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-RemoteDesktop-Session.SelectionTransfer">"SelectionTransfer"</link> D-Bus signal.
 */
void
grd_dbus_remote_desktop_session_emit_selection_transfer (
    GrdDBusRemoteDesktopSession *object,
    const gchar *arg_mime_type,
    guint arg_serial)
{
  g_signal_emit_by_name (object, "selection-transfer", arg_mime_type, arg_serial);
}

/**
 * grd_dbus_remote_desktop_session_call_start:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_start_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_start_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_start (
    GrdDBusRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_start_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_start_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_start_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_start_sync (
    GrdDBusRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_stop:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_stop_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_stop (
    GrdDBusRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_stop_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_stop_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_stop_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_stop_sync (
    GrdDBusRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_keyboard_keycode:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_keycode: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_notify_keyboard_keycode_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_notify_keyboard_keycode_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_notify_keyboard_keycode (
    GrdDBusRemoteDesktopSession *proxy,
    guint arg_keycode,
    gboolean arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeycode",
    g_variant_new ("(ub)",
                   arg_keycode,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_notify_keyboard_keycode_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_notify_keyboard_keycode().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_notify_keyboard_keycode().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_keyboard_keycode_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_keyboard_keycode_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_keycode: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_notify_keyboard_keycode() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_keyboard_keycode_sync (
    GrdDBusRemoteDesktopSession *proxy,
    guint arg_keycode,
    gboolean arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeycode",
    g_variant_new ("(ub)",
                   arg_keycode,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_keyboard_keysym:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_keysym: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_notify_keyboard_keysym_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_notify_keyboard_keysym_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_notify_keyboard_keysym (
    GrdDBusRemoteDesktopSession *proxy,
    guint arg_keysym,
    gboolean arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeysym",
    g_variant_new ("(ub)",
                   arg_keysym,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_notify_keyboard_keysym_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_notify_keyboard_keysym().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_notify_keyboard_keysym().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_keyboard_keysym_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_keyboard_keysym_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_keysym: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_notify_keyboard_keysym() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_keyboard_keysym_sync (
    GrdDBusRemoteDesktopSession *proxy,
    guint arg_keysym,
    gboolean arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeysym",
    g_variant_new ("(ub)",
                   arg_keysym,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_pointer_button:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_button: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_notify_pointer_button_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_notify_pointer_button_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_notify_pointer_button (
    GrdDBusRemoteDesktopSession *proxy,
    gint arg_button,
    gboolean arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerButton",
    g_variant_new ("(ib)",
                   arg_button,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_notify_pointer_button_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_notify_pointer_button().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_notify_pointer_button().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_pointer_button_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_pointer_button_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_button: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_notify_pointer_button() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_pointer_button_sync (
    GrdDBusRemoteDesktopSession *proxy,
    gint arg_button,
    gboolean arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerButton",
    g_variant_new ("(ib)",
                   arg_button,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_pointer_axis:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_notify_pointer_axis_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_notify_pointer_axis_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_notify_pointer_axis (
    GrdDBusRemoteDesktopSession *proxy,
    gdouble arg_dx,
    gdouble arg_dy,
    guint arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerAxis",
    g_variant_new ("(ddu)",
                   arg_dx,
                   arg_dy,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_notify_pointer_axis_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_notify_pointer_axis().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_notify_pointer_axis().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_pointer_axis_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_pointer_axis_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_notify_pointer_axis() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_pointer_axis_sync (
    GrdDBusRemoteDesktopSession *proxy,
    gdouble arg_dx,
    gdouble arg_dy,
    guint arg_flags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerAxis",
    g_variant_new ("(ddu)",
                   arg_dx,
                   arg_dy,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_pointer_axis_discrete:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_axis: Argument to pass with the method invocation.
 * @arg_steps: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_notify_pointer_axis_discrete_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_notify_pointer_axis_discrete_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_notify_pointer_axis_discrete (
    GrdDBusRemoteDesktopSession *proxy,
    guint arg_axis,
    gint arg_steps,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerAxisDiscrete",
    g_variant_new ("(ui)",
                   arg_axis,
                   arg_steps),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_notify_pointer_axis_discrete_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_notify_pointer_axis_discrete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_notify_pointer_axis_discrete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_pointer_axis_discrete_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_pointer_axis_discrete_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_axis: Argument to pass with the method invocation.
 * @arg_steps: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_notify_pointer_axis_discrete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_pointer_axis_discrete_sync (
    GrdDBusRemoteDesktopSession *proxy,
    guint arg_axis,
    gint arg_steps,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerAxisDiscrete",
    g_variant_new ("(ui)",
                   arg_axis,
                   arg_steps),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_pointer_motion_relative:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionRelative">NotifyPointerMotionRelative()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_notify_pointer_motion_relative_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_notify_pointer_motion_relative_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_notify_pointer_motion_relative (
    GrdDBusRemoteDesktopSession *proxy,
    gdouble arg_dx,
    gdouble arg_dy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionRelative",
    g_variant_new ("(dd)",
                   arg_dx,
                   arg_dy),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_notify_pointer_motion_relative_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_notify_pointer_motion_relative().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_notify_pointer_motion_relative().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_pointer_motion_relative_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_pointer_motion_relative_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionRelative">NotifyPointerMotionRelative()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_notify_pointer_motion_relative() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_pointer_motion_relative_sync (
    GrdDBusRemoteDesktopSession *proxy,
    gdouble arg_dx,
    gdouble arg_dy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionRelative",
    g_variant_new ("(dd)",
                   arg_dx,
                   arg_dy),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_pointer_motion_absolute:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_notify_pointer_motion_absolute_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_notify_pointer_motion_absolute_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_notify_pointer_motion_absolute (
    GrdDBusRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionAbsolute",
    g_variant_new ("(sdd)",
                   arg_stream,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_notify_pointer_motion_absolute_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_notify_pointer_motion_absolute().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_notify_pointer_motion_absolute().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_pointer_motion_absolute_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_pointer_motion_absolute_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_notify_pointer_motion_absolute() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_pointer_motion_absolute_sync (
    GrdDBusRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionAbsolute",
    g_variant_new ("(sdd)",
                   arg_stream,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_touch_down:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_notify_touch_down_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_notify_touch_down_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_notify_touch_down (
    GrdDBusRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyTouchDown",
    g_variant_new ("(sudd)",
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_notify_touch_down_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_notify_touch_down().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_notify_touch_down().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_touch_down_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_touch_down_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_notify_touch_down() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_touch_down_sync (
    GrdDBusRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyTouchDown",
    g_variant_new ("(sudd)",
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_touch_motion:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_notify_touch_motion_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_notify_touch_motion_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_notify_touch_motion (
    GrdDBusRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyTouchMotion",
    g_variant_new ("(sudd)",
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_notify_touch_motion_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_notify_touch_motion().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_notify_touch_motion().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_touch_motion_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_touch_motion_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_notify_touch_motion() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_touch_motion_sync (
    GrdDBusRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyTouchMotion",
    g_variant_new ("(sudd)",
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_touch_up:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_slot: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_notify_touch_up_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_notify_touch_up_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_notify_touch_up (
    GrdDBusRemoteDesktopSession *proxy,
    guint arg_slot,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyTouchUp",
    g_variant_new ("(u)",
                   arg_slot),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_notify_touch_up_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_notify_touch_up().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_notify_touch_up().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_touch_up_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_notify_touch_up_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_slot: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_notify_touch_up() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_notify_touch_up_sync (
    GrdDBusRemoteDesktopSession *proxy,
    guint arg_slot,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyTouchUp",
    g_variant_new ("(u)",
                   arg_slot),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_enable_clipboard:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.EnableClipboard">EnableClipboard()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_enable_clipboard_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_enable_clipboard_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_enable_clipboard (
    GrdDBusRemoteDesktopSession *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnableClipboard",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_enable_clipboard_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_enable_clipboard().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_enable_clipboard().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_enable_clipboard_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_enable_clipboard_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.EnableClipboard">EnableClipboard()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_enable_clipboard() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_enable_clipboard_sync (
    GrdDBusRemoteDesktopSession *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnableClipboard",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_disable_clipboard:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.DisableClipboard">DisableClipboard()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_disable_clipboard_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_disable_clipboard_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_disable_clipboard (
    GrdDBusRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DisableClipboard",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_disable_clipboard_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_disable_clipboard().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_disable_clipboard().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_disable_clipboard_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_disable_clipboard_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.DisableClipboard">DisableClipboard()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_disable_clipboard() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_disable_clipboard_sync (
    GrdDBusRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DisableClipboard",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_set_selection:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SetSelection">SetSelection()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_set_selection_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_set_selection_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_set_selection (
    GrdDBusRemoteDesktopSession *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetSelection",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_set_selection_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_set_selection().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_set_selection().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_set_selection_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_set_selection_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SetSelection">SetSelection()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_set_selection() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_set_selection_sync (
    GrdDBusRemoteDesktopSession *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetSelection",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_selection_write:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWrite">SelectionWrite()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_selection_write_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_selection_write_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_selection_write (
    GrdDBusRemoteDesktopSession *proxy,
    guint arg_serial,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "SelectionWrite",
    g_variant_new ("(u)",
                   arg_serial),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_selection_write_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_selection_write().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_selection_write().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_selection_write_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_selection_write_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWrite">SelectionWrite()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_selection_write() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_selection_write_sync (
    GrdDBusRemoteDesktopSession *proxy,
    guint arg_serial,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "SelectionWrite",
    g_variant_new ("(u)",
                   arg_serial),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_selection_write_done:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_success: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWriteDone">SelectionWriteDone()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_selection_write_done_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_selection_write_done_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_selection_write_done (
    GrdDBusRemoteDesktopSession *proxy,
    guint arg_serial,
    gboolean arg_success,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectionWriteDone",
    g_variant_new ("(ub)",
                   arg_serial,
                   arg_success),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_selection_write_done_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_selection_write_done().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_selection_write_done().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_selection_write_done_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_selection_write_done_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_success: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWriteDone">SelectionWriteDone()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_selection_write_done() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_selection_write_done_sync (
    GrdDBusRemoteDesktopSession *proxy,
    guint arg_serial,
    gboolean arg_success,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectionWriteDone",
    g_variant_new ("(ub)",
                   arg_serial,
                   arg_success),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_selection_read:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_mime_type: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionRead">SelectionRead()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_call_selection_read_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_call_selection_read_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_remote_desktop_session_call_selection_read (
    GrdDBusRemoteDesktopSession *proxy,
    const gchar *arg_mime_type,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "SelectionRead",
    g_variant_new ("(s)",
                   arg_mime_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_remote_desktop_session_call_selection_read_finish:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_call_selection_read().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_call_selection_read().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_selection_read_finish (
    GrdDBusRemoteDesktopSession *proxy,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_call_selection_read_sync:
 * @proxy: A #GrdDBusRemoteDesktopSessionProxy.
 * @arg_mime_type: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionRead">SelectionRead()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_call_selection_read() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_remote_desktop_session_call_selection_read_sync (
    GrdDBusRemoteDesktopSession *proxy,
    const gchar *arg_mime_type,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "SelectionRead",
    g_variant_new ("(s)",
                   arg_mime_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_remote_desktop_session_complete_start:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_start (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_stop:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_stop (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_notify_keyboard_keycode:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_notify_keyboard_keycode (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_notify_keyboard_keysym:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_notify_keyboard_keysym (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_notify_pointer_button:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_notify_pointer_button (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_notify_pointer_axis:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_notify_pointer_axis (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_notify_pointer_axis_discrete:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_notify_pointer_axis_discrete (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_notify_pointer_motion_relative:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionRelative">NotifyPointerMotionRelative()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_notify_pointer_motion_relative (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_notify_pointer_motion_absolute:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_notify_pointer_motion_absolute (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_notify_touch_down:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_notify_touch_down (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_notify_touch_motion:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_notify_touch_motion (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_notify_touch_up:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_notify_touch_up (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_enable_clipboard:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.EnableClipboard">EnableClipboard()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_enable_clipboard (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_disable_clipboard:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.DisableClipboard">DisableClipboard()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_disable_clipboard (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_set_selection:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SetSelection">SetSelection()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_set_selection (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_selection_write:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWrite">SelectionWrite()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_selection_write (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   fd),
    fd_list);
}

/**
 * grd_dbus_remote_desktop_session_complete_selection_write_done:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWriteDone">SelectionWriteDone()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_selection_write_done (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grd_dbus_remote_desktop_session_complete_selection_read:
 * @object: A #GrdDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionRead">SelectionRead()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_remote_desktop_session_complete_selection_read (
    GrdDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   fd),
    fd_list);
}

/* ------------------------------------------------------------------------ */

/**
 * GrdDBusRemoteDesktopSessionProxy:
 *
 * The #GrdDBusRemoteDesktopSessionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GrdDBusRemoteDesktopSessionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GrdDBusRemoteDesktopSessionProxy.
 */

struct _GrdDBusRemoteDesktopSessionProxyPrivate
{
  GData *qdata;
};

static void grd_dbus_remote_desktop_session_proxy_iface_init (GrdDBusRemoteDesktopSessionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GrdDBusRemoteDesktopSessionProxy, grd_dbus_remote_desktop_session_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GrdDBusRemoteDesktopSessionProxy)
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_TYPE_REMOTE_DESKTOP_SESSION, grd_dbus_remote_desktop_session_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GrdDBusRemoteDesktopSessionProxy, grd_dbus_remote_desktop_session_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_TYPE_REMOTE_DESKTOP_SESSION, grd_dbus_remote_desktop_session_proxy_iface_init))

#endif
static void
grd_dbus_remote_desktop_session_proxy_finalize (GObject *object)
{
  GrdDBusRemoteDesktopSessionProxy *proxy = GRD_DBUS_REMOTE_DESKTOP_SESSION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (grd_dbus_remote_desktop_session_proxy_parent_class)->finalize (object);
}

static void
grd_dbus_remote_desktop_session_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _grd_dbus_remote_desktop_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
grd_dbus_remote_desktop_session_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Mutter.RemoteDesktop.Session: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
grd_dbus_remote_desktop_session_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _grd_dbus_remote_desktop_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Mutter.RemoteDesktop.Session", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) grd_dbus_remote_desktop_session_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
grd_dbus_remote_desktop_session_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_grd_dbus_remote_desktop_session_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GRD_DBUS_TYPE_REMOTE_DESKTOP_SESSION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GRD_DBUS_TYPE_REMOTE_DESKTOP_SESSION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
grd_dbus_remote_desktop_session_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GrdDBusRemoteDesktopSessionProxy *proxy = GRD_DBUS_REMOTE_DESKTOP_SESSION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_remote_desktop_session_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_remote_desktop_session_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
grd_dbus_remote_desktop_session_proxy_get_session_id (GrdDBusRemoteDesktopSession *object)
{
  GrdDBusRemoteDesktopSessionProxy *proxy = GRD_DBUS_REMOTE_DESKTOP_SESSION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SessionId");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
grd_dbus_remote_desktop_session_proxy_get_caps_lock_state (GrdDBusRemoteDesktopSession *object)
{
  GrdDBusRemoteDesktopSessionProxy *proxy = GRD_DBUS_REMOTE_DESKTOP_SESSION_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CapsLockState");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
grd_dbus_remote_desktop_session_proxy_get_num_lock_state (GrdDBusRemoteDesktopSession *object)
{
  GrdDBusRemoteDesktopSessionProxy *proxy = GRD_DBUS_REMOTE_DESKTOP_SESSION_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NumLockState");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
grd_dbus_remote_desktop_session_proxy_init (GrdDBusRemoteDesktopSessionProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = grd_dbus_remote_desktop_session_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GRD_DBUS_TYPE_REMOTE_DESKTOP_SESSION_PROXY, GrdDBusRemoteDesktopSessionProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), grd_dbus_remote_desktop_session_interface_info ());
}

static void
grd_dbus_remote_desktop_session_proxy_class_init (GrdDBusRemoteDesktopSessionProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = grd_dbus_remote_desktop_session_proxy_finalize;
  gobject_class->get_property = grd_dbus_remote_desktop_session_proxy_get_property;
  gobject_class->set_property = grd_dbus_remote_desktop_session_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = grd_dbus_remote_desktop_session_proxy_g_signal;
  proxy_class->g_properties_changed = grd_dbus_remote_desktop_session_proxy_g_properties_changed;

  grd_dbus_remote_desktop_session_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GrdDBusRemoteDesktopSessionProxyPrivate));
#endif
}

static void
grd_dbus_remote_desktop_session_proxy_iface_init (GrdDBusRemoteDesktopSessionIface *iface)
{
  iface->get_session_id = grd_dbus_remote_desktop_session_proxy_get_session_id;
  iface->get_caps_lock_state = grd_dbus_remote_desktop_session_proxy_get_caps_lock_state;
  iface->get_num_lock_state = grd_dbus_remote_desktop_session_proxy_get_num_lock_state;
}

/**
 * grd_dbus_remote_desktop_session_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_proxy_new_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
grd_dbus_remote_desktop_session_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GRD_DBUS_TYPE_REMOTE_DESKTOP_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop.Session", NULL);
}

/**
 * grd_dbus_remote_desktop_session_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_proxy_new().
 *
 * Returns: (transfer full) (type GrdDBusRemoteDesktopSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusRemoteDesktopSession *
grd_dbus_remote_desktop_session_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GRD_DBUS_REMOTE_DESKTOP_SESSION (ret);
  else
    return NULL;
}

/**
 * grd_dbus_remote_desktop_session_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GrdDBusRemoteDesktopSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusRemoteDesktopSession *
grd_dbus_remote_desktop_session_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GRD_DBUS_TYPE_REMOTE_DESKTOP_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop.Session", NULL);
  if (ret != NULL)
    return GRD_DBUS_REMOTE_DESKTOP_SESSION (ret);
  else
    return NULL;
}


/**
 * grd_dbus_remote_desktop_session_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like grd_dbus_remote_desktop_session_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_remote_desktop_session_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See grd_dbus_remote_desktop_session_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
grd_dbus_remote_desktop_session_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GRD_DBUS_TYPE_REMOTE_DESKTOP_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop.Session", NULL);
}

/**
 * grd_dbus_remote_desktop_session_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_remote_desktop_session_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with grd_dbus_remote_desktop_session_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GrdDBusRemoteDesktopSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusRemoteDesktopSession *
grd_dbus_remote_desktop_session_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GRD_DBUS_REMOTE_DESKTOP_SESSION (ret);
  else
    return NULL;
}

/**
 * grd_dbus_remote_desktop_session_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like grd_dbus_remote_desktop_session_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_remote_desktop_session_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GrdDBusRemoteDesktopSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusRemoteDesktopSession *
grd_dbus_remote_desktop_session_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GRD_DBUS_TYPE_REMOTE_DESKTOP_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop.Session", NULL);
  if (ret != NULL)
    return GRD_DBUS_REMOTE_DESKTOP_SESSION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GrdDBusRemoteDesktopSessionSkeleton:
 *
 * The #GrdDBusRemoteDesktopSessionSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GrdDBusRemoteDesktopSessionSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GrdDBusRemoteDesktopSessionSkeleton.
 */

struct _GrdDBusRemoteDesktopSessionSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_grd_dbus_remote_desktop_session_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GRD_DBUS_TYPE_REMOTE_DESKTOP_SESSION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GRD_DBUS_TYPE_REMOTE_DESKTOP_SESSION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_grd_dbus_remote_desktop_session_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_remote_desktop_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_grd_dbus_remote_desktop_session_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_remote_desktop_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _grd_dbus_remote_desktop_session_skeleton_vtable =
{
  _grd_dbus_remote_desktop_session_skeleton_handle_method_call,
  _grd_dbus_remote_desktop_session_skeleton_handle_get_property,
  _grd_dbus_remote_desktop_session_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
grd_dbus_remote_desktop_session_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return grd_dbus_remote_desktop_session_interface_info ();
}

static GDBusInterfaceVTable *
grd_dbus_remote_desktop_session_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_grd_dbus_remote_desktop_session_skeleton_vtable;
}

static GVariant *
grd_dbus_remote_desktop_session_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_grd_dbus_remote_desktop_session_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _grd_dbus_remote_desktop_session_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _grd_dbus_remote_desktop_session_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _grd_dbus_remote_desktop_session_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.RemoteDesktop.Session", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _grd_dbus_remote_desktop_session_emit_changed (gpointer user_data);

static void
grd_dbus_remote_desktop_session_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _grd_dbus_remote_desktop_session_emit_changed (skeleton);
}

static void
_grd_dbus_remote_desktop_session_on_signal_closed (
    GrdDBusRemoteDesktopSession *object)
{
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.RemoteDesktop.Session", "Closed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_grd_dbus_remote_desktop_session_on_signal_selection_owner_changed (
    GrdDBusRemoteDesktopSession *object,
    GVariant *arg_options)
{
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@a{sv})",
                   arg_options));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.RemoteDesktop.Session", "SelectionOwnerChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_grd_dbus_remote_desktop_session_on_signal_selection_transfer (
    GrdDBusRemoteDesktopSession *object,
    const gchar *arg_mime_type,
    guint arg_serial)
{
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(su)",
                   arg_mime_type,
                   arg_serial));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.RemoteDesktop.Session", "SelectionTransfer",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void grd_dbus_remote_desktop_session_skeleton_iface_init (GrdDBusRemoteDesktopSessionIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GrdDBusRemoteDesktopSessionSkeleton, grd_dbus_remote_desktop_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GrdDBusRemoteDesktopSessionSkeleton)
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_TYPE_REMOTE_DESKTOP_SESSION, grd_dbus_remote_desktop_session_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GrdDBusRemoteDesktopSessionSkeleton, grd_dbus_remote_desktop_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_TYPE_REMOTE_DESKTOP_SESSION, grd_dbus_remote_desktop_session_skeleton_iface_init))

#endif
static void
grd_dbus_remote_desktop_session_skeleton_finalize (GObject *object)
{
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (grd_dbus_remote_desktop_session_skeleton_parent_class)->finalize (object);
}

static void
grd_dbus_remote_desktop_session_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_grd_dbus_remote_desktop_session_emit_changed (gpointer user_data)
{
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Mutter.RemoteDesktop.Session",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_grd_dbus_remote_desktop_session_schedule_emit_changed (GrdDBusRemoteDesktopSessionSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
grd_dbus_remote_desktop_session_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _grd_dbus_remote_desktop_session_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _grd_dbus_remote_desktop_session_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
grd_dbus_remote_desktop_session_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _grd_dbus_remote_desktop_session_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _grd_dbus_remote_desktop_session_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
grd_dbus_remote_desktop_session_skeleton_init (GrdDBusRemoteDesktopSessionSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = grd_dbus_remote_desktop_session_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GRD_DBUS_TYPE_REMOTE_DESKTOP_SESSION_SKELETON, GrdDBusRemoteDesktopSessionSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
}

static const gchar *
grd_dbus_remote_desktop_session_skeleton_get_session_id (GrdDBusRemoteDesktopSession *object)
{
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
grd_dbus_remote_desktop_session_skeleton_get_caps_lock_state (GrdDBusRemoteDesktopSession *object)
{
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
grd_dbus_remote_desktop_session_skeleton_get_num_lock_state (GrdDBusRemoteDesktopSession *object)
{
  GrdDBusRemoteDesktopSessionSkeleton *skeleton = GRD_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
grd_dbus_remote_desktop_session_skeleton_class_init (GrdDBusRemoteDesktopSessionSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = grd_dbus_remote_desktop_session_skeleton_finalize;
  gobject_class->get_property = grd_dbus_remote_desktop_session_skeleton_get_property;
  gobject_class->set_property = grd_dbus_remote_desktop_session_skeleton_set_property;
  gobject_class->notify       = grd_dbus_remote_desktop_session_skeleton_notify;


  grd_dbus_remote_desktop_session_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = grd_dbus_remote_desktop_session_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = grd_dbus_remote_desktop_session_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = grd_dbus_remote_desktop_session_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = grd_dbus_remote_desktop_session_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GrdDBusRemoteDesktopSessionSkeletonPrivate));
#endif
}

static void
grd_dbus_remote_desktop_session_skeleton_iface_init (GrdDBusRemoteDesktopSessionIface *iface)
{
  iface->closed = _grd_dbus_remote_desktop_session_on_signal_closed;
  iface->selection_owner_changed = _grd_dbus_remote_desktop_session_on_signal_selection_owner_changed;
  iface->selection_transfer = _grd_dbus_remote_desktop_session_on_signal_selection_transfer;
  iface->get_session_id = grd_dbus_remote_desktop_session_skeleton_get_session_id;
  iface->get_caps_lock_state = grd_dbus_remote_desktop_session_skeleton_get_caps_lock_state;
  iface->get_num_lock_state = grd_dbus_remote_desktop_session_skeleton_get_num_lock_state;
}

/**
 * grd_dbus_remote_desktop_session_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link>.
 *
 * Returns: (transfer full) (type GrdDBusRemoteDesktopSessionSkeleton): The skeleton object.
 */
GrdDBusRemoteDesktopSession *
grd_dbus_remote_desktop_session_skeleton_new (void)
{
  return GRD_DBUS_REMOTE_DESKTOP_SESSION (g_object_new (GRD_DBUS_TYPE_REMOTE_DESKTOP_SESSION_SKELETON, NULL));
}

