# (C) Copyright 2005-2021 Enthought, Inc., Austin, TX
# All rights reserved.
#
# This software is provided without warranty under the terms of the BSD
# license included in LICENSE.txt and may be redistributed only under
# the conditions described in the aforementioned license. The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
#
# Thanks for using Enthought open source!

import warnings

from . import qt_api

if qt_api == "pyqt5":
    from PyQt5.QtMultimedia import *

elif qt_api == "pyside2":
    from PySide2.QtMultimedia import *

else:
    warnings.warn("Qt 4 does not support QtMultimedia", DeprecationWarning)
