// third_party/blink/public/mojom/payments/payment_handler_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_HANDLER_HOST_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_HANDLER_HOST_MOJOM_JUMBO_H_
#endif
namespace payments {
namespace mojom {
PaymentHandlerMethodData::PaymentHandlerMethodData()
    : method_name(),
      stringified_data() {}

PaymentHandlerMethodData::PaymentHandlerMethodData(
    const std::string& method_name_in,
    const base::Optional<std::string>& stringified_data_in)
    : method_name(std::move(method_name_in)),
      stringified_data(std::move(stringified_data_in)) {}

PaymentHandlerMethodData::~PaymentHandlerMethodData() = default;

void PaymentHandlerMethodData::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("method_name", this->method_name);
  if (this->stringified_data.has_value()) {
    value->SetString("stringified_data", this->stringified_data.value());
  } else {
    value->SetString("stringified_data", "base::nullopt");
  }
}

bool PaymentHandlerMethodData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentHandlerModifier::PaymentHandlerModifier()
    : total(),
      method_data() {}

PaymentHandlerModifier::PaymentHandlerModifier(
    ::payments::mojom::PaymentCurrencyAmountPtr total_in,
    PaymentHandlerMethodDataPtr method_data_in)
    : total(std::move(total_in)),
      method_data(std::move(method_data_in)) {}

PaymentHandlerModifier::~PaymentHandlerModifier() = default;

void PaymentHandlerModifier::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->total.is_null()) {
    value->SetString("total", "nullptr");
  } else {
    value->BeginDictionary("total");
    this->total->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->method_data.is_null()) {
    value->SetString("method_data", "nullptr");
  } else {
    value->BeginDictionary("method_data");
    this->method_data->AsValueInto(value);
    value->EndDictionary();
  }
}

bool PaymentHandlerModifier::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentRequestDetailsUpdate::PaymentRequestDetailsUpdate()
    : total(),
      shipping_options(),
      modifiers(),
      error(""),
      stringified_payment_method_errors(),
      shipping_address_errors() {}

PaymentRequestDetailsUpdate::PaymentRequestDetailsUpdate(
    ::payments::mojom::PaymentCurrencyAmountPtr total_in,
    base::Optional<std::vector<::payments::mojom::PaymentShippingOptionPtr>> shipping_options_in,
    base::Optional<std::vector<PaymentHandlerModifierPtr>> modifiers_in,
    const std::string& error_in,
    const base::Optional<std::string>& stringified_payment_method_errors_in,
    ::payments::mojom::AddressErrorsPtr shipping_address_errors_in)
    : total(std::move(total_in)),
      shipping_options(std::move(shipping_options_in)),
      modifiers(std::move(modifiers_in)),
      error(std::move(error_in)),
      stringified_payment_method_errors(std::move(stringified_payment_method_errors_in)),
      shipping_address_errors(std::move(shipping_address_errors_in)) {}

PaymentRequestDetailsUpdate::~PaymentRequestDetailsUpdate() = default;

void PaymentRequestDetailsUpdate::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->total.is_null()) {
    value->SetString("total", "nullptr");
  } else {
    value->BeginDictionary("total");
    this->total->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->shipping_options.has_value()) {
    value->BeginArray("shipping_options");
    for (const auto& item0 : this->shipping_options.value()) {
      if (item0.is_null()) {
        value->AppendString("nullptr");
      } else {
        value->BeginDictionary();
        item0->AsValueInto(value);
        value->EndDictionary();
      }
    }
    value->EndArray();
  } else {
    value->SetString("shipping_options", "base::nullopt");
  }
  if (this->modifiers.has_value()) {
    value->BeginArray("modifiers");
    for (const auto& item0 : this->modifiers.value()) {
      if (item0.is_null()) {
        value->AppendString("nullptr");
      } else {
        value->BeginDictionary();
        item0->AsValueInto(value);
        value->EndDictionary();
      }
    }
    value->EndArray();
  } else {
    value->SetString("modifiers", "base::nullopt");
  }
  value->SetString("error", this->error);
  if (this->stringified_payment_method_errors.has_value()) {
    value->SetString("stringified_payment_method_errors", this->stringified_payment_method_errors.value());
  } else {
    value->SetString("stringified_payment_method_errors", "base::nullopt");
  }
  if (this->shipping_address_errors.is_null()) {
    value->SetString("shipping_address_errors", "nullptr");
  } else {
    value->BeginDictionary("shipping_address_errors");
    this->shipping_address_errors->AsValueInto(value);
    value->EndDictionary();
  }
}

bool PaymentRequestDetailsUpdate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PaymentHandlerHost::Name_[] = "payments.mojom.PaymentHandlerHost";

class PaymentHandlerHost_ChangePaymentMethod_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentHandlerHost_ChangePaymentMethod_ForwardToCallback(
      PaymentHandlerHost::ChangePaymentMethodCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaymentHandlerHost::ChangePaymentMethodCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaymentHandlerHost_ChangePaymentMethod_ForwardToCallback);
};

class PaymentHandlerHost_ChangeShippingOption_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentHandlerHost_ChangeShippingOption_ForwardToCallback(
      PaymentHandlerHost::ChangeShippingOptionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaymentHandlerHost::ChangeShippingOptionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaymentHandlerHost_ChangeShippingOption_ForwardToCallback);
};

class PaymentHandlerHost_ChangeShippingAddress_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentHandlerHost_ChangeShippingAddress_ForwardToCallback(
      PaymentHandlerHost::ChangeShippingAddressCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaymentHandlerHost::ChangeShippingAddressCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaymentHandlerHost_ChangeShippingAddress_ForwardToCallback);
};

PaymentHandlerHostProxy::PaymentHandlerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaymentHandlerHostProxy::ChangePaymentMethod(
    PaymentHandlerMethodDataPtr in_method_data, ChangePaymentMethodCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentHandlerHost::ChangePaymentMethod", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_method_data.is_null()) {
        raw_value->SetString("method_data", "nullptr");
      } else {
        raw_value->BeginDictionary("method_data");
        in_method_data->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentHandlerHost_ChangePaymentMethod_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentHandlerHost_ChangePaymentMethod_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->method_data)::BaseType::BufferWriter
      method_data_writer;
  mojo::internal::Serialize<::payments::mojom::PaymentHandlerMethodDataDataView>(
      in_method_data, buffer, &method_data_writer, &serialization_context);
  params->method_data.Set(
      method_data_writer.is_null() ? nullptr : method_data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->method_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_data in PaymentHandlerHost.ChangePaymentMethod request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentHandlerHost::Name_);
  message.set_method_name("ChangePaymentMethod");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentHandlerHost_ChangePaymentMethod_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PaymentHandlerHostProxy::ChangeShippingOption(
    const std::string& in_shipping_option_id, ChangeShippingOptionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentHandlerHost::ChangeShippingOption", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("shipping_option_id", in_shipping_option_id);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentHandlerHost_ChangeShippingOption_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentHandlerHost_ChangeShippingOption_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->shipping_option_id)::BaseType::BufferWriter
      shipping_option_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_shipping_option_id, buffer, &shipping_option_id_writer, &serialization_context);
  params->shipping_option_id.Set(
      shipping_option_id_writer.is_null() ? nullptr : shipping_option_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shipping_option_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shipping_option_id in PaymentHandlerHost.ChangeShippingOption request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentHandlerHost::Name_);
  message.set_method_name("ChangeShippingOption");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentHandlerHost_ChangeShippingOption_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PaymentHandlerHostProxy::ChangeShippingAddress(
    ::payments::mojom::PaymentAddressPtr in_shipping_address, ChangeShippingAddressCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentHandlerHost::ChangeShippingAddress", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_shipping_address.is_null()) {
        raw_value->SetString("shipping_address", "nullptr");
      } else {
        raw_value->BeginDictionary("shipping_address");
        in_shipping_address->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentHandlerHost_ChangeShippingAddress_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentHandlerHost_ChangeShippingAddress_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->shipping_address)::BaseType::BufferWriter
      shipping_address_writer;
  mojo::internal::Serialize<::payments::mojom::PaymentAddressDataView>(
      in_shipping_address, buffer, &shipping_address_writer, &serialization_context);
  params->shipping_address.Set(
      shipping_address_writer.is_null() ? nullptr : shipping_address_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shipping_address.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shipping_address in PaymentHandlerHost.ChangeShippingAddress request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentHandlerHost::Name_);
  message.set_method_name("ChangeShippingAddress");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentHandlerHost_ChangeShippingAddress_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder {
 public:
  static PaymentHandlerHost::ChangePaymentMethodCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder> proxy(
        new PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentHandlerHost::ChangePaymentMethodCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentRequestDetailsUpdatePtr in_response_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder);
};

bool PaymentHandlerHost_ChangePaymentMethod_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::PaymentHandlerHost::ChangePaymentMethodCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PaymentHandlerHost_ChangePaymentMethod_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentHandlerHost_ChangePaymentMethod_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  PaymentRequestDetailsUpdatePtr p_response_data{};
  PaymentHandlerHost_ChangePaymentMethod_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResponseData(&p_response_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentHandlerHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_response_data));
  return true;
}

void PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder::Run(
    PaymentRequestDetailsUpdatePtr in_response_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::PaymentHandlerHost::ChangePaymentMethodCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_response_data.is_null()) {
        raw_value->SetString("response_data", "nullptr");
      } else {
        raw_value->BeginDictionary("response_data");
        in_response_data->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentHandlerHost_ChangePaymentMethod_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentHandlerHost_ChangePaymentMethod_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->response_data)::BaseType::BufferWriter
      response_data_writer;
  mojo::internal::Serialize<::payments::mojom::PaymentRequestDetailsUpdateDataView>(
      in_response_data, buffer, &response_data_writer, &serialization_context);
  params->response_data.Set(
      response_data_writer.is_null() ? nullptr : response_data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_data in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::PaymentHandlerHost::ChangePaymentMethodCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentHandlerHost::Name_);
  message.set_method_name("ChangePaymentMethod");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaymentHandlerHost_ChangeShippingOption_ProxyToResponder {
 public:
  static PaymentHandlerHost::ChangeShippingOptionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaymentHandlerHost_ChangeShippingOption_ProxyToResponder> proxy(
        new PaymentHandlerHost_ChangeShippingOption_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaymentHandlerHost_ChangeShippingOption_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentHandlerHost_ChangeShippingOption_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaymentHandlerHost_ChangeShippingOption_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentHandlerHost::ChangeShippingOptionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentRequestDetailsUpdatePtr in_response_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaymentHandlerHost_ChangeShippingOption_ProxyToResponder);
};

bool PaymentHandlerHost_ChangeShippingOption_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::PaymentHandlerHost::ChangeShippingOptionCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PaymentHandlerHost_ChangeShippingOption_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentHandlerHost_ChangeShippingOption_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  PaymentRequestDetailsUpdatePtr p_response_data{};
  PaymentHandlerHost_ChangeShippingOption_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResponseData(&p_response_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentHandlerHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_response_data));
  return true;
}

void PaymentHandlerHost_ChangeShippingOption_ProxyToResponder::Run(
    PaymentRequestDetailsUpdatePtr in_response_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::PaymentHandlerHost::ChangeShippingOptionCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_response_data.is_null()) {
        raw_value->SetString("response_data", "nullptr");
      } else {
        raw_value->BeginDictionary("response_data");
        in_response_data->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentHandlerHost_ChangeShippingOption_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentHandlerHost_ChangeShippingOption_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->response_data)::BaseType::BufferWriter
      response_data_writer;
  mojo::internal::Serialize<::payments::mojom::PaymentRequestDetailsUpdateDataView>(
      in_response_data, buffer, &response_data_writer, &serialization_context);
  params->response_data.Set(
      response_data_writer.is_null() ? nullptr : response_data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_data in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::PaymentHandlerHost::ChangeShippingOptionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentHandlerHost::Name_);
  message.set_method_name("ChangeShippingOption");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder {
 public:
  static PaymentHandlerHost::ChangeShippingAddressCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder> proxy(
        new PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentHandlerHost::ChangeShippingAddressCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentRequestDetailsUpdatePtr in_response_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder);
};

bool PaymentHandlerHost_ChangeShippingAddress_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::PaymentHandlerHost::ChangeShippingAddressCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PaymentHandlerHost_ChangeShippingAddress_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentHandlerHost_ChangeShippingAddress_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  PaymentRequestDetailsUpdatePtr p_response_data{};
  PaymentHandlerHost_ChangeShippingAddress_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResponseData(&p_response_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentHandlerHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_response_data));
  return true;
}

void PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder::Run(
    PaymentRequestDetailsUpdatePtr in_response_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::PaymentHandlerHost::ChangeShippingAddressCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_response_data.is_null()) {
        raw_value->SetString("response_data", "nullptr");
      } else {
        raw_value->BeginDictionary("response_data");
        in_response_data->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentHandlerHost_ChangeShippingAddress_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentHandlerHost_ChangeShippingAddress_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->response_data)::BaseType::BufferWriter
      response_data_writer;
  mojo::internal::Serialize<::payments::mojom::PaymentRequestDetailsUpdateDataView>(
      in_response_data, buffer, &response_data_writer, &serialization_context);
  params->response_data.Set(
      response_data_writer.is_null() ? nullptr : response_data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_data in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::PaymentHandlerHost::ChangeShippingAddressCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentHandlerHost::Name_);
  message.set_method_name("ChangeShippingAddress");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PaymentHandlerHostStubDispatch::Accept(
    PaymentHandlerHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPaymentHandlerHost_ChangePaymentMethod_Name: {
      break;
    }
    case internal::kPaymentHandlerHost_ChangeShippingOption_Name: {
      break;
    }
    case internal::kPaymentHandlerHost_ChangeShippingAddress_Name: {
      break;
    }
  }
  return false;
}

// static
bool PaymentHandlerHostStubDispatch::AcceptWithResponder(
    PaymentHandlerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPaymentHandlerHost_ChangePaymentMethod_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentHandlerHost::ChangePaymentMethod",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentHandlerHost::ChangePaymentMethod");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaymentHandlerHost_ChangePaymentMethod_Params_Data* params =
          reinterpret_cast<
              internal::PaymentHandlerHost_ChangePaymentMethod_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PaymentHandlerMethodDataPtr p_method_data{};
      PaymentHandlerHost_ChangePaymentMethod_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadMethodData(&p_method_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentHandlerHost::Name_, 0, false);
        return false;
      }
      PaymentHandlerHost::ChangePaymentMethodCallback callback =
          PaymentHandlerHost_ChangePaymentMethod_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChangePaymentMethod(
std::move(p_method_data), std::move(callback));
      return true;
    }
    case internal::kPaymentHandlerHost_ChangeShippingOption_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentHandlerHost::ChangeShippingOption",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentHandlerHost::ChangeShippingOption");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaymentHandlerHost_ChangeShippingOption_Params_Data* params =
          reinterpret_cast<
              internal::PaymentHandlerHost_ChangeShippingOption_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_shipping_option_id{};
      PaymentHandlerHost_ChangeShippingOption_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadShippingOptionId(&p_shipping_option_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentHandlerHost::Name_, 1, false);
        return false;
      }
      PaymentHandlerHost::ChangeShippingOptionCallback callback =
          PaymentHandlerHost_ChangeShippingOption_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChangeShippingOption(
std::move(p_shipping_option_id), std::move(callback));
      return true;
    }
    case internal::kPaymentHandlerHost_ChangeShippingAddress_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentHandlerHost::ChangeShippingAddress",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentHandlerHost::ChangeShippingAddress");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaymentHandlerHost_ChangeShippingAddress_Params_Data* params =
          reinterpret_cast<
              internal::PaymentHandlerHost_ChangeShippingAddress_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::payments::mojom::PaymentAddressPtr p_shipping_address{};
      PaymentHandlerHost_ChangeShippingAddress_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadShippingAddress(&p_shipping_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentHandlerHost::Name_, 2, false);
        return false;
      }
      PaymentHandlerHost::ChangeShippingAddressCallback callback =
          PaymentHandlerHost_ChangeShippingAddress_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChangeShippingAddress(
std::move(p_shipping_address), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPaymentHandlerHostValidationInfo[] = {
    {&internal::PaymentHandlerHost_ChangePaymentMethod_Params_Data::Validate,
     &internal::PaymentHandlerHost_ChangePaymentMethod_ResponseParams_Data::Validate},
    {&internal::PaymentHandlerHost_ChangeShippingOption_Params_Data::Validate,
     &internal::PaymentHandlerHost_ChangeShippingOption_ResponseParams_Data::Validate},
    {&internal::PaymentHandlerHost_ChangeShippingAddress_Params_Data::Validate,
     &internal::PaymentHandlerHost_ChangeShippingAddress_ResponseParams_Data::Validate},
};

bool PaymentHandlerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::PaymentHandlerHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPaymentHandlerHostValidationInfo);
}

bool PaymentHandlerHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::PaymentHandlerHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kPaymentHandlerHostValidationInfo);
}
}  // namespace mojom
}  // namespace payments

namespace mojo {


// static
bool StructTraits<::payments::mojom::PaymentHandlerMethodData::DataView, ::payments::mojom::PaymentHandlerMethodDataPtr>::Read(
    ::payments::mojom::PaymentHandlerMethodData::DataView input,
    ::payments::mojom::PaymentHandlerMethodDataPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentHandlerMethodDataPtr result(::payments::mojom::PaymentHandlerMethodData::New());
  
      if (success && !input.ReadMethodName(&result->method_name))
        success = false;
      if (success && !input.ReadStringifiedData(&result->stringified_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentHandlerModifier::DataView, ::payments::mojom::PaymentHandlerModifierPtr>::Read(
    ::payments::mojom::PaymentHandlerModifier::DataView input,
    ::payments::mojom::PaymentHandlerModifierPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentHandlerModifierPtr result(::payments::mojom::PaymentHandlerModifier::New());
  
      if (success && !input.ReadTotal(&result->total))
        success = false;
      if (success && !input.ReadMethodData(&result->method_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentRequestDetailsUpdate::DataView, ::payments::mojom::PaymentRequestDetailsUpdatePtr>::Read(
    ::payments::mojom::PaymentRequestDetailsUpdate::DataView input,
    ::payments::mojom::PaymentRequestDetailsUpdatePtr* output) {
  bool success = true;
  ::payments::mojom::PaymentRequestDetailsUpdatePtr result(::payments::mojom::PaymentRequestDetailsUpdate::New());
  
      if (success && !input.ReadTotal(&result->total))
        success = false;
      if (success && !input.ReadShippingOptions(&result->shipping_options))
        success = false;
      if (success && !input.ReadModifiers(&result->modifiers))
        success = false;
      if (success && !input.ReadError(&result->error))
        success = false;
      if (success && !input.ReadStringifiedPaymentMethodErrors(&result->stringified_payment_method_errors))
        success = false;
      if (success && !input.ReadShippingAddressErrors(&result->shipping_address_errors))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif