/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SSLSupport;

public class AprSSLSupport
implements SSLSupport {
    private final AprEndpoint.AprSocketWrapper socketWrapper;
    private final String clientCertProvider;

    public AprSSLSupport(AprEndpoint.AprSocketWrapper aprSocketWrapper, String string) {
        this.socketWrapper = aprSocketWrapper;
        this.clientCertProvider = string;
    }

    @Override
    public String getCipherSuite() throws IOException {
        try {
            return this.socketWrapper.getSSLInfoS(2);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws IOException {
        try {
            int n = this.socketWrapper.getSSLInfoI(1024);
            byte[] byArray = this.socketWrapper.getSSLInfoB(263);
            X509Certificate[] x509CertificateArray = null;
            if (byArray != null) {
                if (n < 0) {
                    n = 0;
                }
                x509CertificateArray = new X509Certificate[n + 1];
                CertificateFactory certificateFactory = this.clientCertProvider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", this.clientCertProvider);
                x509CertificateArray[0] = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                for (int i = 0; i < n; ++i) {
                    byte[] byArray2 = this.socketWrapper.getSSLInfoB(1024 + i);
                    x509CertificateArray[i + 1] = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray2));
                }
            }
            return x509CertificateArray;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public Integer getKeySize() throws IOException {
        try {
            return this.socketWrapper.getSSLInfoI(3);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public String getSessionId() throws IOException {
        try {
            return this.socketWrapper.getSSLInfoS(1);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public String getProtocol() throws IOException {
        try {
            return this.socketWrapper.getSSLInfoS(7);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public String getRequestedProtocols() throws IOException {
        return null;
    }

    @Override
    public String getRequestedCiphers() throws IOException {
        return null;
    }
}

