
#ifndef KIOCORE_EXPORT_H
#define KIOCORE_EXPORT_H

#ifdef KIOCORE_STATIC_DEFINE
#  define KIOCORE_EXPORT
#  define KIOCORE_NO_EXPORT
#else
#  ifndef KIOCORE_EXPORT
#    ifdef KF5KIOCore_EXPORTS
        /* We are building this library */
#      define KIOCORE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KIOCORE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KIOCORE_NO_EXPORT
#    define KIOCORE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KIOCORE_DECL_DEPRECATED
#  define KIOCORE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KIOCORE_DECL_DEPRECATED_EXPORT
#  define KIOCORE_DECL_DEPRECATED_EXPORT KIOCORE_EXPORT KIOCORE_DECL_DEPRECATED
#endif

#ifndef KIOCORE_DECL_DEPRECATED_NO_EXPORT
#  define KIOCORE_DECL_DEPRECATED_NO_EXPORT KIOCORE_NO_EXPORT KIOCORE_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KIOCORE_NO_DEPRECATED
#    define KIOCORE_NO_DEPRECATED
#  endif
#endif

#define KIOCORE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KIOCORE_NO_DEPRECATED) && !defined(KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KIOCORE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KIOCORE_NO_DEPRECATED_WARNINGS) && !defined(KIOCORE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KIOCORE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KIOCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KIOCORE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KIOCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KIOCORE_NO_DEPRECATED)
#  undef KIOCORE_DEPRECATED
#  define KIOCORE_DEPRECATED_EXPORT KIOCORE_EXPORT
#  define KIOCORE_DEPRECATED_NO_EXPORT KIOCORE_NO_EXPORT
#elif defined(KIOCORE_NO_DEPRECATED_WARNINGS)
#  define KIOCORE_DEPRECATED
#  define KIOCORE_DEPRECATED_EXPORT KIOCORE_EXPORT
#  define KIOCORE_DEPRECATED_NO_EXPORT KIOCORE_NO_EXPORT
#else
#  define KIOCORE_DEPRECATED KIOCORE_DECL_DEPRECATED
#  define KIOCORE_DEPRECATED_EXPORT KIOCORE_DECL_DEPRECATED_EXPORT
#  define KIOCORE_DEPRECATED_NO_EXPORT KIOCORE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KIOCORE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KIOCORE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KIOCORE_NO_DEPRECATED
#  define KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55d00
#endif
#ifdef KIOCORE_NO_DEPRECATED_WARNINGS
#  define KIOCORE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KIOCORE_DEPRECATED_WARNINGS_SINCE
#  ifdef KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KIOCORE_DEPRECATED_WARNINGS_SINCE KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KIOCORE_DEPRECATED_WARNINGS_SINCE 0x55d00
#  endif
#endif

#ifndef KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KIOCORE_DEPRECATED
#  define KIOCORE_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KIOCORE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x30000
#  define KIOCORE_DEPRECATED_VERSION_3_0(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_3_0(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x30100
#  define KIOCORE_DEPRECATED_VERSION_3_1(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_3_1(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x30400
#  define KIOCORE_DEPRECATED_VERSION_3_4(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_3_4(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x40000
#  define KIOCORE_DEPRECATED_VERSION_4_0(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_4_0(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x40300
#  define KIOCORE_DEPRECATED_VERSION_4_3(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_4_3(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x40500
#  define KIOCORE_DEPRECATED_VERSION_4_5(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_4_5(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x40600
#  define KIOCORE_DEPRECATED_VERSION_4_6(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_4_6(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x50000
#  define KIOCORE_DEPRECATED_VERSION_5_0(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_0(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x50200
#  define KIOCORE_DEPRECATED_VERSION_5_2(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_2(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x50800
#  define KIOCORE_DEPRECATED_VERSION_5_8(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_8(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x51800
#  define KIOCORE_DEPRECATED_VERSION_5_24(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_24(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x52d00
#  define KIOCORE_DEPRECATED_VERSION_5_45(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_45(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x53000
#  define KIOCORE_DEPRECATED_VERSION_5_48(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_48(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x53f00
#  define KIOCORE_DEPRECATED_VERSION_5_63(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_63(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x53d00
#  define KIOCORE_DEPRECATED_VERSION_5_61(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_61(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x54000
#  define KIOCORE_DEPRECATED_VERSION_5_64(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_64(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x54100
#  define KIOCORE_DEPRECATED_VERSION_5_65(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_65(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x54200
#  define KIOCORE_DEPRECATED_VERSION_5_66(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_66(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x54500
#  define KIOCORE_DEPRECATED_VERSION_5_69(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_69(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x54800
#  define KIOCORE_DEPRECATED_VERSION_5_72(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_72(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x54e00
#  define KIOCORE_DEPRECATED_VERSION_5_78(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_78(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x54f00
#  define KIOCORE_DEPRECATED_VERSION_5_79(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_79(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55000
#  define KIOCORE_DEPRECATED_VERSION_5_80(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_80(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55100
#  define KIOCORE_DEPRECATED_VERSION_5_81(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_81(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55200
#  define KIOCORE_DEPRECATED_VERSION_5_82(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_82(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55300
#  define KIOCORE_DEPRECATED_VERSION_5_83(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_83(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55400
#  define KIOCORE_DEPRECATED_VERSION_5_84(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_84(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55600
#  define KIOCORE_DEPRECATED_VERSION_5_86(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_86(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55800
#  define KIOCORE_DEPRECATED_VERSION_5_88(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_88(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55a00
#  define KIOCORE_DEPRECATED_VERSION_5_90(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_90(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55b00
#  define KIOCORE_DEPRECATED_VERSION_5_91(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_91(text)
#endif
#define KIOCORE_DEPRECATED_VERSION_3(minor, text)      KIOCORE_DEPRECATED_VERSION_3_##minor(text)
#define KIOCORE_DEPRECATED_VERSION_4(minor, text)      KIOCORE_DEPRECATED_VERSION_4_##minor(text)
#define KIOCORE_DEPRECATED_VERSION_5(minor, text)      KIOCORE_DEPRECATED_VERSION_5_##minor(text)
#define KIOCORE_DEPRECATED_VERSION(major, minor, text) KIOCORE_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KIOCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KIOCORE_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KIOCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KIOCORE_DEPRECATED_VERSION(major, minor, text)
#  define KIOCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KIOCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KIOCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KIOCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KIOCORE_EXPORT_H */


#ifndef ECM_GENERATEEXPORTHEADER_KIOCORE_EXPORT_H
#define ECM_GENERATEEXPORTHEADER_KIOCORE_EXPORT_H


#define KIOCORE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KIOCORE_NO_DEPRECATED) && !defined(KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KIOCORE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KIOCORE_NO_DEPRECATED_WARNINGS) && !defined(KIOCORE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KIOCORE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KIOCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KIOCORE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KIOCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KIOCORE_NO_DEPRECATED)
#  undef KIOCORE_DEPRECATED
#  define KIOCORE_DEPRECATED_EXPORT KIOCORE_EXPORT
#  define KIOCORE_DEPRECATED_NO_EXPORT KIOCORE_NO_EXPORT
#elif defined(KIOCORE_NO_DEPRECATED_WARNINGS)
#  define KIOCORE_DEPRECATED
#  define KIOCORE_DEPRECATED_EXPORT KIOCORE_EXPORT
#  define KIOCORE_DEPRECATED_NO_EXPORT KIOCORE_NO_EXPORT
#else
#  define KIOCORE_DEPRECATED KIOCORE_DECL_DEPRECATED
#  define KIOCORE_DEPRECATED_EXPORT KIOCORE_DECL_DEPRECATED_EXPORT
#  define KIOCORE_DEPRECATED_NO_EXPORT KIOCORE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KIOCORE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KIOCORE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KIOCORE_NO_DEPRECATED
#  define KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55d00
#endif
#ifdef KIOCORE_NO_DEPRECATED_WARNINGS
#  define KIOCORE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KIOCORE_DEPRECATED_WARNINGS_SINCE
#  ifdef KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KIOCORE_DEPRECATED_WARNINGS_SINCE KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KIOCORE_DEPRECATED_WARNINGS_SINCE 0x55d00
#  endif
#endif

#ifndef KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KIOCORE_DEPRECATED
#  define KIOCORE_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KIOCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KIOCORE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x30000
#  define KIOCORE_DEPRECATED_VERSION_3_0(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_3_0(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x30100
#  define KIOCORE_DEPRECATED_VERSION_3_1(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_3_1(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x30400
#  define KIOCORE_DEPRECATED_VERSION_3_4(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_3_4(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x40000
#  define KIOCORE_DEPRECATED_VERSION_4_0(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_4_0(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x40300
#  define KIOCORE_DEPRECATED_VERSION_4_3(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_4_3(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x40500
#  define KIOCORE_DEPRECATED_VERSION_4_5(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_4_5(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x40600
#  define KIOCORE_DEPRECATED_VERSION_4_6(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_4_6(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x50000
#  define KIOCORE_DEPRECATED_VERSION_5_0(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_0(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x50200
#  define KIOCORE_DEPRECATED_VERSION_5_2(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_2(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x50800
#  define KIOCORE_DEPRECATED_VERSION_5_8(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_8(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x51800
#  define KIOCORE_DEPRECATED_VERSION_5_24(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_24(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x52d00
#  define KIOCORE_DEPRECATED_VERSION_5_45(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_45(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x53000
#  define KIOCORE_DEPRECATED_VERSION_5_48(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_48(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x53f00
#  define KIOCORE_DEPRECATED_VERSION_5_63(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_63(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x53d00
#  define KIOCORE_DEPRECATED_VERSION_5_61(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_61(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x54000
#  define KIOCORE_DEPRECATED_VERSION_5_64(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_64(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x54100
#  define KIOCORE_DEPRECATED_VERSION_5_65(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_65(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x54200
#  define KIOCORE_DEPRECATED_VERSION_5_66(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_66(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x54500
#  define KIOCORE_DEPRECATED_VERSION_5_69(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_69(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x54800
#  define KIOCORE_DEPRECATED_VERSION_5_72(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_72(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x54e00
#  define KIOCORE_DEPRECATED_VERSION_5_78(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_78(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x54f00
#  define KIOCORE_DEPRECATED_VERSION_5_79(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_79(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55000
#  define KIOCORE_DEPRECATED_VERSION_5_80(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_80(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55100
#  define KIOCORE_DEPRECATED_VERSION_5_81(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_81(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55200
#  define KIOCORE_DEPRECATED_VERSION_5_82(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_82(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55300
#  define KIOCORE_DEPRECATED_VERSION_5_83(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_83(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55400
#  define KIOCORE_DEPRECATED_VERSION_5_84(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_84(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55600
#  define KIOCORE_DEPRECATED_VERSION_5_86(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_86(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55800
#  define KIOCORE_DEPRECATED_VERSION_5_88(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_88(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55a00
#  define KIOCORE_DEPRECATED_VERSION_5_90(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_90(text)
#endif

#if KIOCORE_DEPRECATED_WARNINGS_SINCE >= 0x55b00
#  define KIOCORE_DEPRECATED_VERSION_5_91(text) KIOCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOCORE_DEPRECATED_VERSION_5_91(text)
#endif
#define KIOCORE_DEPRECATED_VERSION_3(minor, text)      KIOCORE_DEPRECATED_VERSION_3_##minor(text)
#define KIOCORE_DEPRECATED_VERSION_4(minor, text)      KIOCORE_DEPRECATED_VERSION_4_##minor(text)
#define KIOCORE_DEPRECATED_VERSION_5(minor, text)      KIOCORE_DEPRECATED_VERSION_5_##minor(text)
#define KIOCORE_DEPRECATED_VERSION(major, minor, text) KIOCORE_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KIOCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KIOCORE_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KIOCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KIOCORE_DEPRECATED_VERSION(major, minor, text)
#  define KIOCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KIOCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KIOCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KIOCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif


#endif /* ECM_GENERATEEXPORTHEADER_KIOCORE_EXPORT_H */
