/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.P3;
import org.jmol.api.SymmetryInterface;
import org.jmol.render.CageRenderer;
import org.jmol.shape.Axes;

public class AxesRenderer
extends CageRenderer {
    private static final String[] axisLabels = new String[]{"+X", "+Y", "+Z", null, null, null, "a", "b", "c", "X", "Y", "Z", null, null, null, "X", null, "Z", null, "(Y)", null};
    private final P3 originScreen = new P3();
    private short[] colixes = new short[3];
    private P3 pt000;
    private static final String[] axesTypes = new String[]{"a", "b", "c", "x", "y", "z"};
    private final P3 ptTemp = new P3();

    @Override
    protected void initRenderer() {
        this.endcap = (byte)2;
        this.draw000 = false;
    }

    @Override
    protected boolean render() {
        boolean isXY;
        Axes axes = (Axes)this.shape;
        int mad10 = this.vwr.getObjectMad10(1);
        boolean bl = isXY = axes.axisXY.z != 0.0f;
        if (mad10 == 0 || !this.g3d.checkTranslucent(false)) {
            return false;
        }
        if (isXY ? this.exportType == 1 : this.tm.isNavigating() && this.vwr.getBoolean(603979890)) {
            return false;
        }
        int modelIndex = this.vwr.am.cmi;
        if (this.ms.isJmolDataFrameForModel(modelIndex) && !this.ms.getJmolFrameType(modelIndex).equals("plot data")) {
            return false;
        }
        boolean isUnitCell = this.vwr.g.axesMode == 0x24000020;
        SymmetryInterface unitcell = null;
        if (isUnitCell && (unitcell = this.vwr.getCurrentUnitCell()) != null && modelIndex < 0) {
            return false;
        }
        this.imageFontScaling = this.vwr.imageFontScaling;
        if (this.vwr.areAxesTainted()) {
            axes.reinitShape();
        }
        this.font3d = this.vwr.gdata.getFont3DScaled(axes.font3d, this.imageFontScaling);
        String axisType = (isUnitCell &= this.ms.unitCells != null) ? axes.axisType : null;
        boolean isabcxyz = isXY && isUnitCell && axes.axes2 != null;
        this.isPolymer = isUnitCell && unitcell.isPolymer();
        this.isSlab = isUnitCell && unitcell.isSlab();
        float scale = axes.scale;
        if (isabcxyz) {
            if ("xyzabc".equals(axes.axes2)) {
                this.render1(axes, mad10, false, axisType, isUnitCell, 2.0f, null);
            }
            if (!"abc".equals(axes.axes2)) {
                this.vwr.setBooleanProperty("axesmolecular", true);
            }
            axes.initShape();
            this.render1(axes, mad10, true, null, false, scale, axes.axes2);
            this.vwr.setBooleanProperty("axesunitcell", true);
        } else {
            this.render1(axes, mad10, isXY, axisType, isUnitCell, scale, null);
        }
        return true;
    }

    private void render1(Axes axes, int mad10, boolean isXY, String axisType, boolean isUnitCell, float scale, String labels2) {
        boolean checkAxisType;
        boolean isDataFrame = this.vwr.isJmolDataFrame();
        this.pt000 = isDataFrame ? this.pt0 : axes.originPoint;
        int nPoints = 6;
        int labelPtr = 0;
        if (isUnitCell) {
            nPoints = 3;
            labelPtr = 6;
        } else if (isXY) {
            nPoints = 3;
            labelPtr = 9;
        } else if (this.vwr.g.axesMode == 603979809) {
            nPoints = 6;
            int n = labelPtr = this.vwr.getBoolean(603979806) ? 15 : 9;
        }
        if (axes.labels != null) {
            if (nPoints != 3) {
                nPoints = axes.labels.length < 6 ? 3 : 6;
            }
            labelPtr = -1;
        }
        int slab = this.vwr.gdata.slab;
        int diameter = mad10;
        boolean drawTicks = false;
        this.ptTemp.setT(this.originScreen);
        boolean bl = checkAxisType = labels2 == null && axisType != null && (isXY || this.vwr.getFloat(0x22000001) != 0.0f || axes.fixedOrigin != null);
        if (isXY) {
            int i;
            if (mad10 >= 20) {
                int n = diameter = mad10 > 500 ? 3 : mad10 / 200;
                if (diameter == 0) {
                    diameter = 2;
                }
            }
            if (this.g3d.isAntialiased()) {
                diameter += diameter;
            }
            this.g3d.setSlab(0);
            this.ptTemp.setT(axes.axisXY);
            this.pt0i.setT(this.tm.transformPt2D(this.ptTemp));
            if (this.ptTemp.x < 0.0f) {
                int offx = (int)this.ptTemp.x;
                int offy = (int)this.ptTemp.x;
                this.pointT.setT(this.pt000);
                for (i = 0; i < 3; ++i) {
                    this.pointT.add(axes.getAxisPoint(i, false, this.ptTemp));
                }
                this.pt0i.setT(this.tm.transformPt(this.pt000));
                this.pt2i.scaleAdd(-1, this.pt0i, this.tm.transformPt(this.pointT));
                if (this.pt2i.x < 0) {
                    offx = -offx;
                }
                if (this.pt2i.y < 0) {
                    offy = -offy;
                }
                this.pt0i.x += offx;
                this.pt0i.y += offy;
            }
            this.ptTemp.set(this.pt0i.x, this.pt0i.y, this.pt0i.z);
            float zoomDimension = this.vwr.getScreenDim();
            float scaleFactor = zoomDimension / 10.0f * scale;
            if (this.g3d.isAntialiased()) {
                scaleFactor *= 2.0f;
            }
            if ((isUnitCell || "abc".equals(axes.axes2)) && isXY) {
                scaleFactor /= 2.0f;
            }
            for (i = 0; i < 3; ++i) {
                P3 pt = this.p3Screens[i];
                this.tm.rotatePoint(axes.getAxisPoint(i, false, this.pointT), pt);
                pt.z *= -1.0f;
                pt.scaleAdd2(scaleFactor, pt, this.ptTemp);
            }
        } else {
            boolean bl2 = drawTicks = axes.tickInfos != null;
            if (drawTicks) {
                this.checkTickTemps();
                this.tickA.setT(this.pt000);
            }
            this.tm.transformPtNoClip(this.pt000, this.ptTemp);
            diameter = this.getDiameter((int)this.ptTemp.z, mad10);
            int i = nPoints;
            while (--i >= 0) {
                this.tm.transformPtNoClip(axes.getAxisPoint(i, !isDataFrame, this.pointT), this.p3Screens[i]);
            }
        }
        float xCenter = this.ptTemp.x;
        float yCenter = this.ptTemp.y;
        this.colixes[0] = this.vwr.getObjectColix(1);
        this.colixes[1] = this.vwr.getObjectColix(2);
        this.colixes[2] = this.vwr.getObjectColix(3);
        boolean showOrigin = !isXY && nPoints == 3 && (scale == 2.0f || isUnitCell);
        int i = nPoints;
        while (--i >= 0) {
            String label;
            if (labels2 != null && i >= labels2.length() || checkAxisType && !axisType.contains(axesTypes[i])) continue;
            if (this.exportType != 1 && Math.abs(xCenter - this.p3Screens[i].x) + Math.abs(yCenter - this.p3Screens[i].y) <= 2.0f) {
                showOrigin = false;
                if (!false) continue;
            }
            this.colix = this.colixes[i % 3];
            this.g3d.setC(this.colix);
            String string = labels2 != null ? labels2.substring(i, i + 1) : (axes.labels == null ? axisLabels[i + labelPtr] : (label = i < axes.labels.length ? axes.labels[i] : null));
            if (label != null && label.length() > 0) {
                this.renderLabel(label, this.p3Screens[i].x, this.p3Screens[i].y, this.p3Screens[i].z, xCenter, yCenter);
            }
            if (drawTicks) {
                this.tickInfo = axes.tickInfos[i % 3 + 1];
                if (this.tickInfo == null) {
                    this.tickInfo = axes.tickInfos[0];
                }
                if (this.tickInfo != null) {
                    this.tickB.setT(axes.getAxisPoint(i, isDataFrame || isUnitCell, this.pointT));
                    this.tickInfo.first = 0.0f;
                    this.tickInfo.signFactor = i % 6 >= 3 ? -1 : 1;
                }
            }
            int d = this.isSlab && i == 2 || this.isPolymer && i > 0 ? -4 : diameter;
            this.renderLine(this.ptTemp, this.p3Screens[i], d, drawTicks && this.tickInfo != null);
        }
        if (showOrigin) {
            String label0;
            String string = label0 = axes.labels == null || axes.labels.length == 3 || axes.labels[3] == null ? "0" : axes.labels[3];
            if (label0 != null && label0.length() != 0) {
                this.colix = this.vwr.cm.colixBackgroundContrast;
                this.g3d.setC(this.colix);
                this.renderLabel(label0, xCenter, yCenter, this.ptTemp.z, xCenter, yCenter);
            }
        }
        if (isXY) {
            this.g3d.setSlab(slab);
        }
    }

    private void renderLabel(String str, float x, float y, float z, float xCenter, float yCenter) {
        int strAscent = this.font3d.getAscent();
        int strWidth = this.font3d.stringWidth(str);
        float dx = x - xCenter;
        float dy = y - yCenter;
        if (dx != 0.0f || dy != 0.0f) {
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            dx = (float)strWidth * 0.75f * dx / dist;
            dy = (float)strAscent * 0.75f * dy / dist;
            x += dx;
            y += dy;
        }
        double xStrBaseline = Math.floor(x - (float)strWidth / 2.0f);
        double yStrBaseline = Math.floor(y + (float)strAscent / 2.0f);
        this.g3d.drawString(str, this.font3d, (int)xStrBaseline, (int)yStrBaseline, (int)z, (int)z, (short)0);
    }
}

