/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.icons;

import eu.hansolo.tilesfx.icons.Flag;
import eu.hansolo.tilesfx.tools.Helper;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;

public class FlagIcon
extends Region {
    private static final double PREFERRED_WIDTH = 30.0;
    private static final double PREFERRED_HEIGHT = 30.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double DEFAULT_FLAG_SIZE = 30.0;
    private double size;
    private double width;
    private double height;
    private ImageView imageView;
    private Flag flag;
    private double flagSize;

    public FlagIcon() {
        this(Flag.GERMANY, 30.0);
    }

    public FlagIcon(Flag FLAG) {
        this(FLAG, 30.0);
    }

    public FlagIcon(Flag FLAG, double FLAG_SIZE) {
        this.flag = FLAG;
        this.flagSize = Helper.clamp(5.0, 1024.0, FLAG_SIZE);
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.flagSize, this.flagSize);
            } else {
                this.setPrefSize(30.0, 30.0);
            }
        }
        this.imageView = new ImageView(this.flag.getImage(this.flagSize));
        this.getChildren().setAll((Object[])new Node[]{this.imageView});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    protected double computeMinWidth(double HEIGHT) {
        return 5.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 5.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public void setFlag(Flag FLAG) {
        this.setFlag(FLAG, this.flagSize);
    }

    public void setFlag(Flag FLAG, double FLAG_SIZE) {
        if (null == FLAG) {
            throw new IllegalArgumentException("Flag cannot be null");
        }
        this.flag = FLAG;
        this.flagSize = Helper.clamp(5.0, 1024.0, FLAG_SIZE);
        this.redraw();
    }

    public double getFlagSize() {
        return this.flagSize;
    }

    public void setFlagSize(double FLAG_SIZE) {
        this.flagSize = Helper.clamp(5.0, 1024.0, FLAG_SIZE);
        this.redraw();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.imageView.setFitWidth(this.size);
            this.imageView.setFitHeight(this.size);
            this.imageView.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.redraw();
        }
    }

    private void redraw() {
        if (null == this.flag) {
            return;
        }
        this.imageView.setImage(this.flag.getImage(this.flagSize));
    }
}

