/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.lang.management.ManagementFactory;
import mediathek.tool.OperatingSystemType;
import org.apache.commons.lang3.ArchUtils;
import org.apache.commons.lang3.SystemUtils;

public class Functions {
    public static boolean isDebuggerAttached() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    }

    public static String textLaenge(int max, String text, boolean mitte, boolean addVorne) {
        if (((String)text).length() > max) {
            text = mitte ? ((String)text).substring(0, 25) + " .... " + ((String)text).substring(((String)text).length() - (max - 31)) : ((String)text).substring(0, max - 1);
        }
        StringBuilder textBuilder = new StringBuilder((String)text);
        while (textBuilder.length() < max) {
            if (addVorne) {
                textBuilder.insert(0, ' ');
                continue;
            }
            textBuilder.append(' ');
        }
        text = textBuilder.toString();
        return text;
    }

    public static OperatingSystemType getOs() {
        OperatingSystemType os = OperatingSystemType.UNKNOWN;
        if (SystemUtils.IS_OS_WINDOWS) {
            os = ArchUtils.getProcessor().is64Bit() ? OperatingSystemType.WIN64 : OperatingSystemType.WIN32;
        } else if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_FREE_BSD) {
            os = OperatingSystemType.LINUX;
        } else if (SystemUtils.IS_OS_MAC_OSX) {
            os = OperatingSystemType.MAC;
        }
        return os;
    }

    public static String getOsString() {
        return Functions.getOs().toString();
    }
}

