/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.servlet.BaseDtoHandler;
import org.directwebremoting.servlet.DojoModule;
import org.directwebremoting.util.LocalUtil;

public class DojoDtoHandler
extends BaseDtoHandler {
    protected String dojoDtoHandlerUrl;
    protected String dojoDwrBaseModulePath;
    protected String dojoDtoBaseModulePath;

    @Override
    protected String getBaseDtoPath() {
        return this.dojoDtoHandlerUrl;
    }

    @Override
    public String generateDtoScript(String contextPath, String servletPath, String jsClassName) {
        String script = null;
        String dtojs = this.remoter.generateDtoJavaScript(jsClassName, "    ", "c");
        if (dtojs != null) {
            DojoModule mod = new DojoModule(contextPath, servletPath, this.dojoDtoBaseModulePath, jsClassName);
            mod.addRequire(this.dojoDwrBaseModulePath, "engine");
            String engineModule = mod.expandModulePath(this.dojoDwrBaseModulePath, "engine");
            String dtoModule = mod.expandModulePath(this.dojoDtoBaseModulePath, jsClassName);
            mod.addContent("(function() {\n");
            mod.addContent("  var c;\n");
            mod.addContent("  if (!" + engineModule + "._mappedClasses[\"" + jsClassName + "\"]) {\n");
            mod.addContent(dtojs);
            mod.addContent("    " + engineModule + "._mappedClasses[\"" + jsClassName + "\"] = c;\n");
            NamedConverter namedConv = this.converterManager.getNamedConverter(jsClassName);
            String jsSuperClassName = namedConv.getJavascriptSuperClass();
            if (LocalUtil.hasLength(jsSuperClassName)) {
                mod.addContent("\n");
                mod.addRequire(this.dojoDtoBaseModulePath, jsSuperClassName);
                String superClassExpression = engineModule + "._mappedClasses[\"" + jsSuperClassName + "\"]";
                mod.addContent(this.remoter.generateDtoInheritanceJavaScript("    ", "c", superClassExpression, engineModule + "._delegate"));
            }
            mod.addContent("  }\n");
            mod.addContent("  dojo.setObject(\"" + dtoModule + "\", " + engineModule + "._mappedClasses[\"" + jsClassName + "\"]);\n");
            mod.addContent("})();\n");
            script = mod.toString();
        }
        return script;
    }

    public void setDojoDtoHandlerUrl(String dojoDtoHandlerUrl) {
        this.dojoDtoHandlerUrl = dojoDtoHandlerUrl;
    }

    public void setDojoDwrBaseModulePath(String modulePath) {
        this.dojoDwrBaseModulePath = modulePath;
    }

    public void setDojoDtoBaseModulePath(String modulePath) {
        this.dojoDtoBaseModulePath = modulePath;
    }
}

