/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public final class RoundedContainer {
    private final Dimension2D dim;
    private final double titleHeight;
    private final double attributeHeight;
    private final HColor borderColor;
    private final HColor backColor;
    private final HColor imgBackcolor;
    private final UStroke stroke;
    private final double rounded;
    private final double shadowing;

    public RoundedContainer(Dimension2D dim, double titleHeight, double attributeHeight, HColor borderColor, HColor backColor, HColor imgBackcolor, UStroke stroke, double rounded, double shadowing) {
        if (dim.getWidth() == 0.0) {
            throw new IllegalArgumentException();
        }
        this.rounded = rounded;
        this.dim = dim;
        this.imgBackcolor = imgBackcolor;
        this.titleHeight = titleHeight;
        this.borderColor = borderColor;
        this.backColor = backColor;
        this.attributeHeight = attributeHeight;
        this.stroke = stroke;
        this.shadowing = shadowing;
    }

    public void drawU(UGraphic ug) {
        ug = ug.apply(this.backColor.bg()).apply(this.borderColor);
        URectangle rect = new URectangle(this.dim.getWidth(), this.dim.getHeight()).rounded(this.rounded);
        rect.setDeltaShadow(this.shadowing);
        ug.apply(this.stroke).draw(rect);
        double yLine = this.titleHeight + this.attributeHeight;
        ug = ug.apply(this.imgBackcolor.bg());
        double thickness = this.stroke.getThickness();
        URectangle inner = new URectangle(this.dim.getWidth() - 4.0 * thickness, this.dim.getHeight() - this.titleHeight - 4.0 * thickness - this.attributeHeight).rounded(this.rounded);
        ug.apply(this.imgBackcolor).apply(new UTranslate(2.0 * thickness, yLine + 2.0 * thickness)).draw(inner);
        if (this.titleHeight > 0.0) {
            ug.apply(this.stroke).apply(UTranslate.dy(yLine)).draw(ULine.hline(this.dim.getWidth()));
        }
        if (this.attributeHeight > 0.0) {
            ug.apply(this.stroke).apply(UTranslate.dy(yLine - this.attributeHeight)).draw(ULine.hline(this.dim.getWidth()));
        }
    }
}

