/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageAssociation
extends AbstractEntityImage {
    private static final int SIZE = 12;
    private final SName sname;

    public EntityImageAssociation(ILeaf entity, ISkinParam skinParam, SName sname) {
        super(entity, skinParam);
        this.sname = sname;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(24.0, 24.0);
    }

    private Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.sname, SName.diamond);
    }

    @Override
    public final void drawU(UGraphic ug) {
        HColor backgroundColor;
        HColor borderColor;
        UPolygon diams = new UPolygon();
        diams.addPoint(12.0, 0.0);
        diams.addPoint(24.0, 12.0);
        diams.addPoint(12.0, 24.0);
        diams.addPoint(0.0, 12.0);
        diams.addPoint(12.0, 0.0);
        double shadow = 0.0;
        UStroke stroke = new UStroke(1.5);
        if (UseStyle.useBetaStyle()) {
            Style style = this.getStyle();
            borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            backgroundColor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            shadow = style.value(PName.Shadowing).asDouble();
            stroke = style.getStroke();
        } else {
            borderColor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.classBorder);
            backgroundColor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.classBackground);
            if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
                shadow = 5.0;
            }
        }
        diams.setDeltaShadow(shadow);
        ug.apply(borderColor).apply(backgroundColor.bg()).apply(stroke).draw(diams);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.DIAMOND;
    }
}

