/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.BookMarkedURIManager;
import org.protege.editor.core.ui.list.MList;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.core.ui.list.MListSectionHeader;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.core.ui.util.VerifiedInputEditor;

public class OpenFromURLPanel
extends JPanel
implements VerifiedInputEditor {
    private JTextField uriField;
    private MList bookmarksList;
    private List<InputVerificationStatusChangedListener> listeners = new ArrayList<InputVerificationStatusChangedListener>();

    public OpenFromURLPanel() {
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.uriField = new JTextField(45);
        this.uriField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent event) {
                OpenFromURLPanel.this.handleValueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                OpenFromURLPanel.this.handleValueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                OpenFromURLPanel.this.handleValueChanged();
            }
        });
        JPanel uriFieldHolder = new JPanel(new BorderLayout());
        uriFieldHolder.setBorder(ComponentFactory.createTitledBorder("URI"));
        uriFieldHolder.add((Component)this.uriField, "North");
        this.add((Component)uriFieldHolder, "North");
        JPanel bookmarksHolder = new JPanel(new BorderLayout());
        bookmarksHolder.setBorder(ComponentFactory.createTitledBorder("Bookmarks"));
        this.add(bookmarksHolder);
        this.bookmarksList = new MList(){

            @Override
            protected void handleAdd() {
                OpenFromURLPanel.this.addURI();
            }

            @Override
            protected void handleDelete() {
                OpenFromURLPanel.this.deleteSelectedBookmark();
            }
        };
        this.bookmarksList.setCellRenderer((ListCellRenderer)new BookmarkedItemListRenderer());
        bookmarksHolder.add(new JScrollPane(this.bookmarksList));
        this.fillList();
        this.bookmarksList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateTextField();
            }
        });
    }

    private void handleValueChanged() {
        boolean validURI = this.isValidURI();
        for (InputVerificationStatusChangedListener l : this.listeners) {
            l.verifiedStatusChanged(validURI);
        }
    }

    protected boolean isValidURI() {
        URI uri = this.getURI(false);
        return uri != null && uri.isAbsolute() && uri.getScheme() != null;
    }

    public URI getURI() {
        return this.getURI(true);
    }

    private URI getURI(boolean showMessage) {
        try {
            return new URI(this.uriField.getText().trim());
        }
        catch (URISyntaxException e) {
            if (showMessage) {
                this.showURIErrorMessage(e);
            }
            return null;
        }
    }

    private void updateTextField() {
        URIListItem item = this.getSelUriListItem();
        if (item != null) {
            this.uriField.setText(item.uri.toString());
        }
    }

    private void addURI() {
        String uriString = JOptionPane.showInputDialog(this, "Please enter a URI", "URI", -1);
        if (uriString != null) {
            try {
                URI uri = new URI(uriString);
                BookMarkedURIManager.getInstance().add(uri);
            }
            catch (URISyntaxException e) {
                this.showURIErrorMessage(e);
            }
            this.fillList();
        }
    }

    private void showURIErrorMessage(URISyntaxException e) {
        JOptionPane.showMessageDialog(this, e.getMessage(), "Invalid URI", 0);
    }

    private void fillList() {
        BookMarkedURIManager man = BookMarkedURIManager.getInstance();
        TreeSet<URI> ts = new TreeSet<URI>();
        ts.addAll(man.getBookMarkedURIs());
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(new AddURIItem());
        for (URI uri : ts) {
            data.add(new URIListItem(uri));
        }
        this.bookmarksList.setListData(data.toArray());
    }

    private void deleteSelectedBookmark() {
        Object selObj = this.bookmarksList.getSelectedValue();
        if (!(selObj instanceof URIListItem)) {
            return;
        }
        URIListItem item = (URIListItem)selObj;
        BookMarkedURIManager.getInstance().remove(item.uri);
        this.fillList();
    }

    private URIListItem getSelUriListItem() {
        if (this.bookmarksList.getSelectedValue() instanceof URIListItem) {
            return (URIListItem)this.bookmarksList.getSelectedValue();
        }
        return null;
    }

    @Override
    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        listener.verifiedStatusChanged(this.isValidURI());
    }

    @Override
    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    public static URI showDialog() {
        OpenFromURLPanel panel = new OpenFromURLPanel();
        int ret = JOptionPaneEx.showValidatingConfirmDialog(null, "Enter or select a URI", panel, -1, 2, panel.uriField);
        if (ret == 0) {
            return panel.getURI();
        }
        return null;
    }

    private class BookmarkedItemListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -833970269120392171L;

        private BookmarkedItemListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof URIListItem) {
                URIListItem item = (URIListItem)value;
                label.setText(item.uri.toString());
            }
            return label;
        }
    }

    private class URIListItem
    implements MListItem {
        private URI uri;

        public URIListItem(URI uri) {
            this.uri = uri;
        }

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public void handleEdit() {
        }

        @Override
        public boolean isDeleteable() {
            return true;
        }

        @Override
        public boolean handleDelete() {
            return true;
        }

        @Override
        public String getTooltip() {
            return this.uri.toString();
        }
    }

    private class AddURIItem
    implements MListSectionHeader {
        private AddURIItem() {
        }

        @Override
        public String getName() {
            return "Bookmarked URIs";
        }

        @Override
        public boolean canAdd() {
            return true;
        }
    }
}

