/* page-icon.c generated by valac 0.56.0, the Vala compiler
 * generated from page-icon.vala, do not modify */

/*
 * Copyright (C) 2009-2017 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>,
 *         Eduard Gotwig <g@ox.io>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <math.h>
#include <float.h>
#include <handy.h>
#include <gdk/gdk.h>
#include <string.h>

#define PAGE_ICON_MINIMUM_WIDTH 20
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PAGE_ICON (page_icon_get_type ())
#define PAGE_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_ICON, PageIcon))
#define PAGE_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_ICON, PageIconClass))
#define IS_PAGE_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_ICON))
#define IS_PAGE_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_ICON))
#define PAGE_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_ICON, PageIconClass))

typedef struct _PageIcon PageIcon;
typedef struct _PageIconClass PageIconClass;
typedef struct _PageIconPrivate PageIconPrivate;
enum  {
	PAGE_ICON_0_PROPERTY,
	PAGE_ICON_NUM_PROPERTIES
};
static GParamSpec* page_icon_properties[PAGE_ICON_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PageIcon {
	GtkDrawingArea parent_instance;
	PageIconPrivate * priv;
};

struct _PageIconClass {
	GtkDrawingAreaClass parent_class;
};

struct _PageIconPrivate {
	gchar side;
	gint position;
};

static gint PageIcon_private_offset;
static gpointer page_icon_parent_class = NULL;

VALA_EXTERN GType page_icon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageIcon, g_object_unref)
VALA_EXTERN PageIcon* page_icon_new (gchar side,
                         gint position);
VALA_EXTERN PageIcon* page_icon_construct (GType object_type,
                               gchar side,
                               gint position);
static void page_icon_real_get_preferred_width (GtkWidget* base,
                                         gint* minimum_width,
                                         gint* natural_width);
static void page_icon_real_get_preferred_height (GtkWidget* base,
                                          gint* minimum_height,
                                          gint* natural_height);
static void page_icon_real_get_preferred_height_for_width (GtkWidget* base,
                                                    gint width,
                                                    gint* minimum_height,
                                                    gint* natural_height);
static void page_icon_real_get_preferred_width_for_height (GtkWidget* base,
                                                    gint height,
                                                    gint* minimum_width,
                                                    gint* natural_width);
static gboolean page_icon_real_draw (GtkWidget* base,
                              cairo_t* c);
static void page_icon_finalize (GObject * obj);
static GType page_icon_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
page_icon_get_instance_private (PageIcon* self)
{
	return G_STRUCT_MEMBER_P (self, PageIcon_private_offset);
}

PageIcon*
page_icon_construct (GType object_type,
                     gchar side,
                     gint position)
{
	PageIcon * self = NULL;
	self = (PageIcon*) g_object_new (object_type, NULL);
	self->priv->side = side;
	self->priv->position = position;
	return self;
}

PageIcon*
page_icon_new (gchar side,
               gint position)
{
	return page_icon_construct (TYPE_PAGE_ICON, side, position);
}

static void
page_icon_real_get_preferred_width (GtkWidget* base,
                                    gint* minimum_width,
                                    gint* natural_width)
{
	PageIcon * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	self = (PageIcon*) base;
	_vala_natural_width = PAGE_ICON_MINIMUM_WIDTH;
	_vala_minimum_width = _vala_natural_width;
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}

static void
page_icon_real_get_preferred_height (GtkWidget* base,
                                     gint* minimum_height,
                                     gint* natural_height)
{
	PageIcon * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	self = (PageIcon*) base;
	_vala_natural_height = (gint) round (PAGE_ICON_MINIMUM_WIDTH * G_SQRT2);
	_vala_minimum_height = _vala_natural_height;
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}

static void
page_icon_real_get_preferred_height_for_width (GtkWidget* base,
                                               gint width,
                                               gint* minimum_height,
                                               gint* natural_height)
{
	PageIcon * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	self = (PageIcon*) base;
	_vala_natural_height = (gint) (width * G_SQRT2);
	_vala_minimum_height = _vala_natural_height;
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}

static void
page_icon_real_get_preferred_width_for_height (GtkWidget* base,
                                               gint height,
                                               gint* minimum_width,
                                               gint* natural_width)
{
	PageIcon * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	self = (PageIcon*) base;
	_vala_natural_width = (gint) (height / G_SQRT2);
	_vala_minimum_width = _vala_natural_width;
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}

static gboolean
page_icon_real_draw (GtkWidget* base,
                     cairo_t* c)
{
	PageIcon * self;
	gint w = 0;
	gint h = 0;
	gboolean dark = FALSE;
	HdyStyleManager* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean hc = FALSE;
	HdyStyleManager* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_ = FALSE;
	GdkRGBA rgba = {0};
	GdkRGBA _tmp7_ = {0};
	GdkRGBA _tmp19_;
	gboolean _tmp20_ = FALSE;
	gchar* text = NULL;
	gchar* _tmp21_;
	cairo_text_extents_t extents = {0};
	cairo_text_extents_t _tmp22_ = {0};
	cairo_text_extents_t _tmp23_;
	cairo_text_extents_t _tmp24_;
	gboolean result;
	self = (PageIcon*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	w = gtk_widget_get_allocated_width ((GtkWidget*) self);
	h = gtk_widget_get_allocated_height ((GtkWidget*) self);
	if ((w * G_SQRT2) > ((gdouble) h)) {
		w = (gint) round (h / G_SQRT2);
	} else {
		h = (gint) round (w * G_SQRT2);
	}
	cairo_translate (c, (gdouble) ((gtk_widget_get_allocated_width ((GtkWidget*) self) - w) / 2), (gdouble) ((gtk_widget_get_allocated_height ((GtkWidget*) self) - h) / 2));
	_tmp0_ = hdy_style_manager_get_default ();
	_tmp1_ = hdy_style_manager_get_dark (_tmp0_);
	_tmp2_ = _tmp1_;
	dark = _tmp2_;
	_tmp3_ = hdy_style_manager_get_default ();
	_tmp4_ = hdy_style_manager_get_high_contrast (_tmp3_);
	_tmp5_ = _tmp4_;
	hc = _tmp5_;
	if (dark) {
		_tmp6_ = !hc;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		cairo_rectangle (c, (gdouble) 1, (gdouble) 1, (gdouble) (w - 2), (gdouble) (h - 2));
	} else {
		cairo_rectangle (c, (gdouble) 0, (gdouble) 0, (gdouble) w, (gdouble) h);
	}
	rgba = _tmp7_;
	switch (self->priv->side) {
		case 'F':
		{
			gdk_rgba_parse (&rgba, "#c061cb");
			break;
		}
		case 'B':
		{
			gdk_rgba_parse (&rgba, "#ff7800");
			break;
		}
		default:
		{
			GdkRGBA start = {0};
			GdkRGBA _tmp8_ = {0};
			GdkRGBA end = {0};
			GdkRGBA _tmp9_ = {0};
			gdouble progress = 0.0;
			GdkRGBA _tmp10_;
			GdkRGBA _tmp11_;
			GdkRGBA _tmp12_;
			GdkRGBA _tmp13_;
			GdkRGBA _tmp14_;
			GdkRGBA _tmp15_;
			GdkRGBA _tmp16_;
			GdkRGBA _tmp17_;
			GdkRGBA _tmp18_;
			start = _tmp8_;
			end = _tmp9_;
			gdk_rgba_parse (&start, "#f6d32d");
			gdk_rgba_parse (&end, "#ed333b");
			progress = self->priv->position / 5.0;
			_tmp10_ = start;
			_tmp11_ = end;
			_tmp12_ = start;
			rgba.red = _tmp10_.red + ((_tmp11_.red - _tmp12_.red) * progress);
			_tmp13_ = start;
			_tmp14_ = end;
			_tmp15_ = start;
			rgba.green = _tmp13_.green + ((_tmp14_.green - _tmp15_.green) * progress);
			_tmp16_ = start;
			_tmp17_ = end;
			_tmp18_ = start;
			rgba.blue = _tmp16_.blue + ((_tmp17_.blue - _tmp18_.blue) * progress);
			break;
		}
	}
	rgba.alpha = 0.3;
	_tmp19_ = rgba;
	gdk_cairo_set_source_rgba (c, &_tmp19_);
	cairo_fill (c);
	cairo_set_line_width (c, 1.0);
	if (hc) {
		_tmp20_ = dark;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		cairo_set_source_rgba (c, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.5);
	} else {
		if (hc) {
			cairo_set_source_rgba (c, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.5);
		} else {
			cairo_set_source_rgba (c, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.15);
		}
	}
	cairo_rectangle (c, 0.5, 0.5, (gdouble) (w - 1), (gdouble) (h - 1));
	cairo_stroke (c);
	if (dark) {
		cairo_set_source_rgb (c, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	} else {
		cairo_set_source_rgb (c, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	}
	_tmp21_ = g_strdup_printf ("%i", self->priv->position + 1);
	text = _tmp21_;
	cairo_text_extents (c, text, &_tmp22_);
	extents = _tmp22_;
	_tmp23_ = extents;
	_tmp24_ = extents;
	cairo_translate (c, ((w - _tmp23_.width) * 0.5) - 0.5, ((h + _tmp24_.height) * 0.5) - 0.5);
	cairo_show_text (c, text);
	result = TRUE;
	_g_free0 (text);
	return result;
}

static void
page_icon_class_init (PageIconClass * klass,
                      gpointer klass_data)
{
	page_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PageIcon_private_offset);
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) page_icon_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) page_icon_real_get_preferred_height;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*) (GtkWidget*, gint, gint*, gint*)) page_icon_real_get_preferred_height_for_width;
	((GtkWidgetClass *) klass)->get_preferred_width_for_height = (void (*) (GtkWidget*, gint, gint*, gint*)) page_icon_real_get_preferred_width_for_height;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) page_icon_real_draw;
	G_OBJECT_CLASS (klass)->finalize = page_icon_finalize;
}

static void
page_icon_instance_init (PageIcon * self,
                         gpointer klass)
{
	self->priv = page_icon_get_instance_private (self);
}

static void
page_icon_finalize (GObject * obj)
{
	PageIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_ICON, PageIcon);
	G_OBJECT_CLASS (page_icon_parent_class)->finalize (obj);
}

static GType
page_icon_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PageIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PageIcon), 0, (GInstanceInitFunc) page_icon_instance_init, NULL };
	GType page_icon_type_id;
	page_icon_type_id = g_type_register_static (gtk_drawing_area_get_type (), "PageIcon", &g_define_type_info, 0);
	PageIcon_private_offset = g_type_add_instance_private (page_icon_type_id, sizeof (PageIconPrivate));
	return page_icon_type_id;
}

GType
page_icon_get_type (void)
{
	static volatile gsize page_icon_type_id__once = 0;
	if (g_once_init_enter (&page_icon_type_id__once)) {
		GType page_icon_type_id;
		page_icon_type_id = page_icon_get_type_once ();
		g_once_init_leave (&page_icon_type_id__once, page_icon_type_id);
	}
	return page_icon_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

