/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedMethodBinding
extends MethodBinding {
    protected MethodBinding originalMethod;

    public ParameterizedMethodBinding(final ParameterizedTypeBinding parameterizedTypeBinding, MethodBinding methodBinding) {
        block21: {
            int n;
            super(methodBinding.modifiers, methodBinding.selector, methodBinding.returnType, methodBinding.parameters, methodBinding.thrownExceptions, parameterizedTypeBinding);
            this.originalMethod = methodBinding;
            this.tagBits = methodBinding.tagBits & 0xFFFFFFFFFFFFFF7FL;
            this.parameterNonNullness = methodBinding.parameterNonNullness;
            this.defaultNullness = methodBinding.defaultNullness;
            final TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
            Substitution substitution = null;
            final int n2 = typeVariableBindingArray.length;
            final boolean bl = methodBinding.isStatic();
            if (n2 == 0) {
                this.typeVariables = Binding.NO_TYPE_VARIABLES;
                if (!bl) {
                    substitution = parameterizedTypeBinding;
                }
            } else {
                TypeVariableBinding typeVariableBinding;
                final TypeVariableBinding[] typeVariableBindingArray2 = new TypeVariableBinding[n2];
                for (n = 0; n < n2; ++n) {
                    typeVariableBinding = typeVariableBindingArray[n];
                    typeVariableBindingArray2[n] = new TypeVariableBinding(typeVariableBinding.sourceName, this, typeVariableBinding.rank, parameterizedTypeBinding.environment);
                    typeVariableBindingArray2[n].tagBits |= typeVariableBinding.tagBits & 0x180000000100000L;
                }
                this.typeVariables = typeVariableBindingArray2;
                substitution = new Substitution(){

                    @Override
                    public LookupEnvironment environment() {
                        return parameterizedTypeBinding.environment;
                    }

                    @Override
                    public boolean isRawSubstitution() {
                        return !bl && parameterizedTypeBinding.isRawSubstitution();
                    }

                    @Override
                    public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
                        if (typeVariableBinding.rank < n2 && TypeBinding.equalsEquals(typeVariableBindingArray[typeVariableBinding.rank], typeVariableBinding)) {
                            TypeVariableBinding typeVariableBinding2 = typeVariableBindingArray2[typeVariableBinding.rank];
                            return typeVariableBinding.hasTypeAnnotations() ? this.environment().createAnnotatedType((TypeBinding)typeVariableBinding2, typeVariableBinding.getTypeAnnotations()) : typeVariableBinding2;
                        }
                        if (!bl) {
                            return parameterizedTypeBinding.substitute(typeVariableBinding);
                        }
                        return typeVariableBinding;
                    }
                };
                block4: for (n = 0; n < n2; ++n) {
                    typeVariableBinding = typeVariableBindingArray[n];
                    TypeVariableBinding typeVariableBinding2 = typeVariableBindingArray2[n];
                    TypeBinding typeBinding = Scope.substitute(substitution, typeVariableBinding.superclass);
                    ReferenceBinding[] referenceBindingArray = Scope.substitute(substitution, typeVariableBinding.superInterfaces);
                    if (typeVariableBinding.firstBound != null) {
                        TypeBinding typeBinding2 = TypeBinding.equalsEquals(typeVariableBinding.firstBound, typeVariableBinding.superclass) ? typeBinding : referenceBindingArray[0];
                        typeVariableBinding2.setFirstBound(typeBinding2);
                    }
                    switch (typeBinding.kind()) {
                        case 68: {
                            typeVariableBinding2.setSuperClass(parameterizedTypeBinding.environment.getResolvedJavaBaseType(TypeConstants.JAVA_LANG_OBJECT, null));
                            typeVariableBinding2.setSuperInterfaces(referenceBindingArray);
                            continue block4;
                        }
                        default: {
                            if (typeBinding.isInterface()) {
                                typeVariableBinding2.setSuperClass(parameterizedTypeBinding.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null));
                                int n3 = referenceBindingArray.length;
                                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                                referenceBindingArray = new ReferenceBinding[n3 + 1];
                                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 1, n3);
                                referenceBindingArray[0] = (ReferenceBinding)typeBinding;
                                typeVariableBinding2.setSuperInterfaces(referenceBindingArray);
                                continue block4;
                            }
                            typeVariableBinding2.setSuperClass((ReferenceBinding)typeBinding);
                            typeVariableBinding2.setSuperInterfaces(referenceBindingArray);
                        }
                    }
                }
            }
            if (substitution != null) {
                this.returnType = Scope.substitute(substitution, this.returnType);
                this.parameters = Scope.substitute(substitution, this.parameters);
                this.thrownExceptions = Scope.substitute(substitution, this.thrownExceptions);
                if (this.thrownExceptions == null) {
                    this.thrownExceptions = Binding.NO_EXCEPTIONS;
                }
                if (parameterizedTypeBinding.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
                    long l = NullAnnotationMatching.validNullTagBits(this.returnType.tagBits);
                    if (l != 0L) {
                        this.tagBits &= 0xFE7FFFFFFFFFFFFFL;
                        this.tagBits |= l;
                    }
                    int n4 = this.parameters.length;
                    for (int i = 0; i < n4; ++i) {
                        long l2 = NullAnnotationMatching.validNullTagBits(this.parameters[i].tagBits);
                        if (l2 == 0L) continue;
                        if (this.parameterNonNullness == null) {
                            this.parameterNonNullness = new Boolean[n4];
                        }
                        this.parameterNonNullness[i] = l2 == 0x100000000000000L;
                    }
                }
            }
            if ((this.tagBits & 0x80L) == 0L) {
                if ((this.returnType.tagBits & 0x80L) != 0L) {
                    this.tagBits |= 0x80L;
                } else {
                    int n5;
                    n = this.parameters.length;
                    for (n5 = 0; n5 < n; ++n5) {
                        if ((this.parameters[n5].tagBits & 0x80L) == 0L) continue;
                        this.tagBits |= 0x80L;
                        break block21;
                    }
                    n = this.thrownExceptions.length;
                    for (n5 = 0; n5 < n; ++n5) {
                        if ((this.thrownExceptions[n5].tagBits & 0x80L) == 0L) continue;
                        this.tagBits |= 0x80L;
                        break;
                    }
                }
            }
        }
    }

    public ParameterizedMethodBinding(ReferenceBinding referenceBinding, MethodBinding methodBinding, char[][] cArray, final LookupEnvironment lookupEnvironment) {
        block16: {
            int n;
            super(methodBinding.modifiers, methodBinding.selector, methodBinding.returnType, methodBinding.parameters, methodBinding.thrownExceptions, referenceBinding);
            this.originalMethod = methodBinding;
            this.tagBits = methodBinding.tagBits & 0xFFFFFFFFFFFFFF7FL;
            this.parameterNonNullness = methodBinding.parameterNonNullness;
            this.defaultNullness = methodBinding.defaultNullness;
            final TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
            Substitution substitution = null;
            final int n2 = typeVariableBindingArray.length;
            if (n2 == 0) {
                this.typeVariables = Binding.NO_TYPE_VARIABLES;
            } else {
                TypeVariableBinding typeVariableBinding;
                final TypeVariableBinding[] typeVariableBindingArray2 = new TypeVariableBinding[n2];
                for (n = 0; n < n2; ++n) {
                    typeVariableBinding = typeVariableBindingArray[n];
                    typeVariableBindingArray2[n] = new TypeVariableBinding(cArray == null ? typeVariableBinding.sourceName : cArray[n], this, typeVariableBinding.rank, lookupEnvironment);
                    typeVariableBindingArray2[n].tagBits |= typeVariableBinding.tagBits & 0x180000000100000L;
                }
                this.typeVariables = typeVariableBindingArray2;
                substitution = new Substitution(){

                    @Override
                    public LookupEnvironment environment() {
                        return lookupEnvironment;
                    }

                    @Override
                    public boolean isRawSubstitution() {
                        return false;
                    }

                    @Override
                    public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
                        if (typeVariableBinding.rank < n2 && TypeBinding.equalsEquals(typeVariableBindingArray[typeVariableBinding.rank], typeVariableBinding)) {
                            TypeVariableBinding typeVariableBinding2 = typeVariableBindingArray2[typeVariableBinding.rank];
                            return typeVariableBinding.hasTypeAnnotations() ? this.environment().createAnnotatedType((TypeBinding)typeVariableBinding2, typeVariableBinding.getTypeAnnotations()) : typeVariableBinding2;
                        }
                        return typeVariableBinding;
                    }
                };
                block4: for (n = 0; n < n2; ++n) {
                    typeVariableBinding = typeVariableBindingArray[n];
                    TypeVariableBinding typeVariableBinding2 = typeVariableBindingArray2[n];
                    TypeBinding typeBinding = Scope.substitute(substitution, typeVariableBinding.superclass);
                    ReferenceBinding[] referenceBindingArray = Scope.substitute(substitution, typeVariableBinding.superInterfaces);
                    if (typeVariableBinding.firstBound != null) {
                        TypeBinding typeBinding2 = TypeBinding.equalsEquals(typeVariableBinding.firstBound, typeVariableBinding.superclass) ? typeBinding : referenceBindingArray[0];
                        typeVariableBinding2.setFirstBound(typeBinding2);
                    }
                    switch (typeBinding.kind()) {
                        case 68: {
                            typeVariableBinding2.setSuperClass(lookupEnvironment.getResolvedJavaBaseType(TypeConstants.JAVA_LANG_OBJECT, null));
                            typeVariableBinding2.setSuperInterfaces(referenceBindingArray);
                            continue block4;
                        }
                        default: {
                            if (typeBinding.isInterface()) {
                                typeVariableBinding2.setSuperClass(lookupEnvironment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null));
                                int n3 = referenceBindingArray.length;
                                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                                referenceBindingArray = new ReferenceBinding[n3 + 1];
                                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 1, n3);
                                referenceBindingArray[0] = (ReferenceBinding)typeBinding;
                                typeVariableBinding2.setSuperInterfaces(referenceBindingArray);
                                continue block4;
                            }
                            typeVariableBinding2.setSuperClass((ReferenceBinding)typeBinding);
                            typeVariableBinding2.setSuperInterfaces(referenceBindingArray);
                        }
                    }
                }
            }
            if (substitution != null) {
                this.returnType = Scope.substitute(substitution, this.returnType);
                this.parameters = Scope.substitute(substitution, this.parameters);
                this.thrownExceptions = Scope.substitute(substitution, this.thrownExceptions);
                if (this.thrownExceptions == null) {
                    this.thrownExceptions = Binding.NO_EXCEPTIONS;
                }
            }
            if ((this.tagBits & 0x80L) == 0L) {
                if ((this.returnType.tagBits & 0x80L) != 0L) {
                    this.tagBits |= 0x80L;
                } else {
                    int n4;
                    n = this.parameters.length;
                    for (n4 = 0; n4 < n; ++n4) {
                        if ((this.parameters[n4].tagBits & 0x80L) == 0L) continue;
                        this.tagBits |= 0x80L;
                        break block16;
                    }
                    n = this.thrownExceptions.length;
                    for (n4 = 0; n4 < n; ++n4) {
                        if ((this.thrownExceptions[n4].tagBits & 0x80L) == 0L) continue;
                        this.tagBits |= 0x80L;
                        break;
                    }
                }
            }
        }
    }

    public ParameterizedMethodBinding() {
    }

    public static ParameterizedMethodBinding instantiateGetClass(TypeBinding typeBinding, MethodBinding methodBinding, Scope scope) {
        ParameterizedMethodBinding parameterizedMethodBinding = new ParameterizedMethodBinding();
        parameterizedMethodBinding.modifiers = methodBinding.modifiers;
        parameterizedMethodBinding.selector = methodBinding.selector;
        parameterizedMethodBinding.declaringClass = methodBinding.declaringClass;
        parameterizedMethodBinding.typeVariables = Binding.NO_TYPE_VARIABLES;
        parameterizedMethodBinding.originalMethod = methodBinding;
        parameterizedMethodBinding.parameters = methodBinding.parameters;
        parameterizedMethodBinding.thrownExceptions = methodBinding.thrownExceptions;
        parameterizedMethodBinding.tagBits = methodBinding.tagBits;
        ReferenceBinding referenceBinding = scope.getJavaLangClass();
        LookupEnvironment lookupEnvironment = scope.environment();
        TypeBinding typeBinding2 = lookupEnvironment.convertToRawType(typeBinding.erasure(), false);
        if (lookupEnvironment.usesNullTypeAnnotations()) {
            typeBinding2 = lookupEnvironment.createAnnotatedType(typeBinding2, new AnnotationBinding[]{lookupEnvironment.getNonNullAnnotation()});
        }
        parameterizedMethodBinding.returnType = lookupEnvironment.createParameterizedType(referenceBinding, new TypeBinding[]{lookupEnvironment.createWildcard(referenceBinding, 0, typeBinding2, null, 1)}, null);
        if (lookupEnvironment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
            if (lookupEnvironment.usesNullTypeAnnotations()) {
                parameterizedMethodBinding.returnType = lookupEnvironment.createAnnotatedType(parameterizedMethodBinding.returnType, new AnnotationBinding[]{lookupEnvironment.getNonNullAnnotation()});
            } else {
                parameterizedMethodBinding.tagBits |= 0x100000000000000L;
            }
        }
        if ((parameterizedMethodBinding.returnType.tagBits & 0x80L) != 0L) {
            parameterizedMethodBinding.tagBits |= 0x80L;
        }
        return parameterizedMethodBinding;
    }

    @Override
    public boolean hasSubstitutedParameters() {
        return this.parameters != this.originalMethod.parameters;
    }

    @Override
    public boolean hasSubstitutedReturnType() {
        return this.returnType != this.originalMethod.returnType;
    }

    @Override
    public MethodBinding original() {
        return this.originalMethod.original();
    }

    @Override
    public MethodBinding shallowOriginal() {
        return this.originalMethod;
    }
}

