/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "org.freedesktop.NetworkManager.Settings.Connection.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.NetworkManager.Settings.Connection
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NMDBusSettingsConnection
 * @title: NMDBusSettingsConnection
 * @short_description: Generated C code for the org.freedesktop.NetworkManager.Settings.Connection D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Settings-Connection.top_of_page">org.freedesktop.NetworkManager.Settings.Connection</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.NetworkManager.Settings.Connection ---- */

static const _ExtendedGDBusArgInfo _nmdbus_settings_connection_method_info_update_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_settings_connection_method_info_update_IN_ARG_pointers[] =
{
  &_nmdbus_settings_connection_method_info_update_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_settings_connection_method_info_update =
{
  {
    -1,
    (gchar *) "Update",
    (GDBusArgInfo **) &_nmdbus_settings_connection_method_info_update_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-update",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_settings_connection_method_info_update_unsaved_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_settings_connection_method_info_update_unsaved_IN_ARG_pointers[] =
{
  &_nmdbus_settings_connection_method_info_update_unsaved_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_settings_connection_method_info_update_unsaved =
{
  {
    -1,
    (gchar *) "UpdateUnsaved",
    (GDBusArgInfo **) &_nmdbus_settings_connection_method_info_update_unsaved_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-update-unsaved",
  FALSE
};

static const _ExtendedGDBusMethodInfo _nmdbus_settings_connection_method_info_delete =
{
  {
    -1,
    (gchar *) "Delete",
    NULL,
    NULL,
    NULL
  },
  "handle-delete",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_settings_connection_method_info_get_settings_OUT_ARG_settings =
{
  {
    -1,
    (gchar *) "settings",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_settings_connection_method_info_get_settings_OUT_ARG_pointers[] =
{
  &_nmdbus_settings_connection_method_info_get_settings_OUT_ARG_settings.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_settings_connection_method_info_get_settings =
{
  {
    -1,
    (gchar *) "GetSettings",
    NULL,
    (GDBusArgInfo **) &_nmdbus_settings_connection_method_info_get_settings_OUT_ARG_pointers,
    NULL
  },
  "handle-get-settings",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_settings_connection_method_info_get_secrets_IN_ARG_setting_name =
{
  {
    -1,
    (gchar *) "setting_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_settings_connection_method_info_get_secrets_IN_ARG_pointers[] =
{
  &_nmdbus_settings_connection_method_info_get_secrets_IN_ARG_setting_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _nmdbus_settings_connection_method_info_get_secrets_OUT_ARG_secrets =
{
  {
    -1,
    (gchar *) "secrets",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_settings_connection_method_info_get_secrets_OUT_ARG_pointers[] =
{
  &_nmdbus_settings_connection_method_info_get_secrets_OUT_ARG_secrets.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_settings_connection_method_info_get_secrets =
{
  {
    -1,
    (gchar *) "GetSecrets",
    (GDBusArgInfo **) &_nmdbus_settings_connection_method_info_get_secrets_IN_ARG_pointers,
    (GDBusArgInfo **) &_nmdbus_settings_connection_method_info_get_secrets_OUT_ARG_pointers,
    NULL
  },
  "handle-get-secrets",
  FALSE
};

static const _ExtendedGDBusMethodInfo _nmdbus_settings_connection_method_info_clear_secrets =
{
  {
    -1,
    (gchar *) "ClearSecrets",
    NULL,
    NULL,
    NULL
  },
  "handle-clear-secrets",
  FALSE
};

static const _ExtendedGDBusMethodInfo _nmdbus_settings_connection_method_info_save =
{
  {
    -1,
    (gchar *) "Save",
    NULL,
    NULL,
    NULL
  },
  "handle-save",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_settings_connection_method_info_update2_IN_ARG_settings =
{
  {
    -1,
    (gchar *) "settings",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_settings_connection_method_info_update2_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_settings_connection_method_info_update2_IN_ARG_args =
{
  {
    -1,
    (gchar *) "args",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_settings_connection_method_info_update2_IN_ARG_pointers[] =
{
  &_nmdbus_settings_connection_method_info_update2_IN_ARG_settings.parent_struct,
  &_nmdbus_settings_connection_method_info_update2_IN_ARG_flags.parent_struct,
  &_nmdbus_settings_connection_method_info_update2_IN_ARG_args.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _nmdbus_settings_connection_method_info_update2_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_settings_connection_method_info_update2_OUT_ARG_pointers[] =
{
  &_nmdbus_settings_connection_method_info_update2_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_settings_connection_method_info_update2 =
{
  {
    -1,
    (gchar *) "Update2",
    (GDBusArgInfo **) &_nmdbus_settings_connection_method_info_update2_IN_ARG_pointers,
    (GDBusArgInfo **) &_nmdbus_settings_connection_method_info_update2_OUT_ARG_pointers,
    NULL
  },
  "handle-update2",
  FALSE
};

static const GDBusMethodInfo * const _nmdbus_settings_connection_method_info_pointers[] =
{
  &_nmdbus_settings_connection_method_info_update.parent_struct,
  &_nmdbus_settings_connection_method_info_update_unsaved.parent_struct,
  &_nmdbus_settings_connection_method_info_delete.parent_struct,
  &_nmdbus_settings_connection_method_info_get_settings.parent_struct,
  &_nmdbus_settings_connection_method_info_get_secrets.parent_struct,
  &_nmdbus_settings_connection_method_info_clear_secrets.parent_struct,
  &_nmdbus_settings_connection_method_info_save.parent_struct,
  &_nmdbus_settings_connection_method_info_update2.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nmdbus_settings_connection_signal_info_updated =
{
  {
    -1,
    (gchar *) "Updated",
    NULL,
    NULL
  },
  "updated"
};

static const _ExtendedGDBusSignalInfo _nmdbus_settings_connection_signal_info_removed =
{
  {
    -1,
    (gchar *) "Removed",
    NULL,
    NULL
  },
  "removed"
};

static const GDBusSignalInfo * const _nmdbus_settings_connection_signal_info_pointers[] =
{
  &_nmdbus_settings_connection_signal_info_updated.parent_struct,
  &_nmdbus_settings_connection_signal_info_removed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _nmdbus_settings_connection_property_info_unsaved =
{
  {
    -1,
    (gchar *) "Unsaved",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "unsaved",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_settings_connection_property_info_flags =
{
  {
    -1,
    (gchar *) "Flags",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "flags",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_settings_connection_property_info_filename =
{
  {
    -1,
    (gchar *) "Filename",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "filename",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _nmdbus_settings_connection_property_info_pointers[] =
{
  &_nmdbus_settings_connection_property_info_unsaved.parent_struct,
  &_nmdbus_settings_connection_property_info_flags.parent_struct,
  &_nmdbus_settings_connection_property_info_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _nmdbus_settings_connection_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.NetworkManager.Settings.Connection",
    (GDBusMethodInfo **) &_nmdbus_settings_connection_method_info_pointers,
    (GDBusSignalInfo **) &_nmdbus_settings_connection_signal_info_pointers,
    (GDBusPropertyInfo **) &_nmdbus_settings_connection_property_info_pointers,
    NULL
  },
  "settings-connection",
};


/**
 * nmdbus_settings_connection_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Settings-Connection.top_of_page">org.freedesktop.NetworkManager.Settings.Connection</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
nmdbus_settings_connection_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_nmdbus_settings_connection_interface_info.parent_struct;
}

/**
 * nmdbus_settings_connection_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NMDBusSettingsConnection interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
nmdbus_settings_connection_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "unsaved");
  g_object_class_override_property (klass, property_id_begin++, "flags");
  g_object_class_override_property (klass, property_id_begin++, "filename");
  return property_id_begin - 1;
}



/**
 * NMDBusSettingsConnection:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Settings-Connection.top_of_page">org.freedesktop.NetworkManager.Settings.Connection</link>.
 */

/**
 * NMDBusSettingsConnectionIface:
 * @parent_iface: The parent interface.
 * @handle_clear_secrets: Handler for the #NMDBusSettingsConnection::handle-clear-secrets signal.
 * @handle_delete: Handler for the #NMDBusSettingsConnection::handle-delete signal.
 * @handle_get_secrets: Handler for the #NMDBusSettingsConnection::handle-get-secrets signal.
 * @handle_get_settings: Handler for the #NMDBusSettingsConnection::handle-get-settings signal.
 * @handle_save: Handler for the #NMDBusSettingsConnection::handle-save signal.
 * @handle_update: Handler for the #NMDBusSettingsConnection::handle-update signal.
 * @handle_update2: Handler for the #NMDBusSettingsConnection::handle-update2 signal.
 * @handle_update_unsaved: Handler for the #NMDBusSettingsConnection::handle-update-unsaved signal.
 * @get_filename: Getter for the #NMDBusSettingsConnection:filename property.
 * @get_flags: Getter for the #NMDBusSettingsConnection:flags property.
 * @get_unsaved: Getter for the #NMDBusSettingsConnection:unsaved property.
 * @removed: Handler for the #NMDBusSettingsConnection::removed signal.
 * @updated: Handler for the #NMDBusSettingsConnection::updated signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Settings-Connection.top_of_page">org.freedesktop.NetworkManager.Settings.Connection</link>.
 */

typedef NMDBusSettingsConnectionIface NMDBusSettingsConnectionInterface;
G_DEFINE_INTERFACE (NMDBusSettingsConnection, nmdbus_settings_connection, G_TYPE_OBJECT)

static void
nmdbus_settings_connection_default_init (NMDBusSettingsConnectionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * NMDBusSettingsConnection::handle-update:
   * @object: A #NMDBusSettingsConnection.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Update">Update()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_settings_connection_complete_update() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-update",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusSettingsConnectionIface, handle_update),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * NMDBusSettingsConnection::handle-update-unsaved:
   * @object: A #NMDBusSettingsConnection.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.UpdateUnsaved">UpdateUnsaved()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_settings_connection_complete_update_unsaved() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-update-unsaved",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusSettingsConnectionIface, handle_update_unsaved),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * NMDBusSettingsConnection::handle-delete:
   * @object: A #NMDBusSettingsConnection.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Delete">Delete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_settings_connection_complete_delete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusSettingsConnectionIface, handle_delete),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * NMDBusSettingsConnection::handle-get-settings:
   * @object: A #NMDBusSettingsConnection.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.GetSettings">GetSettings()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_settings_connection_complete_get_settings() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-settings",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusSettingsConnectionIface, handle_get_settings),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * NMDBusSettingsConnection::handle-get-secrets:
   * @object: A #NMDBusSettingsConnection.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_setting_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.GetSecrets">GetSecrets()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_settings_connection_complete_get_secrets() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-secrets",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusSettingsConnectionIface, handle_get_secrets),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * NMDBusSettingsConnection::handle-clear-secrets:
   * @object: A #NMDBusSettingsConnection.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.ClearSecrets">ClearSecrets()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_settings_connection_complete_clear_secrets() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-clear-secrets",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusSettingsConnectionIface, handle_clear_secrets),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * NMDBusSettingsConnection::handle-save:
   * @object: A #NMDBusSettingsConnection.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Save">Save()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_settings_connection_complete_save() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-save",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusSettingsConnectionIface, handle_save),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * NMDBusSettingsConnection::handle-update2:
   * @object: A #NMDBusSettingsConnection.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_settings: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   * @arg_args: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Update2">Update2()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_settings_connection_complete_update2() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-update2",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusSettingsConnectionIface, handle_update2),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_UINT, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * NMDBusSettingsConnection::updated:
   * @object: A #NMDBusSettingsConnection.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager-Settings-Connection.Updated">"Updated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("updated",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusSettingsConnectionIface, updated),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * NMDBusSettingsConnection::removed:
   * @object: A #NMDBusSettingsConnection.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager-Settings-Connection.Removed">"Removed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("removed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusSettingsConnectionIface, removed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /* GObject properties for D-Bus properties: */
  /**
   * NMDBusSettingsConnection:unsaved:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Settings-Connection.Unsaved">"Unsaved"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("unsaved", "Unsaved", "Unsaved", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusSettingsConnection:flags:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Settings-Connection.Flags">"Flags"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("flags", "Flags", "Flags", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusSettingsConnection:filename:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Settings-Connection.Filename">"Filename"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("filename", "Filename", "Filename", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * nmdbus_settings_connection_get_unsaved: (skip)
 * @object: A #NMDBusSettingsConnection.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Settings-Connection.Unsaved">"Unsaved"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_settings_connection_get_unsaved (NMDBusSettingsConnection *object)
{
  return NMDBUS_SETTINGS_CONNECTION_GET_IFACE (object)->get_unsaved (object);
}

/**
 * nmdbus_settings_connection_set_unsaved: (skip)
 * @object: A #NMDBusSettingsConnection.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Settings-Connection.Unsaved">"Unsaved"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_settings_connection_set_unsaved (NMDBusSettingsConnection *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "unsaved", value, NULL);
}

/**
 * nmdbus_settings_connection_get_flags: (skip)
 * @object: A #NMDBusSettingsConnection.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Settings-Connection.Flags">"Flags"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_settings_connection_get_flags (NMDBusSettingsConnection *object)
{
  return NMDBUS_SETTINGS_CONNECTION_GET_IFACE (object)->get_flags (object);
}

/**
 * nmdbus_settings_connection_set_flags: (skip)
 * @object: A #NMDBusSettingsConnection.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Settings-Connection.Flags">"Flags"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_settings_connection_set_flags (NMDBusSettingsConnection *object, guint value)
{
  g_object_set (G_OBJECT (object), "flags", value, NULL);
}

/**
 * nmdbus_settings_connection_get_filename: (skip)
 * @object: A #NMDBusSettingsConnection.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Settings-Connection.Filename">"Filename"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_settings_connection_dup_filename() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_settings_connection_get_filename (NMDBusSettingsConnection *object)
{
  return NMDBUS_SETTINGS_CONNECTION_GET_IFACE (object)->get_filename (object);
}

/**
 * nmdbus_settings_connection_dup_filename: (skip)
 * @object: A #NMDBusSettingsConnection.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Settings-Connection.Filename">"Filename"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_settings_connection_dup_filename (NMDBusSettingsConnection *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "filename", &value, NULL);
  return value;
}

/**
 * nmdbus_settings_connection_set_filename: (skip)
 * @object: A #NMDBusSettingsConnection.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Settings-Connection.Filename">"Filename"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_settings_connection_set_filename (NMDBusSettingsConnection *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "filename", value, NULL);
}

/**
 * nmdbus_settings_connection_emit_updated:
 * @object: A #NMDBusSettingsConnection.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager-Settings-Connection.Updated">"Updated"</link> D-Bus signal.
 */
void
nmdbus_settings_connection_emit_updated (
    NMDBusSettingsConnection *object)
{
  g_signal_emit_by_name (object, "updated");
}

/**
 * nmdbus_settings_connection_emit_removed:
 * @object: A #NMDBusSettingsConnection.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager-Settings-Connection.Removed">"Removed"</link> D-Bus signal.
 */
void
nmdbus_settings_connection_emit_removed (
    NMDBusSettingsConnection *object)
{
  g_signal_emit_by_name (object, "removed");
}

/**
 * nmdbus_settings_connection_call_update:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Update">Update()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_settings_connection_call_update_finish() to get the result of the operation.
 *
 * See nmdbus_settings_connection_call_update_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_settings_connection_call_update (
    NMDBusSettingsConnection *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Update",
    g_variant_new ("(@a{sa{sv}})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_settings_connection_call_update_finish:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_settings_connection_call_update().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_settings_connection_call_update().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_update_finish (
    NMDBusSettingsConnection *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_call_update_sync:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Update">Update()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_settings_connection_call_update() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_update_sync (
    NMDBusSettingsConnection *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Update",
    g_variant_new ("(@a{sa{sv}})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_call_update_unsaved:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.UpdateUnsaved">UpdateUnsaved()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_settings_connection_call_update_unsaved_finish() to get the result of the operation.
 *
 * See nmdbus_settings_connection_call_update_unsaved_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_settings_connection_call_update_unsaved (
    NMDBusSettingsConnection *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UpdateUnsaved",
    g_variant_new ("(@a{sa{sv}})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_settings_connection_call_update_unsaved_finish:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_settings_connection_call_update_unsaved().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_settings_connection_call_update_unsaved().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_update_unsaved_finish (
    NMDBusSettingsConnection *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_call_update_unsaved_sync:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.UpdateUnsaved">UpdateUnsaved()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_settings_connection_call_update_unsaved() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_update_unsaved_sync (
    NMDBusSettingsConnection *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UpdateUnsaved",
    g_variant_new ("(@a{sa{sv}})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_call_delete:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Delete">Delete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_settings_connection_call_delete_finish() to get the result of the operation.
 *
 * See nmdbus_settings_connection_call_delete_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_settings_connection_call_delete (
    NMDBusSettingsConnection *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_settings_connection_call_delete_finish:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_settings_connection_call_delete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_settings_connection_call_delete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_delete_finish (
    NMDBusSettingsConnection *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_call_delete_sync:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Delete">Delete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_settings_connection_call_delete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_delete_sync (
    NMDBusSettingsConnection *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_call_get_settings:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.GetSettings">GetSettings()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_settings_connection_call_get_settings_finish() to get the result of the operation.
 *
 * See nmdbus_settings_connection_call_get_settings_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_settings_connection_call_get_settings (
    NMDBusSettingsConnection *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetSettings",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_settings_connection_call_get_settings_finish:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @out_settings: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_settings_connection_call_get_settings().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_settings_connection_call_get_settings().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_get_settings_finish (
    NMDBusSettingsConnection *proxy,
    GVariant **out_settings,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sa{sv}})",
                 out_settings);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_call_get_settings_sync:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @out_settings: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.GetSettings">GetSettings()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_settings_connection_call_get_settings() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_get_settings_sync (
    NMDBusSettingsConnection *proxy,
    GVariant **out_settings,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetSettings",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sa{sv}})",
                 out_settings);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_call_get_secrets:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @arg_setting_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.GetSecrets">GetSecrets()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_settings_connection_call_get_secrets_finish() to get the result of the operation.
 *
 * See nmdbus_settings_connection_call_get_secrets_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_settings_connection_call_get_secrets (
    NMDBusSettingsConnection *proxy,
    const gchar *arg_setting_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetSecrets",
    g_variant_new ("(s)",
                   arg_setting_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_settings_connection_call_get_secrets_finish:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @out_secrets: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_settings_connection_call_get_secrets().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_settings_connection_call_get_secrets().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_get_secrets_finish (
    NMDBusSettingsConnection *proxy,
    GVariant **out_secrets,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sa{sv}})",
                 out_secrets);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_call_get_secrets_sync:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @arg_setting_name: Argument to pass with the method invocation.
 * @out_secrets: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.GetSecrets">GetSecrets()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_settings_connection_call_get_secrets() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_get_secrets_sync (
    NMDBusSettingsConnection *proxy,
    const gchar *arg_setting_name,
    GVariant **out_secrets,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetSecrets",
    g_variant_new ("(s)",
                   arg_setting_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sa{sv}})",
                 out_secrets);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_call_clear_secrets:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.ClearSecrets">ClearSecrets()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_settings_connection_call_clear_secrets_finish() to get the result of the operation.
 *
 * See nmdbus_settings_connection_call_clear_secrets_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_settings_connection_call_clear_secrets (
    NMDBusSettingsConnection *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ClearSecrets",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_settings_connection_call_clear_secrets_finish:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_settings_connection_call_clear_secrets().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_settings_connection_call_clear_secrets().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_clear_secrets_finish (
    NMDBusSettingsConnection *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_call_clear_secrets_sync:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.ClearSecrets">ClearSecrets()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_settings_connection_call_clear_secrets() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_clear_secrets_sync (
    NMDBusSettingsConnection *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ClearSecrets",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_call_save:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Save">Save()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_settings_connection_call_save_finish() to get the result of the operation.
 *
 * See nmdbus_settings_connection_call_save_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_settings_connection_call_save (
    NMDBusSettingsConnection *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Save",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_settings_connection_call_save_finish:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_settings_connection_call_save().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_settings_connection_call_save().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_save_finish (
    NMDBusSettingsConnection *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_call_save_sync:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Save">Save()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_settings_connection_call_save() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_save_sync (
    NMDBusSettingsConnection *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Save",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_call_update2:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @arg_settings: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_args: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Update2">Update2()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_settings_connection_call_update2_finish() to get the result of the operation.
 *
 * See nmdbus_settings_connection_call_update2_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_settings_connection_call_update2 (
    NMDBusSettingsConnection *proxy,
    GVariant *arg_settings,
    guint arg_flags,
    GVariant *arg_args,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Update2",
    g_variant_new ("(@a{sa{sv}}u@a{sv})",
                   arg_settings,
                   arg_flags,
                   arg_args),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_settings_connection_call_update2_finish:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_settings_connection_call_update2().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_settings_connection_call_update2().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_update2_finish (
    NMDBusSettingsConnection *proxy,
    GVariant **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_call_update2_sync:
 * @proxy: A #NMDBusSettingsConnectionProxy.
 * @arg_settings: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_args: Argument to pass with the method invocation.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Update2">Update2()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_settings_connection_call_update2() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_settings_connection_call_update2_sync (
    NMDBusSettingsConnection *proxy,
    GVariant *arg_settings,
    guint arg_flags,
    GVariant *arg_args,
    GVariant **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Update2",
    g_variant_new ("(@a{sa{sv}}u@a{sv})",
                   arg_settings,
                   arg_flags,
                   arg_args),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_settings_connection_complete_update:
 * @object: A #NMDBusSettingsConnection.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Update">Update()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_settings_connection_complete_update (
    NMDBusSettingsConnection *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_settings_connection_complete_update_unsaved:
 * @object: A #NMDBusSettingsConnection.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.UpdateUnsaved">UpdateUnsaved()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_settings_connection_complete_update_unsaved (
    NMDBusSettingsConnection *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_settings_connection_complete_delete:
 * @object: A #NMDBusSettingsConnection.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Delete">Delete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_settings_connection_complete_delete (
    NMDBusSettingsConnection *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_settings_connection_complete_get_settings:
 * @object: A #NMDBusSettingsConnection.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @settings: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.GetSettings">GetSettings()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_settings_connection_complete_get_settings (
    NMDBusSettingsConnection *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *settings)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sa{sv}})",
                   settings));
}

/**
 * nmdbus_settings_connection_complete_get_secrets:
 * @object: A #NMDBusSettingsConnection.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @secrets: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.GetSecrets">GetSecrets()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_settings_connection_complete_get_secrets (
    NMDBusSettingsConnection *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *secrets)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sa{sv}})",
                   secrets));
}

/**
 * nmdbus_settings_connection_complete_clear_secrets:
 * @object: A #NMDBusSettingsConnection.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.ClearSecrets">ClearSecrets()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_settings_connection_complete_clear_secrets (
    NMDBusSettingsConnection *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_settings_connection_complete_save:
 * @object: A #NMDBusSettingsConnection.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Save">Save()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_settings_connection_complete_save (
    NMDBusSettingsConnection *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_settings_connection_complete_update2:
 * @object: A #NMDBusSettingsConnection.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Settings-Connection.Update2">Update2()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_settings_connection_complete_update2 (
    NMDBusSettingsConnection *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   result));
}

/* ------------------------------------------------------------------------ */

/**
 * NMDBusSettingsConnectionProxy:
 *
 * The #NMDBusSettingsConnectionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusSettingsConnectionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusSettingsConnectionProxy.
 */

struct _NMDBusSettingsConnectionProxyPrivate
{
  GData *qdata;
};

static void nmdbus_settings_connection_proxy_iface_init (NMDBusSettingsConnectionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusSettingsConnectionProxy, nmdbus_settings_connection_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NMDBusSettingsConnectionProxy)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_SETTINGS_CONNECTION, nmdbus_settings_connection_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusSettingsConnectionProxy, nmdbus_settings_connection_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_SETTINGS_CONNECTION, nmdbus_settings_connection_proxy_iface_init))

#endif
static void
nmdbus_settings_connection_proxy_finalize (GObject *object)
{
  NMDBusSettingsConnectionProxy *proxy = NMDBUS_SETTINGS_CONNECTION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (nmdbus_settings_connection_proxy_parent_class)->finalize (object);
}

static void
nmdbus_settings_connection_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_settings_connection_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
nmdbus_settings_connection_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.NetworkManager.Settings.Connection: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
nmdbus_settings_connection_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_settings_connection_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.NetworkManager.Settings.Connection", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) nmdbus_settings_connection_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
nmdbus_settings_connection_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_nmdbus_settings_connection_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NMDBUS_TYPE_SETTINGS_CONNECTION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_SETTINGS_CONNECTION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
nmdbus_settings_connection_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NMDBusSettingsConnectionProxy *proxy = NMDBUS_SETTINGS_CONNECTION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_settings_connection_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_settings_connection_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
nmdbus_settings_connection_proxy_get_unsaved (NMDBusSettingsConnection *object)
{
  NMDBusSettingsConnectionProxy *proxy = NMDBUS_SETTINGS_CONNECTION_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Unsaved");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_settings_connection_proxy_get_flags (NMDBusSettingsConnection *object)
{
  NMDBusSettingsConnectionProxy *proxy = NMDBUS_SETTINGS_CONNECTION_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Flags");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_settings_connection_proxy_get_filename (NMDBusSettingsConnection *object)
{
  NMDBusSettingsConnectionProxy *proxy = NMDBUS_SETTINGS_CONNECTION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Filename");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
nmdbus_settings_connection_proxy_init (NMDBusSettingsConnectionProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = nmdbus_settings_connection_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NMDBUS_TYPE_SETTINGS_CONNECTION_PROXY, NMDBusSettingsConnectionProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), nmdbus_settings_connection_interface_info ());
}

static void
nmdbus_settings_connection_proxy_class_init (NMDBusSettingsConnectionProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = nmdbus_settings_connection_proxy_finalize;
  gobject_class->get_property = nmdbus_settings_connection_proxy_get_property;
  gobject_class->set_property = nmdbus_settings_connection_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = nmdbus_settings_connection_proxy_g_signal;
  proxy_class->g_properties_changed = nmdbus_settings_connection_proxy_g_properties_changed;

  nmdbus_settings_connection_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusSettingsConnectionProxyPrivate));
#endif
}

static void
nmdbus_settings_connection_proxy_iface_init (NMDBusSettingsConnectionIface *iface)
{
  iface->get_unsaved = nmdbus_settings_connection_proxy_get_unsaved;
  iface->get_flags = nmdbus_settings_connection_proxy_get_flags;
  iface->get_filename = nmdbus_settings_connection_proxy_get_filename;
}

/**
 * nmdbus_settings_connection_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Settings-Connection.top_of_page">org.freedesktop.NetworkManager.Settings.Connection</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_settings_connection_proxy_new_finish() to get the result of the operation.
 *
 * See nmdbus_settings_connection_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_settings_connection_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_SETTINGS_CONNECTION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Settings.Connection", NULL);
}

/**
 * nmdbus_settings_connection_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_settings_connection_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_settings_connection_proxy_new().
 *
 * Returns: (transfer full) (type NMDBusSettingsConnectionProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusSettingsConnection *
nmdbus_settings_connection_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_SETTINGS_CONNECTION (ret);
  else
    return NULL;
}

/**
 * nmdbus_settings_connection_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Settings-Connection.top_of_page">org.freedesktop.NetworkManager.Settings.Connection</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_settings_connection_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusSettingsConnectionProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusSettingsConnection *
nmdbus_settings_connection_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_SETTINGS_CONNECTION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Settings.Connection", NULL);
  if (ret != NULL)
    return NMDBUS_SETTINGS_CONNECTION (ret);
  else
    return NULL;
}


/**
 * nmdbus_settings_connection_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like nmdbus_settings_connection_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_settings_connection_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See nmdbus_settings_connection_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_settings_connection_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_SETTINGS_CONNECTION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Settings.Connection", NULL);
}

/**
 * nmdbus_settings_connection_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_settings_connection_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_settings_connection_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NMDBusSettingsConnectionProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusSettingsConnection *
nmdbus_settings_connection_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_SETTINGS_CONNECTION (ret);
  else
    return NULL;
}

/**
 * nmdbus_settings_connection_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like nmdbus_settings_connection_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_settings_connection_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusSettingsConnectionProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusSettingsConnection *
nmdbus_settings_connection_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_SETTINGS_CONNECTION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Settings.Connection", NULL);
  if (ret != NULL)
    return NMDBUS_SETTINGS_CONNECTION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NMDBusSettingsConnectionSkeleton:
 *
 * The #NMDBusSettingsConnectionSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusSettingsConnectionSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusSettingsConnectionSkeleton.
 */

struct _NMDBusSettingsConnectionSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_nmdbus_settings_connection_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NMDBusSettingsConnectionSkeleton *skeleton = NMDBUS_SETTINGS_CONNECTION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NMDBUS_TYPE_SETTINGS_CONNECTION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_SETTINGS_CONNECTION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_nmdbus_settings_connection_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NMDBusSettingsConnectionSkeleton *skeleton = NMDBUS_SETTINGS_CONNECTION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_settings_connection_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_nmdbus_settings_connection_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NMDBusSettingsConnectionSkeleton *skeleton = NMDBUS_SETTINGS_CONNECTION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_settings_connection_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _nmdbus_settings_connection_skeleton_vtable =
{
  _nmdbus_settings_connection_skeleton_handle_method_call,
  _nmdbus_settings_connection_skeleton_handle_get_property,
  _nmdbus_settings_connection_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
nmdbus_settings_connection_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return nmdbus_settings_connection_interface_info ();
}

static GDBusInterfaceVTable *
nmdbus_settings_connection_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_nmdbus_settings_connection_skeleton_vtable;
}

static GVariant *
nmdbus_settings_connection_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusSettingsConnectionSkeleton *skeleton = NMDBUS_SETTINGS_CONNECTION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_nmdbus_settings_connection_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _nmdbus_settings_connection_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _nmdbus_settings_connection_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _nmdbus_settings_connection_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.Settings.Connection", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _nmdbus_settings_connection_emit_changed (gpointer user_data);

static void
nmdbus_settings_connection_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusSettingsConnectionSkeleton *skeleton = NMDBUS_SETTINGS_CONNECTION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _nmdbus_settings_connection_emit_changed (skeleton);
}

static void
_nmdbus_settings_connection_on_signal_updated (
    NMDBusSettingsConnection *object)
{
  NMDBusSettingsConnectionSkeleton *skeleton = NMDBUS_SETTINGS_CONNECTION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.Settings.Connection", "Updated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_nmdbus_settings_connection_on_signal_removed (
    NMDBusSettingsConnection *object)
{
  NMDBusSettingsConnectionSkeleton *skeleton = NMDBUS_SETTINGS_CONNECTION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.Settings.Connection", "Removed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void nmdbus_settings_connection_skeleton_iface_init (NMDBusSettingsConnectionIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusSettingsConnectionSkeleton, nmdbus_settings_connection_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NMDBusSettingsConnectionSkeleton)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_SETTINGS_CONNECTION, nmdbus_settings_connection_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusSettingsConnectionSkeleton, nmdbus_settings_connection_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_SETTINGS_CONNECTION, nmdbus_settings_connection_skeleton_iface_init))

#endif
static void
nmdbus_settings_connection_skeleton_finalize (GObject *object)
{
  NMDBusSettingsConnectionSkeleton *skeleton = NMDBUS_SETTINGS_CONNECTION_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (nmdbus_settings_connection_skeleton_parent_class)->finalize (object);
}

static void
nmdbus_settings_connection_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  NMDBusSettingsConnectionSkeleton *skeleton = NMDBUS_SETTINGS_CONNECTION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_nmdbus_settings_connection_emit_changed (gpointer user_data)
{
  NMDBusSettingsConnectionSkeleton *skeleton = NMDBUS_SETTINGS_CONNECTION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.NetworkManager.Settings.Connection",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_nmdbus_settings_connection_schedule_emit_changed (NMDBusSettingsConnectionSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
nmdbus_settings_connection_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  NMDBusSettingsConnectionSkeleton *skeleton = NMDBUS_SETTINGS_CONNECTION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _nmdbus_settings_connection_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _nmdbus_settings_connection_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
nmdbus_settings_connection_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  NMDBusSettingsConnectionSkeleton *skeleton = NMDBUS_SETTINGS_CONNECTION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_settings_connection_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _nmdbus_settings_connection_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
nmdbus_settings_connection_skeleton_init (NMDBusSettingsConnectionSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = nmdbus_settings_connection_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NMDBUS_TYPE_SETTINGS_CONNECTION_SKELETON, NMDBusSettingsConnectionSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
}

static gboolean 
nmdbus_settings_connection_skeleton_get_unsaved (NMDBusSettingsConnection *object)
{
  NMDBusSettingsConnectionSkeleton *skeleton = NMDBUS_SETTINGS_CONNECTION_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_settings_connection_skeleton_get_flags (NMDBusSettingsConnection *object)
{
  NMDBusSettingsConnectionSkeleton *skeleton = NMDBUS_SETTINGS_CONNECTION_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_settings_connection_skeleton_get_filename (NMDBusSettingsConnection *object)
{
  NMDBusSettingsConnectionSkeleton *skeleton = NMDBUS_SETTINGS_CONNECTION_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
nmdbus_settings_connection_skeleton_class_init (NMDBusSettingsConnectionSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = nmdbus_settings_connection_skeleton_finalize;
  gobject_class->get_property = nmdbus_settings_connection_skeleton_get_property;
  gobject_class->set_property = nmdbus_settings_connection_skeleton_set_property;
  gobject_class->notify       = nmdbus_settings_connection_skeleton_notify;


  nmdbus_settings_connection_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = nmdbus_settings_connection_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = nmdbus_settings_connection_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = nmdbus_settings_connection_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = nmdbus_settings_connection_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusSettingsConnectionSkeletonPrivate));
#endif
}

static void
nmdbus_settings_connection_skeleton_iface_init (NMDBusSettingsConnectionIface *iface)
{
  iface->updated = _nmdbus_settings_connection_on_signal_updated;
  iface->removed = _nmdbus_settings_connection_on_signal_removed;
  iface->get_unsaved = nmdbus_settings_connection_skeleton_get_unsaved;
  iface->get_flags = nmdbus_settings_connection_skeleton_get_flags;
  iface->get_filename = nmdbus_settings_connection_skeleton_get_filename;
}

/**
 * nmdbus_settings_connection_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Settings-Connection.top_of_page">org.freedesktop.NetworkManager.Settings.Connection</link>.
 *
 * Returns: (transfer full) (type NMDBusSettingsConnectionSkeleton): The skeleton object.
 */
NMDBusSettingsConnection *
nmdbus_settings_connection_skeleton_new (void)
{
  return NMDBUS_SETTINGS_CONNECTION (g_object_new (NMDBUS_TYPE_SETTINGS_CONNECTION_SKELETON, NULL));
}

