/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletResponseWrapper;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.util.IOTools;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.URLEncoder;
import org.apache.catalina.webresources.CachedResource;
import org.apache.coyote.Constants;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.http.ResponseUtil;
import org.apache.tomcat.util.http.parser.ContentRange;
import org.apache.tomcat.util.http.parser.EntityTag;
import org.apache.tomcat.util.http.parser.Ranges;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.Escape;
import org.apache.tomcat.util.security.PrivilegedGetTccl;
import org.apache.tomcat.util.security.PrivilegedSetTccl;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class DefaultServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static final StringManager sm = StringManager.getManager(DefaultServlet.class);
    private static final DocumentBuilderFactory factory;
    private static final SecureEntityResolver secureEntityResolver;
    protected static final Ranges FULL;
    private static final ContentRange IGNORE;
    protected static final String mimeSeparation = "CATALINA_MIME_BOUNDARY";
    protected static final int BUFFER_SIZE = 4096;
    protected int debug = 0;
    protected int input = 2048;
    protected boolean listings = false;
    protected boolean readOnly = true;
    protected CompressionFormat[] compressionFormats;
    protected int output = 2048;
    protected String localXsltFile = null;
    protected String contextXsltFile = null;
    protected String globalXsltFile = null;
    protected String readmeFile = null;
    protected transient WebResourceRoot resources = null;
    protected String fileEncoding = null;
    private transient Charset fileEncodingCharset = null;
    private BomConfig useBomIfPresent = null;
    protected int sendfileSize = 49152;
    protected boolean useAcceptRanges = true;
    protected boolean showServerInfo = true;
    protected boolean sortListings = false;
    protected transient SortManager sortManager;
    private boolean allowPartialPut = true;

    public void destroy() {
    }

    /*
     * WARNING - void declaration
     */
    public void init() throws ServletException {
        if (this.getServletConfig().getInitParameter("debug") != null) {
            this.debug = Integer.parseInt(this.getServletConfig().getInitParameter("debug"));
        }
        if (this.getServletConfig().getInitParameter("input") != null) {
            this.input = Integer.parseInt(this.getServletConfig().getInitParameter("input"));
        }
        if (this.getServletConfig().getInitParameter("output") != null) {
            this.output = Integer.parseInt(this.getServletConfig().getInitParameter("output"));
        }
        this.listings = Boolean.parseBoolean(this.getServletConfig().getInitParameter("listings"));
        if (this.getServletConfig().getInitParameter("readonly") != null) {
            this.readOnly = Boolean.parseBoolean(this.getServletConfig().getInitParameter("readonly"));
        }
        this.compressionFormats = this.parseCompressionFormats(this.getServletConfig().getInitParameter("precompressed"), this.getServletConfig().getInitParameter("gzip"));
        if (this.getServletConfig().getInitParameter("sendfileSize") != null) {
            this.sendfileSize = Integer.parseInt(this.getServletConfig().getInitParameter("sendfileSize")) * 1024;
        }
        this.fileEncoding = this.getServletConfig().getInitParameter("fileEncoding");
        if (this.fileEncoding == null) {
            this.fileEncodingCharset = Charset.defaultCharset();
            this.fileEncoding = this.fileEncodingCharset.name();
        } else {
            try {
                this.fileEncodingCharset = B2CConverter.getCharset((String)this.fileEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ServletException((Throwable)unsupportedEncodingException);
            }
        }
        String string = this.getServletConfig().getInitParameter("useBomIfPresent");
        if (string == null) {
            this.useBomIfPresent = BomConfig.TRUE;
        } else {
            for (BomConfig bomConfig : BomConfig.values()) {
                if (!bomConfig.configurationValue.equalsIgnoreCase(string)) continue;
                this.useBomIfPresent = bomConfig;
                break;
            }
            if (this.useBomIfPresent == null) {
                IllegalArgumentException bl = new IllegalArgumentException(sm.getString("defaultServlet.unknownBomConfig", new Object[]{string}));
                throw new ServletException((Throwable)bl);
            }
        }
        this.globalXsltFile = this.getServletConfig().getInitParameter("globalXsltFile");
        this.contextXsltFile = this.getServletConfig().getInitParameter("contextXsltFile");
        this.localXsltFile = this.getServletConfig().getInitParameter("localXsltFile");
        this.readmeFile = this.getServletConfig().getInitParameter("readmeFile");
        if (this.getServletConfig().getInitParameter("useAcceptRanges") != null) {
            this.useAcceptRanges = Boolean.parseBoolean(this.getServletConfig().getInitParameter("useAcceptRanges"));
        }
        if (this.input < 256) {
            this.input = 256;
        }
        if (this.output < 256) {
            this.output = 256;
        }
        if (this.debug > 0) {
            this.log("DefaultServlet.init:  input buffer size=" + this.input + ", output buffer size=" + this.output);
        }
        this.resources = (WebResourceRoot)this.getServletContext().getAttribute("org.apache.catalina.resources");
        if (this.resources == null) {
            throw new UnavailableException(sm.getString("defaultServlet.noResources"));
        }
        if (this.getServletConfig().getInitParameter("showServerInfo") != null) {
            this.showServerInfo = Boolean.parseBoolean(this.getServletConfig().getInitParameter("showServerInfo"));
        }
        if (this.getServletConfig().getInitParameter("sortListings") != null) {
            this.sortListings = Boolean.parseBoolean(this.getServletConfig().getInitParameter("sortListings"));
            if (this.sortListings) {
                void var2_7;
                if (this.getServletConfig().getInitParameter("sortDirectoriesFirst") != null) {
                    boolean bl = Boolean.parseBoolean(this.getServletConfig().getInitParameter("sortDirectoriesFirst"));
                } else {
                    boolean bl = false;
                }
                this.sortManager = new SortManager((boolean)var2_7);
            }
        }
        if (this.getServletConfig().getInitParameter("allowPartialPut") != null) {
            this.allowPartialPut = Boolean.parseBoolean(this.getServletConfig().getInitParameter("allowPartialPut"));
        }
    }

    private CompressionFormat[] parseCompressionFormats(String string, String string2) {
        ArrayList<CompressionFormat> arrayList = new ArrayList<CompressionFormat>();
        if (string != null && string.indexOf(61) > 0) {
            for (String string3 : string.split(",")) {
                String[] stringArray = string3.split("=");
                String string4 = stringArray[0];
                String string5 = stringArray[1];
                arrayList.add(new CompressionFormat(string5, string4));
            }
        } else if (string != null) {
            if (Boolean.parseBoolean(string)) {
                arrayList.add(new CompressionFormat(".br", "br"));
                arrayList.add(new CompressionFormat(".gz", "gzip"));
            }
        } else if (Boolean.parseBoolean(string2)) {
            arrayList.add(new CompressionFormat(".gz", "gzip"));
        }
        return arrayList.toArray(new CompressionFormat[0]);
    }

    protected String getRelativePath(HttpServletRequest httpServletRequest) {
        return this.getRelativePath(httpServletRequest, false);
    }

    protected String getRelativePath(HttpServletRequest httpServletRequest, boolean bl) {
        String string;
        String string2;
        if (httpServletRequest.getAttribute("jakarta.servlet.include.request_uri") != null) {
            string2 = (String)httpServletRequest.getAttribute("jakarta.servlet.include.path_info");
            string = (String)httpServletRequest.getAttribute("jakarta.servlet.include.servlet_path");
        } else {
            string2 = httpServletRequest.getPathInfo();
            string = httpServletRequest.getServletPath();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() > 0) {
            stringBuilder.append(string);
        }
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        if (stringBuilder.length() == 0 && !bl) {
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    protected String getPathPrefix(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getContextPath();
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (httpServletRequest.getDispatcherType() == DispatcherType.ERROR) {
            this.doGet(httpServletRequest, httpServletResponse);
        } else {
            super.service(httpServletRequest, httpServletResponse);
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.serveResource(httpServletRequest, httpServletResponse, true, this.fileEncoding);
    }

    protected void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        boolean bl = DispatcherType.INCLUDE.equals((Object)httpServletRequest.getDispatcherType());
        this.serveResource(httpServletRequest, httpServletResponse, bl, this.fileEncoding);
    }

    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setHeader("Allow", this.determineMethodsAllowed(httpServletRequest));
    }

    protected String determineMethodsAllowed(HttpServletRequest httpServletRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OPTIONS, GET, HEAD, POST");
        if (!this.readOnly) {
            stringBuilder.append(", PUT, DELETE");
        }
        if (httpServletRequest instanceof RequestFacade && ((RequestFacade)httpServletRequest).getAllowTrace()) {
            stringBuilder.append(", TRACE");
        }
        return stringBuilder.toString();
    }

    protected void sendNotAllowed(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.addHeader("Allow", this.determineMethodsAllowed(httpServletRequest));
        httpServletResponse.sendError(405);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        WebResource webResource = this.resources.getResource(string);
        ContentRange contentRange = this.parseContentRange(httpServletRequest, httpServletResponse);
        if (contentRange == null) {
            return;
        }
        Object object = null;
        try {
            if (contentRange == IGNORE) {
                object = httpServletRequest.getInputStream();
            } else {
                File file = this.executePartialPut(httpServletRequest, contentRange, string);
                object = new FileInputStream(file);
            }
            if (this.resources.write(string, (InputStream)object, true)) {
                if (webResource.exists()) {
                    httpServletResponse.setStatus(204);
                } else {
                    httpServletResponse.setStatus(201);
                }
            } else {
                httpServletResponse.sendError(409);
            }
        }
        finally {
            if (object != null) {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected File executePartialPut(HttpServletRequest httpServletRequest, ContentRange contentRange, String string) throws IOException {
        String string2;
        File file = (File)this.getServletContext().getAttribute("jakarta.servlet.context.tempdir");
        File file2 = new File(file, string2 = string.replace('/', '.'));
        if (file2.createNewFile()) {
            file2.deleteOnExit();
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");){
            Object object;
            Object object2;
            WebResource webResource = this.resources.getResource(string);
            if (webResource.isFile()) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(webResource.getInputStream(), 4096);
                object2 = null;
                try {
                    int n;
                    object = new byte[4096];
                    while ((n = bufferedInputStream.read((byte[])object)) != -1) {
                        randomAccessFile.write((byte[])object, 0, n);
                    }
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    if (bufferedInputStream != null) {
                        if (object2 != null) {
                            try {
                                bufferedInputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object2).addSuppressed(throwable);
                            }
                        } else {
                            bufferedInputStream.close();
                        }
                    }
                }
            }
            randomAccessFile.setLength(contentRange.getLength());
            randomAccessFile.seek(contentRange.getStart());
            object2 = new byte[4096];
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)httpServletRequest.getInputStream(), 4096);
            object = null;
            try {
                int n;
                while ((n = bufferedInputStream.read((byte[])object2)) != -1) {
                    randomAccessFile.write((byte[])object2, 0, n);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (bufferedInputStream != null) {
                    if (object != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        bufferedInputStream.close();
                    }
                }
            }
        }
        return file2;
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        WebResource webResource = this.resources.getResource(string);
        if (webResource.exists()) {
            if (webResource.delete()) {
                httpServletResponse.setStatus(204);
            } else {
                httpServletResponse.sendError(405);
            }
        } else {
            httpServletResponse.sendError(404);
        }
    }

    protected boolean checkIfHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WebResource webResource) throws IOException {
        return this.checkIfMatch(httpServletRequest, httpServletResponse, webResource) && this.checkIfModifiedSince(httpServletRequest, httpServletResponse, webResource) && this.checkIfNoneMatch(httpServletRequest, httpServletResponse, webResource) && this.checkIfUnmodifiedSince(httpServletRequest, httpServletResponse, webResource);
    }

    protected String rewriteUrl(String string) {
        return URLEncoder.DEFAULT.encode(string, StandardCharsets.UTF_8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void serveResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, String string) throws IOException, ServletException {
        boolean bl2;
        boolean bl3;
        Object object;
        String string2;
        boolean bl4;
        boolean bl5 = bl;
        String string3 = this.getRelativePath(httpServletRequest, true);
        if (this.debug > 0) {
            if (bl5) {
                this.log("DefaultServlet.serveResource:  Serving resource '" + string3 + "' headers and data");
            } else {
                this.log("DefaultServlet.serveResource:  Serving resource '" + string3 + "' headers only");
            }
        }
        if (string3.length() == 0) {
            this.doDirectoryRedirect(httpServletRequest, httpServletResponse);
            return;
        }
        WebResource webResource = this.resources.getResource(string3);
        boolean bl6 = bl4 = DispatcherType.ERROR == httpServletRequest.getDispatcherType();
        if (!webResource.exists()) {
            String string4 = (String)httpServletRequest.getAttribute("jakarta.servlet.include.request_uri");
            if (string4 != null) {
                throw new FileNotFoundException(sm.getString("defaultServlet.missingResource", new Object[]{string4}));
            }
            string4 = httpServletRequest.getRequestURI();
            if (bl4) {
                httpServletResponse.sendError(((Integer)httpServletRequest.getAttribute("jakarta.servlet.error.status_code")).intValue());
                return;
            } else {
                httpServletResponse.sendError(404, sm.getString("defaultServlet.missingResource", new Object[]{string4}));
            }
            return;
        }
        if (!webResource.canRead()) {
            String string5 = (String)httpServletRequest.getAttribute("jakarta.servlet.include.request_uri");
            if (string5 != null) {
                throw new FileNotFoundException(sm.getString("defaultServlet.missingResource", new Object[]{string5}));
            }
            string5 = httpServletRequest.getRequestURI();
            if (bl4) {
                httpServletResponse.sendError(((Integer)httpServletRequest.getAttribute("jakarta.servlet.error.status_code")).intValue());
                return;
            } else {
                httpServletResponse.sendError(403, string5);
            }
            return;
        }
        boolean bl7 = false;
        if (webResource.isFile()) {
            boolean bl8 = bl7 = httpServletRequest.getAttribute("jakarta.servlet.include.context_path") != null;
            if (!(bl7 || bl4 || this.checkIfHeaders(httpServletRequest, httpServletResponse, webResource))) {
                return;
            }
        }
        if ((string2 = webResource.getMimeType()) == null) {
            string2 = this.getServletContext().getMimeType(webResource.getName());
            webResource.setMimeType(string2);
        }
        String string6 = null;
        String string7 = null;
        if (webResource.isFile() && !bl4) {
            string6 = this.generateETag(webResource);
            string7 = webResource.getLastModifiedHttp();
        }
        boolean bl9 = false;
        if (this.compressionFormats.length > 0 && !bl7 && webResource.isFile() && !this.pathEndsWithCompressedExtension(string3) && !(object = this.getAvailablePrecompressedResources(string3)).isEmpty()) {
            ResponseUtil.addVaryFieldName((HttpServletResponse)httpServletResponse, (String)"accept-encoding");
            PrecompressedResource precompressedResource = this.getBestPrecompressedResource(httpServletRequest, (List<PrecompressedResource>)object);
            if (precompressedResource != null) {
                httpServletResponse.addHeader("Content-Encoding", precompressedResource.format.encoding);
                webResource = precompressedResource.resource;
                bl9 = true;
            }
        }
        object = FULL;
        long l = -1L;
        if (webResource.isDirectory()) {
            if (!string3.endsWith("/")) {
                this.doDirectoryRedirect(httpServletRequest, httpServletResponse);
                return;
            }
            if (!this.listings) {
                httpServletResponse.sendError(404, sm.getString("defaultServlet.missingResource", new Object[]{httpServletRequest.getRequestURI()}));
                return;
            }
            string2 = "text/html;charset=UTF-8";
        } else {
            if (!bl4) {
                if (this.useAcceptRanges) {
                    httpServletResponse.setHeader("Accept-Ranges", "bytes");
                }
                if ((object = this.parseRange(httpServletRequest, httpServletResponse, webResource)) == null) {
                    return;
                }
                httpServletResponse.setHeader("ETag", string6);
                httpServletResponse.setHeader("Last-Modified", string7);
            }
            if ((l = webResource.getContentLength()) == 0L) {
                bl5 = false;
            }
        }
        ServletOutputStream servletOutputStream = null;
        PrintWriter printWriter = null;
        if (bl5) {
            try {
                servletOutputStream = httpServletResponse.getOutputStream();
            }
            catch (IllegalStateException illegalStateException) {
                if (bl9 || !DefaultServlet.isText(string2)) throw illegalStateException;
                printWriter = httpServletResponse.getWriter();
                object = FULL;
            }
        }
        HttpServletResponse httpServletResponse2 = httpServletResponse;
        long l2 = 0L;
        while (httpServletResponse2 instanceof ServletResponseWrapper) {
            httpServletResponse2 = ((ServletResponseWrapper)httpServletResponse2).getResponse();
        }
        if (httpServletResponse2 instanceof ResponseFacade) {
            l2 = ((ResponseFacade)httpServletResponse2).getContentWritten();
        }
        if (l2 > 0L) {
            object = FULL;
        }
        String string8 = httpServletResponse.getCharacterEncoding();
        Charset charset = B2CConverter.getCharset((String)string8);
        boolean bl10 = bl3 = string8 != Constants.DEFAULT_BODY_CHARSET.name() && string8 != this.resources.getContext().getResponseCharacterEncoding();
        if (!bl9 && DefaultServlet.isText(string2) && bl3 && !charset.equals(this.fileEncodingCharset)) {
            bl2 = true;
            object = FULL;
        } else {
            bl2 = false;
        }
        if (webResource.isDirectory() || bl4 || object == FULL) {
            if (string2 != null) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentType='" + string2 + "'");
                }
                if (httpServletResponse.getContentType() == null) {
                    httpServletResponse.setContentType(string2);
                }
            }
            if (webResource.isFile() && l >= 0L && (!bl5 || servletOutputStream != null)) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentLength=" + l);
                }
                if (l2 == 0L && !bl2) {
                    httpServletResponse.setContentLengthLong(l);
                }
            }
            if (!bl5) return;
            try {
                httpServletResponse.setBufferSize(this.output);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            InputStream inputStream = null;
            if (servletOutputStream == null) {
                if (webResource.isDirectory()) {
                    inputStream = this.render(httpServletRequest, this.getPathPrefix(httpServletRequest), webResource, string);
                } else {
                    inputStream = webResource.getInputStream();
                    if (bl7) {
                        Charset charset2;
                        if (!inputStream.markSupported()) {
                            inputStream = new BufferedInputStream(inputStream);
                        }
                        if ((charset2 = DefaultServlet.processBom(inputStream, this.useBomIfPresent.stripBom)) != null && this.useBomIfPresent.useBomEncoding) {
                            string = charset2.name();
                        }
                    }
                }
                this.copy(inputStream, printWriter, string);
                return;
            } else {
                if (webResource.isDirectory()) {
                    inputStream = this.render(httpServletRequest, this.getPathPrefix(httpServletRequest), webResource, string);
                } else if (bl2 || bl7) {
                    Charset charset3;
                    InputStream inputStream2 = webResource.getInputStream();
                    if (!inputStream2.markSupported()) {
                        inputStream2 = new BufferedInputStream(inputStream2);
                    }
                    if ((charset3 = DefaultServlet.processBom(inputStream2, this.useBomIfPresent.stripBom)) != null && this.useBomIfPresent.useBomEncoding) {
                        string = charset3.name();
                    }
                    if (bl3) {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)servletOutputStream, charset);
                        PrintWriter printWriter2 = new PrintWriter(outputStreamWriter);
                        this.copy(inputStream2, printWriter2, string);
                        printWriter2.flush();
                    } else {
                        inputStream = inputStream2;
                    }
                } else if (!this.checkSendfile(httpServletRequest, httpServletResponse, webResource, l, null)) {
                    byte[] byArray = null;
                    if (webResource instanceof CachedResource) {
                        byArray = webResource.getContent();
                    }
                    if (byArray == null) {
                        inputStream = webResource.getInputStream();
                    } else {
                        servletOutputStream.write(byArray);
                    }
                }
                if (inputStream == null) return;
                this.copy(inputStream, servletOutputStream);
            }
            return;
        }
        if (object == null || object.getEntries().isEmpty()) {
            return;
        }
        httpServletResponse.setStatus(206);
        if (object.getEntries().size() == 1) {
            Ranges.Entry entry = (Ranges.Entry)object.getEntries().get(0);
            long l3 = DefaultServlet.getStart(entry, l);
            long l4 = DefaultServlet.getEnd(entry, l);
            httpServletResponse.addHeader("Content-Range", "bytes " + l3 + "-" + l4 + "/" + l);
            long l5 = l4 - l3 + 1L;
            httpServletResponse.setContentLengthLong(l5);
            if (string2 != null) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentType='" + string2 + "'");
                }
                httpServletResponse.setContentType(string2);
            }
            if (!bl5) return;
            try {
                httpServletResponse.setBufferSize(this.output);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (servletOutputStream == null) throw new IllegalStateException();
            if (this.checkSendfile(httpServletRequest, httpServletResponse, webResource, l, entry)) return;
            this.copy(webResource, l, servletOutputStream, entry);
            return;
        }
        httpServletResponse.setContentType("multipart/byteranges; boundary=CATALINA_MIME_BOUNDARY");
        if (!bl5) return;
        try {
            httpServletResponse.setBufferSize(this.output);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (servletOutputStream == null) throw new IllegalStateException();
        this.copy(webResource, l, servletOutputStream, (Ranges)object, string2);
    }

    private static Charset processBom(InputStream inputStream, boolean bl) throws IOException {
        byte[] byArray = new byte[4];
        inputStream.mark(byArray.length);
        int n = inputStream.read(byArray);
        if (n < 2) {
            DefaultServlet.skip(inputStream, 0, bl);
            return null;
        }
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        if (n2 == 254 && n3 == 255) {
            DefaultServlet.skip(inputStream, 2, bl);
            return StandardCharsets.UTF_16BE;
        }
        if (n == 2 && n2 == 255 && n3 == 254) {
            DefaultServlet.skip(inputStream, 2, bl);
            return StandardCharsets.UTF_16LE;
        }
        if (n < 3) {
            DefaultServlet.skip(inputStream, 0, bl);
            return null;
        }
        int n4 = byArray[2] & 0xFF;
        if (n2 == 239 && n3 == 187 && n4 == 191) {
            DefaultServlet.skip(inputStream, 3, bl);
            return StandardCharsets.UTF_8;
        }
        if (n < 4) {
            DefaultServlet.skip(inputStream, 0, bl);
            return null;
        }
        int n5 = byArray[3] & 0xFF;
        if (n2 == 0 && n3 == 0 && n4 == 254 && n5 == 255) {
            return Charset.forName("UTF-32BE");
        }
        if (n2 == 255 && n3 == 254 && n4 == 0 && n5 == 0) {
            return Charset.forName("UTF-32LE");
        }
        if (n2 == 255 && n3 == 254) {
            DefaultServlet.skip(inputStream, 2, bl);
            return StandardCharsets.UTF_16LE;
        }
        DefaultServlet.skip(inputStream, 0, bl);
        return null;
    }

    private static void skip(InputStream inputStream, int n, boolean bl) throws IOException {
        inputStream.reset();
        if (bl) {
            while (n-- > 0) {
                inputStream.read();
            }
        }
    }

    private static boolean isText(String string) {
        return string == null || string.startsWith("text") || string.endsWith("xml") || string.contains("/javascript");
    }

    private static boolean validate(ContentRange contentRange) {
        return contentRange != null && "bytes".equals(contentRange.getUnits()) && contentRange.getStart() >= 0L && contentRange.getEnd() >= 0L && contentRange.getStart() <= contentRange.getEnd() && contentRange.getLength() > 0L;
    }

    private static boolean validate(Ranges.Entry entry, long l) {
        long l2 = DefaultServlet.getStart(entry, l);
        long l3 = DefaultServlet.getEnd(entry, l);
        return l2 >= 0L && l3 >= 0L && l2 <= l3;
    }

    private static long getStart(Ranges.Entry entry, long l) {
        long l2 = entry.getStart();
        if (l2 == -1L) {
            long l3 = entry.getEnd();
            if (l3 >= l) {
                return 0L;
            }
            return l - l3;
        }
        return l2;
    }

    private static long getEnd(Ranges.Entry entry, long l) {
        long l2 = entry.getEnd();
        if (entry.getStart() == -1L || l2 == -1L || l2 >= l) {
            return l - 1L;
        }
        return l2;
    }

    private boolean pathEndsWithCompressedExtension(String string) {
        for (CompressionFormat compressionFormat : this.compressionFormats) {
            if (!string.endsWith(compressionFormat.extension)) continue;
            return true;
        }
        return false;
    }

    private List<PrecompressedResource> getAvailablePrecompressedResources(String string) {
        ArrayList<PrecompressedResource> arrayList = new ArrayList<PrecompressedResource>(this.compressionFormats.length);
        for (CompressionFormat compressionFormat : this.compressionFormats) {
            WebResource webResource = this.resources.getResource(string + compressionFormat.extension);
            if (!webResource.exists() || !webResource.isFile()) continue;
            arrayList.add(new PrecompressedResource(webResource, compressionFormat));
        }
        return arrayList;
    }

    private PrecompressedResource getBestPrecompressedResource(HttpServletRequest httpServletRequest, List<PrecompressedResource> list) {
        Enumeration enumeration = httpServletRequest.getHeaders("Accept-Encoding");
        PrecompressedResource precompressedResource = null;
        double d = 0.0;
        int n = Integer.MAX_VALUE;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            block1: for (String string2 : string.split(",")) {
                double d2 = 1.0;
                int n2 = string2.indexOf(59);
                if (n2 > 0) {
                    int n3 = string2.indexOf(61, n2 + 1);
                    if (n3 == -1) continue;
                    d2 = Double.parseDouble(string2.substring(n3 + 1).trim());
                }
                if (!(d2 >= d)) continue;
                String string3 = string2;
                if (n2 > 0) {
                    string3 = string3.substring(0, n2);
                }
                if ("identity".equals(string3 = string3.trim())) {
                    precompressedResource = null;
                    d = d2;
                    n = Integer.MAX_VALUE;
                    continue;
                }
                if ("*".equals(string3)) {
                    precompressedResource = list.get(0);
                    d = d2;
                    n = 0;
                    continue;
                }
                for (int i = 0; i < list.size(); ++i) {
                    PrecompressedResource precompressedResource2 = list.get(i);
                    if (!string3.equals(precompressedResource2.format.encoding)) continue;
                    if (!(d2 > d) && i >= n) continue block1;
                    precompressedResource = precompressedResource2;
                    d = d2;
                    n = i;
                    continue block1;
                }
            }
        }
        return precompressedResource;
    }

    private void doDirectoryRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(httpServletRequest.getRequestURI());
        stringBuilder.append('/');
        if (httpServletRequest.getQueryString() != null) {
            stringBuilder.append('?');
            stringBuilder.append(httpServletRequest.getQueryString());
        }
        while (stringBuilder.length() > 1 && stringBuilder.charAt(1) == '/') {
            stringBuilder.deleteCharAt(0);
        }
        httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(stringBuilder.toString()));
    }

    protected ContentRange parseContentRange(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getHeader("Content-Range");
        if (string == null) {
            return IGNORE;
        }
        if (!this.allowPartialPut) {
            httpServletResponse.sendError(400);
            return null;
        }
        ContentRange contentRange = ContentRange.parse((StringReader)new StringReader(string));
        if (contentRange == null) {
            httpServletResponse.sendError(400);
            return null;
        }
        if (!DefaultServlet.validate(contentRange)) {
            httpServletResponse.sendError(400);
            return null;
        }
        return contentRange;
    }

    protected Ranges parseRange(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WebResource webResource) throws IOException {
        String string;
        long l;
        String string2 = httpServletRequest.getHeader("If-Range");
        if (string2 != null) {
            l = -1L;
            try {
                l = httpServletRequest.getDateHeader("If-Range");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            string = this.generateETag(webResource);
            long l2 = webResource.getLastModified();
            if (l == -1L ? !string.equals(string2.trim()) : Math.abs(l2 - l) > 1000L) {
                return FULL;
            }
        }
        if ((l = webResource.getContentLength()) == 0L) {
            return FULL;
        }
        string = httpServletRequest.getHeader("Range");
        if (string == null) {
            return FULL;
        }
        Ranges ranges = Ranges.parse((StringReader)new StringReader(string));
        if (ranges == null) {
            httpServletResponse.addHeader("Content-Range", "bytes */" + l);
            httpServletResponse.sendError(416);
            return null;
        }
        if (!ranges.getUnits().equals("bytes")) {
            return FULL;
        }
        for (Ranges.Entry entry : ranges.getEntries()) {
            if (DefaultServlet.validate(entry, l)) continue;
            httpServletResponse.addHeader("Content-Range", "bytes */" + l);
            httpServletResponse.sendError(416);
            return null;
        }
        return ranges;
    }

    protected InputStream render(HttpServletRequest httpServletRequest, String string, WebResource webResource, String string2) throws IOException, ServletException {
        Source source = this.findXsltSource(webResource);
        if (source == null) {
            return this.renderHtml(httpServletRequest, string, webResource, string2);
        }
        return this.renderXml(httpServletRequest, string, webResource, source, string2);
    }

    protected InputStream renderXml(HttpServletRequest httpServletRequest, String string, WebResource webResource, Source source, String string2) throws IOException, ServletException {
        ClassLoader classLoader;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\"?>");
        stringBuilder.append("<listing ");
        stringBuilder.append(" contextPath='");
        stringBuilder.append(string);
        stringBuilder.append('\'');
        stringBuilder.append(" directory='");
        stringBuilder.append(webResource.getName());
        stringBuilder.append("' ");
        stringBuilder.append(" hasParent='").append(!webResource.getName().equals("/"));
        stringBuilder.append("'>");
        stringBuilder.append("<entries>");
        String[] stringArray = this.resources.list(webResource.getWebappPath());
        String string3 = this.rewriteUrl(string);
        String string4 = webResource.getWebappPath();
        for (String string5 : stringArray) {
            if (string5.equalsIgnoreCase("WEB-INF") || string5.equalsIgnoreCase("META-INF") || string5.equalsIgnoreCase(this.localXsltFile) || (string4 + string5).equals(this.contextXsltFile) || !(object = this.resources.getResource(string4 + string5)).exists()) continue;
            stringBuilder.append("<entry");
            stringBuilder.append(" type='").append(object.isDirectory() ? "dir" : "file").append('\'');
            stringBuilder.append(" urlPath='").append(string3).append(this.rewriteUrl(string4 + string5)).append(object.isDirectory() ? "/" : "").append('\'');
            if (object.isFile()) {
                stringBuilder.append(" size='").append(this.renderSize(object.getContentLength())).append('\'');
            }
            stringBuilder.append(" date='").append(object.getLastModifiedHttp()).append('\'');
            stringBuilder.append('>');
            stringBuilder.append(Escape.htmlElementContent((String)string5));
            if (object.isDirectory()) {
                stringBuilder.append('/');
            }
            stringBuilder.append("</entry>");
        }
        stringBuilder.append("</entries>");
        String string6 = this.getReadme(webResource, string2);
        if (string6 != null) {
            stringBuilder.append("<readme><![CDATA[");
            stringBuilder.append(string6);
            stringBuilder.append("]]></readme>");
        }
        stringBuilder.append("</listing>");
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedGetTccl privilegedSetTccl = new PrivilegedGetTccl();
            classLoader = (ClassLoader)AccessController.doPrivileged(privilegedSetTccl);
        } else {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            if (Globals.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl transformerFactory = new PrivilegedSetTccl(DefaultServlet.class.getClassLoader());
                AccessController.doPrivileged(transformerFactory);
            } else {
                Thread.currentThread().setContextClassLoader(DefaultServlet.class.getClassLoader());
            }
            TransformerFactory transformerException = TransformerFactory.newInstance();
            StreamSource streamSource = new StreamSource(new StringReader(stringBuilder.toString()));
            object = transformerException.newTransformer(source);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8);
            StreamResult streamResult = new StreamResult(outputStreamWriter);
            ((Transformer)object).transform(streamSource, streamResult);
            outputStreamWriter.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
        catch (TransformerException transformerException) {
            throw new ServletException(sm.getString("defaultServlet.xslError"), (Throwable)transformerException);
        }
        finally {
            if (Globals.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl privilegedSetTccl = new PrivilegedSetTccl(classLoader);
                AccessController.doPrivileged(privilegedSetTccl);
            } else {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    protected InputStream renderHtml(HttpServletRequest httpServletRequest, String string, WebResource webResource, String string2) throws IOException {
        Object object;
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8);
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = webResource.getWebappPath();
        WebResource[] webResourceArray = this.resources.listResources(string3);
        String string4 = this.rewriteUrl(string);
        stringBuilder.append("<!doctype html><html>\r\n");
        stringBuilder.append("<head>\r\n");
        stringBuilder.append("<title>");
        stringBuilder.append(sm.getString("directory.title", new Object[]{string3}));
        stringBuilder.append("</title>\r\n");
        stringBuilder.append("<style>");
        stringBuilder.append("body {font-family:Tahoma,Arial,sans-serif;} h1, h2, h3, b {color:white;background-color:#525D76;} h1 {font-size:22px;} h2 {font-size:16px;} h3 {font-size:14px;} p {font-size:12px;} a {color:black;} .line {height:1px;background-color:#525D76;border:none;}");
        stringBuilder.append("</style> ");
        stringBuilder.append("</head>\r\n");
        stringBuilder.append("<body>");
        stringBuilder.append("<h1>");
        stringBuilder.append(sm.getString("directory.title", new Object[]{string3}));
        String string5 = string3;
        if (string5.endsWith("/")) {
            string5 = string5.substring(0, string5.length() - 1);
        }
        if ((n = string5.lastIndexOf(47)) >= 0) {
            object = string3.substring(0, n);
            stringBuilder.append(" - <a href=\"");
            stringBuilder.append(string4);
            if (((String)object).equals("")) {
                object = "/";
            }
            stringBuilder.append(this.rewriteUrl((String)object));
            if (!((String)object).endsWith("/")) {
                stringBuilder.append('/');
            }
            stringBuilder.append("\">");
            stringBuilder.append("<b>");
            stringBuilder.append(sm.getString("directory.parent", new Object[]{object}));
            stringBuilder.append("</b>");
            stringBuilder.append("</a>");
        }
        stringBuilder.append("</h1>");
        stringBuilder.append("<hr class=\"line\">");
        stringBuilder.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">\r\n");
        object = this.sortListings && null != httpServletRequest ? this.sortManager.getOrder(httpServletRequest.getQueryString()) : null;
        stringBuilder.append("<tr>\r\n");
        stringBuilder.append("<td align=\"left\"><font size=\"+1\"><strong>");
        if (this.sortListings && null != httpServletRequest) {
            stringBuilder.append("<a href=\"?C=N;O=");
            stringBuilder.append(this.getOrderChar((SortManager.Order)object, 'N'));
            stringBuilder.append("\">");
            stringBuilder.append(sm.getString("directory.filename"));
            stringBuilder.append("</a>");
        } else {
            stringBuilder.append(sm.getString("directory.filename"));
        }
        stringBuilder.append("</strong></font></td>\r\n");
        stringBuilder.append("<td align=\"center\"><font size=\"+1\"><strong>");
        if (this.sortListings && null != httpServletRequest) {
            stringBuilder.append("<a href=\"?C=S;O=");
            stringBuilder.append(this.getOrderChar((SortManager.Order)object, 'S'));
            stringBuilder.append("\">");
            stringBuilder.append(sm.getString("directory.size"));
            stringBuilder.append("</a>");
        } else {
            stringBuilder.append(sm.getString("directory.size"));
        }
        stringBuilder.append("</strong></font></td>\r\n");
        stringBuilder.append("<td align=\"right\"><font size=\"+1\"><strong>");
        if (this.sortListings && null != httpServletRequest) {
            stringBuilder.append("<a href=\"?C=M;O=");
            stringBuilder.append(this.getOrderChar((SortManager.Order)object, 'M'));
            stringBuilder.append("\">");
            stringBuilder.append(sm.getString("directory.lastModified"));
            stringBuilder.append("</a>");
        } else {
            stringBuilder.append(sm.getString("directory.lastModified"));
        }
        stringBuilder.append("</strong></font></td>\r\n");
        stringBuilder.append("</tr>");
        if (null != this.sortManager && null != httpServletRequest) {
            this.sortManager.sort(webResourceArray, httpServletRequest.getQueryString());
        }
        boolean bl = false;
        for (WebResource webResource2 : webResourceArray) {
            String string6 = webResource2.getName();
            if (string6.equalsIgnoreCase("WEB-INF") || string6.equalsIgnoreCase("META-INF") || !webResource2.exists()) continue;
            stringBuilder.append("<tr");
            if (bl) {
                stringBuilder.append(" bgcolor=\"#eeeeee\"");
            }
            stringBuilder.append(">\r\n");
            bl = !bl;
            stringBuilder.append("<td align=\"left\">&nbsp;&nbsp;\r\n");
            stringBuilder.append("<a href=\"");
            stringBuilder.append(string4);
            stringBuilder.append(this.rewriteUrl(webResource2.getWebappPath()));
            if (webResource2.isDirectory()) {
                stringBuilder.append('/');
            }
            stringBuilder.append("\"><tt>");
            stringBuilder.append(Escape.htmlElementContent((String)string6));
            if (webResource2.isDirectory()) {
                stringBuilder.append('/');
            }
            stringBuilder.append("</tt></a></td>\r\n");
            stringBuilder.append("<td align=\"right\"><tt>");
            if (webResource2.isDirectory()) {
                stringBuilder.append("&nbsp;");
            } else {
                stringBuilder.append(this.renderSize(webResource2.getContentLength()));
            }
            stringBuilder.append("</tt></td>\r\n");
            stringBuilder.append("<td align=\"right\"><tt>");
            stringBuilder.append(webResource2.getLastModifiedHttp());
            stringBuilder.append("</tt></td>\r\n");
            stringBuilder.append("</tr>\r\n");
        }
        stringBuilder.append("</table>\r\n");
        stringBuilder.append("<hr class=\"line\">");
        String string7 = this.getReadme(webResource, string2);
        if (string7 != null) {
            stringBuilder.append(string7);
            stringBuilder.append("<hr class=\"line\">");
        }
        if (this.showServerInfo) {
            stringBuilder.append("<h3>").append(ServerInfo.getServerInfo()).append("</h3>");
        }
        stringBuilder.append("</body>\r\n");
        stringBuilder.append("</html>\r\n");
        printWriter.write(stringBuilder.toString());
        printWriter.flush();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    protected String renderSize(long l) {
        long l2 = l / 1024L;
        long l3 = l % 1024L / 103L;
        if (l2 == 0L && l3 == 0L && l > 0L) {
            l3 = 1L;
        }
        return "" + l2 + "." + l3 + " kb";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getReadme(WebResource webResource, String string) {
        if (this.readmeFile != null) {
            WebResource webResource2 = this.resources.getResource(webResource.getWebappPath() + this.readmeFile);
            if (webResource2.isFile()) {
                StringWriter stringWriter = new StringWriter();
                InputStreamReader inputStreamReader = null;
                try (InputStream inputStream = webResource2.getInputStream();){
                    inputStreamReader = string != null ? new InputStreamReader(inputStream, string) : new InputStreamReader(inputStream);
                    this.copyRange(inputStreamReader, new PrintWriter(stringWriter));
                }
                catch (IOException iOException) {
                    this.log(sm.getString("defaultServlet.readerCloseFailed"), iOException);
                }
                finally {
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return stringWriter.toString();
            }
            if (this.debug > 10) {
                this.log("readme '" + this.readmeFile + "' not found");
            }
            return null;
        }
        return null;
    }

    protected Source findXsltSource(WebResource webResource) throws IOException {
        Object object;
        if (this.localXsltFile != null) {
            InputStream inputStream;
            object = this.resources.getResource(webResource.getWebappPath() + this.localXsltFile);
            if (object.isFile() && (inputStream = object.getInputStream()) != null) {
                if (Globals.IS_SECURITY_ENABLED) {
                    return this.secureXslt(inputStream);
                }
                return new StreamSource(inputStream);
            }
            if (this.debug > 10) {
                this.log("localXsltFile '" + this.localXsltFile + "' not found");
            }
        }
        if (this.contextXsltFile != null) {
            object = this.getServletContext().getResourceAsStream(this.contextXsltFile);
            if (object != null) {
                if (Globals.IS_SECURITY_ENABLED) {
                    return this.secureXslt((InputStream)object);
                }
                return new StreamSource((InputStream)object);
            }
            if (this.debug > 10) {
                this.log("contextXsltFile '" + this.contextXsltFile + "' not found");
            }
        }
        if (this.globalXsltFile != null && (object = this.validateGlobalXsltFile()) != null) {
            long l = ((File)object).length();
            if (l > Integer.MAX_VALUE) {
                this.log("globalXsltFile [" + ((File)object).getAbsolutePath() + "] is too big to buffer");
            } else {
                try (FileInputStream fileInputStream = new FileInputStream((File)object);){
                    byte[] byArray = new byte[(int)((File)object).length()];
                    IOTools.readFully(fileInputStream, byArray);
                    StreamSource streamSource = new StreamSource(new ByteArrayInputStream(byArray));
                    return streamSource;
                }
            }
        }
        return null;
    }

    private File validateGlobalXsltFile() {
        File file;
        Context context = this.resources.getContext();
        File file2 = new File(context.getCatalinaBase(), "conf");
        File file3 = this.validateGlobalXsltFile(file2);
        if (file3 == null && !file2.equals(file = new File(context.getCatalinaHome(), "conf"))) {
            file3 = this.validateGlobalXsltFile(file);
        }
        return file3;
    }

    private File validateGlobalXsltFile(File file) {
        File file2 = new File(this.globalXsltFile);
        if (!file2.isAbsolute()) {
            file2 = new File(file, this.globalXsltFile);
        }
        if (!file2.isFile()) {
            return null;
        }
        try {
            if (!file2.getCanonicalFile().toPath().startsWith(file.getCanonicalFile().toPath())) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        String string = file2.getName().toLowerCase(Locale.ENGLISH);
        if (!string.endsWith(".xslt") && !string.endsWith(".xsl")) {
            return null;
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Source secureXslt(InputStream inputStream) {
        DOMSource dOMSource = null;
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setEntityResolver(secureEntityResolver);
            Document document = documentBuilder.parse(inputStream);
            dOMSource = new DOMSource(document);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            if (this.debug > 0) {
                this.log(exception.getMessage(), exception);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return dOMSource;
    }

    protected boolean checkSendfile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WebResource webResource, long l, Ranges.Entry entry) {
        String string;
        if (this.sendfileSize > 0 && l > (long)this.sendfileSize && Boolean.TRUE.equals(httpServletRequest.getAttribute("org.apache.tomcat.sendfile.support")) && httpServletRequest.getClass().getName().equals("org.apache.catalina.connector.RequestFacade") && httpServletResponse.getClass().getName().equals("org.apache.catalina.connector.ResponseFacade") && webResource.isFile() && (string = webResource.getCanonicalPath()) != null) {
            httpServletRequest.setAttribute("org.apache.tomcat.sendfile.filename", (Object)string);
            if (entry == null) {
                httpServletRequest.setAttribute("org.apache.tomcat.sendfile.start", (Object)0L);
                httpServletRequest.setAttribute("org.apache.tomcat.sendfile.end", (Object)l);
            } else {
                httpServletRequest.setAttribute("org.apache.tomcat.sendfile.start", (Object)DefaultServlet.getStart(entry, l));
                httpServletRequest.setAttribute("org.apache.tomcat.sendfile.end", (Object)(DefaultServlet.getEnd(entry, l) + 1L));
            }
            return true;
        }
        return false;
    }

    protected boolean checkIfMatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WebResource webResource) throws IOException {
        String string = httpServletRequest.getHeader("If-Match");
        if (string != null) {
            boolean bl;
            if (!string.equals("*")) {
                String string2 = this.generateETag(webResource);
                if (string2 == null) {
                    bl = false;
                } else {
                    Boolean bl2 = EntityTag.compareEntityTag((StringReader)new StringReader(string), (boolean)false, (String)string2);
                    if (bl2 == null) {
                        if (this.debug > 10) {
                            this.log("DefaultServlet.checkIfMatch:  Invalid header value [" + string + "]");
                        }
                        httpServletResponse.sendError(400);
                        return false;
                    }
                    bl = bl2;
                }
            } else {
                bl = true;
            }
            if (!bl) {
                httpServletResponse.sendError(412);
                return false;
            }
        }
        return true;
    }

    protected boolean checkIfModifiedSince(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WebResource webResource) {
        try {
            long l = httpServletRequest.getDateHeader("If-Modified-Since");
            long l2 = webResource.getLastModified();
            if (l != -1L && httpServletRequest.getHeader("If-None-Match") == null && l2 < l + 1000L) {
                httpServletResponse.setStatus(304);
                httpServletResponse.setHeader("ETag", this.generateETag(webResource));
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        return true;
    }

    protected boolean checkIfNoneMatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WebResource webResource) throws IOException {
        String string = httpServletRequest.getHeader("If-None-Match");
        if (string != null) {
            boolean bl;
            String string2 = this.generateETag(webResource);
            if (!string.equals("*")) {
                if (string2 == null) {
                    bl = false;
                } else {
                    Boolean bl2 = EntityTag.compareEntityTag((StringReader)new StringReader(string), (boolean)true, (String)string2);
                    if (bl2 == null) {
                        if (this.debug > 10) {
                            this.log("DefaultServlet.checkIfNoneMatch:  Invalid header value [" + string + "]");
                        }
                        httpServletResponse.sendError(400);
                        return false;
                    }
                    bl = bl2;
                }
            } else {
                bl = true;
            }
            if (bl) {
                if ("GET".equals(httpServletRequest.getMethod()) || "HEAD".equals(httpServletRequest.getMethod())) {
                    httpServletResponse.setStatus(304);
                    httpServletResponse.setHeader("ETag", string2);
                } else {
                    httpServletResponse.sendError(412);
                }
                return false;
            }
        }
        return true;
    }

    protected boolean checkIfUnmodifiedSince(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WebResource webResource) throws IOException {
        try {
            long l = webResource.getLastModified();
            long l2 = httpServletRequest.getDateHeader("If-Unmodified-Since");
            if (l2 != -1L && l >= l2 + 1000L) {
                httpServletResponse.sendError(412);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        return true;
    }

    protected String generateETag(WebResource webResource) {
        return webResource.getETag();
    }

    protected void copy(InputStream inputStream, ServletOutputStream servletOutputStream) throws IOException {
        IOException iOException = null;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, this.input);
        iOException = this.copyRange(bufferedInputStream, servletOutputStream);
        ((InputStream)bufferedInputStream).close();
        if (iOException != null) {
            throw iOException;
        }
    }

    protected void copy(InputStream inputStream, PrintWriter printWriter, String string) throws IOException {
        IOException iOException = null;
        InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        iOException = this.copyRange(inputStreamReader, printWriter);
        ((Reader)inputStreamReader).close();
        if (iOException != null) {
            throw iOException;
        }
    }

    protected void copy(WebResource webResource, long l, ServletOutputStream servletOutputStream, Ranges.Entry entry) throws IOException {
        IOException iOException = null;
        InputStream inputStream = webResource.getInputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, this.input);
        iOException = this.copyRange(bufferedInputStream, servletOutputStream, DefaultServlet.getStart(entry, l), DefaultServlet.getEnd(entry, l));
        ((InputStream)bufferedInputStream).close();
        if (iOException != null) {
            throw iOException;
        }
    }

    protected void copy(WebResource webResource, long l, ServletOutputStream servletOutputStream, Ranges ranges, String string) throws IOException {
        IOException iOException = null;
        for (Ranges.Entry entry : ranges.getEntries()) {
            if (iOException != null) break;
            InputStream inputStream = webResource.getInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, this.input);
            Throwable throwable = null;
            try {
                servletOutputStream.println();
                servletOutputStream.println("--CATALINA_MIME_BOUNDARY");
                if (string != null) {
                    servletOutputStream.println("Content-Type: " + string);
                }
                long l2 = DefaultServlet.getStart(entry, l);
                long l3 = DefaultServlet.getEnd(entry, l);
                servletOutputStream.println("Content-Range: bytes " + l2 + "-" + l3 + "/" + (l3 - l2));
                servletOutputStream.println();
                iOException = this.copyRange(bufferedInputStream, servletOutputStream, l2, l3);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (bufferedInputStream == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)bufferedInputStream).close();
            }
        }
        servletOutputStream.println();
        servletOutputStream.print("--CATALINA_MIME_BOUNDARY--");
        if (iOException != null) {
            throw iOException;
        }
    }

    protected IOException copyRange(InputStream inputStream, ServletOutputStream servletOutputStream) {
        IOException iOException = null;
        byte[] byArray = new byte[this.input];
        int n = byArray.length;
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                servletOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            n = -1;
        }
        return iOException;
    }

    protected IOException copyRange(Reader reader, PrintWriter printWriter) {
        IOException iOException = null;
        char[] cArray = new char[this.input];
        int n = cArray.length;
        try {
            while ((n = reader.read(cArray)) != -1) {
                printWriter.write(cArray, 0, n);
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            n = -1;
        }
        return iOException;
    }

    protected IOException copyRange(InputStream inputStream, ServletOutputStream servletOutputStream, long l, long l2) {
        if (this.debug > 10) {
            this.log("Serving bytes:" + l + "-" + l2);
        }
        long l3 = 0L;
        try {
            l3 = inputStream.skip(l);
        }
        catch (IOException iOException) {
            return iOException;
        }
        if (l3 < l) {
            return new IOException(sm.getString("defaultServlet.skipfail", new Object[]{l3, l}));
        }
        IOException iOException = null;
        long l4 = l2 - l + 1L;
        byte[] byArray = new byte[this.input];
        int n = byArray.length;
        while (l4 > 0L && n >= byArray.length) {
            try {
                n = inputStream.read(byArray);
                if (l4 >= (long)n) {
                    servletOutputStream.write(byArray, 0, n);
                    l4 -= (long)n;
                } else {
                    servletOutputStream.write(byArray, 0, (int)l4);
                    l4 = 0L;
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                n = -1;
            }
            if (n >= byArray.length) continue;
            break;
        }
        return iOException;
    }

    private char getOrderChar(SortManager.Order order, char c) {
        if (c == order.column) {
            if (order.ascending) {
                return 'D';
            }
            return 'A';
        }
        return 'D';
    }

    static {
        FULL = new Ranges(null, new ArrayList());
        IGNORE = new ContentRange(null, 0L, 0L, 0L);
        if (Globals.IS_SECURITY_ENABLED) {
            factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            secureEntityResolver = new SecureEntityResolver();
        } else {
            factory = null;
            secureEntityResolver = null;
        }
    }

    static enum BomConfig {
        TRUE("true", true, true),
        FALSE("false", true, false),
        PASS_THROUGH("pass-through", false, false);

        final String configurationValue;
        final boolean stripBom;
        final boolean useBomEncoding;

        private BomConfig(String string2, boolean bl, boolean bl2) {
            this.configurationValue = string2;
            this.stripBom = bl;
            this.useBomEncoding = bl2;
        }
    }

    private static class ResourceLastModifiedDateComparator
    implements Comparator<WebResource> {
        private Comparator<WebResource> base;

        public ResourceLastModifiedDateComparator(Comparator<WebResource> comparator) {
            this.base = comparator;
        }

        @Override
        public int compare(WebResource webResource, WebResource webResource2) {
            int n = Long.compare(webResource.getLastModified(), webResource2.getLastModified());
            if (0 == n) {
                return this.base.compare(webResource, webResource2);
            }
            return n;
        }
    }

    private static class ResourceSizeComparator
    implements Comparator<WebResource> {
        private Comparator<WebResource> base;

        public ResourceSizeComparator(Comparator<WebResource> comparator) {
            this.base = comparator;
        }

        @Override
        public int compare(WebResource webResource, WebResource webResource2) {
            int n = Long.compare(webResource.getContentLength(), webResource2.getContentLength());
            if (0 == n) {
                return this.base.compare(webResource, webResource2);
            }
            return n;
        }
    }

    private static class ResourceNameComparator
    implements Comparator<WebResource> {
        private ResourceNameComparator() {
        }

        @Override
        public int compare(WebResource webResource, WebResource webResource2) {
            return webResource.getName().compareTo(webResource2.getName());
        }
    }

    private static class DirsFirstComparator
    implements Comparator<WebResource> {
        private final Comparator<WebResource> base;

        public DirsFirstComparator(Comparator<WebResource> comparator) {
            this.base = comparator;
        }

        @Override
        public int compare(WebResource webResource, WebResource webResource2) {
            if (webResource.isDirectory()) {
                if (webResource2.isDirectory()) {
                    return this.base.compare(webResource, webResource2);
                }
                return -1;
            }
            if (webResource2.isDirectory()) {
                return 1;
            }
            return this.base.compare(webResource, webResource2);
        }
    }

    private static class SortManager {
        protected Comparator<WebResource> defaultResourceComparator;
        protected Comparator<WebResource> resourceNameComparator = new ResourceNameComparator();
        protected Comparator<WebResource> resourceNameComparatorAsc = Collections.reverseOrder(this.resourceNameComparator);
        protected Comparator<WebResource> resourceSizeComparator = new ResourceSizeComparator(this.resourceNameComparator);
        protected Comparator<WebResource> resourceSizeComparatorAsc = Collections.reverseOrder(this.resourceSizeComparator);
        protected Comparator<WebResource> resourceLastModifiedComparator = new ResourceLastModifiedDateComparator(this.resourceNameComparator);
        protected Comparator<WebResource> resourceLastModifiedComparatorAsc = Collections.reverseOrder(this.resourceLastModifiedComparator);

        public SortManager(boolean bl) {
            if (bl) {
                this.resourceNameComparator = new DirsFirstComparator(this.resourceNameComparator);
                this.resourceNameComparatorAsc = new DirsFirstComparator(this.resourceNameComparatorAsc);
                this.resourceSizeComparator = new DirsFirstComparator(this.resourceSizeComparator);
                this.resourceSizeComparatorAsc = new DirsFirstComparator(this.resourceSizeComparatorAsc);
                this.resourceLastModifiedComparator = new DirsFirstComparator(this.resourceLastModifiedComparator);
                this.resourceLastModifiedComparatorAsc = new DirsFirstComparator(this.resourceLastModifiedComparatorAsc);
            }
            this.defaultResourceComparator = this.resourceNameComparator;
        }

        public void sort(WebResource[] webResourceArray, String string) {
            Comparator<WebResource> comparator = this.getComparator(string);
            if (null != comparator) {
                Arrays.sort(webResourceArray, comparator);
            }
        }

        public Comparator<WebResource> getComparator(String string) {
            return this.getComparator(this.getOrder(string));
        }

        public Comparator<WebResource> getComparator(Order order) {
            if (null == order) {
                return this.defaultResourceComparator;
            }
            if ('N' == order.column) {
                if (order.ascending) {
                    return this.resourceNameComparatorAsc;
                }
                return this.resourceNameComparator;
            }
            if ('S' == order.column) {
                if (order.ascending) {
                    return this.resourceSizeComparatorAsc;
                }
                return this.resourceSizeComparator;
            }
            if ('M' == order.column) {
                if (order.ascending) {
                    return this.resourceLastModifiedComparatorAsc;
                }
                return this.resourceLastModifiedComparator;
            }
            return this.defaultResourceComparator;
        }

        public Order getOrder(String string) {
            if (null == string || 0 == string.trim().length()) {
                return Order.DEFAULT;
            }
            String[] stringArray = string.split(";");
            if (0 == stringArray.length) {
                return Order.DEFAULT;
            }
            int n = 0;
            boolean bl = false;
            for (String string2 : stringArray) {
                if (2 >= (string2 = string2.trim()).length()) continue;
                char c = string2.charAt(0);
                if ('C' == c) {
                    n = string2.charAt(2);
                    continue;
                }
                if ('O' != c) continue;
                bl = 'A' == string2.charAt(2);
            }
            if (78 == n) {
                if (bl) {
                    return Order.NAME_ASC;
                }
                return Order.NAME;
            }
            if (83 == n) {
                if (bl) {
                    return Order.SIZE_ASC;
                }
                return Order.SIZE;
            }
            if (77 == n) {
                if (bl) {
                    return Order.LAST_MODIFIED_ASC;
                }
                return Order.LAST_MODIFIED;
            }
            return Order.DEFAULT;
        }

        public static class Order {
            final char column;
            final boolean ascending;
            public static final Order NAME = new Order('N', false);
            public static final Order NAME_ASC = new Order('N', true);
            public static final Order SIZE = new Order('S', false);
            public static final Order SIZE_ASC = new Order('S', true);
            public static final Order LAST_MODIFIED = new Order('M', false);
            public static final Order LAST_MODIFIED_ASC = new Order('M', true);
            public static final Order DEFAULT = NAME;

            public Order(char c, boolean bl) {
                this.column = c;
                this.ascending = bl;
            }
        }
    }

    private static class SecureEntityResolver
    implements EntityResolver2 {
        private SecureEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            throw new SAXException(sm.getString("defaultServlet.blockExternalEntity", new Object[]{string, string2}));
        }

        @Override
        public InputSource getExternalSubset(String string, String string2) throws SAXException, IOException {
            throw new SAXException(sm.getString("defaultServlet.blockExternalSubset", new Object[]{string, string2}));
        }

        @Override
        public InputSource resolveEntity(String string, String string2, String string3, String string4) throws SAXException, IOException {
            throw new SAXException(sm.getString("defaultServlet.blockExternalEntity2", new Object[]{string, string2, string3, string4}));
        }
    }

    private static class PrecompressedResource {
        public final WebResource resource;
        public final CompressionFormat format;

        private PrecompressedResource(WebResource webResource, CompressionFormat compressionFormat) {
            this.resource = webResource;
            this.format = compressionFormat;
        }
    }

    protected static class CompressionFormat
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String extension;
        public final String encoding;

        public CompressionFormat(String string, String string2) {
            this.extension = string;
            this.encoding = string2;
        }
    }
}

