"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const SHEBANG_REGEXP = /^#!(.*)/;
function getShebang(fileContent) {
    const match = SHEBANG_REGEXP.exec(fileContent);
    if (!match || !match[1]) {
        return null;
    }
    return match[1].replace('-', '').trim();
}
exports.getShebang = getShebang;
function isBashShebang(shebang) {
    return shebang.endsWith('bash') || shebang.endsWith('sh');
}
exports.isBashShebang = isBashShebang;
function hasBashShebang(fileContent) {
    const shebang = getShebang(fileContent);
    return shebang ? isBashShebang(shebang) : false;
}
exports.hasBashShebang = hasBashShebang;
//# sourceMappingURL=shebang.js.map