/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.ProteinStructure;

public class Sheet
extends ProteinStructure {
    V3 widthUnitVector;
    V3 heightUnitVector;

    Sheet(AlphaPolymer apolymer, int monomerIndex, int monomerCount, STR subtype) {
        this.setupPS(apolymer, STR.SHEET, monomerIndex, monomerCount);
        this.subtype = subtype;
    }

    @Override
    public void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        if (this.nRes == 2) {
            this.axisA = this.apolymer.getLeadPoint(this.monomerIndexFirst);
            this.axisB = this.apolymer.getLeadPoint(this.monomerIndexFirst + 1);
        } else {
            this.axisA = new P3();
            this.apolymer.getLeadMidPoint(this.monomerIndexFirst + 1, this.axisA);
            this.axisB = new P3();
            this.apolymer.getLeadMidPoint(this.monomerIndexFirst + this.nRes - 1, this.axisB);
        }
        this.axisUnitVector = new V3();
        this.axisUnitVector.sub2(this.axisB, this.axisA);
        this.axisUnitVector.normalize();
        P3 tempA = new P3();
        this.apolymer.getLeadMidPoint(this.monomerIndexFirst, tempA);
        if (this.notHelixOrSheet(this.monomerIndexFirst - 1)) {
            Measure.projectOntoAxis((P3)tempA, (P3)this.axisA, (V3)this.axisUnitVector, (V3)this.vectorProjection);
        }
        P3 tempB = new P3();
        this.apolymer.getLeadMidPoint(this.monomerIndexFirst + this.nRes, tempB);
        if (this.notHelixOrSheet(this.monomerIndexFirst + this.nRes)) {
            Measure.projectOntoAxis((P3)tempB, (P3)this.axisA, (V3)this.axisUnitVector, (V3)this.vectorProjection);
        }
        this.axisA = tempA;
        this.axisB = tempB;
    }

    private boolean notHelixOrSheet(int i) {
        return i < 0 || i >= this.apolymer.monomerCount || !this.apolymer.monomers[i].isHelix() && !this.apolymer.monomers[i].isSheet();
    }

    void calcSheetUnitVectors() {
        if (!(this.apolymer instanceof AminoPolymer)) {
            return;
        }
        if (this.widthUnitVector == null) {
            V3 vectorCO = new V3();
            V3 vectorCOSum = new V3();
            AminoMonomer amino = (AminoMonomer)this.apolymer.monomers[this.monomerIndexFirst];
            vectorCOSum.sub2(amino.getCarbonylOxygenAtom(), amino.getCarbonylCarbonAtom());
            int i = this.nRes;
            while (--i > this.monomerIndexFirst) {
                amino = (AminoMonomer)this.apolymer.monomers[i];
                vectorCO.sub2(amino.getCarbonylOxygenAtom(), amino.getCarbonylCarbonAtom());
                if (vectorCOSum.angle(vectorCO) < 1.5707964f) {
                    vectorCOSum.add(vectorCO);
                    continue;
                }
                vectorCOSum.sub(vectorCO);
            }
            this.heightUnitVector = vectorCO;
            this.heightUnitVector.cross(this.axisUnitVector, vectorCOSum);
            this.heightUnitVector.normalize();
            this.widthUnitVector = vectorCOSum;
            this.widthUnitVector.cross(this.axisUnitVector, this.heightUnitVector);
        }
    }

    public void setBox(float w, float h, P3 pt, V3 vW, V3 vH, P3 ptC, float scale) {
        if (this.heightUnitVector == null) {
            this.calcSheetUnitVectors();
        }
        vW.setT(this.widthUnitVector);
        vW.scale(scale * w);
        vH.setT(this.heightUnitVector);
        vH.scale(scale * h);
        ptC.ave(vW, vH);
        ptC.sub2(pt, ptC);
    }
}

