/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.awt.Event;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.JSInterface;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.JmolAppletInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolSyncInterface;
import org.jmol.api.js.JmolToJSmolInterface;
import org.jmol.awtjs2d.Platform;
import org.jmol.c.CBK;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public abstract class GenericApplet
implements JSInterface,
JmolAppletInterface,
JmolStatusListener {
    protected static Map<String, Object> htRegistry;
    protected static boolean isJS;
    private static final int SCRIPT_CHECK = 0;
    private static final int SCRIPT_WAIT = 1;
    private static final int SCRIPT_NOWAIT = 2;
    protected String codeBase;
    protected String documentBase;
    protected boolean isSigned;
    protected String language;
    protected boolean doTranslate = true;
    protected boolean haveDocumentAccess;
    protected boolean isStereoSlave;
    protected boolean mayScript;
    protected String htmlName;
    protected String fullName;
    protected String statusForm;
    protected String statusText;
    protected String statusTextarea;
    protected Object gRight;
    protected Viewer viewer;
    protected Map<CBK, String> callbacks;
    protected Map<String, Object> vwrOptions;
    protected boolean haveNotifiedError;
    protected Object appletObject;
    private boolean loading;
    private String syncId;
    private SB outputBuffer;
    protected Map<String, Object> htParams;

    @Override
    public Object setStereoGraphics(boolean isStereo) {
        return null;
    }

    @Override
    public boolean processMouseEvent(int id, int x, int y, int modifiers, long time) {
        return this.viewer.processMouseEvent(id, x, y, modifiers, time);
    }

    @Override
    public void setDisplay(Object canvas) {
        this.viewer.setDisplay(canvas);
    }

    @Override
    public boolean setStatusDragDropped(int mode, int x, int y, String fileName, String[] retType) {
        return this.viewer.setStatusDragDropped(mode, x, y, fileName, retType);
    }

    @Override
    public void startHoverWatcher(boolean enable) {
        this.viewer.startHoverWatcher(enable);
    }

    @Override
    public void update() {
        this.viewer.updateJS();
    }

    @Override
    public void openFileAsyncSpecial(String fileName, int flags) {
        this.viewer.openFileAsyncSpecial(fileName, flags);
    }

    @Override
    public void processTwoPointGesture(float[][][] touches) {
        this.viewer.processTwoPointGesture(touches);
    }

    @Override
    public void setScreenDimension(int width, int height) {
        this.viewer.setScreenDimension(width, height);
    }

    void resizeDisplay(int width, int height) {
        JmolToJSmolInterface jmol = Platform.Jmol();
        jmol.resizeApplet(this.viewer.html5Applet, new int[]{width, height});
    }

    protected void init(Object applet) {
        this.callbacks = new Hashtable<CBK, String>();
        if (htRegistry == null) {
            htRegistry = new Hashtable<String, Object>();
        }
        this.appletObject = applet;
        this.htmlName = PT.split("" + this.getJmolParameter("name"), "_object")[0];
        this.syncId = this.getJmolParameter("syncId");
        this.fullName = this.htmlName + "__" + this.syncId + "__";
        System.out.println("Jmol JavaScript applet " + this.fullName + " initializing");
        int iLevel = this.getValue("logLevel", this.getBooleanValue("debug", false) ? "5" : "4").charAt(0) - 48;
        if (iLevel != 4) {
            System.out.println("setting logLevel=" + iLevel + " -- To change, use script \"set logLevel [0-5]\"");
        }
        Logger.setLogLevel(iLevel);
        GT.ignoreApplicationBundle();
        this.initOptions();
        GenericApplet.checkIn(this.fullName, this.appletObject);
        this.initApplication();
    }

    private void initApplication() {
        String menuFile;
        this.vwrOptions.put("applet", Boolean.TRUE);
        if (this.getJmolParameter("statusListener") == null) {
            this.vwrOptions.put("statusListener", this);
        }
        this.language = this.getJmolParameter("language");
        if (this.language != null) {
            this.vwrOptions.put("language", this.language);
        }
        this.viewer = new Viewer(this.vwrOptions);
        this.viewer.pushHoldRepaint();
        String emulate = this.getValueLowerCase("emulate", "jmol");
        this.setStringProperty("defaults", emulate.equals("chime") ? "RasMol" : "Jmol");
        this.setStringProperty("backgroundColor", this.getValue("bgcolor", this.getValue("boxbgcolor", "black")));
        this.viewer.setBooleanProperty("frank", true);
        this.loading = true;
        for (CBK item : CBK.values()) {
            String name = item.name();
            String o = this.getValue(name + "Callback", null);
            if (o == null) continue;
            if (o instanceof String) {
                this.setStringProperty(name + "Callback", o);
                continue;
            }
            String def = null;
            this.setStringProperty(name + "Callback", def);
            this.setCallback(name, o);
        }
        this.loading = false;
        if (this.language != null) {
            System.out.print("requested language=" + this.language + "; ");
        }
        this.doTranslate = !"none".equals(this.language) && this.getBooleanValue("doTranslate", true);
        this.language = GT.getLanguage();
        System.out.println("language=" + this.language);
        if (this.callbacks.get((Object)CBK.SCRIPT) == null && this.callbacks.get((Object)CBK.ERROR) == null && (this.callbacks.get((Object)CBK.MESSAGE) != null || this.statusForm != null || this.statusText != null)) {
            if (this.doTranslate && this.getValue("doTranslate", null) == null) {
                this.doTranslate = false;
                Logger.warn("Note -- Presence of message callback disables disable translation; to enable message translation use jmolSetTranslation(true) prior to jmolApplet()");
            }
            if (this.doTranslate) {
                Logger.warn("Note -- Automatic language translation may affect parsing of message callbacks messages; use scriptCallback or errorCallback to process errors");
            }
        }
        if (!this.doTranslate) {
            GT.setDoTranslate(false);
            Logger.warn("Note -- language translation disabled");
        }
        if (!this.getBooleanValue("popupMenu", true)) {
            this.viewer.getProperty("DATA_API", "disablePopupMenu", null);
        }
        if ((menuFile = this.getJmolParameter("menuFile")) != null) {
            this.viewer.setMenu(menuFile, true);
        }
        String script = this.getValue("script", "");
        String loadParam = this.getValue("loadInline", null);
        if (loadParam == null) {
            loadParam = this.getValue("load", null);
            if (loadParam != null) {
                script = "load \"" + loadParam + "\";" + script;
            }
            loadParam = null;
        }
        this.viewer.popHoldRepaint("applet init");
        if (loadParam != null && this.viewer.loadInline(loadParam) != null) {
            script = "";
        }
        if (script.length() > 0) {
            this.scriptProcessor(script, null, 1);
        }
        this.viewer.notifyStatusReady(true);
    }

    @Override
    public void destroy() {
        this.gRight = null;
        this.viewer.notifyStatusReady(false);
        this.viewer = null;
        GenericApplet.checkOut(this.fullName);
    }

    protected boolean getBooleanValue(String propertyName, boolean defaultValue) {
        String value = this.getValue(propertyName, defaultValue ? "true" : "");
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes");
    }

    protected String getValue(String propertyName, String defaultValue) {
        String s = this.getJmolParameter(propertyName);
        System.out.println("Jmol getValue " + propertyName + " " + s);
        return s == null ? defaultValue : s;
    }

    private String getValueLowerCase(String paramName, String defaultValue) {
        String value = this.getValue(paramName, defaultValue);
        if (value != null && (value = value.trim().toLowerCase()).length() == 0) {
            value = null;
        }
        return value;
    }

    private void setStringProperty(String name, String value) {
        if (value == null) {
            return;
        }
        Logger.info(name + " = \"" + value + "\"");
        this.viewer.setStringProperty(name, value);
    }

    private String scriptProcessor(String script, String statusParams, int processType) {
        if (script == null || script.length() == 0) {
            return "";
        }
        switch (processType) {
            case 0: {
                Object err = this.viewer.scriptCheck(script);
                return err instanceof String ? (String)err : "";
            }
            case 1: {
                if (statusParams != null) {
                    return this.viewer.scriptWaitStatus(script, statusParams).toString();
                }
                return this.viewer.scriptWait(script);
            }
        }
        return this.viewer.script(script);
    }

    @Override
    public void register(String id, JmolSyncInterface jsi) {
        GenericApplet.checkIn(id, jsi);
    }

    @Override
    public Map<String, Object> getJSpecViewProperty(String key) {
        return null;
    }

    @Override
    public synchronized void syncScript(String script) {
        this.viewer.syncScript(script, "~", 0);
    }

    @Override
    public boolean handleEvent(Event e) {
        if (this.viewer == null) {
            return false;
        }
        return this.viewer.processMouseEvent(e.id, e.x, e.y, e.modifiers, e.when);
    }

    @Override
    public String getAppletInfo() {
        return GT.o(GT.$("Jmol Applet version {0} {1}.\n\nAn OpenScience project.\n\nSee http://www.jmol.org for more information"), new Object[]{JC.version, JC.date}) + "\nhtmlName = " + PT.esc(this.htmlName) + "\nsyncId = " + PT.esc(this.syncId) + "\ndocumentBase = " + PT.esc(this.documentBase) + "\ncodeBase = " + PT.esc(this.codeBase);
    }

    @Override
    public void script(String script) {
        this.scriptNoWait(script);
    }

    @Override
    public String scriptCheck(String script) {
        if (script == null || script.length() == 0) {
            return "";
        }
        return this.scriptProcessor(script, null, 0);
    }

    @Override
    public String scriptNoWait(String script) {
        if (script == null || script.length() == 0) {
            return "";
        }
        return this.scriptProcessor(script, null, 2);
    }

    @Override
    public String scriptWait(String script) {
        return this.scriptWait(script, null);
    }

    @Override
    public String scriptWait(String script, String statusParams) {
        if (script == null || script.length() == 0) {
            return "";
        }
        this.outputBuffer = null;
        return this.scriptProcessor(script, statusParams, 1);
    }

    @Override
    public String scriptWaitOutput(String script) {
        if (script == null || script.length() == 0) {
            return "";
        }
        this.outputBuffer = new SB();
        this.viewer.scriptWaitStatus(script, "");
        String str = this.outputBuffer == null ? "" : this.outputBuffer.toString();
        this.outputBuffer = null;
        return str;
    }

    @Override
    public int getModelIndexFromId(String id) {
        return this.viewer.getModelIndexFromId(id);
    }

    @Override
    public Object getProperty(String infoType) {
        return this.viewer.getProperty(null, infoType, "");
    }

    @Override
    public Object getProperty(String infoType, String paramInfo) {
        return this.viewer.getProperty(null, infoType, paramInfo);
    }

    @Override
    public String getPropertyAsString(String infoType) {
        return this.viewer.getProperty("readable", infoType, "").toString();
    }

    @Override
    public String getPropertyAsString(String infoType, String paramInfo) {
        return this.viewer.getProperty("readable", infoType, paramInfo).toString();
    }

    @Override
    public String getPropertyAsJSON(String infoType) {
        return this.viewer.getProperty("JSON", infoType, "").toString();
    }

    @Override
    public String getPropertyAsJSON(String infoType, String paramInfo) {
        return this.viewer.getProperty("JSON", infoType, paramInfo).toString();
    }

    @Override
    public String loadInlineString(String strModel, String script, boolean isAppend) {
        String errMsg = this.viewer.loadInlineAppend(strModel, isAppend);
        if (errMsg == null) {
            this.script(script);
        }
        return errMsg;
    }

    @Override
    public String loadInlineArray(String[] strModels, String script, boolean isAppend) {
        if (strModels == null || strModels.length == 0) {
            return null;
        }
        String errMsg = this.viewer.loadInline(strModels, isAppend);
        if (errMsg == null) {
            this.script(script);
        }
        return errMsg;
    }

    @Override
    public String loadDOMNode(Object DOMNode) {
        return this.viewer.openDOM(DOMNode);
    }

    @Override
    @Deprecated
    public String loadInline(String strModel) {
        return this.loadInlineString(strModel, "", false);
    }

    @Override
    @Deprecated
    public String loadInline(String strModel, String script) {
        return this.loadInlineString(strModel, script, false);
    }

    @Override
    @Deprecated
    public String loadInline(String[] strModels) {
        return this.loadInlineArray(strModels, "", false);
    }

    @Override
    @Deprecated
    public String loadInline(String[] strModels, String script) {
        return this.loadInlineArray(strModels, script, false);
    }

    public void output(String s) {
        if (this.outputBuffer != null && s != null) {
            this.outputBuffer.append(s).appendC('\n');
        }
    }

    @Override
    public void setCallback(String name, Object callbackObject) {
        this.viewer.sm.setCallbackFunction(name, callbackObject);
    }

    @Override
    public void setCallbackFunction(String callbackName, String callbackObject) {
        if (callbackName.equalsIgnoreCase("language")) {
            this.consoleMessage("");
            this.consoleMessage(null);
            return;
        }
        CBK callback = CBK.getCallback(callbackName);
        if (callback != null && (this.loading || callback != CBK.EVAL)) {
            if (callbackObject == null) {
                this.callbacks.remove((Object)callback);
            } else {
                this.callbacks.put(callback, callbackObject);
            }
            return;
        }
        this.consoleMessage("Available callbacks include: " + CBK.getNameList().replace(';', ' ').trim());
    }

    private void consoleMessage(String message) {
        this.notifyCallback(CBK.ECHO, new Object[]{"", message});
    }

    @Override
    public boolean notifyEnabled(CBK type) {
        switch (type) {
            case SYNC: {
                if (!isJS) {
                    return false;
                }
            }
            case ANIMFRAME: 
            case DRAGDROP: 
            case ECHO: 
            case ERROR: 
            case EVAL: 
            case IMAGE: 
            case LOADSTRUCT: 
            case MEASURE: 
            case MESSAGE: 
            case PICK: 
            case SCRIPT: {
                return true;
            }
        }
        return this.callbacks.get((Object)type) != null;
    }

    @Override
    public void notifyCallback(CBK type, Object[] data) {
        JmolCallbackListener appConsole;
        String strInfo;
        String callback = type == null ? null : this.callbacks.get((Object)type);
        boolean doCallback = type == null || callback != null && (data == null || data[0] == null);
        boolean toConsole = false;
        if (data != null) {
            data[0] = this.htmlName;
        }
        String string = strInfo = data == null || data[1] == null ? null : data[1].toString();
        if (type != null) {
            switch (type) {
                case APPLETREADY: {
                    data[3] = this.appletObject;
                    break;
                }
                case DRAGDROP: 
                case ERROR: 
                case EVAL: 
                case IMAGE: 
                case AUDIO: 
                case ATOMMOVED: 
                case HOVER: 
                case MINIMIZATION: 
                case MODELKIT: 
                case RESIZE: 
                case SELECT: 
                case SERVICE: 
                case STRUCTUREMODIFIED: {
                    break;
                }
                case CLICK: {
                    if (!"alert".equals(callback)) break;
                    strInfo = "x=" + data[1] + " y=" + data[2] + " action=" + data[3] + " clickCount=" + data[4];
                    break;
                }
                case ANIMFRAME: {
                    int currentDirection;
                    int[] iData = (int[])data[1];
                    int frameNo = iData[0];
                    int fileNo = iData[1];
                    int modelNo = iData[2];
                    int firstNo = iData[3];
                    int lastNo = iData[4];
                    boolean isAnimationRunning = frameNo <= -2;
                    int animationDirection = firstNo < 0 ? -1 : 1;
                    int n = currentDirection = lastNo < 0 ? -1 : 1;
                    if (!doCallback) break;
                    data = new Object[]{this.htmlName, Math.max(frameNo, -2 - frameNo), fileNo, modelNo, Math.abs(firstNo), Math.abs(lastNo), isAnimationRunning ? 1 : 0, animationDirection, currentDirection, data[2], data[3]};
                    break;
                }
                case ECHO: {
                    boolean isScriptQueued;
                    boolean isPrivate = data.length == 2;
                    boolean bl = isScriptQueued = isPrivate || (Integer)data[2] == 1;
                    if (!doCallback) {
                        if (isScriptQueued) {
                            toConsole = true;
                        }
                        boolean bl2 = doCallback = !isPrivate && (callback = this.callbacks.get((Object)(type = CBK.MESSAGE))) != null;
                    }
                    if (toConsole) break;
                    this.output(strInfo);
                    break;
                }
                case LOADSTRUCT: {
                    String errorMsg = (String)data[4];
                    if (errorMsg == null) break;
                    errorMsg = (errorMsg.indexOf("NOTE:") >= 0 ? "" : GT.$("File Error:")) + errorMsg;
                    this.doShowStatus(errorMsg);
                    this.notifyCallback(CBK.MESSAGE, new Object[]{"", errorMsg});
                    return;
                }
                case MEASURE: {
                    String status;
                    if (!doCallback) {
                        type = CBK.MESSAGE;
                        callback = this.callbacks.get((Object)type);
                        boolean bl = doCallback = callback != null;
                    }
                    if ((status = (String)data[3]).indexOf("Picked") >= 0 || status.indexOf("Sequence") >= 0) {
                        this.doShowStatus(strInfo);
                        toConsole = true;
                        break;
                    }
                    if (status.indexOf("Completed") < 0) break;
                    strInfo = status + ": " + strInfo;
                    toConsole = true;
                    break;
                }
                case MESSAGE: {
                    toConsole = !doCallback;
                    doCallback &= strInfo != null;
                    if (toConsole) break;
                    this.output(strInfo);
                    break;
                }
                case PICK: {
                    this.doShowStatus(strInfo);
                    toConsole = true;
                    break;
                }
                case SCRIPT: {
                    int msWalltime = (Integer)data[3];
                    if (msWalltime <= 0 && !doCallback) {
                        type = CBK.MESSAGE;
                        callback = this.callbacks.get((Object)type);
                        doCallback = callback != null;
                    }
                    this.output(strInfo);
                    this.doShowStatus(strInfo);
                    break;
                }
                case SYNC: {
                    this.sendScript(strInfo, (String)data[2], true, doCallback);
                    return;
                }
            }
        }
        if (toConsole && (appConsole = (JmolCallbackListener)this.viewer.getProperty("DATA_API", "getAppConsole", null)) != null) {
            appConsole.notifyCallback(type, data);
            this.output(strInfo);
        }
        if (!doCallback || !this.mayScript) {
            return;
        }
        try {
            this.doSendCallback(type, callback, data, strInfo);
        }
        catch (Exception e) {
            if (!this.haveNotifiedError && Logger.debugging) {
                Logger.debug(type.name() + "Callback call error to " + callback + ": " + e);
            }
            this.haveNotifiedError = true;
        }
    }

    private String sendScript(String script, String appletName, boolean isSync, boolean doCallback) {
        boolean setNoGraphics;
        if (!isJS) {
            return "";
        }
        if (doCallback && ((script = this.notifySync(script, appletName)) == null || script.length() == 0 || script.equals("0"))) {
            return "";
        }
        Lst<String> apps = new Lst<String>();
        GenericApplet.findApplets(appletName, this.syncId, this.fullName, apps);
        int nApplets = apps.size();
        if (nApplets == 0) {
            if (!doCallback && !appletName.equals("*")) {
                Logger.error(this.fullName + " couldn't find applet " + appletName);
            }
            return "";
        }
        SB sb = isSync ? null : new SB();
        boolean getGraphics = isSync && script.equals("GET_GRAPHICS");
        boolean bl = setNoGraphics = isSync && script.equals("SET_GRAPHICS_OFF");
        if (getGraphics) {
            this.gRight = null;
            this.viewer.setStereo(false, null);
        }
        for (int i = 0; i < nApplets; ++i) {
            String theApplet = (String)apps.get(i);
            JmolSyncInterface app = (JmolSyncInterface)htRegistry.get(theApplet);
            boolean isScriptable = true;
            if (Logger.debugging) {
                Logger.debug(this.fullName + " sending to " + theApplet + ": " + script);
            }
            try {
                if (isScriptable && (getGraphics || setNoGraphics)) {
                    this.isStereoSlave = getGraphics;
                    this.gRight = ((JmolAppletInterface)app).setStereoGraphics(getGraphics);
                    this.viewer.setStereo(this.isStereoSlave, this.gRight);
                    return "";
                }
                if (isSync) {
                    app.syncScript(script);
                    continue;
                }
                if (!isScriptable) continue;
                sb.append(((JmolAppletInterface)app).scriptWait(script, "output")).append("\n");
                continue;
            }
            catch (Exception e) {
                String msg = this.htmlName + " couldn't send to " + theApplet + ": " + script + ": " + e;
                Logger.error(msg);
                if (isSync) continue;
                sb.append(msg);
            }
        }
        return isSync ? "" : sb.toString();
    }

    private String notifySync(String info, String appletName) {
        String syncCallback = this.callbacks.get((Object)CBK.SYNC);
        if (!this.mayScript || syncCallback == null) {
            return info;
        }
        try {
            return this.doSendCallback(CBK.SYNC, syncCallback, new Object[]{this.fullName, info, appletName}, null);
        }
        catch (Exception e) {
            if (!this.haveNotifiedError && Logger.debugging) {
                Logger.debug("syncCallback call error to " + syncCallback + ": " + e);
            }
            this.haveNotifiedError = true;
            return info;
        }
    }

    @Override
    public String eval(String strEval) {
        int pt = strEval.indexOf("\u0001");
        if (pt >= 0) {
            return this.sendScript(strEval.substring(pt + 1), strEval.substring(0, pt), false, false);
        }
        if (!this.haveDocumentAccess) {
            return "NO EVAL ALLOWED";
        }
        if (this.callbacks.get((Object)CBK.EVAL) != null) {
            this.notifyCallback(CBK.EVAL, new Object[]{null, strEval});
            return "";
        }
        return this.doEval(strEval);
    }

    @Override
    public String createImage(String fileName, String type, Object text_or_bytes, int quality) {
        return null;
    }

    @Override
    public Map<String, Object> getRegistryInfo() {
        GenericApplet.checkIn(null, null);
        return htRegistry;
    }

    @Override
    public void showUrl(String urlString) {
        if (Logger.debugging) {
            Logger.debug("showUrl(" + urlString + ")");
        }
        if (urlString != null && urlString.length() > 0) {
            try {
                this.doShowDocument(new URL((URL)null, urlString, null));
            }
            catch (MalformedURLException mue) {
                this.consoleMessage("Malformed URL:" + urlString);
            }
        }
    }

    @Override
    public int[] resizeInnerPanel(String data) {
        float[] dims = new float[2];
        Parser.parseStringInfestedFloatArray(data, null, dims);
        this.resizeDisplay((int)dims[0], (int)dims[1]);
        return new int[]{(int)dims[0], (int)dims[1]};
    }

    static synchronized void checkIn(String name, Object applet) {
        if (name != null) {
            Logger.info("AppletRegistry.checkIn(" + name + ")");
            htRegistry.put(name, applet);
        }
        if (Logger.debugging) {
            for (Map.Entry<String, Object> entry : htRegistry.entrySet()) {
                String theApplet = entry.getKey();
                Logger.debug(theApplet + " " + entry.getValue());
            }
        }
    }

    static synchronized void checkOut(String name) {
        htRegistry.remove(name);
    }

    static synchronized void findApplets(String appletName, String mySyncId, String excludeName, Lst<String> apps) {
        if (appletName != null && appletName.indexOf(",") >= 0) {
            String[] names = PT.split(appletName, ",");
            for (int i = 0; i < names.length; ++i) {
                GenericApplet.findApplets(names[i], mySyncId, excludeName, apps);
            }
            return;
        }
        String ext = "__" + mySyncId + "__";
        if (appletName == null || appletName.equals("*") || appletName.equals(">")) {
            for (String appletName2 : htRegistry.keySet()) {
                if (appletName2.equals(excludeName) || appletName2.indexOf(ext) <= 0) continue;
                apps.addLast(appletName2);
            }
            return;
        }
        if (excludeName.indexOf("_object") >= 0 && appletName.indexOf("_object") < 0) {
            appletName = appletName + "_object";
        }
        if (appletName.indexOf("__") < 0) {
            appletName = appletName + ext;
        }
        if (!htRegistry.containsKey(appletName)) {
            appletName = "jmolApplet" + appletName;
        }
        if (!appletName.equals(excludeName) && htRegistry.containsKey(appletName)) {
            apps.addLast(appletName);
        }
    }

    @Override
    public void notifyAudioEnded(Object htParams) {
        this.viewer.sm.notifyAudioStatus((Map)htParams);
    }

    protected void setJSOptions(Map<String, Object> vwrOptions) {
        this.htParams = new Hashtable<String, Object>();
        if (vwrOptions == null) {
            vwrOptions = new Hashtable<String, Object>();
        }
        this.vwrOptions = vwrOptions;
        for (Map.Entry<String, Object> entry : vwrOptions.entrySet()) {
            this.htParams.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        this.documentBase = "" + vwrOptions.get("documentBase");
        this.codeBase = "" + vwrOptions.get("codePath");
    }

    protected void initOptions() {
        this.vwrOptions.remove("debug");
        this.vwrOptions.put("fullName", this.fullName);
        this.haveDocumentAccess = "true".equalsIgnoreCase("" + this.getValue("allowjavascript", "true"));
        this.mayScript = true;
    }

    protected String getJmolParameter(String paramName) {
        Object o = this.htParams.get(paramName.toLowerCase());
        return o == null ? null : "" + o;
    }

    @Override
    public float[][] functionXY(String functionName, int nX, int nY) {
        float[][] fxy = new float[Math.abs(nX)][Math.abs(nY)];
        if (!this.mayScript || !this.haveDocumentAccess || nX == 0 || nY == 0) {
            return fxy;
        }
        try {
            if (nX > 0 && nY > 0) {
                for (int i = 0; i < nX; ++i) {
                    for (int j = 0; j < nY; ++j) {
                    }
                }
            } else if (nY > 0) {
                String data = "";
                nX = Math.abs(nX);
                float[] fdata = new float[nX * nY];
                Parser.parseStringInfestedFloatArray(data, null, fdata);
                int ipt = 0;
                for (int i = 0; i < nX; ++i) {
                    int j = 0;
                    while (j < nY) {
                        fxy[i][j] = fdata[ipt];
                        ++j;
                        ++ipt;
                    }
                }
            } else {
                System.out.println(functionName);
            }
        }
        catch (Exception e) {
            Logger.error("Exception " + e + " with nX, nY: " + nX + " " + nY);
        }
        return fxy;
    }

    @Override
    public float[][][] functionXYZ(String functionName, int nX, int nY, int nZ) {
        float[][][] fxyz = new float[Math.abs(nX)][Math.abs(nY)][Math.abs(nZ)];
        if (!this.mayScript || !this.haveDocumentAccess || nX == 0 || nY == 0 || nZ == 0) {
            return fxyz;
        }
        return fxyz;
    }

    protected void doShowDocument(URL url) {
        String[] surl = PT.split(url.toString(), "?POST?");
        if (surl.length == 1) {
            return;
        }
        String f = "<form id=f method=POST action='" + surl[0] + "'>";
        f = f + "<input type='hidden' name='name' value='nmr-1h-prediction' id='name'>";
        f = f + "<input type='submit' value='working...'>";
        String[] fields = surl[1].split("&");
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            int pt = field.indexOf("=");
            String name = field.substring(0, pt);
            String value = field.substring(pt);
            f = value.indexOf("\n") >= 0 ? f + "<textarea style='display:none' name=" + name + ">" + value + "</textarea>" : f + "<input type=hidden name=" + name + " value=\"" + value + "\">";
        }
        f = f + "</form>";
        System.out.println(f + url);
    }

    protected String doSendCallback(CBK type, Object callback, Object[] data, String strInfo) {
        block1: {
            boolean isString = callback instanceof String;
            if (callback == null || isString && ((String)callback).length() == 0) break block1;
            if (isString && "alert".equals(callback)) {
                return "";
            }
            String[] tokens = isString ? PT.split((String)callback, ".") : null;
        }
        return "";
    }

    protected String doEval(String strEval) {
        return "";
    }

    protected void doShowStatus(String message) {
        try {
            System.out.println(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getGLmolView() {
        return this.viewer.getGLmolView();
    }

    public String openFile(String fileName) {
        return this.viewer.openFile(fileName);
    }

    @Override
    public int cacheFileByName(String fileName, boolean isAdd) {
        return this.viewer.cacheFileByName(fileName, isAdd);
    }

    @Override
    public void cachePut(String key, Object data) {
        this.viewer.cachePut(key, data);
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    static {
        isJS = false;
    }
}

